/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Email;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitentgrupa;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Rabatnaskala;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stavkakarticekomitenta;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.db.entity.Telefon;
import rs.pezar.db.entity.Trosak;

@Entity
@Table(name="Komitent")
public class Komitent
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(unique=true, nullable=false, length=255)
    private String sfrKomitent;
    @Column(nullable=false, length=255)
    private String adresa;
    @Column(nullable=false, length=255)
    private String brFaxa;
    @Column(nullable=false, length=255)
    private String brojPDV;
    @Column(nullable=false)
    private short domaciKomitent;
    @Column(nullable=false, length=255)
    private String email;
    @Column(nullable=false, length=255)
    private String grad;
    @Column(nullable=false, length=255)
    private String kontakt;
    @Column(nullable=false, length=255)
    private String matBroj;
    @Column(nullable=false, length=255)
    private String naziv;
    private BigDecimal novcaniLimit;
    @Column(nullable=false)
    private short obveznikPDV;
    @Column(nullable=false, length=255)
    private String opis;
    @Column(nullable=false, length=255)
    private String pib;
    @Column(nullable=false, length=255)
    private String postBroj;
    @Column(nullable=false)
    private short povPravnoLice;
    @Column(nullable=false, length=255)
    private String regBroj;
    @Column(nullable=false, length=255)
    private String sifDelatnosti;
    @Column(nullable=false)
    private short srbija;
    @Column(nullable=false, length=255)
    private String telefoni;
    @Column(nullable=false)
    private int tip;
    private BigDecimal valutniLimit;
    @Column(nullable=false, length=255)
    private String zemljaKomitenta;
    @OneToMany(mappedBy="proizvodjac")
    private List<Artikal> artikals1;
    @OneToMany(mappedBy="dobavljac")
    private List<Artikal> artikals2;
    @OneToMany(mappedBy="komitent")
    private List<Faktura> fakturas;
    @OneToMany(mappedBy="komitent")
    private List<Fakturausluga> fakturauslugas;
    @OneToMany(mappedBy="komitent")
    private List<Kalkulacija> kalkulacijas;
    @OneToMany(mappedBy="komitent")
    private List<Rabatnaskala> rabatnaskalas;
    @OneToMany(mappedBy="komitent")
    private List<Radnajedinica> radnajedinicas;
    @OneToMany(mappedBy="komitent")
    private List<Stavkakarticekomitenta> stavkakarticekomitentas;
    @OneToMany(mappedBy="komitent")
    private List<Stavkanzk> stavkanzks;
    @OneToMany(mappedBy="komitent")
    private List<Opstidokument> opstidokuments;
    @OneToMany(mappedBy="komitent", cascade={CascadeType.ALL})
    private List<Tekuciracun> tekuciracuns;
    @OneToMany(mappedBy="komitent")
    private List<Trosak> trosaks;
    @OneToMany(mappedBy="komitent", cascade={CascadeType.ALL})
    private List<Email> emails;
    @ManyToMany(mappedBy="komitents")
    private List<Komitentgrupa> komitentgrupas;
    @OneToMany(mappedBy="komitent")
    private List<Telefon> telefons;
    @PrivateOwned
    @OneToMany(mappedBy="komitent", cascade={CascadeType.ALL})
    private List<Komitentparameter> komitentparameters;

    public String getSfrKomitent() {
        return this.sfrKomitent;
    }

    public void setSfrKomitent(String sfrKomitent) {
        this.sfrKomitent = sfrKomitent;
    }

    public String getAdresa() {
        return this.adresa;
    }

    public void setAdresa(String adresa) {
        this.adresa = adresa;
    }

    public String getBrFaxa() {
        return this.brFaxa;
    }

    public void setBrFaxa(String brFaxa) {
        this.brFaxa = brFaxa;
    }

    public String getBrojPDV() {
        return this.brojPDV;
    }

    public void setBrojPDV(String brojPDV) {
        this.brojPDV = brojPDV;
    }

    public short getDomaciKomitent() {
        return this.domaciKomitent;
    }

    public void setDomaciKomitent(short domaciKomitent) {
        this.domaciKomitent = domaciKomitent;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getGrad() {
        return this.grad;
    }

    public void setGrad(String grad) {
        this.grad = grad;
    }

    public String getKontakt() {
        return this.kontakt;
    }

    public void setKontakt(String kontakt) {
        this.kontakt = kontakt;
    }

    public String getMatBroj() {
        return this.matBroj;
    }

    public void setMatBroj(String matBroj) {
        this.matBroj = matBroj;
    }

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public BigDecimal getNovcaniLimit() {
        return this.novcaniLimit;
    }

    public void setNovcaniLimit(BigDecimal novcaniLimit) {
        this.novcaniLimit = novcaniLimit;
    }

    public short getObveznikPDV() {
        return this.obveznikPDV;
    }

    public void setObveznikPDV(short obveznikPDV) {
        this.obveznikPDV = obveznikPDV;
    }

    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public String getPib() {
        return this.pib;
    }

    public void setPib(String PIB) {
        this.pib = PIB;
    }

    public String getPostBroj() {
        return this.postBroj;
    }

    public void setPostBroj(String postBroj) {
        this.postBroj = postBroj;
    }

    public short getPovPravnoLice() {
        return this.povPravnoLice;
    }

    public void setPovPravnoLice(short povPravnoLice) {
        this.povPravnoLice = povPravnoLice;
    }

    public String getRegBroj() {
        return this.regBroj;
    }

    public void setRegBroj(String regBroj) {
        this.regBroj = regBroj;
    }

    public String getSifDelatnosti() {
        return this.sifDelatnosti;
    }

    public void setSifDelatnosti(String sifDelatnosti) {
        this.sifDelatnosti = sifDelatnosti;
    }

    public short getSrbija() {
        return this.srbija;
    }

    public void setSrbija(short srbija) {
        this.srbija = srbija;
    }

    public String getTelefoni() {
        return this.telefoni;
    }

    public void setTelefoni(String telefoni) {
        this.telefoni = telefoni;
    }

    public int getTip() {
        return this.tip;
    }

    public void setTip(int tip) {
        this.tip = tip;
    }

    public BigDecimal getValutniLimit() {
        return this.valutniLimit;
    }

    public void setValutniLimit(BigDecimal valutniLimit) {
        this.valutniLimit = valutniLimit;
    }

    public String getZemljaKomitenta() {
        return this.zemljaKomitenta;
    }

    public void setZemljaKomitenta(String zemljaKomitenta) {
        this.zemljaKomitenta = zemljaKomitenta;
    }

    public List<Artikal> getArtikals1() {
        return this.artikals1;
    }

    public void setArtikals1(List<Artikal> artikals1) {
        this.artikals1 = artikals1;
    }

    public List<Artikal> getArtikals2() {
        return this.artikals2;
    }

    public void setArtikals2(List<Artikal> artikals2) {
        this.artikals2 = artikals2;
    }

    public List<Faktura> getFakturas() {
        return this.fakturas;
    }

    public void setFakturas(List<Faktura> fakturas) {
        this.fakturas = fakturas;
    }

    public List<Fakturausluga> getFakturauslugas() {
        return this.fakturauslugas;
    }

    public void setFakturauslugas(List<Fakturausluga> fakturauslugas) {
        this.fakturauslugas = fakturauslugas;
    }

    public List<Kalkulacija> getKalkulacijas() {
        return this.kalkulacijas;
    }

    public void setKalkulacijas(List<Kalkulacija> kalkulacijas) {
        this.kalkulacijas = kalkulacijas;
    }

    public List<Opstidokument> getOpstidokuments() {
        return this.opstidokuments;
    }

    public void setOpstidokuments(List<Opstidokument> opstidokuments) {
        this.opstidokuments = opstidokuments;
    }

    public List<Rabatnaskala> getRabatnaskalas() {
        return this.rabatnaskalas;
    }

    public void setRabatnaskalas(List<Rabatnaskala> rabatnaskalas) {
        this.rabatnaskalas = rabatnaskalas;
    }

    public List<Radnajedinica> getRadnajedinicas() {
        return this.radnajedinicas;
    }

    public void setRadnajedinicas(List<Radnajedinica> radnajedinicas) {
        this.radnajedinicas = radnajedinicas;
    }

    public List<Stavkakarticekomitenta> getStavkakarticekomitentas() {
        return this.stavkakarticekomitentas;
    }

    public void setStavkakarticekomitentas(List<Stavkakarticekomitenta> stavkakarticekomitentas) {
        this.stavkakarticekomitentas = stavkakarticekomitentas;
    }

    public List<Stavkanzk> getStavkanzks() {
        return this.stavkanzks;
    }

    public void setStavkanzks(List<Stavkanzk> stavkanzks) {
        this.stavkanzks = stavkanzks;
    }

    public List<Tekuciracun> getTekuciracuns() {
        return this.tekuciracuns;
    }

    public void setTekuciracuns(List<Tekuciracun> tekuciracuns) {
        this.tekuciracuns = tekuciracuns;
    }

    public List<Trosak> getTrosaks() {
        return this.trosaks;
    }

    public void setTrosaks(List<Trosak> trosaks) {
        this.trosaks = trosaks;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"\u0160ifra", "Naziv", "Adresa", "<html>Po\u0161tanski<br/>broj</html>", "Grad", "Telefoni", "Faks", "<html>Obveznik<br/>PDV</html>", "PDV broj", "PIB", "Mati\u010dni broj", "<html>Doma\u0107i<br/>komitent</html>", "Zemlja", "Kontakt"};
    }

    @Override
    public Object[] getValues() {
        String domaci = "";
        if (this.domaciKomitent == 1) {
            domaci = "DA ";
            domaci = this.srbija == 1 ? String.valueOf(domaci) + "(Srbija)" : String.valueOf(domaci) + "(Kosovo)";
        } else {
            domaci = "NE";
        }
        return new Object[]{PzEntityUtil.strZero(this.sfrKomitent, 9), this.naziv, this.adresa, this.postBroj, this.grad, this.telefoni, this.brFaxa, this.obveznikPDV == 1 ? "DA" : "NE", this.brojPDV, this.pib, this.matBroj, domaci, this.zemljaKomitenta, this.kontakt};
    }

    public List<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(List<Email> emails) {
        this.emails = emails;
    }

    public List<Komitentgrupa> getKomitentgrupas() {
        return this.komitentgrupas;
    }

    public void setKomitentgrupas(List<Komitentgrupa> komitentgrupas) {
        this.komitentgrupas = komitentgrupas;
    }

    public List<Telefon> getTelefons() {
        return this.telefons;
    }

    public void setTelefons(List<Telefon> telefons) {
        this.telefons = telefons;
    }

    public boolean getGrupaPostoji(String id) {
        if (id == null) {
            return false;
        }
        boolean grupaPostoji = false;
        Iterator<Komitentgrupa> iterator = this.komitentgrupas.iterator();
        while (iterator.hasNext() && !grupaPostoji) {
            Komitentgrupa grp = iterator.next();
            if (!grp.getIdKomitentGrupa().equals(Integer.valueOf(id))) continue;
            grupaPostoji = true;
        }
        return grupaPostoji;
    }

    public String getPunNaziv() {
        return "[ " + this.sfrKomitent + " ] " + this.naziv;
    }

    public List<Komitentparameter> getKomitentparameters() {
        return this.komitentparameters;
    }

    public void setKomitentparameters(List<Komitentparameter> komitentparameters) {
        this.komitentparameters = komitentparameters;
    }

    public Komitentparameter getKomitentparameter(String idParameter) {
        Komitentparameter rez = null;
        if (this.getKomitentparameters() != null) {
            for (Komitentparameter kp : this.getKomitentparameters()) {
                if (!kp.getId().getIdParameter().equals(idParameter)) continue;
                rez = kp;
            }
        }
        return rez;
    }

    public int getDomacaValuta() {
        int res = 1;
        Komitentparameter vlt = this.getKomitentparameter("FAKVAL");
        if (vlt != null && !vlt.getValue().equals("") || this.getDomaciKomitent() == 0) {
            res = 0;
        }
        return res;
    }

    public String getStranaValuta() {
        Komitentparameter v = this.getKomitentparameter("FAKVAL");
        if (v == null) {
            return "EUR";
        }
        return v.getValue();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.adresa == null ? 0 : this.adresa.hashCode());
        result = 31 * result + (this.grad == null ? 0 : this.grad.hashCode());
        result = 31 * result + (this.matBroj == null ? 0 : this.matBroj.hashCode());
        result = 31 * result + (this.naziv == null ? 0 : this.naziv.hashCode());
        result = 31 * result + (this.pib == null ? 0 : this.pib.hashCode());
        result = 31 * result + (this.postBroj == null ? 0 : this.postBroj.hashCode());
        result = 31 * result + (this.sfrKomitent == null ? 0 : this.sfrKomitent.hashCode());
        result = 31 * result + (this.telefoni == null ? 0 : this.telefoni.hashCode());
        result = 31 * result + (this.zemljaKomitenta == null ? 0 : this.zemljaKomitenta.hashCode());
        return result;
    }
}

