/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.FakturaopstidokumentPK;
import rs.pezar.db.entity.PrihodRashod;
import rs.pezar.db.entity.Taksafod;
import rs.pezar.db.entity.ZaduzenjeOdobrenje;

@Entity
@Table(name="FakturaOpstiDokument")
public class Fakturaopstidokument
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private FakturaopstidokumentPK id;
    private BigDecimal iznos = new BigDecimal(0);
    private String porez;
    private String sapravom;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="faktura", nullable=false, insertable=false, updatable=false)
    private Faktura faktura;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="opstidokument", nullable=false, insertable=false, updatable=false)
    private ZaduzenjeOdobrenje zaduzenjeodobrenje;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="opstidokument", nullable=false, insertable=false, updatable=false)
    private PrihodRashod prihodRashod;
    @OneToMany(mappedBy="fakturaopstidokument", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Taksafod> taksafods;

    public FakturaopstidokumentPK getId() {
        return this.id;
    }

    public void setId(FakturaopstidokumentPK id) {
        this.id = id;
    }

    public BigDecimal getIznos() {
        return this.iznos;
    }

    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    public Faktura getFaktura() {
        return this.faktura;
    }

    public void setFaktura(Faktura fakturaBean) {
        this.faktura = fakturaBean;
    }

    public ZaduzenjeOdobrenje getZaduzenjeodobrenje() {
        return this.zaduzenjeodobrenje;
    }

    public void setZaduzenjeodobrenje(ZaduzenjeOdobrenje zaduzenjeodobrenje) {
        this.zaduzenjeodobrenje = zaduzenjeodobrenje;
    }

    public List<Taksafod> getTaksafods() {
        return this.taksafods;
    }

    public void setTaksafods(List<Taksafod> taksafods) {
        this.taksafods = taksafods;
    }

    public void setPorez(String porez) {
        this.porez = porez;
    }

    public String getPorez() {
        return this.porez;
    }

    public void setSapravom(String sapravom) {
        this.sapravom = sapravom;
    }

    public String getSapravom() {
        return this.sapravom;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Faktura", "Iznos bez PDV-a", "PDV", "Ukupan iznos", "Oslobo\u0111eno sa pravom", "Oslobo\u0111eno bez prava"};
    }

    @Override
    public Object[] getValues() {
        BigDecimal ostSaPravom = new BigDecimal(0.0);
        BigDecimal ostBezPrava = new BigDecimal(0.0);
        BigDecimal bezPDV = new BigDecimal(0.0);
        BigDecimal pdv = new BigDecimal(0.0);
        if (this.porez.equalsIgnoreCase("sa_porezom")) {
            int i = 0;
            while (i < this.getTaksafods().size()) {
                pdv.add(this.getTaksafods().get(i).getIznos());
                ++i;
            }
            bezPDV = this.iznos.subtract(pdv);
        } else {
            bezPDV = this.getIznos();
            if (this.sapravom.equalsIgnoreCase("sa_pravom")) {
                ostSaPravom = this.getIznos();
            } else {
                ostBezPrava = this.getIznos();
            }
        }
        return new Object[]{this.getFaktura().getOznDokumenta(), bezPDV, pdv, this.iznos, ostSaPravom, ostBezPrava};
    }

    public void setPrihodRashod(PrihodRashod prihodRashod) {
        this.prihodRashod = prihodRashod;
    }

    public PrihodRashod getPrihodRashod() {
        return this.prihodRashod;
    }
}

