/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Adtaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.ArtikaldokumentPK;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;

@Entity
@Table(name="ArtikalDokument")
public class Artikaldokument
extends PzArtikalDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ArtikaldokumentPK id;
    @Column(length=255)
    private String bliziOpis;
    @Column(nullable=false)
    private double cena;
    private String jm;
    @Column(nullable=false)
    private double kolicina;
    private double nabCena;
    @Column(nullable=false, length=100)
    private String naziv;
    private double procRabata;
    private BigDecimal prodCena;
    private BigDecimal prosNabCena;
    private String sfrSort;
    private int sort;
    @Column(nullable=false, length=1)
    private String vrsta;
    private String vrstaPromene;
    private BigDecimal vrednost;
    @OneToMany(mappedBy="artikaldokument", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Adtaksa> adtaksas;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;

    public Artikaldokument() {
    }

    public Artikaldokument(PzArtikalDokument ad, Dokument dok) {
        this.id = new ArtikaldokumentPK(dok.getIdDok(), ad.getId().getSfrProizvod(), ad.getId().getrBroj());
        this.cena = ad.getCena();
        this.naziv = ad.getNaziv();
        this.bliziOpis = ad.getBliziOpis();
        this.kolicina = BDConverter.getKolicina(ad.getKolicina()).doubleValue();
        this.procRabata = BDConverter.getProcRabata(ad.getProcRabata()).doubleValue();
        this.prodCena = ad.getProdCena() != null ? BDConverter.getProdCena(ad.getProdCena().doubleValue()) : new BigDecimal(0);
        this.nabCena = BDConverter.getNabCena(ad.getNabCena()).doubleValue();
        this.prosNabCena = ad.getProsNabCena() != null ? BDConverter.getPrnc(ad.getProsNabCena().doubleValue()) : new BigDecimal(0);
        this.vrednost = ad.getVrednost() != null ? BDConverter.getIznos(ad.getVrednost()) : new BigDecimal(0);
        this.jm = ad.getJm();
        this.setSfrSort(PzEntityUtil.strZero(this.id.getSfrProizvod(), 9));
        if (ad.getTaksas() != null && ad.getTaksas().size() > 0) {
            this.copyTaksas(ad.getTaksas());
        }
        this.vrsta = ad.getVrsta();
    }

    public void copyTaksas(List<? extends PzADTaksa> taksas) {
        this.setAdtaksas((List<Adtaksa>)new IndirectList());
        for (PzADTaksa pzADTaksa : taksas) {
            this.adtaksas.add(new Adtaksa(this, pzADTaksa));
        }
    }

    public void update(PzArtikalDokument ad) {
        this.cena = ad.getCena();
        this.naziv = ad.getNaziv();
        this.kolicina = ad.getKolicina();
        this.procRabata = ad.getProcRabata();
        this.prodCena = ad.getProdCena();
        this.nabCena = ad.getNabCena();
        this.prosNabCena = ad.getProsNabCena();
        this.jm = ad.getJm();
        this.vrednost = ad.getVrednost();
        this.vrsta = ad.getVrsta();
        if (this.getAdtaksas() == null || this.getAdtaksas().size() == 0) {
            this.copyTaksas(ad.getTaksas());
        } else {
            this.updateTaksas(ad.getTaksas());
        }
    }

    private void updateTaksas(List<? extends PzADTaksa> taksas) {
        if (this.getTaksas() != null && this.getTaksas().size() > 0) {
            boolean found = false;
            for (PzADTaksa pzADTaksa : taksas) {
                found = false;
                for (Adtaksa adtaksa : this.getAdtaksas()) {
                    if (!pzADTaksa.getOznTarGr().equals(adtaksa.getId().getOznTarGr())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.getAdtaksas().add(new Adtaksa(this, pzADTaksa));
            }
            found = false;
            Iterator<Adtaksa> iterator = this.getAdtaksas().iterator();
            while (iterator.hasNext()) {
                Adtaksa adtaksa = iterator.next();
                for (PzADTaksa pzADTaksa : taksas) {
                    if (!pzADTaksa.getOznTarGr().equals(adtaksa.getId().getOznTarGr())) continue;
                    found = true;
                }
                if (found) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public ArtikaldokumentPK getId() {
        return this.id;
    }

    public void setId(ArtikaldokumentPK id) {
        this.id = id;
    }

    @Override
    public void setId(int idDok, String sfrProizvod, int rBroj) {
        this.id = new ArtikaldokumentPK(idDok, sfrProizvod, rBroj);
    }

    @Override
    public String getBliziOpis() {
        return this.bliziOpis;
    }

    @Override
    public void setBliziOpis(String bliziOpis) {
        this.bliziOpis = bliziOpis;
    }

    @Override
    public double getCena() {
        return this.cena;
    }

    @Override
    public void setCena(double cena) {
        this.cena = cena;
    }

    @Override
    public double getKolicina() {
        return this.kolicina;
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String nazivArt) {
        this.naziv = nazivArt;
    }

    @Override
    public double getNabCena() {
        return this.nabCena;
    }

    @Override
    public void setNabCena(double nabCena) {
        this.nabCena = nabCena;
    }

    @Override
    public double getProcRabata() {
        return this.procRabata;
    }

    @Override
    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    @Override
    public BigDecimal getProdCena() {
        return this.prodCena;
    }

    @Override
    public void setProdCena(BigDecimal prodCena) {
        this.prodCena = prodCena;
    }

    @Override
    public BigDecimal getProsNabCena() {
        return this.prosNabCena;
    }

    @Override
    public void setProsNabCena(BigDecimal prosNabCena) {
        this.prosNabCena = prosNabCena;
    }

    public String getSfrSort() {
        return this.sfrSort;
    }

    public void setSfrSort(String sfrSort) {
        this.sfrSort = sfrSort;
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }

    @Override
    public String getVrsta() {
        return this.vrsta;
    }

    public void setVrsta(String vrsta) {
        this.vrsta = vrsta;
    }

    public String getVrstaPromene() {
        return this.vrstaPromene;
    }

    public void setVrstaPromene(String vrstaPromene) {
        this.vrstaPromene = vrstaPromene;
    }

    public List<Adtaksa> getAdtaksas() {
        return this.adtaksas;
    }

    public void setAdtaksas(List<Adtaksa> adtaksas) {
        this.adtaksas = adtaksas;
    }

    @Override
    public Dokument getDokument() {
        return this.dokument;
    }

    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    @Override
    public String[] getColumnNames() {
        return null;
    }

    @Override
    public String getJm() {
        return this.jm;
    }

    @Override
    public Object[] getKValues() {
        return null;
    }

    @Override
    public String getSifra() {
        return this.id.getSfrProizvod();
    }

    @Override
    public Object[] getValues() {
        return null;
    }

    public Object[] getIzvodValues() {
        Dokument d = this.getDokument();
        String sfrKomitent = d.getKomitent() != null ? this.getDokument().getKomitent().getSfrKomitent() : "";
        String nazivKomitent = d.getKomitent() != null ? this.getDokument().getKomitent().getNaziv() : "";
        String oznRj = d.getRadnajedinica().getId().getOznRj();
        String oznDokumenta = d.getOznDokumenta();
        Date datum = d.getDatum();
        return new Object[]{datum, oznRj, oznDokumenta, this.kolicina, this.cena, this.procRabata, sfrKomitent, nazivKomitent};
    }

    @Override
    public void setJm(String jm) {
        this.jm = jm;
    }

    @Override
    public void setDokument(PzDokument dokument) {
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.adtaksas == null) {
            this.adtaksas = new IndirectList();
        }
        this.adtaksas.add(new Adtaksa(this, tgr));
    }

    @Override
    public Artikal getArtikal() {
        return null;
    }

    @Override
    public Usluga getUsluga() {
        return null;
    }

    @Override
    public void setArtikal(Artikal artikal) {
    }

    @Override
    public void setUsluga(Usluga usluga) {
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.adtaksas;
    }

    public void setVrednost(BigDecimal vrednost) {
        this.vrednost = vrednost;
    }

    @Override
    public BigDecimal getVrednost() {
        return this.vrednost;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bliziOpis == null ? 0 : this.bliziOpis.hashCode());
        long temp = Double.doubleToLongBits(this.cena);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.jm == null ? 0 : this.jm.hashCode());
        temp = Double.doubleToLongBits(this.kolicina);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.nabCena);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.naziv == null ? 0 : this.naziv.hashCode());
        temp = Double.doubleToLongBits(this.procRabata);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.prodCena == null ? 0 : this.prodCena.hashCode());
        result = 31 * result + (this.prosNabCena == null ? 0 : this.prosNabCena.hashCode());
        result = 31 * result + (this.sfrSort == null ? 0 : this.sfrSort.hashCode());
        result = 31 * result + this.sort;
        result = 31 * result + (this.vrednost == null ? 0 : this.vrednost.hashCode());
        result = 31 * result + (this.vrsta == null ? 0 : this.vrsta.hashCode());
        result = 31 * result + (this.vrstaPromene == null ? 0 : this.vrstaPromene.hashCode());
        return result;
    }
}

