/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import rs.pezar.core.PzApplication;
import rs.pezar.core.RuleKepu;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentCustomizer;
import rs.pezar.db.PzDokumentException;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzRacun;
import rs.pezar.db.entity.Adtaksa;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Akonstaksa;
import rs.pezar.db.entity.Aktaksa;
import rs.pezar.db.entity.Antaksa;
import rs.pezar.db.entity.Aodtaksa;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.BrojacrjPK;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Dtaksa;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaservisa;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Id_gen;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Popis;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Sfutaksa;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Trosak;
import rs.pezar.db.entity.Uftaksa;
import rs.pezar.db.entity.Uslugafaktura;
import rs.pezar.util.PzDateUtility;

public class PzEntityManager {
    public static int KOLICINE_NEPROMENJENE;
    public static int KOLICINE_UMANJENJE;
    public static int KOLICINE_UVECANJE;
    public static int KOLICINA_UKUPNA;
    public static int KOLICINA_ALOCIRANA;

    static {
        KOLICINE_UMANJENJE = 1;
        KOLICINE_UVECANJE = 2;
        KOLICINA_UKUPNA = 1;
        KOLICINA_ALOCIRANA = 2;
    }

    public static EntityManager getEm() {
        return PzEntityManagerFactory.getInstance().createEm();
    }

    public static void insert(Object entity) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            PzEntityManager.insert(entity, em);
            em.getTransaction().commit();
        }
        finally {
            em.close();
        }
    }

    public static void insert(Object entity, EntityManager em) throws Exception {
        em.persist(entity);
    }

    public static void update(Object entity) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            PzEntityManager.update(entity, em);
            em.getTransaction().commit();
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    public static void update(Object entity, EntityManager em) throws Exception {
        entity = em.merge(entity);
    }

    public static void delete(Class c, Object key) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            PzEntityManager.delete(c, key, em);
            em.getTransaction().commit();
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    public static void delete(Class c, Object key, EntityManager em) throws Exception {
        Object toRemove = em.find(c, key);
        if (toRemove == null) {
            return;
        }
        if (!(toRemove instanceof PzDokument)) {
            em.remove(toRemove);
        } else {
            PzDokument d = (PzDokument)toRemove;
            d.setArhiviran((short)-1);
            if (d.getDokument() != null) {
                d.getDokument().setArhiviran((short)-1);
                d.createLog(4, null, (Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()), em);
            }
            if (!em.contains((Object)d)) {
                em.merge((Object)d);
            }
        }
    }

    public static Vector<PzEntity> selectAll(String tableName) throws Exception {
        Vector v = new Vector();
        EntityManager em = PzEntityManager.getEm();
        try {
            v = (Vector)em.createQuery("select e from " + tableName + " e").getResultList();
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return v;
    }

    public static Vector<PzEntity> select(String query) throws Exception {
        Vector v = new Vector();
        EntityManager em = PzEntityManager.getEm();
        try {
            v = (Vector)em.createQuery(query).getResultList();
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return v;
    }

    public static List getList(String query) throws Exception {
        List v;
        EntityManager em = PzEntityManager.getEm();
        try {
            v = em.createQuery(query).getResultList();
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return v;
    }

    public static Vector<PzEntity> select(Query query) throws Exception {
        Vector v = new Vector();
        EntityManager em = PzEntityManager.getEm();
        try {
            v = (Vector)query.getResultList();
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return v;
    }

    public static List<? extends PzEntity> selectAll(Class<? extends PzEntity> type) throws Exception {
        List v = null;
        EntityManager em = PzEntityManager.getEm();
        try {
            v = em.createQuery("select e from " + type.getSimpleName() + " e").getResultList();
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return v;
    }

    public static Vector<PzEntity> search(PzEntity entity) throws Exception {
        String tableName = entity.getClass().getName().replaceAll(String.valueOf(entity.getClass().getPackage().getName()) + ".", "");
        String query = "SELECT e FROM " + tableName + " e ";
        HashMap<String, String> map = PzEntityUtil.getFieldsAndValues(entity);
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        String expression = "";
        if (map.size() > 0) {
            expression = "WHERE ";
        }
        while (it.hasNext()) {
            if (!expression.equals("WHERE ")) {
                expression = String.valueOf(expression) + " AND ";
            }
            Map.Entry<String, String> entry = it.next();
            expression = String.valueOf(expression) + "e." + entry.getKey() + " LIKE '%" + entry.getValue() + "%'";
        }
        query = String.valueOf(query) + expression;
        return PzEntityManager.select(query);
    }

    public static PzEntity find(Class type, Object key) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            PzEntity pzEntity = PzEntityManager.find(type, key, em);
            return pzEntity;
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    public static PzEntity findEntity(Class type, Object key) {
        EntityManager em = PzEntityManager.getEm();
        try {
            PzEntity pzEntity = (PzEntity)em.find(type, key);
            return pzEntity;
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    public static PzEntity find(Class type, Object key, EntityManager em) throws Exception {
        return (PzEntity)em.find(type, key);
    }

    public static void insert(List<? extends PzEntity> list) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                for (PzEntity pzEntity : list) {
                    em.persist((Object)pzEntity);
                }
                em.getTransaction().commit();
            }
            catch (Exception exception) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
                throw exception;
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    @Deprecated
    public static void arhivirajDokument(PzDokument dokument, boolean azuriranjeStavki, PzDokumentCustomizer customizer) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                PzEntityManager.arhivirajDokument(dokument, azuriranjeStavki, customizer, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    @Deprecated
    public static void arhivirajDokument(PzDokument dokumentK, boolean azuriranjeStavki, PzDokumentCustomizer customizer, EntityManager em) throws Exception {
        if (dokumentK.getUserPoc() == null) {
            dokumentK.setUserPoc((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
        }
        dokumentK.setUserKraj((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
        if (dokumentK.getRadnajedinica() != null && dokumentK.getRadnajedinica().getgTip().equals("V")) {
            dokumentK.setCvProdajna(dokumentK.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA") ? (short)1 : 0);
            if (azuriranjeStavki) {
                PzEntityUtil.osveziPRNC(dokumentK, em);
            }
        } else {
            dokumentK.setCvProdajna((short)1);
        }
        dokumentK.izracunajVrednostRobe();
        Brojacrj rBroj = null;
        Brojacrj brDok = null;
        Brojacrj brKepu = null;
        if (dokumentK.getRadnajedinica() != null) {
            rBroj = PzEntityManager.getRBroj(dokumentK, em);
            brDok = PzEntityManager.getRbrDok(dokumentK, em);
            brKepu = PzEntityManager.getRbrKepu(dokumentK, em);
        }
        if (dokumentK.getIdDok() == 0) {
            Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
            if (dokId == null) {
                dokId = new Id_gen();
                dokId.setIdName("DOKUMENT_ID");
                dokId.setIdVal(1);
                em.persist((Object)dokId);
            } else {
                dokId.setIdVal(dokId.getIdVal() + 1);
            }
            dokumentK.setIdDok(dokId.getIdVal());
        }
        if (azuriranjeStavki) {
            dokumentK.addTaksas();
            dokumentK.adjust();
        }
        dokumentK.setArhiviran((short)1);
        dokumentK.setDatArh(PzDateUtility.getCurrentDate());
        if (dokumentK.getRadnajedinica() != null) {
            rBroj.setRBroj(rBroj.getRBroj() + 1);
            brDok.setRBroj(brDok.getRBroj() + 1);
            dokumentK.setrBroj(rBroj.getRBroj());
            dokumentK.setRbrDok(brDok.getRBroj());
        }
        if (!(dokumentK instanceof Dokument)) {
            if (dokumentK.getDokument() == null) {
                if (dokumentK instanceof Interniracun) {
                    PzEntityManager.podesiInterniracun(dokumentK, em);
                } else {
                    Dokument dok = new Dokument(dokumentK, azuriranjeStavki);
                    dokumentK.setDokument(dok);
                }
            } else {
                dokumentK.updateDokument(azuriranjeStavki);
            }
        }
        if (dokumentK.getRadnajedinica() != null && RuleKepu.isInKepu(dokumentK.getRadnajedinica(), dokumentK.getTip()) && dokumentK.getDokument() != null) {
            brKepu.setRBroj(brKepu.getRBroj() + 1);
            int kepu = brKepu.getRBroj();
            dokumentK.getDokument().setRbrKepu(kepu);
        }
        if (dokumentK.getDokument() != null && (dokumentK.getOznDokumenta() == null || dokumentK.getOznDokumenta().length() == 0)) {
            dokumentK.formirajOznaku();
            dokumentK.getDokument().setOznDokumenta(dokumentK.getOznDokumenta());
            dokumentK.getDokument().setOpis(dokumentK.getOpis());
        }
        if (dokumentK instanceof Interniracun) {
            ((Interniracun)dokumentK).getDokument2().setOznDokumenta(dokumentK.getOznDokumenta());
            ((Interniracun)dokumentK).getDokument2().setRbrKepu(brKepu.getRBroj());
        }
        em.merge((Object)dokumentK);
        if (rBroj != null) {
            em.merge((Object)rBroj);
        }
        if (brDok != null) {
            em.merge((Object)brDok);
        }
        if (brKepu != null) {
            em.merge((Object)brKepu);
        }
    }

    private static Brojacrj getRbrKepu(PzDokument dokument, EntityManager em) throws Exception {
        Brojacrj brDok = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(dokument.getRadnajedinica().getId(), "KEPU", dokument.getArhiviran()));
        if (brDok == null) {
            brDok = new Brojacrj();
            BrojacrjPK pk = new BrojacrjPK();
            pk.setArhiviran(dokument.getArhiviran());
            pk.setOznOgranak(dokument.getRadnajedinica().getId().getOznOgranak());
            pk.setOznRj(dokument.getRadnajedinica().getId().getOznRj());
            pk.setTip("KEPU");
            brDok.setId(pk);
            brDok.setRadnajedinica(dokument.getRadnajedinica());
            Query q = em.createQuery("SELECT max(d.rbrKepu) FROM Dokument d WHERE d.radnajedinica=:rj");
            q.setParameter("rj", (Object)dokument.getRadnajedinica());
            int br = q.getSingleResult() != null ? (Integer)q.getSingleResult() : 0;
            brDok.setRBroj(br);
            em.persist((Object)brDok);
        }
        return brDok;
    }

    private static Brojacrj getRbrDok(PzDokument dokument, EntityManager em) throws Exception {
        Brojacrj brDok = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(dokument.getRadnajedinica().getId(), "DOKUMENT", dokument.getArhiviran()));
        if (brDok == null) {
            brDok = new Brojacrj();
            BrojacrjPK pk = new BrojacrjPK();
            pk.setArhiviran(dokument.getArhiviran());
            pk.setOznOgranak(dokument.getRadnajedinica().getId().getOznOgranak());
            pk.setOznRj(dokument.getRadnajedinica().getId().getOznRj());
            pk.setTip("DOKUMENT");
            brDok.setId(pk);
            brDok.setRadnajedinica(dokument.getRadnajedinica());
            Query q = em.createQuery("SELECT max(d.rbrDok) FROM Dokument d WHERE d.radnajedinica=:rj");
            q.setParameter("rj", (Object)dokument.getRadnajedinica());
            int br = q.getSingleResult() != null ? (Integer)q.getSingleResult() : 0;
            brDok.setRBroj(br);
            em.persist((Object)brDok);
        }
        return brDok;
    }

    private static Brojacrj getRBroj(PzDokument dokument, EntityManager em) throws Exception {
        if (dokument.getRadnajedinica() == null) {
            throw new Exception("Dokument koji nema radnu jedinicu ne moze imati redni broj u radnoj jedinici");
        }
        Brojacrj rBroj = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(dokument.getRadnajedinica().getId(), dokument.getTip(), dokument.getArhiviran()));
        if (rBroj == null) {
            rBroj = new Brojacrj();
            BrojacrjPK pk = new BrojacrjPK();
            pk.setArhiviran(dokument.getArhiviran());
            pk.setOznOgranak(dokument.getRadnajedinica().getId().getOznOgranak());
            pk.setOznRj(dokument.getRadnajedinica().getId().getOznRj());
            pk.setTip(dokument.getTip());
            rBroj.setId(pk);
            rBroj.setRadnajedinica(dokument.getRadnajedinica());
            Query q = em.createQuery("SELECT count(d) FROM Dokument d WHERE d.radnajedinica=:rj AND d.tip=:tip and d.storno=0 AND d.datum>:datum");
            q.setParameter("rj", (Object)dokument.getRadnajedinica());
            q.setParameter("tip", (Object)dokument.getTip());
            q.setParameter("datum", (Object)PzDateUtility.getFirstDayOfCurrentYear());
            int br = q.getSingleResult() != null ? ((Long)q.getSingleResult()).intValue() : 0;
            rBroj.setRBroj(br);
            em.persist((Object)rBroj);
        }
        return rBroj;
    }

    private static Brojacrj getBrojacRj(String tip, Radnajedinica rj, EntityManager em) throws Exception {
        if (rj == null) {
            throw new Exception("Dokument koji nema radnu jedinicu ne moze imati radni broj u radnoj jedinici");
        }
        Brojacrj rBroj = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(rj.getId(), tip, 1));
        if (rBroj == null) {
            rBroj = new Brojacrj();
            BrojacrjPK pk = new BrojacrjPK();
            pk.setArhiviran((short)1);
            pk.setOznOgranak(rj.getId().getOznOgranak());
            pk.setOznRj(rj.getId().getOznRj());
            pk.setTip(tip);
            rBroj.setId(pk);
            rBroj.setRadnajedinica(rj);
            Query q = em.createQuery("SELECT count(d) FROM Dokument d WHERE d.radnajedinica=:rj " + (tip != null ? "AND d.tip=:tip" : ""));
            q.setParameter("rj", (Object)rj);
            if (tip != null) {
                q.setParameter("tip", (Object)tip);
            }
            int br = ((Long)q.getSingleResult()).intValue();
            rBroj.setRBroj(br);
            em.persist((Object)rBroj);
        }
        return rBroj;
    }

    private static void podesiInterniracun(PzDokument dok, EntityManager em) {
        Interniracun ir = (Interniracun)dok;
        ir.setVrsta("I");
        Dokument dokument1 = new Dokument(ir, true);
        ir.setVrsta("U");
        Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
        if (dokId == null) {
            dokId = new Id_gen();
            dokId.setIdName("DOKUMENT_ID");
            dokId.setIdVal(1);
        }
        dokId.setIdVal(dokId.getIdVal() + 1);
        em.merge((Object)dokId);
        ir.setIdDok(dokId.getIdVal());
        ir.adjust();
        Dokument dokument2 = new Dokument(ir, true);
        ir.setIdDok(dokument1.getIdDok());
        ir.adjust();
        ir.setDokument1(dokument1);
        ir.setDokument2(dokument2);
        dokument1.setInterniracun(ir);
        dokument1.setInterniracun1(ir);
        dokument1.setPodTip("IZLAZ");
        dokument2.setInterniracun(ir);
        dokument2.setInterniracun1(ir);
        em.merge((Object)dokument1);
        em.merge((Object)dokument2);
    }

    @Deprecated
    public static void snimiDokument(PzDokument dokument, boolean azuriranjeStavki, PzDokumentCustomizer customizer) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                PzEntityManager.snimiDokument(dokument, azuriranjeStavki, customizer, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
                throw e;
            }
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    @Deprecated
    public static void snimiDokument(PzDokument dokument, boolean azuriranjeStavki, PzDokumentCustomizer customizer, EntityManager em) throws Exception {
        dokument.setUserPoc(PzApplication.getApplication().getSession().getLoggedUser());
        dokument.setUserKraj(PzApplication.getApplication().getSession().getLoggedUser());
        if (dokument.getRadnajedinica() != null) {
            dokument.setCvProdajna(dokument.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA") ? (short)1 : 0);
        }
        dokument.getClass().getSimpleName();
        Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
        boolean novi = false;
        if (dokument.getIdDok() == 0) {
            novi = true;
            if (dokId == null) {
                dokId = new Id_gen();
                dokId.setIdName("DOKUMENT_ID");
                dokId.setIdVal(0);
            }
            dokId.setIdVal(dokId.getIdVal() + 1);
            em.merge((Object)dokId);
            dokument.setIdDok(dokId.getIdVal());
        }
        dokument.adjust();
        dokument.setArhiviran((short)0);
        if (dokument.getDokument() == null) {
            if (dokument instanceof Interniracun) {
                PzEntityManager.podesiInterniracun(dokument, em);
            } else {
                Dokument dok = new Dokument(dokument, true);
                dokument.setDokument(dok);
            }
        } else {
            dokument.updateDokument(azuriranjeStavki);
        }
        if (novi) {
            em.persist((Object)dokument);
        } else {
            em.merge((Object)dokument);
        }
        em.flush();
    }

    public void snimiStorno(PzDokument dokument) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                PzEntityManager.snimiDokument(dokument, true, null, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
                throw e;
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    @Deprecated
    public static void arhivirajStorno(PzDokument stornoDokument, int azurirajKolicine, int kojeKolicine, boolean azurirajTakse, PzDokumentCustomizer customizer) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                PzEntityManager.arhivirajStorno(stornoDokument, azurirajKolicine, kojeKolicine, azurirajTakse, null, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    @Deprecated
    public static void arhivirajStorno(PzDokument stornoDokument, int azurirajKolicine, int kojeKolicine, boolean azurirajTakse, PzDokumentCustomizer customizer, EntityManager em) throws Exception {
        if (stornoDokument.getRadnajedinica() != null) {
            stornoDokument.setCvProdajna(stornoDokument.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA") ? (short)1 : 0);
        }
        PzDokument original = (PzDokument)em.find(stornoDokument.getClass(), (Object)stornoDokument.getIdDok());
        Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
        if (dokId == null) {
            dokId = new Id_gen();
            dokId.setIdName("DOKUMENT_ID");
            dokId.setIdVal(0);
        }
        dokId.setIdVal(dokId.getIdVal() + 1);
        em.merge((Object)dokId);
        em.flush();
        stornoDokument.setStornoIznos(new BigDecimal(0));
        stornoDokument.setIdDok(dokId.getIdVal());
        if (azurirajTakse && stornoDokument.getArtikalDocuments() != null && stornoDokument.getArtikalDocuments().size() >= 1) {
            stornoDokument.setTaksadokuments(new Vector());
            stornoDokument.addTaksas();
        }
        stornoDokument.adjust();
        stornoDokument.setArhiviran((short)1);
        stornoDokument.setStorno(1);
        stornoDokument.izracunajVrednostRobe();
        original.setStornoIznos(original.getStornoIznos().add(stornoDokument.getIznos()));
        original.getDokument().setStornoIznos(original.getStornoIznos());
        if (azurirajKolicine != KOLICINE_NEPROMENJENE && stornoDokument.getArtikalDocuments() != null) {
            Iterator<? extends PzArtikalDokument> i = stornoDokument.getArtikalDocuments().iterator();
            Stanje s = null;
            double novaKolicina = 0.0;
            while (i.hasNext()) {
                PzArtikalDokument artdok = i.next();
                s = (Stanje)PzEntityManager.find(Stanje.class, new StanjePK(artdok.getId().getSfrProizvod(), stornoDokument.getRadnajedinica()), em);
                if (s == null) continue;
                if (azurirajKolicine == KOLICINE_UMANJENJE) {
                    novaKolicina = s.getKolicina() - artdok.getKolicina();
                } else if (azurirajKolicine == KOLICINE_UVECANJE) {
                    novaKolicina = kojeKolicine == KOLICINA_UKUPNA ? s.getKolicina() + artdok.getKolicina() : s.getAlocKolicina() - artdok.getKolicina();
                }
                if (novaKolicina < 0.0 && azurirajKolicine == KOLICINE_UMANJENJE) {
                    throw new PzDokumentException(PzDokumentException.EXCEPTION_NEMA_KOLICINE, "Artikal '" + artdok.getId().getSfrProizvod() + " " + artdok.getNaziv() + "' nema dovoljno raspolo\u017eive koli\u010dine za storniranje. Storno ne\u0107e biti izra\u0111en.");
                }
                if (kojeKolicine == KOLICINA_UKUPNA) {
                    s.setKolicina(novaKolicina);
                } else {
                    s.setAlocKolicina(novaKolicina);
                }
                em.merge((Object)s);
            }
        }
        stornoDokument.setOriginal(original);
        Dokument dok = new Dokument(stornoDokument, true);
        stornoDokument.setDokument(dok);
        Brojacrj brKepu = null;
        if (stornoDokument.getRadnajedinica() != null) {
            brKepu = PzEntityManager.getRbrKepu(stornoDokument, em);
            if (RuleKepu.isInKepu(stornoDokument.getRadnajedinica(), stornoDokument.getTip())) {
                brKepu.setRBroj(brKepu.getRBroj() + 1);
                int kepu = brKepu.getRBroj();
                stornoDokument.getDokument().setRbrKepu(kepu);
            }
        }
        if (stornoDokument instanceof Fakturaservisa) {
            Fakturaservisa fs = (Fakturaservisa)stornoDokument;
            List<Uslugafaktura> list = fs.getUslugafakturas();
            fs.setUslugafakturas(new Vector<Uslugafaktura>());
            em.persist((Object)fs);
            em.flush();
            fs.setUslugafakturas(list);
        } else {
            em.persist((Object)stornoDokument);
        }
    }

    @Deprecated
    public static void deleteDokument(PzDokument dokument, PzDokumentCustomizer customizer) throws Exception {
        if (dokument == null) {
            return;
        }
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                PzEntityManager.deleteDokument(dokument, null, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    @Deprecated
    public static void deleteDokument(PzDokument dokument, PzDokumentCustomizer customizer, EntityManager em) throws Exception {
        Query q;
        if (dokument == null) {
            return;
        }
        HashMap<Class<Fakturaservisa>, Class[]> map = new HashMap<Class<Fakturaservisa>, Class[]>();
        map.put(Kalkulacija.class, new Class[]{Aktaksa.class, Taksakalkulacija.class, Trosak.class, Artikalkalkulacija.class});
        map.put(Konsignacija.class, new Class[]{Akonstaksa.class, Artikalkonsignacija.class});
        map.put(Faktura.class, new Class[]{Aftaksa.class, Taksafaktura.class, Artikalfaktura.class});
        map.put(Fakturausluga.class, new Class[]{Sfutaksa.class, Stavkafaktureusl.class});
        map.put(Nivelacija.class, new Class[]{Antaksa.class, Artikalnivelacija.class});
        map.put(Opstidokument.class, new Class[]{Aodtaksa.class, Artikalopstidokument.class});
        map.put(Popis.class, new Class[]{Aodtaksa.class, Artikalopstidokument.class});
        map.put(Dokument.class, new Class[]{Adtaksa.class, Dtaksa.class, Artikaldokument.class});
        map.put(Fakturaservisa.class, new Class[]{Aftaksa.class, Taksafaktura.class, Artikalfaktura.class, Uftaksa.class, Uslugafaktura.class});
        int i = 0;
        while (i < ((Class[])map.get(dokument.getClass())).length) {
            q = em.createQuery("DELETE FROM :classname a WHERE a.id.idDok = :idDok".replace(":classname", ((Class[])map.get(dokument.getClass()))[i].getSimpleName()));
            q.setParameter("idDok", (Object)dokument.getIdDok());
            q.executeUpdate();
            ++i;
        }
        q = em.createQuery("DELETE FROM :classname a WHERE a.idDok = :idDok".replace(":classname", dokument.getClass().getSimpleName()));
        q.setParameter("idDok", (Object)dokument.getIdDok());
        q.executeUpdate();
        i = 0;
        while (i < ((Class[])map.get(Dokument.class)).length) {
            q = em.createQuery("DELETE FROM :classname a WHERE a.id.idDok = :idDok".replace(":classname", ((Class[])map.get(Dokument.class))[i].getSimpleName()));
            q.setParameter("idDok", (Object)dokument.getIdDok());
            q.executeUpdate();
            ++i;
        }
        q = em.createQuery("DELETE FROM Dokument d WHERE d.idDok = :idDok");
        q.setParameter("idDok", (Object)dokument.getIdDok());
        q.executeUpdate();
    }

    public static void updateDokumentRacun(PzDokument dokument, EntityManager em) {
        Dokument dok = (Dokument)em.find(Dokument.class, (Object)dokument.getIdDok());
        if (dokument instanceof PzRacun) {
            dok.setUplata(((PzRacun)((Object)dokument)).getUplata());
        }
        dok.setStornoIznos(dokument.getStornoIznos());
    }
}

