/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db;

import java.math.BigDecimal;
import rs.pezar.db.PzArtikalDokumentPK;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzProizvodDokument;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;
import rs.pezar.util.PzMathUtility;

public abstract class PzArtikalDokument
extends PzProizvodDokument {
    public static final String[] kColNames = new String[]{"Datum", "Komitent", "Dokument", "Naziv dokumenta", "Kalkulacija", "Cena", "ULAZ", "IZLAZ", "Stanje", "%rabat", "Vrednost ulaza", "Vrednost izlaza", "Saldo", "Nalog za knji\u017eenje", "Opis"};

    @Override
    public abstract String[] getColumnNames();

    @Override
    public abstract Object[] getValues();

    public PzArtikalDokument() {
    }

    public PzArtikalDokument(Artikal artikal, PzDokument dokument) {
        this.init(artikal, dokument);
    }

    public PzArtikalDokument(Stanjeartikal sa, PzDokument dokument) throws Exception {
        this.init(sa, dokument);
    }

    public PzArtikalDokument(Usluga usluga, PzDokument dokument) {
        this.init(usluga, dokument);
    }

    public abstract Object[] getKValues();

    public abstract PzArtikalDokumentPK getId();

    public abstract void setId(int var1, String var2, int var3);

    public abstract String getSifra();

    public abstract BigDecimal getProdCena();

    public abstract void setProdCena(BigDecimal var1);

    public abstract BigDecimal getProsNabCena();

    public abstract void setProsNabCena(BigDecimal var1);

    public void setNabCena(double nabCena) {
    }

    public double getNabCena() {
        return 0.0;
    }

    public abstract void setJm(String var1);

    public abstract String getJm();

    public abstract String getBliziOpis();

    public abstract void setBliziOpis(String var1);

    public abstract void setArtikal(Artikal var1);

    public abstract Artikal getArtikal();

    public abstract Usluga getUsluga();

    public abstract void setUsluga(Usluga var1);

    @Override
    public abstract void setSort(int var1);

    public double getCena(boolean izlaznaRJ) {
        return this.getCena();
    }

    public BigDecimal getVrednost() {
        return new BigDecimal(0);
    }

    public void init(Artikal a, PzDokument dokument) {
        int iddok = dokument != null ? dokument.getIdDok() : 0;
        this.setId(iddok, a.getSfrProizvod(), dokument.getNextRBrojArtikli());
        this.setSort(this.getId().getrBroj());
        this.setNaziv(a.getNaziv());
        this.setBliziOpis(a.getBliziOpis());
        this.setJm(a.getJedMere());
        this.setArtikal(a);
        this.setDokument(dokument);
        for (Tarifnagrupa tgr : a.getTarifnagrupas()) {
            this.addTaksa(tgr);
        }
    }

    public void init(int idDok, String sfrProizvod, int rBroj, String naziv, String bliziOpis, String jm) {
        this.setId(idDok, sfrProizvod, rBroj);
        this.setSort(this.getId().getrBroj());
        this.setNaziv(naziv);
        this.setBliziOpis(bliziOpis);
        this.setJm(jm);
    }

    public void init(Stanjeartikal sa, PzDokument dokument) throws Exception {
        Artikal artikal = (Artikal)PzEntityManager.find(Artikal.class, sa.getId().getSfrProizvod());
        this.init(artikal, dokument);
        this.setProdCena(PzMathUtility.roundToBigDecimal(sa.getProdCena()));
        this.setProsNabCena(sa.getProsNabCena());
    }

    public void init(Usluga usluga, PzDokument dokument) {
        this.setId(dokument.getIdDok(), usluga.getSfrProizvod(), dokument.getNextRBrojArtikli());
        this.setNaziv(usluga.getNaziv());
        this.setUsluga(usluga);
        this.setDokument(dokument);
        for (Tarifnagrupa tgr : usluga.getTarifnagrupas()) {
            this.addTaksa(tgr);
        }
    }
}

