/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.transformation;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.persistence.queries.FetchGroup;
import rs.pezar.core.PzApplication;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.ArtikallistaPK;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.swing.PzDialog;
import rs.pezar.util.PzDateUtility;

public class DefaultDokumentTransformer
extends DokumentTransformer {
    private Class<PzDokument> dokumentClass;
    private Class<PzArtikalDokument> artikaldokumentClass;
    private Vector<String[]> fields = new Vector();

    public DefaultDokumentTransformer(Class<?> dokumentClass, Class<?> artikaldokumentClass) {
        this.dokumentClass = dokumentClass;
        this.artikaldokumentClass = artikaldokumentClass;
    }

    @Override
    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        return null;
    }

    @Override
    public PzDokument getDokumentToTransform(PzDialog parent) {
        return null;
    }

    @Override
    public PzDokument toDokument(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        String sifre = this.checkArtikal(l, em);
        if (sifre != null) {
            throw new TransformationException("Gre\u0161ka! \u0160ifre: " + sifre + " ne postoje u bazi");
        }
        PzDokument dokument = this.dokumentClass.newInstance();
        dokument.setArhiviran((short)0);
        dokument.setCvProdajna((short)-1);
        dokument.setDatum(l.getDatum());
        dokument.setKomitent(l.getKomitent());
        dokument.setProknjizen((short)0);
        dokument.setStorno(0);
        dokument.setUserKraj((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
        dokument.setUserPoc((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
        Vector<PzArtikalDokument> list = new Vector<PzArtikalDokument>();
        PzArtikalDokument ad = null;
        List<Artikal> artikli = this.getArtikli1(l, em);
        for (Artikallista al : l.getArtikallistas()) {
            ad = this.artikaldokumentClass.newInstance();
            this.init(ad, dokument, al, artikli);
            list.add(ad);
        }
        dokument.setArtikalDokuments(list);
        return dokument;
    }

    public void setCustomFieldsToCopy(String[][] fields) {
        this.fields = new Vector();
        int i = 0;
        while (i < fields.length) {
            this.fields.add(fields[i]);
            ++i;
        }
    }

    public void addCustomFieldsToCopy(String[] fields) {
        this.fields.add(fields);
    }

    private String checkArtikal(Lista l, EntityManager em) {
        String res = null;
        Query q = em.createQuery("SELECT al.sfrProizvod FROM Artikallista al WHERE al.id.idLista=:idLista and al.sfrProizvod NOT IN (SELECT a.sfrProizvod from Artikal a)");
        q.setParameter("idLista", (Object)l.getIdLista());
        List data = q.getResultList();
        if (data.size() != 0) {
            res = (String)data.get(0);
            int i = 1;
            while (i < data.size()) {
                res = String.valueOf(res) + ", " + (String)data.get(i);
                ++i;
            }
        }
        return res;
    }

    private void init(PzArtikalDokument ad, PzDokument dokument, Artikallista al, List<Artikal> artikli) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ad.setDokument(dokument);
        int iddok = dokument != null ? dokument.getIdDok() : 0;
        ad.setId(iddok, al.getSfrProizvod(), al.getId().getrBroj());
        ad.setNaziv(al.getNaziv());
        ad.setBliziOpis(al.getBliziOpis());
        ad.setJm(al.getJm());
        if (this.fields != null) {
            int i = 0;
            while (i < this.fields.size()) {
                BeanUtils.setProperty((Object)ad, (String)this.fields.get(i)[1], (Object)BeanUtils.getProperty((Object)al, (String)this.fields.get(i)[0]));
                ++i;
            }
        }
        this.addTaksa(ad, artikli);
    }

    private void addTaksa(PzArtikalDokument ad, List<Artikal> artikli) {
        for (Artikal a : artikli) {
            if (!a.getSfrProizvod().equals(ad.getId().getSfrProizvod())) continue;
            for (Tarifnagrupa tg : a.getTarifnagrupas()) {
                ad.addTaksa(tg);
            }
        }
    }

    private List<Artikal> getArtikli1(Lista l, EntityManager em) {
        Query q = em.createQuery("SELECT a FROM Artikal a JOIN FETCH a.tarifnagrupas WHERE a.sfrProizvod IN (SELECT al.sfrProizvod FROM Artikallista al WHERE al.id.idLista = :idLista)");
        q.setParameter("idLista", (Object)l.getIdLista());
        FetchGroup grp = new FetchGroup();
        grp.addAttribute("sfrProizvod");
        q.setHint("eclipselink.fetch-group", (Object)grp);
        return q.getResultList();
    }

    @Override
    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Lista l = new Lista();
        l.setDatum(PzDateUtility.getCurrentDate());
        l.setKomitent(dokument.getKomitent());
        if (dokument.getOznDokumenta() != null) {
            l.setNaslov(String.valueOf(dokument.getTip()) + " " + dokument.getOznDokumenta());
        }
        l.setPzuser(PzApplication.getApplication().getSession().getLoggedUser());
        l.setTip("STANDARDNA");
        l.setArhiviran(0);
        l.setArtikallistas(new Vector<Artikallista>());
        Artikallista al = null;
        int i = 0;
        for (PzArtikalDokument pzArtikalDokument : dokument.getArtikalDocuments()) {
            al = new Artikallista();
            al.setId(new ArtikallistaPK(0, i++));
            al.setSfrProizvod(pzArtikalDokument.getId().getSfrProizvod());
            al.setNaziv(pzArtikalDokument.getNaziv());
            al.setBliziOpis(pzArtikalDokument.getBliziOpis());
            al.setJm(pzArtikalDokument.getJm());
            al.setKolicina(pzArtikalDokument.getKolicina());
            al.setCena(new BigDecimal(pzArtikalDokument.getCena()).setScale(2, 4));
            l.getArtikallistas().add(al);
        }
        return l;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }
}

