/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.workbench;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.util.ComponentWindowProvider;
import bibliothek.gui.dock.util.WindowProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.application.SingleFrameApplication;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import rs.pezar.core.PzApplication;
import rs.pezar.core.gui.defaultWidgets.mainView.MainViewWidget;
import rs.pezar.core.gui.menu.PzMenuPermissions;
import rs.pezar.core.gui.workbench.docking.PzDockingWorkArea;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzMenu;
import rs.pezar.swing.PzMenuBar;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzWindow;
import rs.pezar.swing.PzWorkbench;
import rs.pezar.swing.WorkArea;
import rs.pezar.swing.event.PzWorkbenchListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.util.PzFileUtility;

public class PzDockingWorkbench
extends SingleFrameApplication
implements PzWorkbench {
    private PzMenuBar menuBar;
    private WorkArea workArea;
    private PzStatusBar statusbar;
    private Vector<PzWorkbenchListener> listeners = new Vector();
    private CControl control;
    private MainViewWidget mainview;
    private CGrid grid;
    private PzPanel pnlMain;
    private File layoutResource;
    private final HashMap<Class<? extends PzDialog>, PzDialog> activeDialogs = new HashMap();
    private JFrame mainFrame;

    private void init() {
        try {
            PzApplication.getApplication().setWorkbench(this);
            PzApplication.getApplication().getSession().setSessionStorage(this.getContext().getSessionStorage());
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent e) {
                    if (e.getNewValue() instanceof PzFieldImpl) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PzFieldImpl textField = (PzFieldImpl)e.getNewValue();
                                if (!(textField instanceof PzDateField) && textField.isSelectAllOnFocus()) {
                                    textField.selectAll();
                                } else {
                                    textField.setCaretPosition(0);
                                }
                            }
                        });
                    }
                }
            });
            UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
            JFrame.setDefaultLookAndFeelDecorated(true);
            this.mainFrame = this.getMainFrame();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this.getMainFrame(), e);
        }
    }

    private void loadMenuBar() {
        try {
            Document doc = PzFileUtility.loadXML("rs/pezar/core/resource/menu.xml", this.getClass().getClassLoader());
            NodeList list = doc.getElementsByTagName("menu");
            int i = 0;
            while (i < list.getLength()) {
                PzMenu menu = new PzMenu(list.item(i), this.getClass().getClassLoader());
                PzMenuPermissions.setMenuItems(menu);
                this.menuBar.addMenu(menu);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initGUI() {
        try {
            if (PzFirma.getFirma() != null) {
                this.mainFrame.setTitle(String.valueOf(PzParameter.getParameterValue("TEKUCA_GODINA")) + " - " + PzFirma.getFirma().getNaziv() + " - Pezar - robno, materijalno i finansijsko knjigovodstvo");
            }
            this.mainFrame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/48x48.png")).getImage());
            this.pnlMain = new PzPanel();
            this.pnlMain.setPaintGradient(true);
            this.pnlMain.setGradient(Color.BLUE, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
            this.pnlMain.setLayout(new BorderLayout());
            this.menuBar = new PzMenuBar(this);
            this.loadMenuBar();
            this.mainFrame.setJMenuBar(this.menuBar);
            this.mainview = new MainViewWidget();
            this.mainview.addElements(PzApplication.getApplication().getTreeElementRegistry());
            this.statusbar = new PzStatusBar();
            this.statusbar.setPreferredSize(new Dimension(855, 24));
            this.statusbar.setBorder(BorderFactory.createBevelBorder(1));
            this.pnlMain.add((Component)((Object)this.statusbar), "South");
            this.statusbar.add(new JLabel(" (c) Copyright TetraByte DOO, 2017. Sva prava zadr\u017eana."));
            this.statusbar.add(new JLabel("Kontakt: 060 618 11 33, kontakt@tetrabyte.rs"));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(e);
        }
        for (PzMenu menu : PzApplication.getApplication().getMenuRegistry()) {
            try {
                this.getWorkbenchMenuBar().merge(menu);
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle(e);
            }
        }
        this.show(this.pnlMain);
        this.initDock();
    }

    private void initDock() {
        ComponentWindowProvider provider = new ComponentWindowProvider((Component)this.pnlMain);
        this.control = new CControl((WindowProvider)provider);
        this.control.setTheme("eclipse");
        this.control.getContentArea().setOpaque(false);
        this.pnlMain.add((Component)this.control.getContentArea());
        this.grid = new CGrid(this.control);
        this.workArea = new PzDockingWorkArea(this.grid, this);
        this.workArea.add(this.mainview);
        this.workArea.add(PzApplication.getApplication().getWidgetRegistry());
        this.control.getContentArea().deploy(this.grid);
        try {
            this.layoutResource = new File(String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + "dockable_layout");
            if (this.layoutResource.exists()) {
                this.control.getResources().readFile(this.layoutResource);
                this.control.load("docking_frame");
            } else {
                this.workArea.applyDefaultVisibility();
            }
            this.workArea.initData();
            for (PzWorkbenchListener listener : this.listeners) {
                listener.workbenchExposed();
            }
            this.mainview.getDockable().addFocusListener(new CFocusListener(){

                public void focusLost(CDockable arg0) {
                }

                public void focusGained(CDockable arg0) {
                    PzDockingWorkbench.this.mainview.setFocusOnContent();
                }
            });
        }
        catch (IOException iOException) {}
    }

    private void handleOpaque(JComponent pnl) {
        if (pnl.getComponents().length > 0) {
            int i = 0;
            while (i < pnl.getComponents().length) {
                Component c = pnl.getComponents()[i];
                if (c instanceof JPanel) {
                    ((JComponent)c).setOpaque(false);
                    this.handleOpaque((JComponent)c);
                }
                ++i;
            }
        }
    }

    protected void startup() {
        this.init();
        this.initGUI();
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                PzDockingWorkbench.this.mainview.getDockable().toFront();
            }
        });
    }

    protected void shutdown() {
        try {
            this.control.save("docking_frame");
            this.control.getResources().writeFile(this.layoutResource);
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle(this.mainFrame, e);
        }
        for (PzWorkbenchListener listener : this.listeners) {
            listener.workbenchClosed();
        }
        super.shutdown();
    }

    @Override
    public PzToolBar getToolBar() {
        return null;
    }

    @Override
    public PzStatusBar getStatusBar() {
        return this.statusbar;
    }

    @Override
    public PzMenuBar getWorkbenchMenuBar() {
        return this.menuBar;
    }

    @Override
    public void addWorkbenchListener(PzWorkbenchListener newPzWorkbenchListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(newPzWorkbenchListener);
    }

    @Override
    public List<PzWorkbenchListener> getWorkbenchListeners() {
        return this.listeners;
    }

    @Override
    public void instantiateWindow(Class windowClass) {
    }

    @Override
    public void fireWindowInstantiated(PzWindow window) {
    }

    @Override
    public void showDialog(Class<? extends PzDialog> type, String parameter) {
        try {
            if (this.activeDialogs.get(type) != null) {
                this.activeDialogs.get(type).requestFocus();
            } else {
                Constructor<? extends PzDialog> c = parameter == null ? type.getConstructor(JFrame.class) : type.getConstructor(JFrame.class, String.class);
                PzDialog dialog = parameter == null ? c.newInstance(this.mainFrame) : c.newInstance(this.mainFrame, parameter);
                dialog.setDialogSessionOwner(true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        PzDialog dlg = (PzDialog)PzDockingWorkbench.this.activeDialogs.get(e.getWindow().getClass());
                        if (dlg != null) {
                            dlg.setDialogSessionOwner(false);
                        }
                        PzDockingWorkbench.this.activeDialogs.remove(e.getWindow().getClass());
                    }
                });
                if (dialog.shouldBeShown()) {
                    this.fireDialogInstantiated(dialog);
                    dialog.setLocationRelativeTo(this.mainFrame);
                    if (dialog.isRestorable()) {
                        dialog.restoreSize();
                    }
                    dialog.setVisible(true);
                    this.activeDialogs.put(type, dialog);
                } else {
                    dialog.dispose();
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this.mainFrame, e);
        }
    }

    private void fireDialogInstantiated(PzDialog dialog) {
        for (PzWorkbenchListener listener : this.listeners) {
            listener.dialogInstantiated(dialog);
        }
    }

    @Override
    public void removeWorkbenchListener(PzWorkbenchListener wbListener) {
        this.listeners.remove(wbListener);
    }

    @Override
    public void save() {
    }

    @Override
    public void restore() {
    }

    @Override
    public WorkArea getWorkArea() {
        return this.workArea;
    }

    @Override
    public void expose() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isVisible() {
        return this.mainFrame.isVisible();
    }
}

