/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.pretraga.criteria;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import rs.pezar.core.gui.pretraga.criteria.Condition;
import rs.pezar.core.gui.pretraga.criteria.Criteria;
import rs.pezar.core.gui.pretraga.criteria.CriteriaChoices;
import rs.pezar.core.gui.pretraga.criteria.CriteriaListener;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.fields.PzBooleanField;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzTextField;

public class CriteriaComponent
extends PzPanel {
    private static final long serialVersionUID = 1031006653818452161L;
    private JComboBox cbField;
    private JComboBox cbCriteria;
    private PzComboBox cbLink;
    private Component tfValue;
    private PzCheckbox cbEnabled;
    private CriteriaComponent nextCriteriaComponent;
    private CriteriaComponent prevCriteriaComponent;
    private JCheckBox cbConnected;
    private boolean active = true;
    private List<CriteriaListener> listeners;
    private Criteria[] criteriasOriginal;
    private boolean fieldEnabled;
    private int id;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new CriteriaComponent());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public CriteriaComponent() {
        this.initGUI();
        this.fieldEnabled = true;
        this.listeners = new Vector<CriteriaListener>();
        this.setId(0);
    }

    public void setCriterias(Criteria[] criterias) {
        if (criterias == null || criterias.length == 0) {
            return;
        }
        this.clear();
        this.criteriasOriginal = new Criteria[criterias.length];
        int i = 0;
        while (i < criterias.length) {
            this.criteriasOriginal[i] = criterias[i].clone();
            ++i;
        }
        Criteria[] criteriaArray = criterias;
        int n = criterias.length;
        int n2 = 0;
        while (n2 < n) {
            Criteria criteria = criteriaArray[n2];
            this.cbField.addItem(criteria);
            criteria.setId(String.valueOf(this.id));
            ++n2;
        }
        this.updateCriteria(criterias[0]);
        if (this.nextCriteriaComponent != null) {
            this.nextCriteriaComponent.setCriterias(this.criteriasOriginal);
        }
    }

    private void updateCriteria(Criteria criteria) {
        this.cbCriteria.removeAllItems();
        if (this.tfValue != null) {
            this.tfValue.setVisible(false);
            this.remove(this.tfValue);
        }
        if (criteria.getChoices() == null) {
            this.cbCriteria.setEnabled(false);
        } else {
            this.cbCriteria.setEnabled(true);
            PzChoice[] pzChoiceArray = criteria.getChoices();
            int n = pzChoiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                PzChoice choice = pzChoiceArray[n2];
                this.cbCriteria.addItem(choice);
                ++n2;
            }
        }
        this.tfValue = (Component)((Object)criteria.getPzField());
        this.tfValue.setPreferredSize(new Dimension(173, 26));
        this.tfValue.setBounds(270, 0, 225, 26);
        this.tfValue.setEnabled(this.fieldEnabled);
        this.add(this.tfValue);
    }

    private void updateLink() {
        PzChoice[] pzChoiceArray = CriteriaChoices.CHOICES_LINK;
        int n = CriteriaChoices.CHOICES_LINK.length;
        int n2 = 0;
        while (n2 < n) {
            PzChoice choice = pzChoiceArray[n2];
            this.cbLink.addItem(choice);
            ++n2;
        }
    }

    private void initGUI() {
        try {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(612, 40));
            this.cbEnabled = new PzCheckbox();
            this.cbEnabled.setSelected(true);
            this.add(this.cbEnabled);
            this.cbEnabled.setBounds(0, 4, 19, 17);
            this.cbEnabled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CriteriaComponent.this.cbEnabledActionPerformed(evt);
                }
            });
            this.cbField = new JComboBox();
            this.add(this.cbField);
            this.cbField.setFont(new Font("SansSerif", 0, 14));
            this.cbField.setBounds(25, 0, 155, 26);
            this.cbField.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    CriteriaComponent.this.cbFieldItemStateChanged(evt);
                }
            });
            this.cbCriteria = new JComboBox();
            this.add(this.cbCriteria);
            this.cbCriteria.setFont(new Font("SansSerif", 0, 14));
            this.cbCriteria.setBounds(186, 0, 80, 26);
            this.cbLink = new PzComboBox();
            this.add(this.cbLink);
            this.cbLink.setFont(new Font("SansSerif", 0, 14));
            this.cbLink.setBounds(501, 0, 80, 26);
            this.updateLink();
            this.cbLink.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    CriteriaComponent.this.cbLinkItemStateChanged(evt);
                }
            });
            this.cbConnected = new JCheckBox();
            this.cbConnected.setVisible(false);
            this.add(this.cbConnected);
            this.cbConnected.setBounds(595, 22, 23, 20);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private void cbFieldItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            Criteria c = (Criteria)evt.getItem();
            this.updateCriteria(c);
        }
    }

    public CriteriaComponent getNextCriteriaComponent() {
        return this.nextCriteriaComponent;
    }

    public void setPrevCriteriaComponent(CriteriaComponent prevCriteriaComponent) {
        this.prevCriteriaComponent = prevCriteriaComponent;
    }

    public CriteriaComponent getPrevCriteriaComponent() {
        return this.prevCriteriaComponent;
    }

    private void cbLinkItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            PzChoice c = (PzChoice)evt.getItem();
            if (c.getValue() == null) {
                if (this.getNextCriteriaComponent() != null) {
                    this.getNextCriteriaComponent().deActivateCriteriaComponentArray();
                }
                this.cbConnected.setVisible(false);
            } else {
                if (this.getNextCriteriaComponent() != null && !this.getNextCriteriaComponent().isActive()) {
                    this.getNextCriteriaComponent().activateCriteriaComponentArray();
                } else if (this.getNextCriteriaComponent() == null) {
                    this.addNewEmptyCriteriaComponent();
                }
                this.cbConnected.setVisible(true);
            }
        }
    }

    private void addNewEmptyCriteriaComponent() {
        this.nextCriteriaComponent = new CriteriaComponent();
        this.nextCriteriaComponent.setId(this.getId() + 1);
        this.nextCriteriaComponent.setCriterias(this.criteriasOriginal);
        this.nextCriteriaComponent.setPrevCriteriaComponent(this);
        this.fireNewCriteriaComponentAdded(this.nextCriteriaComponent);
    }

    private void fireNewCriteriaComponentAdded(CriteriaComponent cc) {
        for (CriteriaListener l : this.listeners) {
            l.newCriteriaComponentAdded(cc);
        }
    }

    public void activateCriteriaComponentArray() {
        this.active = true;
        this.setVisible(true);
        if (this.getNextCriteriaComponent() != null) {
            this.getNextCriteriaComponent().activateCriteriaComponentArray();
        }
    }

    public void deActivateCriteriaComponentArray() {
        this.active = false;
        this.setVisible(false);
        if (this.getNextCriteriaComponent() != null) {
            this.getNextCriteriaComponent().deActivateCriteriaComponentArray();
        }
    }

    public void addCriteriaListener(CriteriaListener listener) {
        this.listeners.add(listener);
    }

    public String getField() {
        return ((Criteria)this.cbField.getSelectedItem()).getFieldName();
    }

    public String getExpression() {
        return (String)((PzChoice)this.cbCriteria.getSelectedItem()).getValue();
    }

    public Object getValue() {
        return ((PzField)((Object)this.tfValue)).getVal();
    }

    public String getLink() {
        return (String)((PzChoice)this.cbLink.getSelectedItem()).getValue();
    }

    public boolean hasNextActiveComponent() {
        if (this.nextCriteriaComponent == null) {
            return false;
        }
        if (this.nextCriteriaComponent.isActive()) {
            return true;
        }
        return this.nextCriteriaComponent.hasNextActiveComponent();
    }

    public boolean connectedToNextComponent() {
        if (this.nextCriteriaComponent == null) {
            return false;
        }
        if (this.nextCriteriaComponent.isActive() && this.nextCriteriaComponent.isVisible()) {
            return this.nextCriteriaComponent.connectedToPrevComponent();
        }
        return this.nextCriteriaComponent.connectedToNextComponent();
    }

    public boolean connectedToPrevComponent() {
        if (this.prevCriteriaComponent == null) {
            return false;
        }
        if (this.prevCriteriaComponent.isActive() && this.prevCriteriaComponent.isVisible()) {
            return this.prevCriteriaComponent.cbConnected.isVisible() && this.prevCriteriaComponent.cbConnected.isSelected();
        }
        return this.prevCriteriaComponent.connectedToPrevComponent();
    }

    @Override
    public void setEnabled(boolean arg) {
        super.setEnabled(arg);
        this.active = arg;
        this.cbConnected.setEnabled(arg);
        this.cbCriteria.setEnabled(arg);
        this.cbField.setEnabled(arg);
        this.cbLink.setEnabled(arg);
        this.fieldEnabled = arg;
        if (this.tfValue != null) {
            this.tfValue.setEnabled(arg);
        }
    }

    private void cbEnabledActionPerformed(ActionEvent evt) {
        this.setEnabled(!this.isEnabled());
    }

    public void clear() {
        this.cbField.removeAllItems();
        this.cbCriteria.removeAllItems();
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void restoreState(Condition condition) throws Exception {
        int i = 0;
        while (i < this.cbField.getItemCount()) {
            if (((Criteria)this.cbField.getItemAt(i)).getFieldName().equals(condition.getField())) {
                this.cbField.setSelectedIndex(i);
                Criteria c = (Criteria)this.cbField.getSelectedItem();
                this.updateCriteria(c);
            }
            ++i;
        }
        i = 0;
        while (i < this.cbCriteria.getItemCount()) {
            if (((PzChoice)this.cbCriteria.getItemAt(i)).getValue().equals(condition.getExpression())) {
                this.cbCriteria.setSelectedIndex(i);
            }
            ++i;
        }
        if (this.tfValue instanceof PzBooleanField) {
            ((PzField)((Object)this.tfValue)).setVal(Integer.valueOf(condition.getValue()));
        } else if (this.tfValue instanceof PzDoubleField) {
            ((PzField)((Object)this.tfValue)).setVal(Double.valueOf(condition.getValue()));
        } else if (this.tfValue instanceof PzDateField) {
            ((PzField)((Object)this.tfValue)).setVal(new Date(new SimpleDateFormat("yyyy-MM-dd").parse(condition.getValue()).getTime()));
        } else if (this.tfValue instanceof PzTextField) {
            ((PzField)((Object)this.tfValue)).setVal(condition.getValue());
        }
        i = 0;
        while (i < this.cbLink.getItemCount()) {
            Object link = ((PzChoice)this.cbLink.getItemAt(i)).getValue();
            if (link != null && link.equals(condition.getLink())) {
                this.cbLink.setSelectedIndex(i);
            }
            ++i;
        }
        if (condition.isConnectedToNext()) {
            this.cbConnected.setSelected(true);
        }
        if (this.getNextCriteriaComponent() != null) {
            this.getNextCriteriaComponent().restoreState(condition.getNextCondition());
        }
    }
}

