/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.pretraga.criteria;

import javax.swing.JComponent;
import rs.pezar.core.gui.pretraga.criteria.CriteriaChoices;
import rs.pezar.db.PzEntity;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.fields.PzBooleanField;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzIntegerField;
import rs.pezar.swing.fields.PzTextField;

public class Criteria {
    private String fieldName;
    private String fieldText;
    private int type;
    private PzChoice[] choices;
    private Class<PzDialog> dialogClass;
    private Class<PzEntity> entityClass;

    public Criteria(String fieldName, String fieldText, int type) {
        this.fieldName = fieldName;
        this.fieldText = fieldText;
        this.type = type;
        this.dialogClass = null;
        this.entityClass = null;
    }

    public Criteria(String fieldName, String fieldText, int type, PzChoice[] choices) {
        this.fieldName = fieldName;
        this.fieldText = fieldText;
        this.type = type;
        this.choices = choices;
        this.dialogClass = null;
        this.entityClass = null;
    }

    public Criteria(String fieldName, String fieldText, int type, Class<PzEntity> entityClass, Class<PzDialog> dialogClass, PzChoice[] choices) {
        this.fieldName = fieldName;
        this.fieldText = fieldText;
        this.type = type;
        this.entityClass = entityClass;
        this.dialogClass = dialogClass;
        this.choices = choices;
    }

    public PzField getPzField() {
        JComponent res = null;
        switch (this.type) {
            case 0: {
                res = new PzDoubleField();
                break;
            }
            case 1: {
                res = new PzTextField();
                break;
            }
            case 2: {
                res = new PzDateField();
                break;
            }
            case 3: {
                res = new PzIntegerField();
                break;
            }
            case 4: {
                res = new PzBooleanField();
            }
        }
        if (this.dialogClass != null && this.entityClass != null) {
            res.setFKField(this.entityClass, this.dialogClass, true, null);
        }
        return res;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public PzChoice[] getChoices() {
        return this.choices == null ? CriteriaChoices.getChoicesForType(this.type) : this.choices;
    }

    public void setFieldText(String fieldText) {
        this.fieldText = fieldText;
    }

    public String getFieldText() {
        return this.fieldText;
    }

    public String toString() {
        return this.fieldText;
    }

    public void setId(String id) {
        this.fieldName = this.fieldName.replace("<id>", id);
        if (this.choices != null) {
            PzChoice[] pzChoiceArray = this.choices;
            int n = this.choices.length;
            int n2 = 0;
            while (n2 < n) {
                PzChoice choice = pzChoiceArray[n2];
                String val = choice.getValue().toString().replace("<id>", id);
                choice.setValue(val);
                ++n2;
            }
        }
    }

    public Criteria clone() {
        PzChoice[] choicesClone = null;
        if (this.choices != null) {
            choicesClone = new PzChoice[this.choices.length];
            int i = 0;
            while (i < this.choices.length) {
                choicesClone[i] = new PzChoice(this.choices[i].getText(), (String)this.choices[i].getValue());
                ++i;
            }
        }
        return new Criteria(this.getFieldName(), this.getFieldText(), this.type, this.entityClass, this.dialogClass, choicesClone);
    }

    public static class Type {
        public static final int DOUBLE = 0;
        public static final int STRING = 1;
        public static final int DATE = 2;
        public static final int INTEGER = 3;
        public static final int BOOLEAN = 4;
    }
}

