/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import rs.pezar.core.PzApplication;
import rs.pezar.core.gui.menu.lokalniParametri.Dodavanje;
import rs.pezar.db.entity.Parameter;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogLokalniParametri
extends PzDialog {
    private PzPanel mainPanel;
    private JScrollPane spTable;
    private PzTable tblParametri;
    private JToolBar toolbar;
    private PzButton icnDodavanje;
    private PzButton icnIzmena;
    private PzButton icnBrisanje;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private final JLabel renderer1 = new JLabel();
    private int selrow;
    boolean wait = false;
    private Timer t;
    private Properties localProperties;
    private Parameter p;
    private File f;

    public PzDialogLokalniParametri(JFrame frame) {
        super(frame);
        this.initGUI();
        this.restoreData();
    }

    private void restoreData() {
        this.localProperties = new Properties();
        try {
            this.f = new File(String.valueOf(PzApplication.getApplication().getDataFolder().getPath()) + File.separator + "local.properties");
            if (!this.f.exists()) {
                this.f.createNewFile();
            }
            FileInputStream is = new FileInputStream(this.f);
            this.localProperties.load(is);
            ArrayList<Parameter> pList = new ArrayList<Parameter>();
            String[] parametri = this.localProperties.toString().split(",");
            int i = 0;
            while (i < parametri.length) {
                String[] parametar = parametri[i].split("=");
                this.p = new Parameter();
                this.p.setName(parametar[0].replace("{", " ").replace(" ", ""));
                this.p.setValue(parametar[1].replace("}", ""));
                pList.add(this.p);
                ++i;
            }
            this.tblParametri.setData(pList, Parameter.class);
            this.brDok.setText(String.valueOf(this.tblParametri.getRowCount()));
            ((InputStream)is).close();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Definisanje lokalnih parametara");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout(mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.spTable = new JScrollPane();
            this.mainPanel.add((Component)this.spTable, new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(7, 7, 7, 7), 0, 0));
            this.tblParametri = new PzTable();
            this.spTable.setViewportView((Component)((Object)this.tblParametri));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzButton();
            this.icnDodavanje.setLayout(null);
            this.toolbar.add(this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(INSERT)");
            this.icnDodavanje.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/gear_add.png")));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener(this);
            this.icnDodavanje.setShortcut("INSERT");
            this.icnDodavanje.setFocusable(false);
            this.icnDodavanje.setOpaque(false);
            this.icnIzmena = new PzButton();
            this.icnIzmena.setLayout(null);
            this.toolbar.add(this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/gear_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.addActionListener(this);
            this.icnIzmena.setShortcut("f3");
            this.icnIzmena.setFocusable(false);
            this.icnIzmena.setOpaque(false);
            this.icnBrisanje = new PzButton();
            this.icnBrisanje.setLayout(null);
            this.toolbar.add(this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(DELETE)");
            this.icnBrisanje.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/gear_delete.png")));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener(this);
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setFocusable(false);
            this.icnBrisanje.setOpaque(false);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)((Object)this.statusBar), "South");
            this.statusBar.add(this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki");
            this.statusBar.add(this.brDok);
            this.statusBar.add(this.renderer1);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setRestorable(false);
            this.setMinimumSize(new Dimension(520, 220));
            this.setSize(520, 326);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            this.getSession().putParameter("localparametars", this.localProperties);
            this.getSession().putParameter("tabela", (Object)this.tblParametri);
            if (actionCommand.equals("dodavanje")) {
                this.getSession().putParameter("update", false);
                this.getSession().putParameter("restoreData", false);
                this.showDialog(Dodavanje.class);
                if (((Boolean)this.getSession().getParameter("restoreData")).booleanValue()) {
                    this.restoreData();
                }
                return;
            }
            if (actionCommand.equals("izmena")) {
                this.getSession().putParameter("update", true);
                this.getSession().putParameter("restoreData", false);
                this.showDialog(Dodavanje.class);
                if (((Boolean)this.getSession().getParameter("restoreData")).booleanValue()) {
                    this.restoreData();
                }
                return;
            }
            if (actionCommand.equals("brisanje")) {
                if (this.tblParametri.getRowCount() == 0) {
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog(SwingUtilities.getRoot(this), "Da li ste sigurni?!", "Brisanje", null, false);
                if (rez == 0) {
                    this.localProperties.remove(((Parameter)this.tblParametri.getSelectedEntity()).getName());
                    FileOutputStream fos = new FileOutputStream(this.f);
                    this.localProperties.store(fos, "");
                    fos.flush();
                    fos.close();
                    this.restoreData();
                }
                return;
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle(this, e1);
        }
    }

    @Override
    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
    }
}

