/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.defaultWidgets.workArea;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.apache.commons.configuration.ConfigurationException;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeElement;
import rs.pezar.core.gui.defaultWidgets.mainView.WidgetTree;
import rs.pezar.core.gui.defaultWidgets.workArea.PzIconChooser;
import rs.pezar.core.gui.defaultWidgets.workArea.PzShortcutListCellRenderer;
import rs.pezar.core.gui.defaultWidgets.workArea.PzShortcutsConfig;

public class PzDragAndDropTransferHandler
extends TransferHandler
implements Transferable {
    private WidgetTree tree = null;
    private final DataFlavor flavors = new DataFlavor(Vector.class, "Vector");
    private Vector<Object> vector = new Vector();

    public PzDragAndDropTransferHandler(WidgetTree tree) {
        this.tree = tree;
    }

    public PzDragAndDropTransferHandler() {
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof WidgetTree) {
            this.vector.clear();
            TreeElement element = (TreeElement)this.tree.getLastSelectedPathComponent();
            if (element.hasChildren()) {
                return null;
            }
            String position = element.getLabel();
            TreeElement parent = element.getParent();
            position = String.valueOf(parent.getLabel()) + "/" + position;
            if (parent.getParent() != null) {
                do {
                    parent = parent.getParent();
                    position = String.valueOf(parent.getLabel()) + "/" + position;
                } while (parent.getParent() != null);
            }
            this.vector.add(element.getLabel());
            this.vector.add(element.getActionClass());
            this.vector.add(element.getParameter());
            this.vector.add(position);
        } else if (c instanceof JList) {
            try {
                this.vector.clear();
                JList list = (JList)c;
                Object[] values = (Object[])list.getSelectedValue();
                int index = list.getSelectedIndex();
                String path = PzShortcutsConfig.getPathByIndex(index);
                String parameter = PzShortcutsConfig.getParameterByIndex(index);
                this.vector.add(values[1]);
                this.vector.add(values[0]);
                this.vector.add(values[2]);
                this.vector.add(path);
                this.vector.add(parameter);
                this.vector.add(Integer.toString(index));
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.vector;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.flavors};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.flavors);
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (c instanceof WidgetTree) {
            return 3;
        }
        return 2;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.getComponent() instanceof WidgetTree) {
            return false;
        }
        if (!support.isDataFlavorSupported(this.flavors)) {
            return false;
        }
        JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
        return dl.getIndex() != -1;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (support.getComponent() instanceof JList) {
            block16: {
                if (!support.isDrop()) {
                    return false;
                }
                if (!support.isDataFlavorSupported(this.flavors)) {
                    this.displayDropLocation("Lista ne podrzava drop na ovom mestu");
                    return false;
                }
                JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
                JList list = (JList)support.getComponent();
                boolean insert = dl.isInsert();
                int index = dl.getIndex();
                Vector vector = new Vector();
                Transferable t = support.getTransferable();
                int d = support.getSourceDropActions();
                try {
                    vector = (Vector)t.getTransferData(this.flavors);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return false;
                }
                if (insert && d == 3) {
                    Vector<Object> choosenIcon = PzIconChooser.getSelectedIcon((String)vector.get(0), false);
                    list.setCellRenderer(new PzShortcutListCellRenderer(true));
                    if (!choosenIcon.get(0).equals("")) {
                        Object[] o = new Object[]{choosenIcon.get(1), choosenIcon.get(0), vector.get(3)};
                        ((DefaultListModel)list.getModel()).add(index, o);
                        try {
                            boolean check = PzShortcutsConfig.documentExist();
                            if (!check) {
                                PzShortcutsConfig.createNewXML(vector, choosenIcon, index);
                                break block16;
                            }
                            PzShortcutsConfig.addXML(vector, choosenIcon, index);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (insert && d == 2) {
                    try {
                        PzShortcutsConfig.removeXML((String)vector.get(1));
                        Object[] o = new Object[]{vector.get(1), vector.get(0), vector.get(2)};
                        list.setCellRenderer(new PzShortcutListCellRenderer(true));
                        Vector<Object> choosenIcon = new Vector<Object>();
                        choosenIcon.add(vector.get(0));
                        choosenIcon.add(vector.get(1));
                        Vector<String> vect = new Vector<String>();
                        vect.add((String)vector.get(1));
                        vect.add((String)vector.get(3));
                        vect.add((String)vector.get(4));
                        vect.add((String)vector.get(2));
                        if (index > Integer.valueOf((String)vector.get(5))) {
                            ((DefaultListModel)list.getModel()).remove(Integer.valueOf((String)vector.get(5)));
                            ((DefaultListModel)list.getModel()).add(index - 1, o);
                            PzShortcutsConfig.addXML(vect, choosenIcon, index - 1);
                        } else {
                            ((DefaultListModel)list.getModel()).remove(Integer.valueOf((String)vector.get(5)));
                            ((DefaultListModel)list.getModel()).add(index, o);
                            PzShortcutsConfig.addXML(vect, choosenIcon, index);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void displayDropLocation(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, string);
            }
        });
    }
}

