/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core;

import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import net.sourceforge.jeval.EvaluationException;
import net.sourceforge.jeval.Evaluator;
import rs.pezar.core.KepuElementiDokumenta;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;

public class RuleKep {
    public static final byte RULE_RAZDUZENJE_BEZ_PDV = 0;
    public static final byte RULE_RAZDUZENJE_BEZ_PDV_I_RABATA = 1;
    public static final byte RULE_RAZDUZENJE_SA_PDV_I_RABATOM = 2;
    public static final byte RULE_3 = 3;
    private byte rule;
    private Radnajedinica radnaJedinica;
    Evaluator evaluator;
    private HashMap<String, String> zaduzenje;
    private HashMap<String, String> razduzenje;
    private HashMap<String, String> uplata;
    private static Vector<String> changeables = new Vector();

    public RuleKep(Radnajedinica rj, byte rule) {
        this.radnaJedinica = rj;
        this.rule = rule;
        this.formChangeableDocuments();
        this.evaluator = new Evaluator();
        switch (rule) {
            case 0: {
                if (rj.getgTip().equals("E")) {
                    this.kepuMaloprodaja();
                    break;
                }
                this.razduzenjeBezPdv();
                break;
            }
            case 1: {
                if (rj.getgTip().equals("E")) {
                    this.kepuMaloprodaja();
                    break;
                }
                this.razduzenjeBezPdvIRabata();
                break;
            }
            case 2: {
                if (rj.getgTip().equals("E")) {
                    this.kepuMaloprodaja();
                    break;
                }
                this.razduzenjeSaPdvIRabatom();
                break;
            }
        }
    }

    public BigDecimal getZaduzenje(KepuElementiDokumenta elementi) {
        String result = elementi.buildExpression(this.zaduzenje.get(elementi.getTipDokumenta()));
        BigDecimal res = null;
        try {
            res = BigDecimal.valueOf(Double.parseDouble(this.evaluator.evaluate(result)));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (EvaluationException e) {
            e.printStackTrace();
        }
        if (elementi.isStorno()) {
            res = res.negate();
        }
        return res;
    }

    public BigDecimal getRazduzenje(KepuElementiDokumenta elementi) {
        String result = elementi.buildExpression(this.razduzenje.get(elementi.getTipDokumenta()));
        BigDecimal res = null;
        try {
            res = BigDecimal.valueOf(Double.parseDouble(this.evaluator.evaluate(result)));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (EvaluationException e) {
            System.out.println("wrong: " + result);
            e.printStackTrace();
        }
        if (elementi.isStorno()) {
            res = res.negate();
        }
        return res;
    }

    public BigDecimal getUplata(KepuElementiDokumenta elementi) {
        String result = elementi.buildExpression(this.uplata.get(elementi.getTipDokumenta()));
        BigDecimal res = null;
        try {
            res = BigDecimal.valueOf(Double.parseDouble(this.evaluator.evaluate(result)));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (EvaluationException e) {
            e.printStackTrace();
        }
        if (elementi.isStorno()) {
            res = res.negate();
        }
        return res;
    }

    private void razduzenjeBezPdv() {
        this.zaduzenje = new HashMap();
        this.razduzenje = new HashMap();
        this.uplata = new HashMap();
        this.zaduzenje.put(TipDokumentConfig.get().FAKTURA_SERVISA, " (osnuslugefakservisa) ");
        this.razduzenje.put(TipDokumentConfig.get().FAKTURA_SERVISA, "(osnuslugefakservisa + osnrobafakservisa)");
        this.zaduzenje.put(TipDokumentConfig.get().FAKTURA, "-(rabat)");
        this.razduzenje.put(TipDokumentConfig.get().FAKTURA, "(iznbezpir - (rabat))");
        this.zaduzenje.put(TipDokumentConfig.get().KALKULACIJA, "(prodajnabezpir)");
        this.razduzenje.put(TipDokumentConfig.get().KALKULACIJA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, "(nabavnavrednost)");
        this.razduzenje.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, "0");
        this.zaduzenje.put(TipDokumentConfig.get().POPIS, "(popisrazlikaviskaimanjka)");
        this.razduzenje.put(TipDokumentConfig.get().POPIS, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().OTPIS, "-(otpis)");
        this.razduzenje.put(TipDokumentConfig.get().OTPIS, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().NIVELACIJA, "(nivelazijabezpor)");
        this.razduzenje.put(TipDokumentConfig.get().NIVELACIJA, "(0)");
        this.zaduzenje.put("VREDONOSNA_NIVELACIJA", "(nivelazijabezpor)");
        this.razduzenje.put("VREDONOSNA_NIVELACIJA", "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, "(0)");
        this.razduzenje.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, " (fakbezpor) ");
        this.zaduzenje.put(TipDokumentConfig.get().ZATVARANJE_PRIHODOM, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().ZATVARANJE_PRIHODOM, "-(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA, "(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA, "-(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "(0)");
        this.razduzenje.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "(0)");
        this.uplata.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().INTERNI_NALOG, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().INTERNI_NALOG, "0");
        this.zaduzenje.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().POVRATNICA, "(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().POVRATNICA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, "(0)");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, "-(konsignacijabezpor)");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, "(0)");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, " (konsignacijabezpor) ");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().KEPU_DOKUMENT, "(kepuzad)");
        this.razduzenje.put(TipDokumentConfig.get().KEPU_DOKUMENT, "(kepuraz)");
        this.uplata.put(TipDokumentConfig.get().KEPU_DOKUMENT, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().UVECANJE_LAGERA, "(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().UVECANJE_LAGERA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().UMANJENJE_LAGERA, "-(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().UMANJENJE_LAGERA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, "(0)");
        this.razduzenje.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, "(iznbezpir)");
        this.zaduzenje.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, "-(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().DOSTAVNICA, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().DOSTAVNICA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().TREBOVANJE, "0");
        this.razduzenje.put(TipDokumentConfig.get().TREBOVANJE, "(otpis)");
        this.zaduzenje.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, "-(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, "(0)");
    }

    private void razduzenjeBezPdvIRabata() {
        this.zaduzenje = new HashMap();
        this.razduzenje = new HashMap();
        this.uplata = new HashMap();
        this.zaduzenje.put(TipDokumentConfig.get().FAKTURA, " (osnuslugefakservisa) ");
        this.razduzenje.put(TipDokumentConfig.get().FAKTURA, "(iznbezpir)");
        this.zaduzenje.put(TipDokumentConfig.get().FAKTURA_SERVISA, " (osnuslugefakservisa) ");
        this.razduzenje.put(TipDokumentConfig.get().FAKTURA_SERVISA, "(osnuslugefakservisa + (osnrobafakservisa))");
        this.zaduzenje.put(TipDokumentConfig.get().KALKULACIJA, "(prodajnabezpir)");
        this.razduzenje.put(TipDokumentConfig.get().KALKULACIJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, "(nabavnavrednost)");
        this.razduzenje.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, "0");
        this.zaduzenje.put(TipDokumentConfig.get().POPIS, "(popisrazlikaviskaimanjka)");
        this.razduzenje.put(TipDokumentConfig.get().POPIS, "0");
        this.zaduzenje.put(TipDokumentConfig.get().OTPIS, "-(otpis)");
        this.razduzenje.put(TipDokumentConfig.get().OTPIS, "0");
        this.zaduzenje.put(TipDokumentConfig.get().NIVELACIJA, "(nivelazijabezpor)");
        this.razduzenje.put(TipDokumentConfig.get().NIVELACIJA, "0");
        this.zaduzenje.put("VREDONOSNA_NIVELACIJA", "(nivelazijabezpor)");
        this.razduzenje.put("VREDONOSNA_NIVELACIJA", "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, "0");
        this.razduzenje.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, " (fakbezpor) ");
        this.zaduzenje.put(TipDokumentConfig.get().ZATVARANJE_PRIHODOM, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().ZATVARANJE_PRIHODOM, "-(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA, "(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA, "-(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, "0");
        this.zaduzenje.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "0");
        this.razduzenje.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "0");
        this.uplata.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().INTERNI_NALOG, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().INTERNI_NALOG, "0");
        this.zaduzenje.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().POVRATNICA, "(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().POVRATNICA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, "0");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, "-(konsignacijabezpor)");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, "0");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, " (konsignacijabezpor) ");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KEPU_DOKUMENT, "(kepuzad)");
        this.razduzenje.put(TipDokumentConfig.get().KEPU_DOKUMENT, "kepuraz");
        this.uplata.put(TipDokumentConfig.get().KEPU_DOKUMENT, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().UVECANJE_LAGERA, "(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().UVECANJE_LAGERA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().UMANJENJE_LAGERA, "-(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().UMANJENJE_LAGERA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, "(0)");
        this.razduzenje.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, "(iznbezpir)");
        this.zaduzenje.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, "-(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().DOSTAVNICA, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().DOSTAVNICA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().TREBOVANJE, "0");
        this.razduzenje.put(TipDokumentConfig.get().TREBOVANJE, "(otpis)");
        this.zaduzenje.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, "-(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, "(0)");
    }

    private void razduzenjeSaPdvIRabatom() {
        this.zaduzenje = new HashMap();
        this.razduzenje = new HashMap();
        this.uplata = new HashMap();
        this.zaduzenje.put(TipDokumentConfig.get().FAKTURA, " (pdv -(rabat)) ");
        this.razduzenje.put(TipDokumentConfig.get().FAKTURA, "(iznbezpir -(rabat) + (pdv))");
        this.zaduzenje.put(TipDokumentConfig.get().FAKTURA_SERVISA, " (osnuslugefakservisa + (pdv)) ");
        this.razduzenje.put(TipDokumentConfig.get().FAKTURA_SERVISA, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().KALKULACIJA, "(prodajnabezpir)");
        this.razduzenje.put(TipDokumentConfig.get().KALKULACIJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, "(nabavnavrednost)");
        this.razduzenje.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, "0");
        this.zaduzenje.put(TipDokumentConfig.get().POPIS, "(popisrazlikaviskaimanjka)");
        this.razduzenje.put(TipDokumentConfig.get().POPIS, "0");
        this.zaduzenje.put(TipDokumentConfig.get().OTPIS, "-(otpis)");
        this.razduzenje.put(TipDokumentConfig.get().OTPIS, "0");
        this.zaduzenje.put(TipDokumentConfig.get().NIVELACIJA, "(nivelazijabezpor)");
        this.razduzenje.put(TipDokumentConfig.get().NIVELACIJA, "0");
        this.zaduzenje.put("VREDONOSNA_NIVELACIJA", "(nivelazijabezpor)");
        this.razduzenje.put("VREDONOSNA_NIVELACIJA", "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, "0");
        this.razduzenje.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, " (fakbezpor) ");
        this.zaduzenje.put(TipDokumentConfig.get().ZATVARANJE_PRIHODOM, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().ZATVARANJE_PRIHODOM, "-(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA, "(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA, "-(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, "0");
        this.zaduzenje.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "0");
        this.razduzenje.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "0");
        this.uplata.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().INTERNI_NALOG, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().INTERNI_NALOG, "0");
        this.zaduzenje.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().POVRATNICA, "(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().POVRATNICA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, "0");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, "-(konsignacijabezpor)");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, "0");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, " (konsignacijabezpor) ");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KEPU_DOKUMENT, "(kepuzad)");
        this.razduzenje.put(TipDokumentConfig.get().KEPU_DOKUMENT, "kepuraz");
        this.uplata.put(TipDokumentConfig.get().KEPU_DOKUMENT, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().UVECANJE_LAGERA, "(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().UVECANJE_LAGERA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().UMANJENJE_LAGERA, "-(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().UMANJENJE_LAGERA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, "(0)");
        this.razduzenje.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, "(iznbezpir)");
        this.zaduzenje.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, "-(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().DOSTAVNICA, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().DOSTAVNICA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().TREBOVANJE, "0");
        this.razduzenje.put(TipDokumentConfig.get().TREBOVANJE, "(otpis)");
        this.zaduzenje.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, "-(iznbezpir)");
        this.razduzenje.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, "(0)");
    }

    private void kepuMaloprodaja() {
        this.zaduzenje = new HashMap();
        this.razduzenje = new HashMap();
        this.uplata = new HashMap();
        this.zaduzenje.put(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_CEK", "0");
        this.razduzenje.put(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_CEK", "iznosukupno");
        this.zaduzenje.put(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_PLK", "0");
        this.razduzenje.put(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_PLK", "iznosukupno");
        this.zaduzenje.put(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_GOT", "izvestajusluge");
        this.razduzenje.put(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_GOT", "iznosukupno");
        this.zaduzenje.put(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_FAK", "0");
        this.razduzenje.put(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_FAK", "iznosukupno");
        this.zaduzenje.put(TipDokumentConfig.get().KALKULACIJA, "(prodajnabezpir)");
        this.razduzenje.put(TipDokumentConfig.get().KALKULACIJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, "(nabavnavrednost)");
        this.razduzenje.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, "0");
        this.zaduzenje.put(TipDokumentConfig.get().POPIS, "popisrazlikaviskaimanjka");
        this.razduzenje.put(TipDokumentConfig.get().POPIS, "0");
        this.zaduzenje.put(TipDokumentConfig.get().OTPIS, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().OTPIS, "0");
        this.zaduzenje.put(TipDokumentConfig.get().POVRATNICA, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().POVRATNICA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().NIVELACIJA, "nivelazijabezpor");
        this.razduzenje.put(TipDokumentConfig.get().NIVELACIJA, "0");
        this.zaduzenje.put("VREDONOSNA_NIVELACIJA", "(nivelazijabezpor)");
        this.razduzenje.put("VREDONOSNA_NIVELACIJA", "0");
        this.zaduzenje.put(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA, "iznosukupno");
        this.razduzenje.put(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA, "iznosukupno");
        this.zaduzenje.put(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA, "-(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "0");
        this.razduzenje.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "0");
        this.uplata.put(TipDokumentConfig.get().OTPIS_POTRAZIVANJA, "iznosukupno");
        this.zaduzenje.put(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC, "0");
        this.razduzenje.put(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC, "0");
        this.uplata.put(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC, "(iznosukupno)");
        this.zaduzenje.put(TipDokumentConfig.get().INTERNI_NALOG, "iznosukupno");
        this.razduzenje.put(TipDokumentConfig.get().INTERNI_NALOG, "0");
        this.zaduzenje.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KEPU_DOKUMENT, "kepuzad");
        this.razduzenje.put(TipDokumentConfig.get().KEPU_DOKUMENT, "kepuraz");
        this.uplata.put(TipDokumentConfig.get().KEPU_DOKUMENT, "iznosukupno");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, "konsignacijabezpor");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, "-(konsignacijabezpor)");
        this.razduzenje.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().UVECANJE_LAGERA, "(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().UVECANJE_LAGERA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().UMANJENJE_LAGERA, "-(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().UMANJENJE_LAGERA, "0");
        this.zaduzenje.put(TipDokumentConfig.get().PROMENA_STOPE, "(iznosukupno)");
        this.razduzenje.put(TipDokumentConfig.get().PROMENA_STOPE, "0");
        this.zaduzenje.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, "0");
        this.razduzenje.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, "0");
        this.zaduzenje.put(TipDokumentConfig.get().DOSTAVNICA, "(magacinizlazulaz)");
        this.razduzenje.put(TipDokumentConfig.get().DOSTAVNICA, "(0)");
        this.zaduzenje.put(TipDokumentConfig.get().TREBOVANJE, "0");
        this.razduzenje.put(TipDokumentConfig.get().TREBOVANJE, "(otpis)");
    }

    private void formChangeableDocuments() {
        changeables.add(TipDokumentConfig.get().KEPU_DOKUMENT);
    }

    public static boolean isInKepu(Radnajedinica rj, String tipDokumenta) {
        RuleKep rk = new RuleKep(rj, 1);
        if (rj.getgTip().equals("E") && tipDokumenta.equals(TipDokumentConfig.get().FISKALNI_IZVESTAJ)) {
            return true;
        }
        return rk.zaduzenje.containsKey(tipDokumenta);
    }

    public static int getKepuIncrement(Radnajedinica rj, String tipDokumenta) {
        if (tipDokumenta.equals(TipDokumentConfig.get().FISKALNI_IZVESTAJ)) {
            return 1;
        }
        return 1;
    }

    public boolean isKepuDocumentChangeable(String tipDokumenta) {
        for (String i : changeables) {
            if (!i.equals(tipDokumenta)) continue;
            return true;
        }
        return false;
    }

    public String getKepuDocumentTypes() {
        String types = "";
        Iterator<String> it = this.zaduzenje.keySet().iterator();
        while (it.hasNext()) {
            types = String.valueOf(types) + "'" + it.next() + "',";
        }
        if (types.length() > 0) {
            types = types.substring(0, types.length() - 1).replaceAll(",'null'", "");
        }
        if (this.radnaJedinica.getTip().substring(0, 1).equals("V")) {
            types = types.replaceAll(",'" + TipDokumentConfig.get().OTPREMNICA + "'", "");
        }
        return types;
    }

    public Vector<String> getZaduzenjeValuedDocuments() {
        Vector<String> temp = new Vector<String>();
        for (String type : this.zaduzenje.keySet()) {
            if (this.zaduzenje.get(type).equals("0")) continue;
            temp.add(type);
        }
        return temp;
    }

    public Vector<String> getRazduzenjeValuedDocuments() {
        Vector<String> temp = new Vector<String>();
        for (String type : this.razduzenje.keySet()) {
            if (this.razduzenje.get(type).equals("0")) continue;
            temp.add(type);
        }
        return temp;
    }

    public Vector<String> getUplateValuedDocuments() {
        Vector<String> temp = new Vector<String>();
        for (String type : this.uplata.keySet()) {
            if (this.uplata.get(type).equals("0")) continue;
            temp.add(type);
        }
        return temp;
    }

    public static String getDocumentOpis(String documentType, Date documentDate, String document, String komitent, Integer redniBroj, String opis, Integer storno, String podtip) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        String formattedDate = formatter.format(documentDate);
        if (documentType.equals(TipDokumentConfig.get().FAKTURA_SERVISA)) {
            if (storno != 1) {
                return "Faktura servisa: " + document + ",datum: " + formattedDate;
            }
            return "Storno fakture servisa: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().FAKTURA_USLUGA)) {
            if (storno != 1) {
                return "Faktura usluga: " + document + ",datum: " + formattedDate;
            }
            return "Storno fakture usluga: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().FAKTURA)) {
            if (storno != 1) {
                return "Faktura: " + document + ",datum: " + formattedDate;
            }
            return "Storno fakture: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().PRIJEMNICA_REPRO)) {
            if (storno != 1) {
                return "Prijemnica repromaterijala: " + document + ",datum: " + formattedDate;
            }
            return "Storno prijemnice repr.: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().KALKULACIJA)) {
            if (storno != 1) {
                return "Kalkulacija: " + redniBroj.toString() + ",komitent: " + komitent + ",datum: " + formattedDate;
            }
            return "Storno kalkulacije: " + redniBroj.toString() + ",komitent: " + komitent + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().TREBOVANJE)) {
            if (storno != 1) {
                return "Trebovanje: " + document + ", datum: " + formattedDate;
            }
            return "Storno trebovanja: " + document + ", datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().DOSTAVNICA)) {
            if (storno != 1) {
                return "Dostavnica: " + document + ", datum: " + formattedDate;
            }
            return "Storno dostavnice: " + document + ", datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().POPIS)) {
            if (storno != 1) {
                return "Popis: " + document + ",datum: " + formattedDate;
            }
            return "Storno popisa: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().OTPIS)) {
            if (storno != 1) {
                return "Otpis: " + document + ",datum: " + formattedDate;
            }
            return "Storno otpisa: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().UPLATA_PAZARA)) {
            String podtipstring = "";
            podtipstring = podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_CEKOVI) ? "\u010dekovi" : (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_GOTOVINA) ? "gotovina" : (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_PL_KARTICE) ? "kartice" : (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_VIRMAN) ? "virman" : "")));
            return "Uplata pazara, " + podtipstring + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().NIVELACIJA)) {
            return "Nivelacija: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals("VREDONOSNA_NIVELACIJA")) {
            return "Nivelacija: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().ZATVARANJE_PRIHODOM)) {
            return "Zatvori prihodom: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().ZATVARANJE_RASHODOM)) {
            return "Zatvori rashodom: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA)) {
            if (storno != 1) {
                return "Knj.zadu\u017e. kupca: " + document + ",komitent: " + komitent + ",datum: " + formattedDate;
            }
            return "Storno zadu\u017eenja kupca: " + document + ",komitent: " + komitent + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA)) {
            if (storno != 1) {
                return "Knj.odob. kupca: " + document + ",komitent: " + komitent + ",datum: " + formattedDate;
            }
            return "Storno odobrenja kupca: " + document + ",komitent: " + komitent + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().INTERNI_NALOG)) {
            return "Interni nalog: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().PRIMO_PREDAJNICA)) {
            return "Primopredajnica: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().POVRATNICA)) {
            return "Povratnica: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE)) {
            return "Zadu\u017eeje na\u0161e konsig.: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE)) {
            return "Povratnica na\u0161e konsig.: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().OTPREMNICA)) {
            return "Otpremnica: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().OTPIS_POTRAZIVANJA)) {
            return "Otpis potra\u017eivanja: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().UPLATA_KUPCA)) {
            return "Uplata kupca: " + komitent + ",po dokumentu: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ)) {
            return "Povra\u0107aj upl.kupca: " + komitent + ",po dokumentu: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN)) {
            if (storno != 1) {
                return "Interni ra\u010dun: " + document + ",datum: " + formattedDate;
            }
            return "Storno interni ra\u010dun: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS)) {
            return "Primljen avans: " + komitent + ",po dokumentu: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC)) {
            return "Zatvaranje avansom: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA)) {
            return "Konsignaciona povratnica: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().UVECANJE_LAGERA)) {
            return "Prijem robe: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().UMANJENJE_LAGERA)) {
            return "Povracaj robe: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA)) {
            return "Konsignaciona povratnica: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA)) {
            return "Konsignacija prijem: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA)) {
            return "Konsignacija prijem: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().KEPU_DOKUMENT)) {
            return opis;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_GOT")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - ke\u0161: " + document + ",datum: " + formattedDate;
            }
            return "Storno Dn. fiskalni izve\u0161taj - ke\u0161: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_PLK")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - kartica: " + document + ",datum: " + formattedDate;
            }
            return "Storno Dn. fiskalni izve\u0161taj - kartica: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_CEK")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - \u010dek: " + document + ",datum: " + formattedDate;
            }
            return "Storno Dn. fiskalni izve\u0161taj - \u010dek: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_FAK")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - ostalo: " + document + ",datum: " + formattedDate;
            }
            return "Storno Dn. fiskalni izve\u0161taj - ostalo: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE)) {
            return "Prenosnica sa konsignacije " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().PROMENA_STOPE)) {
            return "Promena tarifne stope: " + document + ",datum: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU)) {
            return "Trebovanje u gar. roku " + document + ",datum: " + formattedDate;
        }
        return null;
    }

    public static void main(String[] args) {
        Radnajedinica rj = new Radnajedinica();
        rj.setTip("E");
        RuleKep r = new RuleKep(rj, 0);
        r.getZaduzenjeValuedDocuments();
        KepuElementiDokumenta ke = new KepuElementiDokumenta();
        ke.setiznosBezPdviRabata(new BigDecimal(100.0));
        ke.setPdv(new BigDecimal(16.2));
        ke.setRabat(new BigDecimal(10.0));
        ke.setTipDokumenta("FAKTURA");
        r.getRazduzenje(ke);
        r.getZaduzenje(ke);
    }
}

