/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core;

import java.awt.Color;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import rs.pezar.core.PzApplicationSession;
import rs.pezar.core.PzExtensionManager;
import rs.pezar.core.PzGenericServiceRegistry;
import rs.pezar.core.PzGlobalKeyboardShortcutRegistry;
import rs.pezar.core.PzLocalPropertiesManager;
import rs.pezar.core.PzPermissionController;
import rs.pezar.core.PzSettingsManager;
import rs.pezar.core.PzUserSettings;
import rs.pezar.core.gui.defaultWidgets.mainView.MainViewWidget;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeElement;
import rs.pezar.core.gui.workbench.PzDockingWorkbench;
import rs.pezar.core.gui.workbench.PzWorkbenchImplNew;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzDokumentFinalizer;
import rs.pezar.db.PzDokumentValidator;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzColumnsManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.swing.PzMenu;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWidget;
import rs.pezar.swing.PzWorkbench;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.custom.PzLoginDialog;
import rs.pezar.swing.event.PzWorkbenchAdapter;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.CertUtil;
import rs.pezar.util.UserLockUtility;

public class PzApplication
implements BundleActivator {
    private static PzApplication instance;
    private PzApplicationSession session;
    private PzEntityManagerFactory emf;
    private PzWorkbench workbench;
    private BundleContext bundleContext;
    private Class appClass;
    private File dataFolder;
    private PzLogger log;
    private PzUserSettings localMachineUserSettings;
    private PzPermissionController permissionController;
    private PzSettingsManager settingsManager;
    private PzLocalPropertiesManager propManager;
    private List<PzWidget> widgetRegistry;
    private List<TreeElement> treeElementRegistry;
    private List<PzMenu> menuRegistry;
    private List<PzDokumentFinalizer> dokumentFinalizerRegistry;
    private List<PzDokumentValidator> dokumentValidatorRegistry;
    private List<ImageIcon> iconRegistry;
    private PzGlobalKeyboardShortcutRegistry shortcutRegistry;
    private PzGenericServiceRegistry genericServiceRegistry;
    private HashMap<String, String> appArguments;
    private File configFolder;

    public static PzApplication getApplication() {
        return instance;
    }

    private void initApplication() {
        this.dataFolder = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".pezar");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdir();
        }
        this.configFolder = new File(String.valueOf(this.dataFolder.getPath()) + File.separator + "config");
        if (!this.configFolder.exists()) {
            this.configFolder.mkdir();
        }
        this.session = new PzApplicationSession();
        this.shortcutRegistry = new PzGlobalKeyboardShortcutRegistry();
        this.localMachineUserSettings = new PzUserSettings();
        this.localMachineUserSettings.initializeProperties(this.dataFolder);
        this.permissionController = new PzPermissionController(this);
        this.genericServiceRegistry = new PzGenericServiceRegistry();
        this.dokumentFinalizerRegistry = new Vector<PzDokumentFinalizer>();
        this.dokumentValidatorRegistry = new Vector<PzDokumentValidator>();
        this.setSettingsManager(new PzSettingsManager(this));
        this.setPropManager(new PzLocalPropertiesManager(this.getDataFolder().getPath()));
        this.setWidgetRegistry(new ArrayList<PzWidget>());
        this.setTreeElementRegistry(new ArrayList<TreeElement>());
        this.setMenuRegistry(new ArrayList<PzMenu>());
        this.setIconRegistry(new ArrayList<ImageIcon>());
        this.appArguments = this.initArguments();
        this.localMachineUserSettings.setProperty("USER.DIR", System.getProperty("user.home"));
        this.setKeyStores();
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    public PzApplicationSession getSession() {
        return this.session;
    }

    public void initEMF() {
        PzEntityManagerFactory.initFactory();
        this.emf = PzEntityManagerFactory.getInstance();
    }

    private void closeEMF() {
        this.emf.close();
    }

    public PzEntityManagerFactory getEmf() {
        return this.emf;
    }

    public PzLogger getLog() {
        return this.log;
    }

    public void setLog(PzLogger log) {
        this.log = log;
    }

    public PzUserSettings getLocalMachineUserSettings() {
        return this.localMachineUserSettings;
    }

    public PzPermissionController getPermissionController() {
        return this.permissionController;
    }

    public void setWorkbench(PzWorkbench workbench) {
        this.workbench = workbench;
        workbench.addWorkbenchListener(new PzWorkbenchAdapter(){

            @Override
            public void workbenchClosed() {
                try {
                    PzApplication.this.bundleContext.getBundle(0L).stop();
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void workbenchExposed() {
                String cydb;
                String cy = new SimpleDateFormat("yyyy").format(new Date());
                if (!cy.equals(cydb = PzParameter.getParameterValue("TEKUCA_GODINA"))) {
                    PzSwingUtility.showInformationMessage(PzApplication.this.workbench.getMainFrame(), "UPOZORENJE: GODINA U KOJOJ RADITE NIJE TEKU\u0106A!");
                    PzApplication.getApplication().getWidgetRegistry();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainViewWidget.getInstance().setGradient(Color.RED, Color.WHITE, PzPanel.GRADIENT_NORTH_SOUTH);
                            MainViewWidget.getInstance().repaint();
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainViewWidget.getInstance().setGradient(Color.BLUE, Color.WHITE, PzPanel.GRADIENT_NORTH_SOUTH);
                            MainViewWidget.getInstance().repaint();
                        }
                    });
                }
            }
        });
    }

    public PzWorkbench getWorkbench() {
        return this.workbench;
    }

    public void start(BundleContext context) throws Exception {
        PzLogger.getInstance().logInfo("Installing dropins ...");
        this.loadDropins(context);
        PzLogger.getInstance().logInfo("Starting application instance ...");
        this.bundleContext = context;
        String arg = context.getProperty("pz.gui");
        this.appClass = PzWorkbenchImplNew.class;
        if ("dockable".equalsIgnoreCase(arg)) {
            this.appClass = PzDockingWorkbench.class;
        }
        PzLogger.getInstance().logInfo("Application implementation used : " + this.appClass.getName());
        instance = this;
        this.initApplication();
        PzLogger.getInstance().logInfo("Application session initialized.");
        this.initEMF();
        PzLogger.getInstance().logInfo("Application persistence layer initialized.");
        if (PzLogger.getInstance() != null) {
            PzLogger.getInstance().setApplication(this);
        }
        PzLoginDialog.logUser(this);
    }

    private void loadDropins(BundleContext context) {
        File dropinsFolter = new File(".." + File.separator + "pezar.dropins");
        if (dropinsFolter.exists() && dropinsFolter.isDirectory()) {
            File[] plugins = dropinsFolter.listFiles();
            int i = 0;
            while (i < plugins.length) {
                try {
                    context.installBundle(plugins[i].toURI().toURL().toExternalForm()).start();
                }
                catch (Exception e) {
                    PzLogger.getInstance().logException(e);
                }
                ++i;
            }
        }
    }

    private void createSharedDir() {
        File dir;
        String deljeniDir = PzParameter.getParameterValue("DELJENI_DIR");
        if (!(!"".equals(deljeniDir) && deljeniDir != null && new File(deljeniDir).exists() || (dir = new File(".." + File.separator + "shared")).exists())) {
            dir.mkdir();
        }
    }

    private HashMap<String, String> initArguments() {
        HashMap<String, String> map = new HashMap<String, String>();
        String gui = this.bundleContext.getProperty("pz.gui");
        String log = this.bundleContext.getProperty("pz.logtofile");
        map.put("pz.gui", gui);
        map.put("pz.logtofile", log);
        return map;
    }

    public void stop(BundleContext context) throws Exception {
        UserLockUtility.unLockCurrentUser();
        this.closeEMF();
    }

    public void exit() throws BundleException {
        this.bundleContext.getBundle(0L).stop();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void runApplication() {
        this.createSharedDir();
        PzColumnsManager.checkColumns();
        if (PzExtensionManager.getInstance() != null) {
            PzExtensionManager.getInstance().setApplication(instance);
        }
        Application.launch((Class)this.appClass, null);
    }

    public PzSettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(PzSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public PzLocalPropertiesManager getPropManager() {
        return this.propManager;
    }

    public void setPropManager(PzLocalPropertiesManager propManager) {
        this.propManager = propManager;
    }

    public List<PzWidget> getWidgetRegistry() {
        return this.widgetRegistry;
    }

    public void setWidgetRegistry(List<PzWidget> widgetRegistry) {
        this.widgetRegistry = widgetRegistry;
    }

    public List<TreeElement> getTreeElementRegistry() {
        return this.treeElementRegistry;
    }

    public void setTreeElementRegistry(List<TreeElement> treeElementRegistry) {
        this.treeElementRegistry = treeElementRegistry;
    }

    public List<PzMenu> getMenuRegistry() {
        return this.menuRegistry;
    }

    public void setMenuRegistry(List<PzMenu> menuRegistry) {
        this.menuRegistry = menuRegistry;
    }

    public List<ImageIcon> getIconRegistry() {
        return this.iconRegistry;
    }

    public void setIconRegistry(List<ImageIcon> iconRegistry) {
        this.iconRegistry = iconRegistry;
    }

    public HashMap<String, String> getAppArguments() {
        return this.appArguments;
    }

    public void setAppArguments(HashMap<String, String> appArguments) {
        this.appArguments = appArguments;
    }

    public PzGlobalKeyboardShortcutRegistry getShortcutRegistry() {
        return this.shortcutRegistry;
    }

    public PzGenericServiceRegistry getGenericServiceRegistry() {
        return this.genericServiceRegistry;
    }

    public List<PzDokumentFinalizer> getDokumentFinalizerRegistry() {
        return this.dokumentFinalizerRegistry;
    }

    public List<PzDokumentValidator> getDokumentValidatorRegistry() {
        return this.dokumentValidatorRegistry;
    }

    private void setKeyStores() {
        File cacerts = CertUtil.getCertFile();
        System.setProperty("javax.net.ssl.trustStore", cacerts.getAbsolutePath());
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        System.setProperty("javax.net.ssl.keyStore", cacerts.getAbsolutePath());
        System.setProperty("javax.net.ssl.keyStorePassword", "changeit");
    }

    public void restart() {
        PzWorkerDialog.showStatus("Zamena radne baze podataka u toku.", this.getWorkbench().getMainFrame());
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){
            EntityManager em;

            @Override
            protected Object doInBackground() throws Exception {
                Pzuser u1 = (Pzuser)PzEntityManager.findEntity(Pzuser.class, PzApplication.getApplication().getSession().getLoggedUser().getPzusername());
                u1.getDozvolas();
                u1.getEmails();
                u1.getTelefons();
                u1.getPzuserInfo();
                u1.getRadnoMesto();
                if (u1.getPzuser() != null) {
                    u1.getPzuser().getDozvolas();
                    u1.getPzuser().getEmails();
                    u1.getPzuser().getTelefons();
                    u1.getPzuser().getPzuserInfo();
                    u1.getPzuser().getRadnoMesto();
                }
                PzApplication.this.closeEMF();
                PzApplication.this.initEMF();
                this.em = PzEntityManagerFactory.getInstance().createEm();
                this.em.getTransaction().begin();
                Pzuser u2 = (Pzuser)this.em.find(Pzuser.class, (Object)u1.getPzusername());
                if (u2 == null) {
                    this.em.persist((Object)u1);
                }
                u2 = u1;
                Firma f = (Firma)this.em.find(Firma.class, (Object)1);
                this.em.getTransaction().commit();
                PzApplication.this.getSession().setLoggedUser(u2);
                return f;
            }

            @Override
            protected void done() {
                block8: {
                    try {
                        try {
                            String cydb;
                            String cy;
                            Firma f = (Firma)this.get();
                            if (f != null) {
                                PzApplication.this.getWorkbench().getMainFrame().setTitle(String.valueOf(PzParameter.getParameterValue("TEKUCA_GODINA")) + " - " + f.getNaziv() + " - Pezar - robno, materijalno i finansijsko knjigovodstvo");
                            }
                            if (!(cy = new SimpleDateFormat("yyyy").format(new Date())).equals(cydb = PzParameter.getParameterValue("TEKUCA_GODINA"))) {
                                PzSwingUtility.showInformationMessage(PzApplication.getApplication().getWorkbench().getMainFrame(), "UPOZORENJE: GODINA U KOJOJ RADITE NIJE TEKU\u0106A!");
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MainViewWidget.getInstance().setGradient(Color.RED, Color.WHITE, PzPanel.GRADIENT_NORTH_SOUTH);
                                        MainViewWidget.getInstance().repaint();
                                    }
                                });
                                break block8;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MainViewWidget.getInstance().setGradient(Color.BLUE, Color.WHITE, PzPanel.GRADIENT_NORTH_SOUTH);
                                    MainViewWidget.getInstance().repaint();
                                }
                            });
                        }
                        catch (Exception e) {
                            if (this.em.getTransaction().isActive()) {
                                this.em.getTransaction().rollback();
                            }
                            PzLogger.getInstance().logException(e);
                            PzWorkerDialog.hideStatus();
                            this.em.close();
                        }
                    }
                    finally {
                        PzWorkerDialog.hideStatus();
                        this.em.close();
                    }
                }
            }
        };
        worker.execute();
    }
}

