/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.calculator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.border.EmptyBorder;
import rs.pezar.calculator.CustomABOUTDialog;
import rs.pezar.calculator.DivideByZeroException;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;

public class Calculator
extends PzDialog {
    private static final long serialVersionUID = -766790252590900597L;
    final int MAX_INPUT_LENGTH = 20;
    final int INPUT_MODE = 0;
    final int RESULT_MODE = 1;
    final int ERROR_MODE = 2;
    int displayMode;
    boolean clearOnNextDigit;
    boolean percent;
    BigDecimal lastNumber;
    String lastOperator;
    private JMenu jmenuFile;
    private JMenu jmenuHelp;
    private JMenuItem jmenuitemExit;
    private JMenuItem jmenuitemAbout;
    private JLabel jlbOutput;
    private PzButton[] jbnButtons;
    private PzPanel jplMaster;
    private PzPanel jplBackSpace;
    private PzPanel jplControl;
    Font f12 = new Font("SansSerif", 0, 12);
    Font f121 = new Font("SansSerif", 1, 12);

    public Calculator(JFrame frame, String parameter) {
        super(frame);
        this.initGUI();
    }

    public Calculator(PzDialog parent) {
        super(parent);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("Kalkulator");
        this.jplMaster = new PzPanel();
        this.jlbOutput = new JLabel("0");
        this.jlbOutput.setHorizontalTextPosition(4);
        this.jlbOutput.setHorizontalAlignment(4);
        this.jlbOutput.setBackground(Color.WHITE);
        this.jlbOutput.setFont(new Font("SansSerif", 1, 16));
        this.jlbOutput.setOpaque(true);
        this.jlbOutput.setBorder(new EmptyBorder(2, 5, 2, 5));
        this.getContentPane().add((Component)this.jlbOutput, "North");
        this.jbnButtons = new PzButton[23];
        PzPanel jplButtons = new PzPanel();
        int i = 0;
        while (i <= 9) {
            this.jbnButtons[i] = new PzButton(String.valueOf(i));
            this.jbnButtons[i].setShortcut("NUMPAD" + String.valueOf(i));
            ++i;
        }
        this.jbnButtons[10] = new PzButton("+/-");
        this.jbnButtons[11] = new PzButton(".");
        this.jbnButtons[11].setShortcut("DECIMAL");
        this.jbnButtons[12] = new PzButton("=");
        this.jbnButtons[12].setShortcut("ENTER");
        this.jbnButtons[13] = new PzButton("/");
        this.jbnButtons[13].setShortcut("DIVIDE");
        this.jbnButtons[14] = new PzButton("*");
        this.jbnButtons[14].setShortcut("MULTIPLY");
        this.jbnButtons[15] = new PzButton("-");
        this.jbnButtons[15].setShortcut("SUBTRACT");
        this.jbnButtons[16] = new PzButton("+");
        this.jbnButtons[16].setShortcut("ADD");
        this.jbnButtons[17] = new PzButton("sqrt");
        this.jbnButtons[18] = new PzButton("1/x");
        this.jbnButtons[19] = new PzButton("%");
        this.jplBackSpace = new PzPanel();
        this.jplBackSpace.setLayout(new GridLayout(1, 1, 2, 2));
        this.jplBackSpace.setOpaque(false);
        this.jbnButtons[20] = new PzButton("Backspace");
        this.jbnButtons[20].setShortcut("BACKSPACE");
        this.jplBackSpace.add(this.jbnButtons[20]);
        this.jplControl = new PzPanel();
        this.jplControl.setLayout(new GridLayout(1, 2, 2, 2));
        this.jplControl.setOpaque(false);
        this.jbnButtons[21] = new PzButton(" CE ");
        this.jbnButtons[22] = new PzButton("C");
        this.jbnButtons[22].setShortcut("DELETE");
        this.jplControl.add(this.jbnButtons[21]);
        this.jplControl.add(this.jbnButtons[22]);
        i = 0;
        while (i < this.jbnButtons.length) {
            this.jbnButtons[i].setFont(this.f12);
            if (i < 10) {
                this.jbnButtons[i].setForeground(Color.blue);
            } else {
                this.jbnButtons[i].setForeground(Color.red);
            }
            ++i;
        }
        jplButtons.setLayout(new GridLayout(4, 5, 2, 2));
        jplButtons.setOpaque(false);
        i = 7;
        while (i <= 9) {
            jplButtons.add(this.jbnButtons[i]);
            ++i;
        }
        jplButtons.add(this.jbnButtons[13]);
        jplButtons.add(this.jbnButtons[17]);
        i = 4;
        while (i <= 6) {
            jplButtons.add(this.jbnButtons[i]);
            ++i;
        }
        jplButtons.add(this.jbnButtons[14]);
        jplButtons.add(this.jbnButtons[18]);
        i = 1;
        while (i <= 3) {
            jplButtons.add(this.jbnButtons[i]);
            ++i;
        }
        jplButtons.add(this.jbnButtons[15]);
        jplButtons.add(this.jbnButtons[19]);
        jplButtons.add(this.jbnButtons[0]);
        jplButtons.add(this.jbnButtons[10]);
        jplButtons.add(this.jbnButtons[11]);
        jplButtons.add(this.jbnButtons[16]);
        jplButtons.add(this.jbnButtons[12]);
        jplButtons.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.jplMaster.setLayout(new BorderLayout());
        this.jplMaster.add((Component)this.jplBackSpace, "West");
        this.jplMaster.add((Component)this.jplControl, "East");
        this.jplMaster.add((Component)jplButtons, "South");
        this.jplMaster.setPaintGradient(true);
        this.jplMaster.setGradient(Color.WHITE, Color.LIGHT_GRAY, PzPanel.GRADIENT_WEST_EAST);
        this.getContentPane().add((Component)this.jplMaster, "South");
        this.requestFocus();
        i = 0;
        while (i < this.jbnButtons.length) {
            this.jbnButtons[i].addActionListener(this);
            this.jbnButtons[i].setFocusable(false);
            ++i;
        }
        this.clearAll();
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BigDecimal result = new BigDecimal("0");
        if (e.getSource() == this.jmenuitemAbout) {
            CustomABOUTDialog dlgAbout = new CustomABOUTDialog(this, "About Java Swing Calculator", true);
            dlgAbout.setVisible(true);
        } else if (e.getSource() == this.jmenuitemExit) {
            this.dispose();
        }
        int i = 0;
        while (i < this.jbnButtons.length) {
            if (e.getSource() == this.jbnButtons[i]) {
                switch (i) {
                    case 0: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 1: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 2: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 3: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 4: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 5: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 6: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 7: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 8: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 9: {
                        this.addDigitToDisplay(i);
                        break;
                    }
                    case 10: {
                        this.processSignChange();
                        break;
                    }
                    case 11: {
                        this.addDecimalPoint();
                        break;
                    }
                    case 12: {
                        this.processEquals();
                        break;
                    }
                    case 13: {
                        this.processOperator("/");
                        break;
                    }
                    case 14: {
                        this.processOperator("*");
                        break;
                    }
                    case 15: {
                        this.processOperator("-");
                        break;
                    }
                    case 16: {
                        this.processOperator("+");
                        break;
                    }
                    case 17: {
                        if (this.displayMode == 2) break;
                        try {
                            if (this.getDisplayString().indexOf("-") == 0) {
                                this.displayError("Invalid input for function!");
                            }
                            result = new BigDecimal(Math.sqrt(this.getNumberInDisplay().doubleValue()));
                            this.displayResult(result);
                        }
                        catch (Exception exception) {
                            this.displayError("Invalid input for function!");
                            this.displayMode = 2;
                        }
                        break;
                    }
                    case 18: {
                        if (this.displayMode == 2) break;
                        try {
                            if (this.getNumberInDisplay().equals(new BigDecimal("0"))) {
                                this.displayError("Cannot divide by zero!");
                            }
                            result = new BigDecimal(1.0 / this.getNumberInDisplay().doubleValue());
                            this.displayResult(result);
                        }
                        catch (Exception exception) {
                            this.displayError("Cannot divide by zero!");
                            this.displayMode = 2;
                        }
                        break;
                    }
                    case 19: {
                        if (this.displayMode == 2) break;
                        try {
                            result = new BigDecimal(this.getNumberInDisplay().doubleValue() / 100.0);
                            this.displayResult(result);
                        }
                        catch (Exception exception) {
                            this.displayError("Invalid input for function!");
                            this.displayMode = 2;
                        }
                        break;
                    }
                    case 20: {
                        if (this.displayMode == 2) break;
                        this.setDisplayString(this.getDisplayString().substring(0, this.getDisplayString().length() - 1));
                        if (this.getDisplayString().length() >= 1) break;
                        this.setDisplayString("0");
                        break;
                    }
                    case 21: {
                        this.clearExisting();
                        break;
                    }
                    case 22: {
                        this.clearAll();
                    }
                }
            }
            ++i;
        }
    }

    void setDisplayString(String s) {
        this.jlbOutput.setText(s);
    }

    String getDisplayString() {
        return this.jlbOutput.getText();
    }

    void addDigitToDisplay(int digit) {
        String inputString;
        if (this.clearOnNextDigit) {
            this.setDisplayString("");
        }
        if ((inputString = this.getDisplayString()).indexOf("0") == 0) {
            inputString = inputString.substring(1);
        }
        if (!(inputString.equals("0") && digit <= 0 || inputString.length() >= 20)) {
            this.setDisplayString(String.valueOf(inputString) + digit);
        }
        this.displayMode = 0;
        this.clearOnNextDigit = false;
    }

    void addDecimalPoint() {
        String inputString;
        this.displayMode = 0;
        if (this.clearOnNextDigit) {
            this.setDisplayString("");
        }
        if ((inputString = this.getDisplayString()).indexOf(".") < 0) {
            this.setDisplayString(new String(String.valueOf(inputString) + "."));
        }
    }

    void processSignChange() {
        BigDecimal numberInDisplay;
        if (this.displayMode == 0) {
            String input = this.getDisplayString();
            if (input.length() > 0 && !input.equals("0")) {
                if (input.indexOf("-") == 0) {
                    this.setDisplayString(input.substring(1));
                } else {
                    this.setDisplayString("-" + input);
                }
            }
        } else if (this.displayMode == 1 && !(numberInDisplay = this.getNumberInDisplay()).equals(new BigDecimal("0"))) {
            this.displayResult(numberInDisplay.negate());
        }
    }

    void clearAll() {
        this.setDisplayString("0");
        this.lastOperator = "0";
        this.lastNumber = new BigDecimal("0");
        this.displayMode = 0;
        this.clearOnNextDigit = true;
    }

    void clearExisting() {
        this.setDisplayString("0");
        this.clearOnNextDigit = true;
        this.displayMode = 0;
    }

    BigDecimal getNumberInDisplay() {
        String input = this.jlbOutput.getText();
        return new BigDecimal(input);
    }

    void processOperator(String op) {
        if (this.displayMode != 2) {
            BigDecimal numberInDisplay = this.getNumberInDisplay();
            if (!this.lastOperator.equals("0")) {
                try {
                    BigDecimal result = this.processLastOperator();
                    this.displayResult(result);
                    this.lastNumber = result;
                }
                catch (DivideByZeroException divideByZeroException) {}
            } else {
                this.lastNumber = numberInDisplay;
            }
            this.clearOnNextDigit = true;
            this.lastOperator = op;
        }
    }

    void processEquals() {
        BigDecimal result = new BigDecimal("0");
        if (this.displayMode != 2) {
            try {
                result = this.processLastOperator();
                this.displayResult(result);
            }
            catch (DivideByZeroException divideByZeroException) {
                this.displayError("Cannot divide by zero!");
            }
            this.lastOperator = "0";
        }
    }

    BigDecimal processLastOperator() throws DivideByZeroException {
        BigDecimal result = new BigDecimal("0");
        BigDecimal numberInDisplay = this.getNumberInDisplay();
        if (this.lastOperator.equals("/")) {
            if (numberInDisplay.equals(new BigDecimal("0"))) {
                throw new DivideByZeroException();
            }
            result = new BigDecimal(this.lastNumber.doubleValue() / numberInDisplay.doubleValue()).setScale(15, 4);
        }
        if (this.lastOperator.equals("*")) {
            result = this.lastNumber.multiply(numberInDisplay);
        }
        if (this.lastOperator.equals("-")) {
            result = this.lastNumber.subtract(numberInDisplay);
        }
        if (this.lastOperator.equals("+")) {
            result = this.lastNumber.add(numberInDisplay);
        }
        return result;
    }

    void displayResult(BigDecimal result) {
        this.setDisplayString(result.toString());
        this.lastNumber = result;
        this.displayMode = 1;
        this.clearOnNextDigit = true;
    }

    void displayError(String errorMessage) {
        this.setDisplayString(errorMessage);
        this.lastNumber = new BigDecimal("0");
        this.displayMode = 2;
        this.clearOnNextDigit = true;
    }
}

