/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PZDBF;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.interniprenos.PzExtensionLoader;
import rs.pezar.interniprenos.gui.PzDialogIzradaPovratnice;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogDokumentiPovratnica
extends PzDialog {
    protected static Interniracun selected;
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjePovratnice;
    private PzToolBarIcon icnIzmenaPovratnice;
    private PzToolBarIcon icnDododavanjePovratnice;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private PzComponentGroup fIcnGroup;
    private Interniracun povratnicaBrisanje;
    private Stanje stanje;
    private String parameter;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogDokumentiPovratnica(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDokumentiPovratnica(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    public PzDialogDokumentiPovratnica(PzDialog dialog, String parameter) {
        super(dialog);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        if (this.parameter.equalsIgnoreCase("Interniracun")) {
            this.fIcnGroup.hideAll();
        } else {
            this.parameter.equalsIgnoreCase("");
        }
        this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)this.parameter, (int)0, (int)0, (String)"POVRATNICA"), Interniracun.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogDokumentiPovratnica.this.table.getSelectedRow() != -1) {
                    PzDialogDokumentiPovratnica.this.showDialog(PzDialogIzradaPovratnice.class, true, PzDialogDokumentiPovratnica.this.table, PzDialogDokumentiPovratnica.this.table.getSelectedEntity());
                }
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogDokumentiPovratnica.this.brDok.setText(Integer.toString(PzDialogDokumentiPovratnica.this.table.getDataSize()));
            }
        });
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{110, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setPreferredSize(new Dimension(992, 339));
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.kIcnGroup = new PzComponentGroup();
            this.fIcnGroup = new PzComponentGroup();
            this.toolbar.setOpaque(false);
            this.icnDododavanjePovratnice = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDododavanjePovratnice);
            this.toolbar.add((Component)this.icnDododavanjePovratnice);
            this.icnDododavanjePovratnice.setText("Nova|povratnica|(Insert)");
            this.icnDododavanjePovratnice.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_add.png")));
            this.icnDododavanjePovratnice.addActionListener((ActionListener)((Object)this));
            this.icnDododavanjePovratnice.setActionCommand("insert_povratnica");
            this.icnDododavanjePovratnice.setShortcut("insert");
            this.icnIzmenaPovratnice = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaPovratnice);
            this.toolbar.add((Component)this.icnIzmenaPovratnice);
            this.icnIzmenaPovratnice.setText("Izmena|povratnice|(F3)");
            this.icnIzmenaPovratnice.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_edit.png")));
            this.icnIzmenaPovratnice.setActionCommand("update_povratnica");
            this.icnIzmenaPovratnice.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaPovratnice.setShortcut("f3");
            this.icnBrisanjePovratnice = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjePovratnice);
            this.toolbar.add((Component)this.icnBrisanjePovratnice);
            this.icnBrisanjePovratnice.setText("Brisanje|povratnice|(Delete)");
            this.icnBrisanjePovratnice.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_delete.png")));
            this.icnBrisanjePovratnice.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjePovratnice.setActionCommand("delete_povratnica");
            this.icnBrisanjePovratnice.setShortcut("delete");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(1000, 600);
            this.setMinimumSize(new Dimension(800, 600));
            this.setTitle("Povratnice u pripremi");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        boolean izmena = false;
        if (!actionCommand.equals("insert_povratnica")) {
            if (actionCommand.equals("update_povratnica")) {
                if (this.table.getSelectedRow() == -1) {
                    return;
                }
                izmena = true;
            } else if (actionCommand.equals("delete_povratnica")) {
                EntityManager em = PzEntityManager.getEm();
                this.povratnicaBrisanje = (Interniracun)this.table.getSelectedEntity();
                if (this.povratnicaBrisanje == null) {
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    for (Artikalinterniracun aintrac : this.povratnicaBrisanje.getArtikalinterniracuns()) {
                        this.stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(aintrac.getId().getSfrProizvod(), this.povratnicaBrisanje.getIzlaznaRJ()));
                        if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                            this.stanje.setAlocKolicina(this.stanje.getAlocKolicina() - aintrac.getKolicina());
                        }
                        em.merge((Object)this.stanje);
                    }
                    em.remove(em.find(Interniracun.class, (Object)this.povratnicaBrisanje.getIdDok()));
                    em.getTransaction().commit();
                    this.table.removeSelectedEntity(false, false);
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
                finally {
                    em.close();
                }
            }
        }
        this.showDialog(PzDialogIzradaPovratnice.class, izmena, this.table, null);
        this.table.refreshData();
        this.refresh();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogDokumentiPovratnica(Boolean.FALSE);
    }

    public PzDialogDokumentiPovratnica(Boolean initGUI) {
    }

    public void finish() {
        this.table.removeSelectedEntity(false, false);
    }

    public static Interniracun getInterniRacunUPripermi(PzDialog parent, String parameter) {
        PzDialogDokumentiPovratnica dlg = new PzDialogDokumentiPovratnica(parent, parameter);
        if (!dlg.shouldBeShown()) {
            return null;
        }
        dlg.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selected = (Interniracun)PzDialogDokumentiPovratnica.this.table.getSelectedEntity();
                PzDialogDokumentiPovratnica.this.dispose();
            }
        });
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        Interniracun res = selected;
        selected = null;
        return res;
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        return true;
    }
}

