/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.shemeKnjizenja;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Shema;
import rs.pezar.db.entity.Stavkasheme;
import rs.pezar.db.entity.StavkashemePK;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.sifarnici.gui.PzDialogKontniPlan;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextArea;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogNovaStavka
extends PzDialog {
    private static final long serialVersionUID = 2624805856164880298L;
    private PzPanel content;
    private PzTextField tfNazivKonta;
    private PzButton btnOK;
    private PzTextAreaPanel taIzraz;
    private JLabel lblIzraz;
    private JLabel lblPolja;
    private PzTextField tfOpis;
    private JScrollPane scpPolja;
    private JList lstPolja;
    private PzRadioGroup rgrStrana;
    private JLabel lblOpis;
    private PzTextField txtAnalitika;
    private JLabel lblAnalitika;
    private PzTextField tfKonto;
    private JLabel lblKonto;
    private PzPanel mainPanel;
    private PzPanelHeader header;
    private ResourceMap rmap;
    private PzRadioGroup rgrIndikator;
    private boolean update;
    private PzTextAreaPanel taUslov;
    private JLabel lblUslov;
    private PzChoice chUlaznaRj;
    private PzChoice chIzlaznaRj;
    private PzTextArea inFocus;

    public static void main(String[] args) {
    }

    public PzDialogNovaStavka(JFrame frame) {
        super(frame);
        this.rmap = Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass());
        this.initGUI();
    }

    public PzDialogNovaStavka() {
        this.initGUI();
    }

    public PzDialogNovaStavka(PzDialog parent) {
        super(parent);
        this.rmap = Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass());
        this.initGUI();
        Boolean update = (Boolean)this.getSession().getParameter("update");
        if (update.booleanValue()) {
            this.setHeaderOnUpdate();
            this.onUpdate();
            if (this.getSession().getParameter("kopiranje") != null) {
                update = Boolean.FALSE;
                this.update = Boolean.FALSE;
                this.getSession().putParameter("update", (Object)Boolean.FALSE);
            }
        } else {
            this.setHeaderOnInsert();
            this.onInsert();
        }
        this.populateList();
        this.addFocusListener();
    }

    protected void initGUI() {
        try {
            this.content = new PzPanel();
            BorderLayout contentLayout = new BorderLayout();
            this.content.setLayout((LayoutManager)contentLayout);
            this.getContentPane().add((Component)this.content, "Center");
            this.header = new PzPanelHeader();
            this.content.add((Component)this.header, (Object)"North");
            this.mainPanel = new PzPanel();
            this.content.add((Component)this.mainPanel, (Object)"Center");
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.1, 0.0};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7, 77, 75, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 89, 7, 7};
            this.lblKonto = new JLabel();
            this.lblKonto.setText("Konto:");
            this.mainPanel.add((Component)this.lblKonto, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
            this.lblKonto.setName("lblKonto");
            this.tfKonto = new PzTextField();
            this.tfKonto.setFKField(Konto.class, PzDialogKontniPlan.class, true, null);
            this.tfKonto.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        return PzEntityManager.find(Konto.class, (Object)new KontoPK(PzDialogNovaStavka.this.tfKonto.getVal(), ""));
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)PzDialogNovaStavka.this.tfKonto, (Throwable)e);
                        return null;
                    }
                }
            });
            this.mainPanel.add((Component)this.tfKonto, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.tfKonto.setName("tfKonto");
            this.lblAnalitika = new JLabel("Tip analitike:");
            this.mainPanel.add((Component)this.lblAnalitika, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
            this.lblAnalitika.setName("lblAnalitika");
            this.txtAnalitika = new PzTextField();
            this.mainPanel.add((Component)this.txtAnalitika, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.txtAnalitika.setName("txtAnalitika");
            this.txtAnalitika.setEditable(false);
            this.txtAnalitika.setFocusable(false);
            this.tfNazivKonta = new PzTextField();
            this.mainPanel.add((Component)this.tfNazivKonta, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.tfNazivKonta.setName("tfNazivKonta");
            this.tfNazivKonta.setEditable(false);
            this.tfNazivKonta.setFocusable(false);
            PzChoice chDuguje = new PzChoice(this.rmap.getString("duguje", new Object[0]), (Object)"D");
            PzChoice chPotrazuje = new PzChoice(this.rmap.getString("potrazuje", new Object[0]), (Object)"P");
            this.rgrStrana = PzRadioGroup.create((Object[])new PzChoice[]{chDuguje, chPotrazuje});
            this.rgrStrana.setSelectedValue((Object)chDuguje);
            this.mainPanel.add((Component)this.rgrStrana, (Object)new GridBagConstraints(3, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.chUlaznaRj = new PzChoice(this.rmap.getString("ulaznaRj", new Object[0]), (Object)"Q");
            this.chIzlaznaRj = new PzChoice(this.rmap.getString("izlaznaRj", new Object[0]), (Object)"W");
            this.rgrIndikator = PzRadioGroup.create((Object[])new PzChoice[]{this.chUlaznaRj, this.chIzlaznaRj});
            this.rgrIndikator.setSelectedValue((Object)this.chUlaznaRj);
            this.mainPanel.add((Component)this.rgrIndikator, (Object)new GridBagConstraints(3, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.lblOpis = new JLabel("Opis");
            this.mainPanel.add((Component)this.lblOpis, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
            this.lblOpis.setName("lblOpis");
            this.tfOpis = new PzTextField();
            this.mainPanel.add((Component)this.tfOpis, (Object)new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.scpPolja = new JScrollPane();
            this.mainPanel.add((Component)this.scpPolja, (Object)new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.lstPolja = new JList();
            this.scpPolja.setViewportView(this.lstPolja);
            this.lstPolja.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PzDialogNovaStavka.this.lstPoljaMouseClicked(evt);
                }
            });
            this.lblPolja = new JLabel("Polja:");
            this.mainPanel.add((Component)this.lblPolja, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
            this.lblPolja.setName("lblPolja");
            this.lblIzraz = new JLabel("Izraz");
            this.mainPanel.add((Component)this.lblIzraz, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
            this.lblIzraz.setName("lblIzraz");
            this.taIzraz = new PzTextAreaPanel();
            this.mainPanel.add((Component)this.taIzraz, (Object)new GridBagConstraints(1, 7, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.btnOK = new PzButton("OK");
            this.mainPanel.add((Component)this.btnOK, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOK.setName("btnOK");
            this.btnOK.setAction(this.getAppActionMap().get((Object)"akcijaOK"));
            this.lblUslov = new JLabel("Uslov");
            this.mainPanel.add((Component)this.lblUslov, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
            this.lblUslov.setName("lblUslov");
            this.taUslov = new PzTextAreaPanel();
            this.mainPanel.add((Component)this.taUslov, (Object)new GridBagConstraints(1, 6, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.setSize(637, 602);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    @Action
    public void akcijaOK() {
        Stavkasheme stavka;
        Shema shema = (Shema)this.getSession().getParameter("shema");
        Object object = stavka = !this.update ? new Stavkasheme() : ((PzTable)this.getSession().getParameter("TABLE_STAVKE")).getSelectedEntity();
        if (!this.update) {
            stavka.setId(new StavkashemePK(shema.getId(), this.getMaximum(shema.getStavkashemes()) + 1));
        }
        stavka.setIndikator(((PzChoice)this.rgrIndikator.getSelectedValue()).getValue().toString());
        stavka.setStrana(Integer.valueOf(this.rgrStrana.getSelectedIndex()));
        stavka.setOpis(this.tfOpis.getVal());
        stavka.setNazivKonta(this.tfNazivKonta.getVal());
        stavka.setOznKonto(this.tfKonto.getVal());
        stavka.setTipAnalitike(this.txtAnalitika.getVal());
        stavka.setIzraz(this.taIzraz.getVal().replaceAll("\t", ""));
        stavka.setShema(shema);
        stavka.setUslov(this.taUslov.getVal().replaceAll("\t", ""));
        if (!this.update) {
            ((PzTable)this.getSession().getParameter("TABLE_STAVKE")).insert((PzEntity)stavka, true);
        } else {
            ((PzTable)this.getSession().getParameter("TABLE_STAVKE")).updateSelectedEntity((PzEntity)stavka, true);
        }
        this.dispose();
    }

    private int getMaximum(List<Stavkasheme> stavkashemes) {
        int max = 0;
        for (Stavkasheme stavka : stavkashemes) {
            if (stavka.getId().getrBroj() <= max) continue;
            max = stavka.getId().getrBroj();
        }
        return max;
    }

    private ApplicationActionMap getAppActionMap() {
        return Application.getInstance().getContext().getActionMap((Object)this);
    }

    private Vector<String> getFieldNames(Class c) {
        Vector<String> result = new Vector<String>();
        Field[] fields = c.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType().equals(Double.TYPE) || fields[i].getType().equals(Double.class) || fields[i].getType().equals(Integer.TYPE) || fields[i].getType().equals(Integer.class) || fields[i].getType().equals(Short.TYPE) || fields[i].getType().equals(Short.class) || fields[i].getType().equals(BigDecimal.class) || fields[i].getType().equals(String.class)) {
                result.add(fields[i].getName());
            }
            ++i;
        }
        if (c.getSuperclass() != null) {
            result.addAll(this.getFieldNames(c.getSuperclass()));
        }
        return result;
    }

    private void populateList() {
        Shema s = (Shema)this.getSession().getParameter("shema");
        Vector<String> fnames = this.getFieldNames(TipDokumentConfig.getClassByValue((String)s.getId().getTipDok()));
        this.lstPolja.setListData(fnames);
    }

    protected void setHeaderOnUpdate() {
        this.header.setTitle(this.rmap.getString("header.text.update", new Object[0]));
        this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource(this.rmap.getString("header.icon.update", new Object[0]))));
    }

    protected void setHeaderOnInsert() {
        this.header.setTitle(this.rmap.getString("header.text.insert", new Object[0]));
        this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource(this.rmap.getString("header.icon.insert", new Object[0]))));
    }

    protected void onUpdate() {
        try {
            if (((PzTable)this.getSession().getParameter("TABLE_STAVKE")).getSelectedEntity() != null) {
                Stavkasheme stavka = (Stavkasheme)((PzTable)this.getSession().getParameter("TABLE_STAVKE")).getSelectedEntity();
                Konto konto = (Konto)PzEntityManager.find(Konto.class, (Object)new KontoPK(stavka.getOznKonto(), ""));
                this.tfKonto.setVal((Object)konto.getId().getOznKonto());
                this.tfNazivKonta.setVal((Object)konto.getNaziv());
                this.txtAnalitika.setVal((Object)stavka.getTipAnalitike());
                this.rgrStrana.setSelectedIndex(stavka.getStrana().intValue());
                if (this.chIzlaznaRj.getValue().equals(stavka.getIndikator())) {
                    this.rgrIndikator.setSelectedValue((Object)this.chIzlaznaRj);
                }
                this.tfOpis.setVal((Object)stavka.getOpis());
                this.taUslov.setVal((Object)stavka.getUslov());
                this.taIzraz.setVal((Object)stavka.getIzraz());
                this.update = true;
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void onInsert() {
        this.update = false;
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        Konto konto = (Konto)entity;
        this.tfKonto.setVal((Object)konto.getId().getOznKonto());
        this.tfNazivKonta.setVal((Object)konto.getNaziv());
        this.txtAnalitika.setVal((Object)konto.getTipAnalitike());
    }

    private void lstPoljaMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            String fname = (String)this.lstPolja.getSelectedValue();
            fname = "DOK{" + fname + "}";
            this.inFocus.insert(fname, this.inFocus.getCaretPosition());
        }
    }

    private void addFocusListener() {
        FocusListener listener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                PzDialogNovaStavka.this.inFocus = (PzTextArea)e.getSource();
            }
        };
        this.taIzraz.getArea().addFocusListener(listener);
        this.taUslov.getArea().addFocusListener(listener);
    }
}

