/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.obracuni;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.OtpisPotrazivanja;
import rs.pezar.finansije.gui.obracuni.IspravkaPotrazivanja;
import rs.pezar.finansije.util.FinansijeGradientUtil;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogPotrazivanja
extends PzDialog {
    private static final String KUPCI = "Kupci";
    private static final String DOBAVLJACI = "Dobavlja\u010di";
    private static final String ISPRAVKA = "ispravka";
    private static final String OTPIS = "otpis";
    private PzFieldIndikator indDug;
    private JLabel jLabel1;
    private PzDoubleField dfIznosDuga;
    private JLabel lblIznos;
    private JToolBar toolbar;
    private JLabel lblNapomena;
    private PzCalculatedField dfVrednost;
    private JLabel lblVrednost;
    private PzButton btnDalje;
    private PzDateField dfDatum;
    private JLabel lblDatum;
    private PzRadioGroup<String> panelRbs1;
    private PzScrollableTableEntity tblTabela;
    private JScrollPane scrollPane;
    private PzPanel pnlField;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnSelectDeselect;
    private PzToolBarIcon icnDeselectAll;
    private PzToolBarIcon icnSelectAll;
    private PzToolBarIcon icnArhiva;
    private String parameter;
    private ScrollableCursor cursor = null;
    private PzTextField tfSifra;
    private JLabel lblKomitent;
    private String tipDok;
    private PzToolBarIcon icnSlikaDokumenta;
    private boolean ispravka = false;
    private boolean arhiva = false;
    private List<Kalkulacija> listaKal = null;
    private List<Faktura> listaFak = null;
    private final int idDokColumnIndex = 0;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel("0");

    public PzDialogPotrazivanja(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        if (this.parameter.equals(ISPRAVKA)) {
            this.lblNapomena.setText("<html>NAPOMENA:<br>Modul za izradu ispravke potra\u017eivanja radi na nivou INFORMATIVNE TABELE.<br>Dakle, formirana informacija se ne bele\u017ei i ne knji\u017ei ni u jednu drugu tabelu.</html>");
            this.setTitle("ISPRAVKA POTRA\u017dIVANJA");
        } else {
            this.icnSelectAll.setEnabled(false);
            this.icnDeselectAll.setEnabled(false);
            this.setTitle("OTPIS POTRA\u017dIVANJA");
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1, 0.0, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{90, 80, 66, 140, 122, 55};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlField = new PzPanel();
            GridBagLayout pnlFieldLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlField, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldLayout.rowHeights = new int[]{5, 14, 25, 25, 25, 7};
            pnlFieldLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldLayout.columnWidths = new int[]{10, 118, 110, 120, 25, 123, 120, 112, 7};
            this.pnlField.setLayout((LayoutManager)pnlFieldLayout);
            this.pnlField.setOpaque(false);
            this.panelRbs1 = new PzRadioGroup((Object[])new String[]{KUPCI, DOBAVLJACI});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs1, 1);
            this.panelRbs1.setLayout((LayoutManager)panelRBsLayout);
            this.pnlField.add(this.panelRbs1, (Object)new GridBagConstraints(1, 1, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.panelRbs1.setBorder((Border)BorderFactory.createTitledBorder("Grupa"));
            this.panelRbs1.setSelectedValue((Object)KUPCI);
            this.panelRbs1.setOpaque(false);
            this.lblDatum = new JLabel();
            this.pnlField.add((Component)this.lblDatum, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblDatum.setName("lblDatum");
            this.dfDatum = new PzDateField();
            this.pnlField.add((Component)this.dfDatum, (Object)new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnDalje = new PzButton();
            this.pnlField.add((Component)this.btnDalje, (Object)new GridBagConstraints(7, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.btnDalje.setName("btnDalje");
            this.btnDalje.setBounds(195, 12, 133, 30);
            this.btnDalje.setFont(new Font("Tahoma", 1, 12));
            this.btnDalje.setActionCommand("dalje");
            this.btnDalje.addActionListener((ActionListener)((Object)this));
            this.btnDalje.setShortcut("enter");
            this.lblVrednost = new JLabel();
            this.pnlField.add((Component)this.lblVrednost, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblVrednost.setName("lblVrednost");
            this.lblKomitent = new JLabel();
            this.pnlField.add((Component)this.lblKomitent, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKomitent.setName("lblKomitent");
            this.tfSifra = new PzTextField();
            this.pnlField.add((Component)this.tfSifra, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (!PzDialogPotrazivanja.this.tfSifra.getVal().equals("")) {
                        try {
                            Komitent k = (Komitent)PzEntityManager.find(Komitent.class, (Object)PzDialogPotrazivanja.this.tfSifra.getVal());
                            if (k == null) {
                                PzSwingUtility.showErrorMessage((Component)((Object)PzDialogPotrazivanja.this), (String)"Komitet sa izabranom \u0161ifrom ne postoji u bazi!");
                                return false;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
            });
            this.lblIznos = new JLabel();
            this.pnlField.add((Component)this.lblIznos, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblIznos.setText("Iznos duga");
            this.dfIznosDuga = new PzDoubleField();
            this.pnlField.add((Component)this.dfIznosDuga, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfIznosDuga.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    PzField field = (PzField)arg0;
                    if (PzDialogPotrazivanja.this.dfIznosDuga.getVal() != null) {
                        field.setState(PzFieldIndikator.STATE_VALID);
                        return true;
                    }
                    field.setState(PzFieldIndikator.STATE_INVALID);
                    return false;
                }
            });
            this.jLabel1 = new JLabel();
            this.pnlField.add((Component)this.jLabel1, (Object)new GridBagConstraints(2, 4, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel1.setText("Napomena: Prikazuju se dokumenti ciji dug je manji od iznosa unetog u polje Iznos duga");
            this.indDug = new PzFieldIndikator();
            this.pnlField.add((Component)this.indDug, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 2, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.scrollPane.setViewportView((Component)this.tblTabela);
            this.lblNapomena = new JLabel();
            this.pnlGlavni.add((Component)this.lblNapomena, (Object)new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblNapomena.setFont(new Font("Tahoma", 1, 12));
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnSelectDeselect = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSelectDeselect);
            this.icnSelectDeselect.setText("Sel/Desel|(F2)");
            this.icnSelectDeselect.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/select.png")));
            this.icnSelectDeselect.setActionCommand("select");
            this.icnSelectDeselect.addActionListener((ActionListener)((Object)this));
            this.icnSelectDeselect.setShortcut("F2");
            this.icnSelectAll = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSelectAll);
            this.icnSelectAll.setText("Selektuj sve|(Alt+F2)");
            this.icnSelectAll.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/selection_sve.png")));
            this.icnSelectAll.setActionCommand("selectAll");
            this.icnSelectAll.addActionListener((ActionListener)((Object)this));
            this.icnSelectAll.setShortcut("Alt+F2");
            this.icnDeselectAll = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDeselectAll);
            this.icnDeselectAll.setText("Deselektuj sve|(Alt+F5)");
            this.icnDeselectAll.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/deselect_all.png")));
            this.icnDeselectAll.setActionCommand("deselectAll");
            this.icnDeselectAll.addActionListener((ActionListener)((Object)this));
            this.icnDeselectAll.setShortcut("Alt+F5");
            this.icnSlikaDokumenta = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlikaDokumenta);
            this.icnSlikaDokumenta.setText("Slika dokumenta|(F4)");
            this.icnSlikaDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/presentation_chart.png")));
            this.icnSlikaDokumenta.setActionCommand("slika");
            this.icnSlikaDokumenta.addActionListener((ActionListener)((Object)this));
            this.icnSlikaDokumenta.setShortcut("f4");
            this.icnArhiva = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiva);
            if (this.parameter.equalsIgnoreCase(ISPRAVKA)) {
                this.icnArhiva.setText("\u0160tampa|(Ctrl+W)");
            } else {
                this.icnArhiva.setText("Arhiva|(Ctrl+W)");
            }
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/printer_preferences.png")));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("Ctrl+w");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.dfIznosDuga.setStateIndikator(this.indDug);
            this.pack();
            this.setSize(906, 653);
            this.setMinimumSize(new Dimension(906, 653));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (!this.pnlField.validateForm(true)) {
            return;
        }
        try {
            if (actionCommand.equals("dalje")) {
                this.panelRbs1.setEnabled(false);
                this.initializeTable();
            } else if (actionCommand.equals("select")) {
                if (this.tblTabela.getRowCount() != 0) {
                    this.tblTabela.switchIt();
                }
            } else if (actionCommand.equals("selectAll")) {
                if (this.tblTabela.getRowCount() != 0) {
                    this.tblTabela.checkAll();
                }
            } else if (actionCommand.equals("deselectAll")) {
                if (this.tblTabela.getRowCount() != 0) {
                    this.tblTabela.unCheckAll();
                }
            } else if (actionCommand.equals("slika")) {
                if (this.tblTabela.getRowCount() != 0) {
                    if (this.tipDok.equals(TipDokumentConfig.get().FAKTURA)) {
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)((Faktura)this.tblTabela.getSelectedEntity()));
                    } else if (this.tipDok.equals(TipDokumentConfig.get().KALKULACIJA)) {
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)((Kalkulacija)this.tblTabela.getSelectedEntity()));
                    }
                }
            } else if (actionCommand.equals("arhiva") && this.tblTabela.getRowCount() != 0) {
                if (this.parameter.equals(ISPRAVKA)) {
                    this.showReports();
                } else {
                    this.arhiva = true;
                    this.arhiviraj();
                }
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void initializeTable() {
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                em.getTransaction().begin();
                if (PzDialogPotrazivanja.this.cursor != null) {
                    PzDialogPotrazivanja.this.cursor.close();
                }
                String upit = "";
                Double dug = PzDialogPotrazivanja.this.dfIznosDuga.getVal();
                Query q = null;
                FetchGroup grp = null;
                if (((String)PzDialogPotrazivanja.this.panelRbs1.getSelectedValue()).equals(PzDialogPotrazivanja.KUPCI)) {
                    grp = new FetchGroup();
                    grp.addAttribute("iznos");
                    grp.addAttribute("stornoIznos");
                    grp.addAttribute("datValute");
                    grp.addAttribute("oznDokumenta");
                    grp.addAttribute("uplata");
                    grp.addAttribute("komitent.sfrKomitent");
                    upit = "Select dok From Faktura dok join fetch dok.komitent Where dok.tip='" + TipDokumentConfig.get().FAKTURA + "' and " + "dok.iznos-dok.stornoIznos-dok.uplata >0 and dok.iznos-dok.stornoIznos-dok.uplata<=" + dug + " and " + "dok.arhiviran=1 and " + "dok.storno=0 and " + "dok.datum<:datum";
                    PzDialogPotrazivanja.this.tipDok = TipDokumentConfig.get().FAKTURA;
                    PzDialogPotrazivanja.this.tblTabela = new PzScrollableTableEntity(Faktura.class);
                } else if (((String)PzDialogPotrazivanja.this.panelRbs1.getSelectedValue()).equals(PzDialogPotrazivanja.DOBAVLJACI)) {
                    grp = new FetchGroup();
                    grp.addAttribute("iznos");
                    grp.addAttribute("stornoIznos");
                    grp.addAttribute("datValute");
                    grp.addAttribute("oznDokumenta");
                    grp.addAttribute("uplata");
                    grp.addAttribute("komitent.sfrKomitent");
                    upit = "Select dok From Kalkulacija dok join fetch dok.komitent Where dok.iznos-dok.stornoIznos-dok.uplata >0 and dok.iznos-dok.stornoIznos-dok.uplata<=" + dug + " and " + "dok.arhiviran=1 and " + "dok.storno=0 and " + "dok.datum<:datum and " + "((dok.tip='" + TipDokumentConfig.get().KALKULACIJA + "' and dok.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA + "') or dok.tip='" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "' or dok.tip='" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "')";
                    PzDialogPotrazivanja.this.tipDok = TipDokumentConfig.get().KALKULACIJA;
                    PzDialogPotrazivanja.this.tblTabela = new PzScrollableTableEntity(Kalkulacija.class);
                }
                if (!PzDialogPotrazivanja.this.tfSifra.getVal().equals("")) {
                    upit = String.valueOf(upit) + " and dok.komitent.sfrKomitent=:komitent";
                }
                q = em.createQuery(upit);
                if (!PzDialogPotrazivanja.this.tfSifra.getVal().equals("")) {
                    q.setParameter("komitent", (Object)PzDialogPotrazivanja.this.tfSifra.getVal());
                }
                q.setParameter("datum", (Object)PzDialogPotrazivanja.this.dfDatum.getVal());
                q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                q.setHint("eclipselink.read-only", (Object)"True");
                q.setHint("eclipselink.fetch-group", (Object)grp);
                PzDialogPotrazivanja.this.cursor = (ScrollableCursor)q.getSingleResult();
                System.out.println("Kursor je nasao: " + PzDialogPotrazivanja.this.cursor.size());
                em.getTransaction().commit();
                return null;
            }

            @Override
            protected void done() {
                block9: {
                    try {
                        try {
                            this.get();
                            if (PzDialogPotrazivanja.this.cursor != null && PzDialogPotrazivanja.this.cursor.size() != 0) {
                                PzDialogPotrazivanja.this.brDok.setText(Integer.toString(PzDialogPotrazivanja.this.cursor.size()));
                                PzDialogPotrazivanja.this.tblTabela.read(PzDialogPotrazivanja.this.cursor);
                                PzDialogPotrazivanja.this.tableFilter(PzDialogPotrazivanja.this.tblTabela);
                                PzDialogPotrazivanja.this.setCheskBox(PzDialogPotrazivanja.this.tblTabela);
                                PzDialogPotrazivanja.this.tblTabela.getTableHeader().setFocusable(false);
                                if (PzDialogPotrazivanja.this.parameter.equals(PzDialogPotrazivanja.ISPRAVKA)) {
                                    PzDialogPotrazivanja.this.tblTabela.setId("TABLE_I");
                                } else {
                                    PzDialogPotrazivanja.this.tblTabela.setId("TABLE_O");
                                }
                                PzDialogPotrazivanja.this.scrollPane.setViewportView((Component)PzDialogPotrazivanja.this.tblTabela);
                                if (PzDialogPotrazivanja.this.cursor.size() > 0) {
                                    PzDialogPotrazivanja.this.tblTabela.setRowSelectionInterval(0, 0);
                                    PzDialogPotrazivanja.this.tblTabela.requestFocusInWindow();
                                }
                                PzDialogPotrazivanja.this.lblVrednost.setVisible(true);
                                PzDialogPotrazivanja.this.dfVrednost = PzDialogPotrazivanja.this.tblTabela.createExpresionField("$3$");
                                PzDialogPotrazivanja.this.pnlField.add((Component)PzDialogPotrazivanja.this.dfVrednost, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                                PzDialogPotrazivanja.this.dfVrednost.setForeground(new Color(255, 0, 0));
                                PzDialogPotrazivanja.this.dfVrednost.setFocusable(false);
                                PzDialogPotrazivanja.this.tblTabela.calculateFields();
                                break block9;
                            }
                            JOptionPane.showMessageDialog(PzDialogPotrazivanja.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPotrazivanja.this), (Throwable)e);
                            em.close();
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
            }
        };
        worker.execute();
    }

    private void setCheskBox(final PzScrollableTableEntity table) {
        table.setCheckboxColumn(0);
        if (this.parameter.equals(ISPRAVKA)) {
            table.checkAll();
        } else {
            table.unCheckAll();
        }
        table.addCheckboxListener(new PzTableCheckboxListener(){

            public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                if (newValue) {
                    BigDecimal iznosZaSlanje = (BigDecimal)table.getModel().getValueAt(rowIndex, 2);
                    PzDialogPotrazivanja.this.getSession().putParameter("iznosZaSlanje", (Object)iznosZaSlanje);
                    PzDialogPotrazivanja.this.showDialog(IspravkaPotrazivanja.class);
                    BigDecimal iznos = new BigDecimal(0);
                    if (PzDialogPotrazivanja.this.ispravka) {
                        iznos = new BigDecimal((Double)PzDialogPotrazivanja.this.getSession().getParameter("iznos"));
                    }
                    if (PzDialogPotrazivanja.this.parameter.equals(PzDialogPotrazivanja.OTPIS)) {
                        if (PzDialogPotrazivanja.this.tipDok.equals(TipDokumentConfig.get().FAKTURA)) {
                            Faktura dok = (Faktura)table.getSelectedEntity();
                            table.updateGUI(rowIndex, (PzEntity)dok);
                            dok.setZatvaranje(Double.valueOf(iznos.doubleValue()));
                            table.updateGUI(rowIndex, (PzEntity)dok);
                        } else if (PzDialogPotrazivanja.this.tipDok.equals(TipDokumentConfig.get().KALKULACIJA)) {
                            Kalkulacija dok = (Kalkulacija)table.getSelectedEntity();
                            table.updateGUI(rowIndex, (PzEntity)dok);
                            dok.setZatvaranje(iznos);
                            table.updateGUI(rowIndex, (PzEntity)dok);
                        }
                    }
                    if (iznos.doubleValue() == 0.0) {
                        table.setRowChecked(rowIndex, false);
                    }
                } else if (PzDialogPotrazivanja.this.parameter.equals(PzDialogPotrazivanja.OTPIS)) {
                    if (PzDialogPotrazivanja.this.tipDok.equals(TipDokumentConfig.get().FAKTURA)) {
                        ((Faktura)table.getSelectedEntity()).setZatvaranje(Double.valueOf(0.0));
                        table.updateGUI(rowIndex, table.getSelectedEntity());
                    } else if (PzDialogPotrazivanja.this.tipDok.equals(TipDokumentConfig.get().KALKULACIJA)) {
                        ((Kalkulacija)table.getSelectedEntity()).setZatvaranje(new BigDecimal(0));
                        table.updateGUI(rowIndex, table.getSelectedEntity());
                    }
                }
                table.calculateFields();
            }
        });
    }

    public void ispravkaPotrazivanja(boolean ispravka) {
        this.ispravka = ispravka;
    }

    private void tableFilter(PzScrollableTableEntity table) {
        table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Object[] object = null;
                if (PzDialogPotrazivanja.this.tipDok.equals(TipDokumentConfig.get().FAKTURA)) {
                    Faktura dok = (Faktura)entity;
                    BigDecimal dug = dok.getIznos().subtract(dok.getStornoIznos()).subtract(dok.getUplata());
                    int kasni = PzDateUtility.subtract((Date)PzDialogPotrazivanja.this.dfDatum.getVal(), (Date)dok.getDatValute());
                    object = PzDialogPotrazivanja.this.parameter.equals(PzDialogPotrazivanja.ISPRAVKA) ? new Object[]{dok.getOznDokumenta(), dug, dug, dok.getDatValute(), kasni} : new Object[]{dok.getOznDokumenta(), dug, dok.getZatvaranje(), dok.getDatValute(), kasni};
                } else if (PzDialogPotrazivanja.this.tipDok.equals(TipDokumentConfig.get().KALKULACIJA)) {
                    Kalkulacija dok = (Kalkulacija)entity;
                    BigDecimal dug = dok.getIznos().subtract(dok.getStornoIznos()).subtract(dok.getUplata());
                    int kasni = PzDateUtility.subtract((Date)PzDialogPotrazivanja.this.dfDatum.getVal(), (Date)dok.getDatValute());
                    object = PzDialogPotrazivanja.this.parameter.equals(PzDialogPotrazivanja.ISPRAVKA) ? new Object[]{dok.getOznDokumenta(), dug, dug, dok.getDatValute(), kasni} : new Object[]{dok.getOznDokumenta(), dug, dok.getZatvaranje(), dok.getDatValute(), kasni};
                }
                return object;
            }

            public String[] getColumnNames() {
                return new String[]{"Faktura", "Dug", "Ispr. potraz.", "Datum valute", "Kasni"};
            }
        });
    }

    private void arhiviraj() {
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                em.getTransaction().begin();
                if (PzDialogPotrazivanja.this.tipDok.equals(TipDokumentConfig.get().FAKTURA)) {
                    PzDialogPotrazivanja.this.listaFak = PzDialogPotrazivanja.this.tblTabela.getCheckedEntities();
                    for (Faktura fak : PzDialogPotrazivanja.this.listaFak) {
                        BigDecimal otpis = new BigDecimal(fak.getZatvaranje());
                        PzDialogPotrazivanja.this.snimiDokument((PzDokument)fak, otpis, em);
                        Dokument dok = (Dokument)em.find(Dokument.class, (Object)fak.getIdDok());
                        dok.setStornoIznos(dok.getStornoIznos().add(otpis));
                        fak.setStornoIznos(fak.getStornoIznos().add(otpis));
                        em.merge((Object)fak);
                        em.merge((Object)dok);
                    }
                } else if (PzDialogPotrazivanja.this.tipDok.equals(TipDokumentConfig.get().KALKULACIJA)) {
                    PzDialogPotrazivanja.this.listaKal = PzDialogPotrazivanja.this.tblTabela.getCheckedEntities();
                    for (Kalkulacija kal : PzDialogPotrazivanja.this.listaKal) {
                        PzDialogPotrazivanja.this.snimiDokument((PzDokument)kal, kal.getZatvaranje(), em);
                        Dokument dok = (Dokument)em.find(Dokument.class, (Object)kal.getIdDok());
                        dok.setStornoIznos(dok.getStornoIznos().add(kal.getZatvaranje()));
                        kal.setStornoIznos(kal.getStornoIznos().add(kal.getZatvaranje()));
                        em.merge((Object)kal);
                        em.merge((Object)dok);
                    }
                }
                em.getTransaction().commit();
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        PzDialogPotrazivanja.this.showReports();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPotrazivanja.this), (Throwable)e);
                        em.close();
                        PzWorkerDialog.hideStatus();
                        PzDialogPotrazivanja.this.dispose();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                    PzDialogPotrazivanja.this.dispose();
                }
            }
        };
        worker.execute();
    }

    private void snimiDokument(PzDokument dok, BigDecimal iznos, EntityManager em) {
        try {
            OtpisPotrazivanja op = new OtpisPotrazivanja();
            if (dok.getTip().equals(TipDokumentConfig.get().FAKTURA)) {
                op.setPodTip(TipDokumentConfig.get().PODTIP_OTPIS_FAKTURA);
            } else if (dok.getTip().equals(TipDokumentConfig.get().KALKULACIJA)) {
                op.setPodTip(TipDokumentConfig.get().PODTIP_OTPIS_KALKULACIJA);
            } else if (dok.getTip().equals(TipDokumentConfig.get().RACUN_DOBAVLJACA)) {
                op.setPodTip(TipDokumentConfig.get().PODTIP_OTPIS_RACUN_DOBAVLJACA);
            } else if (dok.getTip().equals(TipDokumentConfig.get().ZAPISNIK_OTPREMNICE)) {
                op.setPodTip(TipDokumentConfig.get().PODTIP_OTPIS_ZAPISNIK_OTPREMNICE);
            }
            op.setArhiviran((short)1);
            op.setOznDokumenta(dok.getOznDokumenta());
            op.setDatum(PzDateUtility.getCurrentDate());
            op.setDatArh(PzDateUtility.getCurrentDate());
            op.setRadnajedinica(dok.getRadnajedinica());
            op.setIznos(iznos);
            op.setPoDokumentu(dok.getIdDok());
            op.setKomitent(dok.getKomitent());
            op.setUserPoc(dok.getUserPoc());
            op.setUserKraj(dok.getUserKraj());
            op.setVrsta(dok.getVrsta());
            op.setTip(TipDokumentConfig.get().OTPIS_POTRAZIVANJA);
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)op, true, null, em);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        data.add(PzFirma.getFirma());
        PzDataSourceExtended ds = null;
        String fname = "";
        String title = "";
        if (this.tipDok.equals(TipDokumentConfig.get().FAKTURA)) {
            if (this.parameter.equalsIgnoreCase(ISPRAVKA)) {
                title = "ISPRAVKA POTRA\u017dIVANJA OD KUPCA";
                this.listaFak = this.tblTabela.getCheckedEntities();
            } else {
                title = "OTPIS POTRA\u017dIVANJA OD KUPCA";
            }
            ds = new PzDataSourceExtended(data, this.listaFak);
            fname = "rs/pezar/finansije/resource/reports/compiled/otpis.potrazivanja.faktura.jasper";
        } else if (this.tipDok.equals(TipDokumentConfig.get().KALKULACIJA)) {
            if (this.parameter.equalsIgnoreCase(ISPRAVKA)) {
                title = "ISPRAVKA POTRA\u017dIVANJA PREMA DOBAVLJA\u010cU";
                this.listaKal = this.tblTabela.getCheckedEntities();
            } else {
                title = "OTPIS POTRA\u017dIVANJA PREMA DOBAVLJA\u010cU";
            }
            ds = new PzDataSourceExtended(data, this.listaKal);
            fname = "rs/pezar/finansije/resource/reports/compiled/otpis.potrazivanja.kalkulacija.jasper";
        }
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", title);
        params.put("reklama", "");
        params.put("datum", this.dfDatum.getText());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (!this.arhiva) {
            String poruka = "";
            poruka = this.parameter.equals(ISPRAVKA) ? "Sigurno napusta\u0161 modul za ispravku potra\u017eivanja?!" : "Sigurno napusta\u0161 modul za otpis potra\u017eivanja?!";
            int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)poruka, (String)"Informacija", null, (boolean)false);
            if (rez == 1) {
                return;
            }
        }
    }

    public boolean shouldBeShown() {
        this.pnlGlavni.setPaintGradient(true);
        this.pnlGlavni.setGradient(FinansijeGradientUtil.OBRACUN_GRADIENT);
        this.getSession().putParameter("gradient", (Object)FinansijeGradientUtil.OBRACUN_GRADIENT);
        return true;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPotrazivanja(Boolean.FALSE);
    }

    public PzDialogPotrazivanja(Boolean initGUI) {
    }
}

