/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.nalogZaKnjizenje.akcije;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Uplata;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.PrimljenAvansManager;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.UplataManager;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzComponentFactory;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogAkcija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.custom.PzDialogMaloprodajaPorezIznos;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PrimljenAvans
extends PzDialogAkcija {
    private static final long serialVersionUID = 3608517966665248132L;
    private final JPanel contentPanel = new JPanel();
    private PzPanelHeader pnlHeader;
    private PzPanel pnlForm;
    private JLabel lblDatumKnjienja;
    private JLabel lblifraKupca;
    private JLabel lblOznakaAvansnogRauna;
    private JLabel lblIznosUplate;
    private JLabel lblDatumUplate;
    private PzDateField datDatumKnjizenja;
    private PzNumericOnlyTextField numSifraKupca;
    private PzTextField txtOznAvansnogRacuna;
    private PzDoubleField dblIznosUplate;
    private PzDateField datDatumUplate;
    private JLabel lblIznosAvRauna;
    private JLabel lblPlaenoDoSada;
    private JLabel lblOstajeZaUplatu;
    private PzDoubleField dblIznosAvansnogRacuna;
    private PzDoubleField dblPlacenoDoSada;
    private PzDoubleField dblOstajeZaUplatu;
    private JScrollPane scpPorezLevo;
    private JScrollPane scpPorezDesno;
    private PzTablePorez tblPorezLevo;
    private PzTablePorez tblPorezDesno;
    private PzTextField txtNazivKupca;
    private Uplata uplata;
    private Faktura avRacun;
    private Komitent komitent;
    private JLabel lblPdv;
    private PzDoubleField dblPd;

    public static void main(String[] args) {
        try {
            PrimljenAvans dialog = new PrimljenAvans();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PrimljenAvans() {
        this.initGUI();
    }

    public PrimljenAvans(PzDialog parent) {
        super(parent);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)this.contentPanel, "Center");
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new FlowLayout(1));
            this.contentPanel.add((Component)buttonPane, "South");
            JButton okButton = new JButton("OK");
            okButton.setIcon(new ImageIcon(PrimljenAvans.class.getResource("/rs/pezar/finansije/resource/img/check.png")));
            okButton.addActionListener((ActionListener)((Object)this));
            okButton.setActionCommand("OK");
            buttonPane.add(okButton);
            this.getRootPane().setDefaultButton(okButton);
            this.pnlHeader = new PzPanelHeader();
            this.pnlHeader.setTitle("Knji\u017eenje uplate avansa kupca");
            this.contentPanel.add((Component)this.pnlHeader, "North");
            this.pnlForm = new PzPanel();
            this.contentPanel.add((Component)this.pnlForm, "Center");
            GridBagLayout gbl_pnlForm = new GridBagLayout();
            int[] nArray = new int[8];
            nArray[0] = 114;
            nArray[1] = 109;
            nArray[2] = 60;
            nArray[3] = 76;
            nArray[4] = 105;
            nArray[5] = 107;
            nArray[6] = 106;
            gbl_pnlForm.columnWidths = nArray;
            gbl_pnlForm.rowHeights = new int[8];
            gbl_pnlForm.columnWeights = new double[]{0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
            gbl_pnlForm.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
            this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
            this.lblDatumKnjienja = new JLabel("Datum knji\u017eenja:");
            GridBagConstraints gbc_lblDatumKnjienja = new GridBagConstraints();
            gbc_lblDatumKnjienja.anchor = 13;
            gbc_lblDatumKnjienja.insets = new Insets(0, 0, 5, 5);
            gbc_lblDatumKnjienja.gridx = 0;
            gbc_lblDatumKnjienja.gridy = 0;
            this.pnlForm.add((Component)this.lblDatumKnjienja, (Object)gbc_lblDatumKnjienja);
            this.datDatumKnjizenja = new PzDateField();
            GridBagConstraints gbc_datDatumKnjizenja = new GridBagConstraints();
            gbc_datDatumKnjizenja.insets = new Insets(0, 0, 5, 5);
            gbc_datDatumKnjizenja.fill = 2;
            gbc_datDatumKnjizenja.gridx = 1;
            gbc_datDatumKnjizenja.gridy = 0;
            this.pnlForm.add((Component)this.datDatumKnjizenja, (Object)gbc_datDatumKnjizenja);
            this.lblifraKupca = new JLabel("\u0160ifra kupca:");
            GridBagConstraints gbc_lblifraKupca = new GridBagConstraints();
            gbc_lblifraKupca.anchor = 13;
            gbc_lblifraKupca.insets = new Insets(0, 0, 5, 5);
            gbc_lblifraKupca.gridx = 0;
            gbc_lblifraKupca.gridy = 1;
            this.pnlForm.add((Component)this.lblifraKupca, (Object)gbc_lblifraKupca);
            this.numSifraKupca = PzComponentFactory.createKomitentField();
            GridBagConstraints gbc_numSifraKupca = new GridBagConstraints();
            gbc_numSifraKupca.insets = new Insets(0, 0, 5, 5);
            gbc_numSifraKupca.fill = 2;
            gbc_numSifraKupca.gridx = 1;
            gbc_numSifraKupca.gridy = 1;
            this.pnlForm.add((Component)this.numSifraKupca, (Object)gbc_numSifraKupca);
            this.txtNazivKupca = new PzTextField();
            this.txtNazivKupca.setFocusable(false);
            this.txtNazivKupca.setEditable(false);
            GridBagConstraints gbc_txtNazivKupca = new GridBagConstraints();
            gbc_txtNazivKupca.gridwidth = 3;
            gbc_txtNazivKupca.insets = new Insets(0, 0, 5, 5);
            gbc_txtNazivKupca.fill = 2;
            gbc_txtNazivKupca.gridx = 2;
            gbc_txtNazivKupca.gridy = 1;
            this.pnlForm.add((Component)this.txtNazivKupca, (Object)gbc_txtNazivKupca);
            this.lblOznakaAvansnogRauna = new JLabel("Oznaka av. ra\u010duna:");
            GridBagConstraints gbc_lblOznakaAvansnogRauna = new GridBagConstraints();
            gbc_lblOznakaAvansnogRauna.anchor = 13;
            gbc_lblOznakaAvansnogRauna.insets = new Insets(0, 0, 5, 5);
            gbc_lblOznakaAvansnogRauna.gridx = 0;
            gbc_lblOznakaAvansnogRauna.gridy = 2;
            this.pnlForm.add((Component)this.lblOznakaAvansnogRauna, (Object)gbc_lblOznakaAvansnogRauna);
            PzEntityFilter filter = new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Faktura f = (Faktura)entity;
                    return new Object[]{f.getOznDokumenta(), f.getDatum(), f.getIznos(), f.getUplata(), f.getIznos().subtract(f.getUplata()).subtract(f.getStornoIznos())};
                }

                public String[] getColumnNames() {
                    return new String[]{"Av. ra\u010dun", "Datum", "Iznos", "Do sada pla\u0107eno", "Dug"};
                }
            };
            ArrayList<String> tipovi = new ArrayList<String>();
            tipovi.add(TipDokumentConfig.get().AVANSNI_RACUN);
            this.txtOznAvansnogRacuna = PzComponentFactory.createOznDokumentaField(this.numSifraKupca, Faktura.class, tipovi, null, this, filter, null, null);
            GridBagConstraints gbc_txtOznAvansnogRacuna = new GridBagConstraints();
            gbc_txtOznAvansnogRacuna.gridwidth = 2;
            gbc_txtOznAvansnogRacuna.insets = new Insets(0, 0, 5, 5);
            gbc_txtOznAvansnogRacuna.fill = 2;
            gbc_txtOznAvansnogRacuna.gridx = 1;
            gbc_txtOznAvansnogRacuna.gridy = 2;
            this.pnlForm.add((Component)this.txtOznAvansnogRacuna, (Object)gbc_txtOznAvansnogRacuna);
            this.lblIznosAvRauna = new JLabel("Iznos av. ra\u010duna:");
            GridBagConstraints gbc_lblIznosAvRauna = new GridBagConstraints();
            gbc_lblIznosAvRauna.anchor = 13;
            gbc_lblIznosAvRauna.insets = new Insets(0, 0, 5, 5);
            gbc_lblIznosAvRauna.gridx = 4;
            gbc_lblIznosAvRauna.gridy = 2;
            this.pnlForm.add((Component)this.lblIznosAvRauna, (Object)gbc_lblIznosAvRauna);
            this.dblIznosAvansnogRacuna = new PzDoubleField();
            this.dblIznosAvansnogRacuna.setBackground(new Color(176, 196, 222));
            this.dblIznosAvansnogRacuna.setFocusable(false);
            this.dblIznosAvansnogRacuna.setEditable(false);
            GridBagConstraints gbc_dblIznosAvansnogRacuna = new GridBagConstraints();
            gbc_dblIznosAvansnogRacuna.insets = new Insets(0, 0, 5, 5);
            gbc_dblIznosAvansnogRacuna.fill = 2;
            gbc_dblIznosAvansnogRacuna.gridx = 5;
            gbc_dblIznosAvansnogRacuna.gridy = 2;
            this.pnlForm.add((Component)this.dblIznosAvansnogRacuna, (Object)gbc_dblIznosAvansnogRacuna);
            this.lblIznosUplate = new JLabel("Iznos uplate:");
            GridBagConstraints gbc_lblIznosUplate = new GridBagConstraints();
            gbc_lblIznosUplate.insets = new Insets(0, 0, 5, 5);
            gbc_lblIznosUplate.anchor = 13;
            gbc_lblIznosUplate.gridx = 0;
            gbc_lblIznosUplate.gridy = 3;
            this.pnlForm.add((Component)this.lblIznosUplate, (Object)gbc_lblIznosUplate);
            this.dblIznosUplate = new PzDoubleField();
            this.dblIznosUplate.setVerifyInput(true);
            GridBagConstraints gbc_dblIznosUplate = new GridBagConstraints();
            gbc_dblIznosUplate.insets = new Insets(0, 0, 5, 5);
            gbc_dblIznosUplate.fill = 2;
            gbc_dblIznosUplate.gridx = 1;
            gbc_dblIznosUplate.gridy = 3;
            this.pnlForm.add((Component)this.dblIznosUplate, (Object)gbc_dblIznosUplate);
            this.lblPlaenoDoSada = new JLabel("Pla\u0107eno do sada:");
            GridBagConstraints gbc_lblPlaenoDoSada = new GridBagConstraints();
            gbc_lblPlaenoDoSada.anchor = 13;
            gbc_lblPlaenoDoSada.insets = new Insets(0, 0, 5, 5);
            gbc_lblPlaenoDoSada.gridx = 4;
            gbc_lblPlaenoDoSada.gridy = 3;
            this.pnlForm.add((Component)this.lblPlaenoDoSada, (Object)gbc_lblPlaenoDoSada);
            this.dblPlacenoDoSada = new PzDoubleField();
            this.dblPlacenoDoSada.setBackground(new Color(176, 196, 222));
            this.dblPlacenoDoSada.setFocusable(false);
            this.dblPlacenoDoSada.setEditable(false);
            GridBagConstraints gbc_dblPlacenoDoSada = new GridBagConstraints();
            gbc_dblPlacenoDoSada.insets = new Insets(0, 0, 5, 5);
            gbc_dblPlacenoDoSada.fill = 2;
            gbc_dblPlacenoDoSada.gridx = 5;
            gbc_dblPlacenoDoSada.gridy = 3;
            this.pnlForm.add((Component)this.dblPlacenoDoSada, (Object)gbc_dblPlacenoDoSada);
            this.lblDatumUplate = new JLabel("Datum uplate:");
            GridBagConstraints gbc_lblDatumUplate = new GridBagConstraints();
            gbc_lblDatumUplate.insets = new Insets(0, 0, 5, 5);
            gbc_lblDatumUplate.anchor = 13;
            gbc_lblDatumUplate.gridx = 0;
            gbc_lblDatumUplate.gridy = 4;
            this.pnlForm.add((Component)this.lblDatumUplate, (Object)gbc_lblDatumUplate);
            this.datDatumUplate = new PzDateField();
            GridBagConstraints gbc_datDatumUplate = new GridBagConstraints();
            gbc_datDatumUplate.insets = new Insets(0, 0, 5, 5);
            gbc_datDatumUplate.fill = 2;
            gbc_datDatumUplate.gridx = 1;
            gbc_datDatumUplate.gridy = 4;
            this.pnlForm.add((Component)this.datDatumUplate, (Object)gbc_datDatumUplate);
            this.lblOstajeZaUplatu = new JLabel("Ostaje za uplatu:");
            GridBagConstraints gbc_lblOstajeZaUplatu = new GridBagConstraints();
            gbc_lblOstajeZaUplatu.anchor = 13;
            gbc_lblOstajeZaUplatu.insets = new Insets(0, 0, 5, 5);
            gbc_lblOstajeZaUplatu.gridx = 4;
            gbc_lblOstajeZaUplatu.gridy = 4;
            this.pnlForm.add((Component)this.lblOstajeZaUplatu, (Object)gbc_lblOstajeZaUplatu);
            this.dblOstajeZaUplatu = new PzDoubleField();
            this.dblOstajeZaUplatu.setBackground(new Color(176, 196, 222));
            this.dblOstajeZaUplatu.setFocusable(false);
            this.dblOstajeZaUplatu.setEditable(false);
            GridBagConstraints gbc_dblOstajeZaUplatu = new GridBagConstraints();
            gbc_dblOstajeZaUplatu.insets = new Insets(0, 0, 5, 5);
            gbc_dblOstajeZaUplatu.fill = 2;
            gbc_dblOstajeZaUplatu.gridx = 5;
            gbc_dblOstajeZaUplatu.gridy = 4;
            this.pnlForm.add((Component)this.dblOstajeZaUplatu, (Object)gbc_dblOstajeZaUplatu);
            this.lblPdv = new JLabel("PDV:");
            GridBagConstraints gbc_lblPdv = new GridBagConstraints();
            gbc_lblPdv.anchor = 13;
            gbc_lblPdv.insets = new Insets(0, 0, 5, 5);
            gbc_lblPdv.gridx = 4;
            gbc_lblPdv.gridy = 5;
            this.pnlForm.add((Component)this.lblPdv, (Object)gbc_lblPdv);
            this.scpPorezLevo = new JScrollPane();
            GridBagConstraints gbc_scpPorezLevo = new GridBagConstraints();
            gbc_scpPorezLevo.gridwidth = 4;
            gbc_scpPorezLevo.insets = new Insets(0, 0, 0, 5);
            gbc_scpPorezLevo.fill = 1;
            gbc_scpPorezLevo.gridx = 0;
            gbc_scpPorezLevo.gridy = 6;
            this.pnlForm.add((Component)this.scpPorezLevo, (Object)gbc_scpPorezLevo);
            this.tblPorezLevo = PzComponentFactory.createPzTablePorez();
            this.tblPorezLevo.setDialogClass(PzDialogMaloprodajaPorezIznos.class);
            this.scpPorezLevo.setViewportView((Component)this.tblPorezLevo);
            this.scpPorezDesno = new JScrollPane();
            GridBagConstraints gbc_scpPorezDesno = new GridBagConstraints();
            gbc_scpPorezDesno.gridwidth = 3;
            gbc_scpPorezDesno.fill = 1;
            gbc_scpPorezDesno.gridx = 4;
            gbc_scpPorezDesno.gridy = 6;
            this.pnlForm.add((Component)this.scpPorezDesno, (Object)gbc_scpPorezDesno);
            this.tblPorezDesno = PzComponentFactory.createPzTablePorez();
            this.tblPorezDesno.setEnabled(false);
            this.tblPorezDesno.setEditable(false);
            this.scpPorezDesno.setViewportView((Component)this.tblPorezDesno);
            this.dblPd = this.tblPorezDesno.createExpresionField("$3$");
            this.dblPd.setBackground(new Color(176, 196, 222));
            this.dblPd.setFocusable(false);
            this.dblPd.setEditable(false);
            GridBagConstraints gbc_dblPd = new GridBagConstraints();
            gbc_dblPd.insets = new Insets(0, 0, 5, 5);
            gbc_dblPd.fill = 2;
            gbc_dblPd.gridx = 5;
            gbc_dblPd.gridy = 5;
            this.pnlForm.add((Component)this.dblPd, (Object)gbc_dblPd);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.pack();
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.numSifraKupca.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.txtNazivKupca.setVal((Object)((Komitent)entity).getNaziv());
        }
    }

    @Override
    public boolean setEntity(PzEntity entity, PzFieldImpl component) {
        if (entity instanceof Faktura) {
            this.avRacun = (Faktura)entity;
            if (this.avRacun.getIznos().subtract(this.avRacun.getUplata()).compareTo(new BigDecimal(0)) <= 0) {
                this.txtOznAvansnogRacuna.setVal((Object)"");
                this.txtOznAvansnogRacuna.requestFocusInWindow();
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Izabrani avansni ra\u010dun je ve\u0107 napla\u0107en. Ne mo\u017eete nastaviti dalje.");
                return false;
            }
            this.dblIznosAvansnogRacuna.setVal((Object)this.avRacun.getIznos());
            this.dblPlacenoDoSada.setVal((Object)this.avRacun.getUplata());
            this.dblOstajeZaUplatu.setVal((Object)this.avRacun.getIznos().subtract(this.avRacun.getUplata()));
            this.tblPorezDesno.setPorezi(this.avRacun.getTaksadokuments(), false);
            BigDecimal pdv = new BigDecimal(0);
            for (Taksafaktura tf : this.avRacun.getTaksafakturas()) {
                pdv = pdv.add(tf.getIznos());
            }
            this.tblPorezDesno.packAll();
            this.tblPorezLevo.packAll();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.pnlForm.validateForm(true)) {
            return;
        }
        this.commit();
    }

    @Override
    public Date getDatKnjizenja() {
        return this.datDatumKnjizenja.getVal();
    }

    @Override
    public PzDokument getNewDokument() throws Exception {
        this.uplata = new Uplata();
        this.uplata.setDatum(this.datDatumUplate.getVal());
        this.uplata.setIznos(this.dblIznosUplate.getBigDecimal());
        this.uplata.setPoDokumentu(this.avRacun.getIdDok());
        this.uplata.setOznDokumenta(this.avRacun.getOznDokumenta());
        this.uplata.setTipDokumentaUpl(this.avRacun.getTip());
        this.uplata.setTaksaopstidokuments(this.tblPorezLevo.getPorezi());
        this.uplata.setKomitent(this.komitent);
        this.uplata.setRadnajedinica(this.avRacun.getRadnajedinica());
        if (this.avRacun.getSaPorezom() == 0) {
            if (this.avRacun.getSaPravomNaOdbitak() == 0) {
                this.uplata.setPorez("BEZ_PRAVA");
            } else {
                this.uplata.setPorez("SA_PRAVOM");
            }
        } else {
            this.uplata.setPorez("SA_PDV");
        }
        this.uplata.setTip(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS);
        return this.uplata;
    }

    @Override
    public void commit() {
        List poreziLevo = this.tblPorezLevo.getPorezi();
        List poreziDesno = this.tblPorezDesno.getPorezi();
        for (Taksaopstidokument porezLevo : poreziLevo) {
            for (Taksafaktura porezDesno : poreziDesno) {
                if (!porezLevo.getId().getOznTarGr().equals(porezDesno.getId().getOznTarGr()) || porezLevo.getIznos().compareTo(porezDesno.getIznos()) <= 0) continue;
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("Uneseni iznos PDV-a po tarifi" + porezLevo.getId().getOznTarGr() + " je ve\u0107i od iznosa po istoj tarifi sa izabranog avansnog racuna. Unos prekinut!"));
                return;
            }
        }
        if (this.avRacun.getSaPorezom() != 0 && this.tblPorezLevo.sumAll("$2$+$3$") != this.dblIznosUplate.getVal().doubleValue()) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Iznos uplate se ne sla\u017ee sa zbirom osnovice i PDV-a. Ne mo\u017eete nastaviti dalje.");
        } else {
            super.commit();
        }
    }

    @Override
    public UplataManager getUplataManager() {
        return new PrimljenAvansManager((PzDokument)this.avRacun, this.uplata);
    }
}

