/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import rs.pezar.core.PzApplication;
import rs.pezar.db.entity.Dokument;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;

public class PzDialogPotvrdiKnjizenje
extends PzDialog {
    private static final long serialVersionUID = 3079954036626006691L;
    private final JPanel contentPanel = new JPanel();
    private PzButton btnKnjizi;
    private JLabel lblDatumKnjienja;
    private PzDateField datDatum;
    public static Date DATUM;
    private JScrollPane scp;
    private PzPanelHeader header;
    private JXTable table;
    HashMap<String, String> properties = new HashMap();

    public static void main(String[] args) {
        try {
            PzDialogPotvrdiKnjizenje dialog = new PzDialogPotvrdiKnjizenje();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzDialogPotvrdiKnjizenje(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.initTable();
    }

    public PzDialogPotvrdiKnjizenje() {
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("Parametri knji\u017eenja");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout contentPanelLayout = new GridBagLayout();
        this.contentPanel.setLayout(contentPanelLayout);
        this.contentPanel.setPreferredSize(new Dimension(436, 262));
        contentPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
        contentPanelLayout.rowHeights = new int[]{55, 7, 7};
        contentPanelLayout.columnWeights = new double[]{0.0, 0.1, 0.1};
        contentPanelLayout.columnWidths = new int[]{7, 7, 7};
        this.lblDatumKnjienja = new JLabel("Datum knji\u017eenja: ");
        this.lblDatumKnjienja.setBounds(10, 14, 101, 29);
        this.contentPanel.add((Component)this.lblDatumKnjienja, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.btnKnjizi = new PzButton();
        this.btnKnjizi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzDialogPotvrdiKnjizenje.this.actionPerformedpzbtnKnjizi(arg0);
            }
        });
        this.btnKnjizi.setBounds(277, 12, 107, 32);
        this.btnKnjizi.setIcon((Icon)new ImageIcon(PzDialogPotvrdiKnjizenje.class.getResource("/rs/pezar/finansije/gui/resources/img/check.png")));
        this.btnKnjizi.setText("Knji\u017ei       ");
        this.contentPanel.add((Component)this.btnKnjizi, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.datDatum = new PzDateField();
        this.contentPanel.add((Component)this.datDatum, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.scp = new JScrollPane();
        this.contentPanel.add((Component)this.scp, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.table = new JXTable();
        this.scp.setViewportView((Component)this.table);
        this.header = new PzPanelHeader();
        this.header.setTitle("Izbor parametara knji\u017eenja");
        this.contentPanel.add((Component)this.header, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void actionPerformedpzbtnKnjizi(ActionEvent arg0) {
        try {
            DATUM = this.datDatum.getVal();
            HashMap<String, String> nzkProperties = this.getProperties();
            this.getSession().putParameter("nzk_properties", nzkProperties);
            PzApplication.getApplication().getPropManager().saveObject(this.properties, "nzk_properties.sav");
            this.dispose();
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private TableCellEditor createCellEditor() {
        return new DefaultCellEditor((JComboBox<?>)this.getComboBox());
    }

    private PzComboBox getComboBox() {
        PzComboBox cb = new PzComboBox();
        cb.addItem((Object)new PzChoice("Svi dokumenti na jedan nalog", (Object)"SVI"));
        cb.addItem((Object)new PzChoice("Razdvoji po datumu dokumenta", (Object)"DATUM"));
        cb.addItem((Object)new PzChoice("Razdvoji po radnoj jedinici", (Object)"RJ"));
        cb.addItem((Object)new PzChoice("Razdvoji po radnoj jedinici i datumu", (Object)"RJ_DATUM"));
        return cb;
    }

    private List<String> getTipoviDokumenata() {
        Vector<String> tipovi = new Vector<String>();
        List dokumenti = (List)this.getSession().getParameter("dokumenti_za_knjizenje");
        for (Dokument d : dokumenti) {
            if (tipovi.contains(d.getTip())) continue;
            tipovi.add(d.getTip());
        }
        return tipovi;
    }

    private String getText(PzComboBox cb, String value) {
        String rez = "Svi dokumenti na jedan nalog";
        int i = 0;
        while (i < cb.getItemCount()) {
            PzChoice choice = (PzChoice)cb.getItemAt(i);
            if (choice.getValue().toString().equals(value)) {
                rez = choice.getText();
            }
            ++i;
        }
        return rez;
    }

    private void initTable() {
        List<String> tipovi = this.getTipoviDokumenata();
        Object[][] data = new Object[tipovi.size()][2];
        PzComboBox cb = this.getComboBox();
        try {
            this.properties = (HashMap)PzApplication.getApplication().getPropManager().loadObject("nzk_properties.sav");
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        int i = 0;
        while (i < tipovi.size()) {
            data[i] = new Object[]{new PzChoice(TipDokumentConfig.getNameByValue((String)tipovi.get(i), null), (Object)tipovi.get(i)), new PzChoice(this.getText(cb, this.properties.get(tipovi.get(i))), (Object)(this.properties.get(tipovi.get(i)) == null ? "SVI" : this.properties.get(tipovi.get(i))))};
            ++i;
        }
        DefaultTableModel model = new DefaultTableModel();
        model.setDataVector(data, new Object[]{"Vrsta dokumenta", "Na\u010din grupisanja na nalozima"});
        this.table.getTableHeader().setFont(new Font("SansSerif", 1, 12));
        this.table.setModel((TableModel)model);
        this.table.getColumn(1).setCellEditor(this.createCellEditor());
    }

    private HashMap<String, String> getProperties() {
        HashMap<String, String> prop = new HashMap<String, String>();
        int i = 0;
        while (i < this.table.getRowCount()) {
            prop.put(((PzChoice)this.table.getValueAt(i, 0)).getValue().toString(), ((PzChoice)this.table.getValueAt(i, 1)).getValue().toString());
            System.out.println(String.valueOf(((PzChoice)this.table.getValueAt(i, 0)).getValue().toString()) + ", " + ((PzChoice)this.table.getValueAt(i, 1)).getValue().toString());
            if (this.properties.get(((PzChoice)this.table.getValueAt(i, 0)).getValue().toString()) != null) {
                this.properties.remove(((PzChoice)this.table.getValueAt(i, 0)).getValue().toString());
            }
            this.properties.put(((PzChoice)this.table.getValueAt(i, 0)).getValue().toString(), ((PzChoice)this.table.getValueAt(i, 1)).getValue().toString());
            ++i;
        }
        return prop;
    }
}

