/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.engine.izvod.uplataLoader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Uplata;
import rs.pezar.finansije.engine.izvod.TransakcijaIzvodaBanke;
import rs.pezar.finansije.engine.izvod.uplataLoader.UplataLoader;
import rs.pezar.finansije.gui.izvod.uplate.PnlUplataPoRacunu;
import rs.pezar.finansije.gui.izvod.uplate.UplataComponent;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;

public class UplataByRacunDobavljacaLoader
implements UplataLoader {
    @Override
    public List<Uplata> getUplate(Komitent k, TransakcijaIzvodaBanke t, BigDecimal iznos, EntityManager em) {
        ArrayList<Uplata> uplate = new ArrayList<Uplata>();
        BigDecimal ostatak = iznos;
        Query q = this.createQuery(k, em, "k");
        List kalkulacije = q.getResultList();
        final String pb = t.getPozivNaBroj();
        Collections.sort(kalkulacije, new Comparator<Kalkulacija>(){

            @Override
            public int compare(Kalkulacija o1, Kalkulacija o2) {
                if (o1.getOznDokumenta().equals(pb) && !o2.getOznDokumenta().equals(pb)) {
                    return -1;
                }
                if (o2.getOznDokumenta().equals(pb) && !o1.getOznDokumenta().equals(pb)) {
                    return 1;
                }
                return o1.getDatum().compareTo(o2.getDatum());
            }
        });
        for (Kalkulacija fakturaDobavljaca : kalkulacije) {
            Uplata uplata = this.createUplataKalkulacija(fakturaDobavljaca, k);
            uplata.setDatum(t.getDatumPlacanja());
            if (ostatak.compareTo(new BigDecimal("0")) > 0) {
                if (fakturaDobavljaca.getDug().compareTo(ostatak) <= 0) {
                    uplata.setIznos(fakturaDobavljaca.getDug());
                    ostatak = ostatak.subtract(fakturaDobavljaca.getDug());
                    fakturaDobavljaca.setUplata(fakturaDobavljaca.getUplata().add(fakturaDobavljaca.getDug()));
                } else {
                    fakturaDobavljaca.setUplata(fakturaDobavljaca.getUplata().add(ostatak));
                    uplata.setIznos(ostatak);
                    ostatak = new BigDecimal("0");
                }
            }
            uplate.add(uplata);
        }
        return null;
    }

    private Uplata createUplataKalkulacija(Kalkulacija fakturaDobavljaca, Komitent k) {
        Uplata uplata = new Uplata();
        uplata.setDatum(PzDateUtility.getCurrentDate());
        uplata.setPoDokumentu(fakturaDobavljaca.getIdDok());
        uplata.setOznDokumenta(fakturaDobavljaca.getOznDokumenta());
        uplata.setTipDokumentaUpl(fakturaDobavljaca.getTip());
        uplata.setRadnajedinica(fakturaDobavljaca.getRadnajedinica());
        uplata.setTip(TipDokumentConfig.get().UPLATA_DOBAVLJACU);
        uplata.setPodTip(TipDokumentConfig.get().PODTIP_UPLATA_VIRMAN);
        uplata.setKomitent(k);
        uplata.setDokumentUpl((PzDokument)fakturaDobavljaca);
        return uplata;
    }

    @Override
    public void rebuildUplate(List<Uplata> uplate, String strana, BigDecimal iznos) {
        BigDecimal ostatak = iznos;
        for (Uplata uplata : uplate) {
            Kalkulacija fakturaDobavljaca = (Kalkulacija)uplata.getDokumentUpl();
            if (ostatak.compareTo(new BigDecimal("0")) <= 0) continue;
            if (fakturaDobavljaca.getDug().compareTo(ostatak) <= 0) {
                uplata.setIznos(fakturaDobavljaca.getDug());
                ostatak = ostatak.subtract(fakturaDobavljaca.getDug());
                fakturaDobavljaca.setUplata(fakturaDobavljaca.getUplata().add(fakturaDobavljaca.getDug()));
                continue;
            }
            fakturaDobavljaca.setUplata(fakturaDobavljaca.getUplata().add(ostatak));
            uplata.setIznos(ostatak);
            ostatak = new BigDecimal("0.00");
        }
    }

    @Override
    public UplataComponent getGUIComponent(Uplata u) {
        return new PnlUplataPoRacunu(u);
    }

    @Override
    public boolean primenjujeSe(Komitent k, TransakcijaIzvodaBanke t, EntityManager em) {
        return t.getStrana().equals("ZADUZENJE") && (Long)this.createQuery(k, em, "COUNT(k.idDok)").getSingleResult() > 0L;
    }

    private Query createQuery(Komitent k, EntityManager em, String e) {
        Query q = em.createQuery("SELECT " + e + " FROM Kalkulacija k WHERE k.arhiviran = 1 AND k.komitent=:k AND (k.iznos-k.stornoIznos-k.uplata > 0) AND NOT (k.tip = '" + TipDokumentConfig.get().KALKULACIJA + "' AND (k.podTip = '" + TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA + "' OR k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "')) AND k.storno=0 ORDER BY k.datum");
        q.setParameter("k", (Object)k);
        return q;
    }
}

