/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.engine.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Shema;
import rs.pezar.db.entity.ShemaPK;
import rs.pezar.db.entity.Stavkasheme;
import rs.pezar.finansije.engine.ShemaProvider;

public class PzShemaProvider
implements ShemaProvider {
    private List<Shema> sheme;

    public PzShemaProvider() {
        this.loadShemas();
    }

    @Override
    public Shema getShema(PzDokument dokument) {
        int count = 0;
        int max = 0;
        boolean ptip = false;
        Shema shema = null;
        for (Shema s : this.sheme) {
            block6: {
                Radnajedinica rj;
                ShemaPK pk;
                block8: {
                    block10: {
                        block7: {
                            block9: {
                                pk = s.getId();
                                if (!pk.getTipDok().equals(dokument.getTip())) break block6;
                                ++count;
                                Radnajedinica radnajedinica = rj = !(dokument instanceof Interniracun) ? dokument.getRadnajedinica() : ((Interniracun)dokument).getIzlaznaRJ();
                                if (!pk.getPodTipDok().equals(dokument.getPodTip())) break block7;
                                if (!ptip) {
                                    ptip = true;
                                    max = count;
                                }
                                ++count;
                                if (rj == null) break block8;
                                if (!pk.getTipRj().equals(rj.getgTip())) break block9;
                                ++count;
                                if (!pk.getpTipRj().equals(rj.getpTip())) break block8;
                                ++count;
                                if (!pk.getPpTipRj().equals(rj.getPpTip())) break block8;
                                ++count;
                                break block8;
                            }
                            if (!pk.getTipRj().equals("")) {
                                --count;
                                continue;
                            }
                            break block8;
                        }
                        if (rj == null || ptip) break block8;
                        if (!pk.getTipRj().equals(rj.getgTip())) break block10;
                        ++count;
                        if (!pk.getpTipRj().equals(rj.getpTip())) break block8;
                        ++count;
                        if (!pk.getPpTipRj().equals(rj.getPpTip())) break block8;
                        ++count;
                        break block8;
                    }
                    if (!pk.getTipRj().equals("")) {
                        --count;
                        continue;
                    }
                }
                if (rj != null && pk.getOznRj().equals(rj.getId().getOznRj()) && pk.getOznOgranak().equals(rj.getId().getOznOgranak())) {
                    ++count;
                }
            }
            if (count > max) {
                max = count;
                shema = s;
            }
            count = 0;
        }
        return shema;
    }

    public List<Shema> loadShemas() {
        String schemaDir = PzParameter.getParameterValue((String)"SHEMA_DIR");
        if (schemaDir == null) {
            EntityManager em = PzEntityManager.getEm();
            this.sheme = em.createQuery("SELECT s FROM Shema s").getResultList();
            em.close();
        } else {
            File dir = new File(String.valueOf(schemaDir) + File.separator + PzParameter.getParameterValue((String)"TEKUCA_GODINA"));
            if (!(dir.exists() && dir.isDirectory() || (dir = new File(schemaDir)).exists() && dir.isDirectory())) {
                this.sheme = new Vector<Shema>();
                return null;
            }
            this.sheme = new Vector<Shema>();
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Shema.class});
                Unmarshaller u = jc.createUnmarshaller();
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!f.isDirectory() && f.getPath().endsWith(".shema")) {
                        Shema shema = (Shema)u.unmarshal((InputStream)new FileInputStream(f));
                        this.fixId(shema);
                        this.sheme.add(shema);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                PzLogger.getInstance().logException((Throwable)e);
            }
        }
        return this.sheme;
    }

    private void fixId(Shema s) {
        if (s.getStavkashemes() != null && s.getStavkashemes().size() != 0) {
            for (Stavkasheme ss : s.getStavkashemes()) {
                ss.setShema(s);
            }
        }
        if (s.getNadSheme() != null && s.getNadSheme().size() != 0) {
            for (Shema s1 : s.getNadSheme()) {
                this.fixId(s1);
            }
        }
    }

    @Override
    public Shema getShema(Nzk nalog) {
        Shema result = null;
        for (Shema s : this.sheme) {
            if (!s.getrBroj().equals(nalog.getBrSheme())) continue;
            result = s;
            break;
        }
        return result;
    }
}

