/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports.excel;

import BI.QC;
import com.jxcell.CellException;
import com.jxcell.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import rs.pezar.core.PzApplication;
import rs.pezar.reports.PzReportViewer;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzFileUtility;

public class PzXlsViewer
extends PzDialog {
    private static final long serialVersionUID = 6020172486637946268L;
    private final JPanel contentPanel = new JPanel();
    private View view;
    private JasperPrint jp;
    private String exportFilename;
    private JToolBar toolBar;
    private PzButton btnStampaj;
    private PzButton btnUvecaj;
    private PzButton btnUmanji;
    private int scale;
    private String path;
    private boolean visible = true;
    private PzButton btnOtvori;

    static {
        PzFileUtility.removeDirectory((File)new File(PzApplication.getApplication().getDataFolder() + File.separator + "xls" + File.separator + "tmp"));
    }

    public static void main(String[] args) {
        try {
            PzXlsViewer dialog = new PzXlsViewer();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzXlsViewer() {
        this.initGUI();
    }

    public PzXlsViewer(PzDialog dialog, JasperPrint jp, String exportFilename) {
        super(dialog);
        this.jp = jp;
        this.exportFilename = exportFilename;
        this.initGUI();
        this.initView(jp);
    }

    public PzXlsViewer(PzDialog dialog, String path) {
        super(dialog);
        this.path = path;
        this.initGUI();
        this.initView(path);
    }

    private void initGUI() {
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.toolBar = new JToolBar();
        this.toolBar.setLayout(new FlowLayout(3));
        this.contentPanel.add((Component)this.toolBar, "North");
        this.btnStampaj = new PzButton("Formatiraj za|\u0161tampu(ALT+S)");
        this.btnStampaj.setFocusable(false);
        this.btnStampaj.setIcon((Icon)new ImageIcon(PzXlsViewer.class.getResource("/rs/pezar/reports/img/printer.png")));
        this.toolBar.add((Component)this.btnStampaj);
        this.btnStampaj.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = -166803619661069538L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzXlsViewer.this.btnStampajAction();
            }
        });
        this.btnStampaj.setShortcut("ALT+S");
        this.btnOtvori = new PzButton("Otvori kroz|eksterni program(ALT+O)");
        this.btnOtvori.setFocusable(false);
        this.btnOtvori.setIcon((Icon)new ImageIcon(PzXlsViewer.class.getResource("/rs/pezar/reports/img/gear_run.png")));
        this.toolBar.add((Component)this.btnOtvori);
        this.btnOtvori.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = -166803619661069538L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    PzXlsViewer.this.btnOtvoriAction();
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)PzXlsViewer.this), (Throwable)e);
                }
            }
        });
        this.btnOtvori.setShortcut("ALT+O");
        this.btnUvecaj = new PzButton("Uve\u0107aj (F12)");
        this.btnUvecaj.setFocusable(false);
        this.btnUvecaj.setIcon((Icon)new ImageIcon(PzXlsViewer.class.getResource("/rs/pezar/reports/img/document_zoom_in.png")));
        this.toolBar.add((Component)this.btnUvecaj);
        this.btnUvecaj.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = -4332796939996958797L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzXlsViewer.this.btnUvecajAction();
            }
        });
        this.btnUvecaj.setShortcut("F12");
        this.btnUmanji = new PzButton("Umanji (F11)");
        this.btnUmanji.setFocusable(false);
        this.btnUmanji.setIcon((Icon)new ImageIcon(PzXlsViewer.class.getResource("/rs/pezar/reports/img/document_zoom_out.png")));
        this.toolBar.add((Component)this.btnUmanji);
        this.btnUmanji.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = -3242010880827110388L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzXlsViewer.this.btnUmanjiAction();
            }
        });
        this.btnUmanji.setShortcut("F11");
    }

    protected void btnOtvoriAction() throws Exception {
        if (!Desktop.isDesktopSupported()) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Va\u0161 operativni sistem ne podr\u017eava ovu funkciju");
        } else {
            String tmpfile = String.valueOf(this.getXlsTmpDir()) + File.separator + new SimpleDateFormat("yyyyMMddhhss").format(new Date()) + ".xls";
            PzFileUtility.copyFile((String)(String.valueOf(this.getXlsDir()) + File.separator + "last_table.xls"), (String)tmpfile);
            Desktop.getDesktop().open(new File(tmpfile));
        }
    }

    private void initView(JasperPrint jp) {
        this.view = new View();
        try {
            JRXlsExporter exporterXLS = new JRXlsExporter();
            exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, (Object)jp);
            exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, (Object)new FileOutputStream(new File(String.valueOf(this.getXlsDir()) + "last_table.xls")));
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
            exporterXLS.setParameter(JRXlsExporterParameter.IGNORE_PAGE_MARGINS, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            exporterXLS.exportReport();
            this.view.read(String.valueOf(this.getXlsDir()) + File.separator + "last_table.xls");
            int n = this.scale = PzApplication.getApplication().getLocalMachineUserSettings().getProperty("PzXlsViewer.scale") != null ? PzApplication.getApplication().getLocalMachineUserSettings().getInt("PzXlsViewer.scale") : 0;
            if (this.scale == 0) {
                this.scale = 165;
            }
            this.view.setViewScale(this.scale);
            this.contentPanel.add((Component)this.view, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PzXlsViewer.this.view.requestFocus();
                    PzXlsViewer.this.getTableComponent((JComponent)PzXlsViewer.this.view);
                }
            });
            this.visible = true;
        }
        catch (QC qC) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Nema podataka za prikaz");
            this.visible = false;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void getTableComponent(JComponent parent) {
        Component[] components = parent.getComponents();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            if (component instanceof JComponent) {
                ((JComponent)component).getInputMap(0).put(KeyStroke.getKeyStroke(27, 0, false), "ESC");
                ((JComponent)component).getActionMap().put("ESC", new AbstractAction(){
                    private static final long serialVersionUID = -932888635410651974L;

                    @Override
                    public void actionPerformed(ActionEvent paramActionEvent) {
                        PzXlsViewer.this.dispose();
                    }
                });
                this.getTableComponent((JComponent)component);
            }
            ++i;
        }
    }

    private void initView(String path) {
        this.view = new View();
        try {
            this.view.read(path);
            int n = this.scale = PzApplication.getApplication().getLocalMachineUserSettings().getProperty("PzXlsViewer.scale") != null ? PzApplication.getApplication().getLocalMachineUserSettings().getInt("PzXlsViewer.scale") : 0;
            if (this.scale == 0) {
                this.scale = 165;
            }
            this.view.setViewScale(this.scale);
            this.contentPanel.add((Component)this.view, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PzXlsViewer.this.view.requestFocus();
                    PzXlsViewer.this.getTableComponent((JComponent)PzXlsViewer.this.view);
                }
            });
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
    }

    public String getXlsDir() {
        String path = PzApplication.getApplication().getDataFolder() + File.separator + "xls";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        return String.valueOf(path) + File.separator;
    }

    public String getXlsTmpDir() {
        String path = PzApplication.getApplication().getDataFolder() + File.separator + "xls" + File.separator + "tmp";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        return String.valueOf(path) + File.separator;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public static void viewReport(PzDialog parent, JasperPrint jp, String exportFilename) {
        PzXlsViewer dlg = new PzXlsViewer(parent, jp, exportFilename);
        if (!dlg.visible) {
            dlg.dispose();
        } else {
            dlg.setModal(true);
            dlg.restoreSize();
            dlg.setVisible(true);
        }
    }

    public static void viewReport(PzDialog parent, String path) {
        PzXlsViewer dlg = new PzXlsViewer(parent, path);
        if (!dlg.visible) {
            dlg.dispose();
        } else {
            dlg.setModal(true);
            dlg.restoreSize();
            dlg.setVisible(true);
        }
    }

    private void btnUvecajAction() {
        try {
            if (this.scale + 10 <= 200) {
                this.view.setViewScale(this.scale += 10);
            }
        }
        catch (CellException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void btnUmanjiAction() {
        try {
            if (this.scale - 10 >= 100) {
                this.view.setViewScale(this.scale -= 10);
            }
        }
        catch (CellException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void btnStampajAction() {
        PzReportViewer.viewReport(this, this.jp, this.exportFilename);
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        PzApplication.getApplication().getLocalMachineUserSettings().setProperty("PzXlsViewer.scale", (Object)String.valueOf(this.scale));
    }
}

