/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports.engine.dokument;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.beanutils.PropertyUtils;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.dokument.PzDokumentResolver;

public class DokumentDS
implements JRDataSource {
    private PzDokumentResolver dokumentResolver;
    private Iterator<List<? extends PzEntity>> dsi;
    private Iterator<? extends PzEntity> i;
    private PzEntity current;
    private PzEntity[] staticContent;
    private PzDokument dokument;
    private boolean firstTime;
    private boolean dynamicExists;

    public DokumentDS(PzDokument dokument) throws Exception {
        this.dokument = dokument;
        if (PzReportManager.getReportData(dokument) == null) {
            throw new Exception("Gre\u0161ka! Za tra\u017eeni tip dokumenta ( " + dokument.getTip() + " ) ne postoji definicija izve\u0161taja unutar konfiguracionog fajla!");
        }
        this.dokumentResolver = (PzDokumentResolver)PzReportManager.getReportData(dokument).get("resolver");
        this.dokumentResolver.setDokument(dokument);
        this.staticContent = this.dokumentResolver.getStaticContent();
        this.dsi = this.dokumentResolver.getDynamicContent().iterator();
        if (this.dsi.hasNext()) {
            this.i = this.dsi.next().iterator();
        }
        this.firstTime = true;
        this.dynamicExists = true;
    }

    public void reset() throws Exception {
        this.dsi = this.dokumentResolver.getDynamicContent().iterator();
        if (this.dsi.hasNext()) {
            this.i = this.dsi.next().iterator();
        }
        this.firstTime = true;
        this.dynamicExists = true;
    }

    public Object getFieldValue(JRField field) throws JRException {
        try {
            if (field.getName().startsWith("stat@")) {
                return this.getValueFromStaticContent(field.getName());
            }
            if (field.getName().startsWith("dyn@")) {
                return this.getValueFromDynamicContent(field.getName());
            }
            if (field.getName().startsWith("doc@")) {
                return this.getValueFromDocumentField(field.getName());
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getValueFromDocumentField(String fname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String[] parts = fname.split("\\@");
        if (parts.length != 2) {
            return null;
        }
        String name = parts[1];
        return PropertyUtils.getProperty((Object)this.dokument, (String)name);
    }

    private Object getValueFromDynamicContent(String fname) {
        String[] parts;
        block6: {
            if (!this.dynamicExists) {
                return null;
            }
            parts = fname.split("\\@");
            if (parts.length == 2) break block6;
            return null;
        }
        try {
            return this.dokumentResolver.getValues(this.current)[Integer.parseInt(parts[1])];
        }
        catch (NumberFormatException e) {
            System.out.println("Ime polja " + fname + " nije dobro formirano. Ime mora da pocne sa dyn$ iza koga sledi redni broj polja u nizu");
            System.out.println(e.getMessage());
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private Object getValueFromStaticContent(String fname) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
        String[] parts = fname.split("\\@");
        if (parts.length != 2) {
            return null;
        }
        String type = parts[1].substring(0, parts[1].indexOf(46));
        String name = parts[1].substring(parts[1].indexOf(46) + 1);
        if (parts.length != 2) {
            return null;
        }
        int i = 0;
        while (i < this.staticContent.length) {
            if (this.staticContent[i] != null && this.staticContent[i].getClass().getSimpleName().equalsIgnoreCase(type)) {
                return DokumentDS.getClassFieldValue(this.staticContent[i], name);
            }
            ++i;
        }
        return null;
    }

    public boolean next() throws JRException {
        if (this.i.hasNext()) {
            this.firstTime = false;
            this.current = this.i.next();
            return true;
        }
        if (this.dsi.hasNext()) {
            this.i = this.dsi.next().iterator();
            if (this.i.hasNext()) {
                this.firstTime = false;
                this.current = this.i.next();
                return true;
            }
            return false;
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.dynamicExists = false;
            return true;
        }
        return false;
    }

    public static Object getClassFieldValue(PzEntity entity, String fieldName) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)entity, (String)fieldName);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return result;
    }
}

