/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.engine.internal;

import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.engine.DokumentCompilerException;
import rs.pezar.prostoKnjigovodstvo.engine.DokumentCompilerObserver;
import rs.pezar.prostoKnjigovodstvo.engine.MultiDokumentCompiler;
import rs.pezar.prostoKnjigovodstvo.engine.SingleDokumentCompiler;

public class PzMultiDokumentCompiler
implements MultiDokumentCompiler {
    private SingleDokumentCompiler sCompiler;
    private Vector<DokumentCompilerObserver> observers;
    private Map<String, String> props;
    private Map<NzkKey, Nzk> nzkLookup = new HashMap<NzkKey, Nzk>();

    public PzMultiDokumentCompiler(SingleDokumentCompiler sCompiler) {
        this.sCompiler = sCompiler;
        this.observers = new Vector();
    }

    @Override
    public List<Nzk> compile(List<PzDokument> dokuments, Map<String, String> properties) throws Exception {
        this.props = properties;
        Iterator<PzDokument> i = dokuments.iterator();
        Vector<Nzk> result = this.populateResult(i);
        return result;
    }

    public List<Nzk> compile(ScrollableCursor dokuments) throws Exception {
        Vector<Nzk> result = this.populateResult((Iterator<PzDokument>)dokuments);
        return result;
    }

    private Vector<Nzk> populateResult(Iterator<PzDokument> i) throws Exception {
        Vector<Nzk> result = new Vector<Nzk>();
        while (i.hasNext()) {
            Dokument dok = (Dokument)i.next();
            Class c = TipDokumentConfig.getClassByValue((String)dok.getTip());
            PzDokument dokument = (PzDokument)PzEntityManager.find((Class)c, (Object)dok.getIdDok());
            if (dokument == null) {
                throw new DokumentCompilerException("Nepostoje\u0107i dokument " + dok.getTip() + " ID: " + dok.getIdDok());
            }
            this.fireCompilationStarted(dokument);
            this.addNzk(result, dokument);
            this.fireCompilationEnded(dokument);
        }
        return result;
    }

    private void addNzk(Vector<Nzk> result, Nzk nzk2) {
        boolean found = false;
        for (Nzk nzk : result) {
            if (nzk2.getBrSheme().intValue() != nzk.getBrSheme().intValue()) continue;
            Radnajedinica rj1 = nzk.getRadnajedinica();
            Radnajedinica rj2 = nzk2.getRadnajedinica();
            try {
                if ((rj1 != null || rj2 != null) && !rj1.getId().equals((Object)rj2.getId())) continue;
                nzk.getStavkanzks().addAll(nzk2.getStavkanzks());
                int i = 0;
                while (i < nzk.getStavkanzks().size()) {
                    ((Stavkanzk)nzk.getStavkanzks().get(i)).getId().setrBroj(Integer.valueOf(i));
                    ++i;
                }
                found = true;
                break;
            }
            catch (NullPointerException nullPointerException) {}
        }
        if (!found) {
            result.add(nzk2);
        }
    }

    private void addNzk(List<Nzk> list, PzDokument d) throws DokumentCompilerException {
        Nzk nzk;
        Nzk compiled = this.sCompiler.compileDokument(d);
        if (compiled != null && compiled.getDuguje().compareTo(compiled.getPotrazuje()) != 0 && this.sCompiler.getShemaProvider().getShema(d).getZatvori() == 1) {
            this.props.put("NZK_ERROR_DOKUMENT_ID", String.valueOf(d.getIdDok()));
        }
        if ((nzk = this.findNzk(d, list)) == null) {
            this.addNzk(list, this.createKey(d), compiled);
        } else {
            nzk.getStavkanzks().addAll(compiled.getStavkanzks());
            Radnajedinica rj1 = nzk.getRadnajedinica();
            Radnajedinica rj2 = compiled.getRadnajedinica();
            if (rj1 == null || rj2 == null || !nzk.getRadnajedinica().getId().equals((Object)compiled.getRadnajedinica().getId())) {
                nzk.setRadnajedinica(null);
            }
            int i = 0;
            while (i < nzk.getStavkanzks().size()) {
                ((Stavkanzk)nzk.getStavkanzks().get(i)).getId().setrBroj(Integer.valueOf(i));
                ++i;
            }
        }
    }

    private String getProperty(PzDokument d) {
        return this.props.get(d.getTip());
    }

    private void fireCompilationStarted(PzDokument dokument) {
        for (DokumentCompilerObserver observer : this.observers) {
            observer.compilationStarted(dokument);
        }
    }

    private void fireCompilationEnded(PzDokument dokument) {
        for (DokumentCompilerObserver observer : this.observers) {
            observer.compilationDone(dokument);
        }
    }

    @Override
    public void addObserver(DokumentCompilerObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(DokumentCompilerObserver observer) {
        this.observers.remove(observer);
    }

    private Nzk findNzk(PzDokument d, List<Nzk> list) {
        Nzk nzk = this.nzkLookup.get(this.createKey(d));
        return nzk;
    }

    private void addNzk(List<Nzk> list, NzkKey key, Nzk nzk) {
        this.nzkLookup.put(key, nzk);
        list.add(nzk);
    }

    private NzkKey createKey(PzDokument d) {
        NzkKey key = new NzkKey();
        key.setTip(d.getTip());
        if (this.getProperty(d).equals("DATUM")) {
            key.setDatum(d.getDatArh());
        } else if (this.getProperty(d).equals("RJ")) {
            if (d.getRadnajedinica() != null) {
                key.setOznRj(d.getRadnajedinica().getId().getOznRj());
            } else {
                key.setOznRj("");
            }
        } else if (this.getProperty(d).equals("RJ_DATUM")) {
            if (d.getRadnajedinica() != null) {
                key.setOznRj(d.getRadnajedinica().getId().getOznRj());
            } else {
                key.setOznRj("");
            }
            key.setDatum(d.getDatArh());
        }
        return key;
    }

    private static class NzkKey {
        private String tip;
        private Date datum;
        private String oznRj;

        public String getTip() {
            return this.tip;
        }

        public void setTip(String tip) {
            this.tip = tip;
        }

        public Date getDatum() {
            return this.datum;
        }

        public void setDatum(Date datum) {
            this.datum = datum;
        }

        public String getOznRj() {
            return this.oznRj;
        }

        public void setOznRj(String oznRj) {
            this.oznRj = oznRj;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.datum == null ? 0 : this.datum.hashCode());
            result = 31 * result + (this.oznRj == null ? 0 : this.oznRj.hashCode());
            result = 31 * result + (this.tip == null ? 0 : this.tip.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NzkKey other = (NzkKey)obj;
            if (this.datum == null ? other.datum != null : !this.datum.equals(other.datum)) {
                return false;
            }
            if (this.oznRj == null ? other.oznRj != null : !this.oznRj.equals(other.oznRj)) {
                return false;
            }
            return !(this.tip == null ? other.tip != null : !this.tip.equals(other.tip));
        }
    }
}

