/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.cashregister.galeb.gp100.gui;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import rs.pezar.kasa.cashregister.CashRegisterControl;
import rs.pezar.kasa.cashregister.CashRegisterProtocol;
import rs.pezar.kasa.cashregister.CharacterTable;
import rs.pezar.kasa.cashregister.DatecsProtocol;

public class GP100Control
implements CashRegisterControl {
    public DatecsProtocol protocol = new DatecsProtocol();
    public static final int MAX_PLU = 65022;
    public static final double MAX_PRICE = 999999.99;
    public static final char PAY_METHOD_CASH = 'P';
    public static final char PAY_METHOD_CHECK = 'C';
    public static final char PAY_METHOD_CARD = 'D';
    public static final char CLOSURE_REPORT_Z = '0';
    public static final char CLOSURE_REPORT_X = '1';
    public static final char CLOSURE_REPORT_X_EXTENDED = '2';
    public static final char CLOSURE_TAX_AMOUNTS = '0';
    public static final char CLOSURE_NETO_TAX_AMOUNTS = '1';
    public static final char CLOSURE_SUM_TAX_AMOUNTS = '2';
    public static final char CLOSURE_TAX_RATES = '3';
    public static final char CLOSURE_PEROD_TAX_RATES = '4';
    public static final char CLOSURE_PERIOD_NETO_TAX_RATES = '5';
    public static final char CLOSURE_PERIOD_SUM_TAX_AMOUNT = '6';
    public static final byte CMD_DISPLAY_CLEAR = 33;
    public static final byte CMD_DISPLAY_LOWER_ROW = 35;
    public static final byte CMD_INFO_OPEN = 38;
    public static final byte CMD_INFO_CLOSE = 39;
    public static final byte CMD_TXT_PRINT = 42;
    public static final byte CMD_HEADER_FOOTER_PRINT = 43;
    public static final byte CMD_PAPER_ROLL = 44;
    public static final byte CMD_PAPER_CUT = 45;
    public static final byte CMD_DISPLAY_UPPER_ROW = 47;
    public static final byte CMD_FISCAL_OPEN = 48;
    public static final byte CMD_TAX_RATES = 50;
    public static final byte CMD_CHEKCSUM = 51;
    public static final byte CMD_BILL_AND_DISPLAY = 52;
    public static final byte CMD_PAYMENT_TOTAL = 53;
    public static final byte CMD_FISCAL_CLOSE = 56;
    public static final byte CMD_BILL = 58;
    public static final byte CMD_TIME_GET = 62;
    public static final byte CMD_DISPLAY_TIME_DATE = 63;
    public static final byte CMD_REPORT_LAST_DAILY = 64;
    public static final byte CMD_REPORT_PAYMENTS_DAILY = 65;
    public static final byte CMD_REPORT_PAYMENTS_DAILY_D = 67;
    public static final byte CMD_REPORT_MEMORY_FREE = 68;
    public static final byte CMD_REPORT_END_TAKE = 69;
    public static final byte CMD_RAISE_MONEY = 70;
    public static final byte CMD_REPORT_DIAGNOSE = 71;
    public static final byte CMD_FISCALIZE = 72;
    public static final byte CMD_REPORT_ON_MEMORY = 73;
    public static final byte CMD_REPORT_STATUS = 74;
    public static final byte CMD_REPORT_FISCAL_TRANSACT = 76;
    public static final byte CMD_REPORT_PERIODICAL = 79;
    public static final byte CMD_BEEP = 80;
    public static final byte CMD_INPUT_FRACT_TAX_RATES = 83;
    public static final byte CMD_REPORT_MEMORY_TEST = 89;
    public static final byte CMD_REPORT_DIAGNOSE_DATA = 90;
    public static final byte CMD_INPUT_IBFM_AND_COUNTRY = 91;
    public static final byte CMD_INPUT_FABRICATING_NUMBER = 92;
    public static final byte CMD_REPORT_TAX_RATES = 97;
    public static final byte CMD_INPUT_TAX_ID = 98;
    public static final byte CMD_REPORT_PIB = 99;
    public static final byte CMD_DISPLAY_TEXT = 100;
    public static final byte CMD_INPUT_OPERATOR_PASSWORD = 101;
    public static final byte CMD_INPUT_OPERATOR_NAME = 102;
    public static final byte CMD_REPORT_CURR_FISCAL_BILL = 103;
    public static final byte CMD_OPERATOR_CLEAR = 104;
    public static final byte CMD_REPORT_ON_OPERATORS = 105;
    public static final byte CMD_OPEN_CASH_REGISTER = 106;
    public static final byte CMD_INPUT_ARTICLE_DATA = 107;
    public static final byte CMD_ADDITIONAL_INFO_ON_DATE = 110;
    public static final byte CMD_REPORT_ON_ARTICLE = 111;
    public static final byte CMD_REPORT_ON_OPERATOR = 112;
    public static final byte CMD_REPORT_LAST_BILS_NR = 113;
    public static final byte CMD_REPORT_ON_DAILY_FISCAL = 114;
    public static final byte CMD_INPUT_GRAPHIC_LOGO = 115;
    public static final byte CMD_REPORT_FISCAL_MEM_BLOCK = 116;
    public static final byte CMD_REPORT_OPER_MEM_BILLS = 117;
    public static final byte ROLL_MAIN = 1;
    public static final byte ROLL_BACK = 2;
    public static final byte ROLL_BOTH = 3;
    private static HashMap<Byte, Byte> codeTranslation = new HashMap();

    static {
        codeTranslation.put((byte)-26, (byte)-4);
        codeTranslation.put((byte)-58, (byte)-36);
        codeTranslation.put((byte)-24, (byte)-3);
        codeTranslation.put((byte)-56, (byte)-35);
        codeTranslation.put((byte)-102, (byte)-2);
        codeTranslation.put((byte)-118, (byte)-34);
        codeTranslation.put((byte)-16, (byte)-6);
        codeTranslation.put((byte)-48, (byte)-38);
        codeTranslation.put((byte)-98, (byte)-5);
        codeTranslation.put((byte)-114, (byte)-37);
    }

    public byte[][] InitialSequence() throws Exception {
        byte[][] initial = new byte[10][220];
        initial[0] = this.ControlDisplayErase();
        initial[1] = this.ControlBeep();
        return initial;
    }

    public void deviceDiscoverer() {
    }

    public CashRegisterProtocol GetProtocol() {
        return this.protocol;
    }

    public byte[] ControlSetHeaderFooter(char line, String text) throws Exception {
        String textTemp = new String("");
        byte[] temp = new byte[37];
        if (line > '9') {
            throw new Exception();
        }
        textTemp = text.length() > 36 ? (String)text.subSequence(0, 35) : text;
        temp[0] = (byte)line;
        System.arraycopy(textTemp.getBytes(), 0, temp, 1, textTemp.length());
        this.protocol.FormMessage((byte)43, temp, textTemp.length() + 1);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetHeaderFooter(char line) throws Exception {
        byte[] temp = new byte[38];
        if (line > '9') {
            throw new Exception();
        }
        temp[0] = 73;
        temp[1] = (byte)line;
        this.protocol.FormMessage((byte)43, temp, 2);
        return this.protocol.messageDown;
    }

    public byte[] ControlAllowLogoToBePrinted(boolean sw) throws Exception {
        String temp = sw ? String.format(null, "L1", new Object[0]) : String.format(null, "L0", new Object[0]);
        this.protocol.FormMessage((byte)43, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlSetDateTime() throws Exception {
        return null;
    }

    public byte[] ControlFiscalize() throws Exception {
        return null;
    }

    public byte[] ControlSetTaxRates() throws Exception {
        return null;
    }

    public byte[] ControlSetFiscalModuleIDandCountry() throws Exception {
        return null;
    }

    public byte[] ControlSetFabricatingNumber() throws Exception {
        return null;
    }

    public byte[] ControlSetPIB() throws Exception {
        return null;
    }

    public byte[] ControlSetOperatorPassword() throws Exception {
        return null;
    }

    public byte[] ControlSetOperatorName() throws Exception {
        return null;
    }

    public byte[] ControlClearOperatorInfo() throws Exception {
        return null;
    }

    public byte[] ControlItemSet(int itemCode, char itemTaxGroup, BigDecimal d, String itemName, String unit) throws Exception {
        String command = "";
        String name = "";
        if (itemCode > 65022 || itemCode < 1) {
            throw new Exception("itemCode out of range.");
        }
        if (d.doubleValue() > 999999.99 || d.doubleValue() < 0.0) {
            throw new Exception("Najveca dozvoljena cena je 999999.00 po artiklu (firmware 1.50SR), cena ne moze biti manja od 0");
        }
        if (itemName.length() == 0) {
            throw new Exception("Ime ne moze biti duzine 0.");
        }
        name = itemName.length() > 28 ? itemName.substring(0, 27) : itemName;
        if (unit != null && unit.length() > 0) {
            name = String.format(null, "%s/%s", name, unit);
        }
        command = String.format(null, "P%s%d,%.2f,", Character.valueOf(itemTaxGroup), itemCode, d);
        byte[] temp = null;
        temp = command.getBytes();
        byte[] tempName = null;
        tempName = CharacterTable.translate((String)name);
        temp = ArrayUtils.addAll((byte[])temp, (byte[])tempName);
        temp.toString();
        switch (itemTaxGroup) {
            case 'A': {
                temp[1] = -64;
                break;
            }
            case 'G': {
                temp[1] = -61;
                break;
            }
            case 'D': {
                temp[1] = -60;
                break;
            }
            case 'd': {
                temp[1] = -128;
                break;
            }
            case 'E': {
                temp[1] = -59;
                break;
            }
            case 'Z': {
                temp[1] = -58;
                break;
            }
            case 'I': {
                temp[1] = -56;
                break;
            }
            case 'J': {
                temp[1] = -93;
                break;
            }
            case 'K': {
                temp[1] = -54;
                break;
            }
            default: {
                throw new Exception("Tax Group not recognized!");
            }
        }
        this.protocol.FormMessage((byte)107, temp, temp.length);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemDelete(int itemCode) throws Exception {
        String command = "";
        if (itemCode > 65022 || itemCode < 1) {
            throw new Exception();
        }
        command = String.format(null, "D%d", itemCode);
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemDeleteAll() throws Exception {
        String command = "DA";
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemGet(int itemCode) throws Exception {
        String command = "";
        if (itemCode > 65022 || itemCode < 1) {
            throw new Exception("PLU izvan granica");
        }
        command = String.format(null, "R%d", itemCode);
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemSetNewPrice(int itemCode, BigDecimal price) throws Exception {
        String command = "";
        if (itemCode > 65022 || itemCode < 1) {
            throw new Exception("Plu sifra nije regularna");
        }
        if (price.doubleValue() > 999999.99 || price.doubleValue() < 0.0) {
            throw new Exception("Najveca dozvoljena cena je 999999.00 po artiklu (firmware 1.50SR)");
        }
        command = String.format(null, "C%d,%5.2f", itemCode, price);
        command = command.replace(" ", "");
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemGetFirst() throws Exception {
        String command = "F";
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemGetNext() throws Exception {
        String command = "N";
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemGetFirstSold() throws Exception {
        String command = "f";
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemGetNextSold() throws Exception {
        String command = "n";
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemGetFirstUnused() throws Exception {
        String command = "X";
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlItemGetTechnicalInfo() throws Exception {
        String command = "I";
        this.protocol.FormMessage((byte)107, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlSetGraphicalLogo(int numRow, String data) throws Exception {
        if (numRow > 95 || data.length() > 108) {
            throw new Exception("Unallowed row number, or data length exceeded allowed 108 characters.");
        }
        String temp = String.format(null, "%d,%s", numRow, data);
        this.protocol.FormMessage((byte)115, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlOpenText() throws Exception {
        this.protocol.FormMessage((byte)38, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlCloseText() throws Exception {
        this.protocol.FormMessage((byte)39, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlPrintText(String text) throws Exception {
        String textTemp = new String("");
        if (text.isEmpty() || text == null) {
            return textTemp.getBytes();
        }
        textTemp = text.length() > 30 ? (String)text.subSequence(0, 29) : text;
        this.protocol.FormMessage((byte)42, textTemp);
        return this.protocol.messageDown;
    }

    public byte[] ControlOpenBill(String operaterCode, String operatorPassword, String crNumber) throws Exception {
        if (operaterCode != null && operaterCode.length() != 1) {
            throw new Exception("Kod operatera mora biti duzine 1 karakter");
        }
        if (!StringUtils.containsOnly((String)operaterCode, (String)"0123456789")) {
            throw new Exception("Kod operatera mora da sadrzi samo numericke vrednosti(cele brojeve)");
        }
        if (operatorPassword != null && (operatorPassword.length() < 4 || operatorPassword.length() > 6)) {
            throw new Exception("Lozinka operatera mora biti duzine 4-6 karaktera");
        }
        if (!StringUtils.containsOnly((String)operatorPassword, (String)"0123456789")) {
            throw new Exception("Lozinka operatera mora da sadrzi samo numericke vrednosti(cele brojeve)");
        }
        if (crNumber != null && crNumber.length() > 5) {
            throw new Exception("Kod kase mora biti do 5 karaktera");
        }
        if (!StringUtils.containsOnly((String)crNumber, (String)"123456789")) {
            throw new Exception("kod kase mora da sadrzi samo numericke vrednosti(cele brojeve)");
        }
        String dataTemp = operaterCode;
        dataTemp = dataTemp.concat(";");
        dataTemp = dataTemp.concat(operatorPassword);
        dataTemp = dataTemp.concat(",");
        dataTemp = dataTemp.concat(crNumber);
        this.protocol.FormMessage((byte)48, dataTemp);
        return this.protocol.messageDown;
    }

    public byte[] ControlCheckSum() throws Exception {
        String temp = "1";
        this.protocol.FormMessage((byte)51, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlRegisterSellingsWithDisplay(char sign, int itemCode, BigDecimal quan) throws Exception {
        String format;
        String temp = "";
        String format1 = "S%c%d*%1.3f";
        String format2 = "S%c%d*%2.2f";
        String format3 = "S%c%d*%3.1f";
        String format4 = "S%c%d*0%4.0f";
        String format5 = "S%c%d*%5.0f";
        if (quan.doubleValue() < 10.0) {
            format = format1;
        } else if (quan.doubleValue() >= 10.0 && quan.doubleValue() < 100.0) {
            format = format2;
        } else if (quan.doubleValue() >= 100.0 && quan.doubleValue() < 1000.0) {
            format = format3;
        } else if (quan.doubleValue() >= 1000.0 && quan.doubleValue() < 10000.0) {
            format = format4;
        } else if (quan.doubleValue() >= 10000.0 && quan.doubleValue() < 100000.0) {
            format = format5;
        } else {
            throw new Exception();
        }
        temp = String.format(null, format, Character.valueOf(sign), itemCode, quan);
        this.protocol.FormMessage((byte)52, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlPayRegister(char paymentMode, BigDecimal amount) throws Exception {
        if (paymentMode != 'D' && paymentMode != 'P' && paymentMode != 'C') {
            throw new Exception("Payment mode unknown");
        }
        String temp = String.format(null, "%c%-8.2f", Character.valueOf(paymentMode), amount).trim();
        this.protocol.FormMessage((byte)53, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlCloseBill() throws Exception {
        this.protocol.FormMessage((byte)56, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlRegisterSellingsWithoutDisplay(char sign, int itemCode, BigDecimal quan) throws Exception {
        String format;
        String temp = "";
        String format1 = "S%c%d*%1.3f";
        String format2 = "S%c%d*%2.2f";
        String format3 = "S%c%d*%3.1f";
        String format4 = "S%c%d*0%4.0f";
        String format5 = "S%c%d*%5.0f";
        if (quan.doubleValue() < 10.0) {
            format = format1;
        } else if (quan.doubleValue() >= 10.0 && quan.doubleValue() < 100.0) {
            format = format2;
        } else if (quan.doubleValue() >= 100.0 && quan.doubleValue() < 1000.0) {
            format = format3;
        } else if (quan.doubleValue() >= 1000.0 && quan.doubleValue() < 10000.0) {
            format = format4;
        } else if (quan.doubleValue() >= 10000.0 && quan.doubleValue() < 100000.0) {
            format = format5;
        } else {
            throw new Exception("Quantity does not apply to any of these patterns : #####, ###.#, ##.##, #.###");
        }
        temp = String.format(null, format, Character.valueOf(sign), itemCode, quan);
        this.protocol.FormMessage((byte)52, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlCloseTheDay(char option, char mode1, char mode2) throws Exception {
        String temp = String.format(null, "%c%c%c", Character.valueOf(option), Character.valueOf(mode1), Character.valueOf(mode2));
        this.protocol.FormMessage((byte)69, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlCloseTheDay(char option, char mode1) throws Exception {
        String temp = String.format(null, "%c%c", Character.valueOf(option), Character.valueOf(mode1));
        this.protocol.FormMessage((byte)69, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlCloseTheDay(char option) throws Exception {
        if (option != '1' && option != '0' && option != '2') {
            throw new Exception("Option unknown, option can be: '0', '1' or '2'");
        }
        String temp = String.format(null, "%c", Character.valueOf(option));
        this.protocol.FormMessage((byte)69, String.valueOf(temp) + "AN");
        return this.protocol.messageDown;
    }

    public byte[] ControlInfoTaxRatesChanges() throws Exception {
        return null;
    }

    public byte[] ControlInfoOnFiscalMemory() throws Exception {
        return null;
    }

    public byte[] ControlInfoPeriodical(String startDate, String endDate) throws Exception {
        if (startDate.length() != 6 || endDate.length() != 6) {
            throw new Exception();
        }
        String command = String.format(null, "%s,%s", startDate, endDate);
        this.protocol.FormMessage((byte)79, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlInfoOnOperater() throws Exception {
        this.protocol.FormMessage((byte)105, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlInfoOnItem(int option) throws Exception {
        String command = "";
        if (option > 1 || option < 0) {
            throw new Exception();
        }
        command = String.format(null, "%d", option);
        this.protocol.FormMessage((byte)111, command);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetDateTime() throws Exception {
        this.protocol.FormMessage((byte)62, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetLastBillInfo() throws Exception {
        this.protocol.FormMessage((byte)64, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetDayTrafficInfo() throws Exception {
        this.protocol.FormMessage((byte)65, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetDayTrafficInfoOnP() throws Exception {
        this.protocol.FormMessage((byte)67, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetFiscalMemorySpaceLeft() throws Exception {
        this.protocol.FormMessage((byte)68, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetStatusDeviceRegisterWait() throws Exception {
        this.protocol.FormMessage((byte)74, "W");
        return this.protocol.messageDown;
    }

    public byte[] ControlGetStatusDeviceRegister() throws Exception {
        this.protocol.FormMessage((byte)74, "X");
        return this.protocol.messageDown;
    }

    public byte[] ControlGetFiscalTransactionStatus() throws Exception {
        this.protocol.FormMessage((byte)76, new String("T"));
        return this.protocol.messageDown;
    }

    public byte[] ControlGetDiagnose() throws Exception {
        this.protocol.FormMessage((byte)90, "1");
        return this.protocol.messageDown;
    }

    public byte[] ControlGetTaxRates() throws Exception {
        this.protocol.FormMessage((byte)97, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetPIB() throws Exception {
        this.protocol.FormMessage((byte)99, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetCurrentBillInfo() throws Exception {
        this.protocol.FormMessage((byte)103, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetAmountInfoP() throws Exception {
        this.protocol.FormMessage((byte)110, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetOperaterInfo(int operaterId) throws Exception {
        if (operaterId < 1 || operaterId > 8) {
            throw new Exception("Operater Id range: 1 - 8");
        }
        String temp = String.format(null, "%d", operaterId);
        this.protocol.FormMessage((byte)112, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetNumberOnLastPrintedDocument() throws Exception {
        this.protocol.FormMessage((byte)113, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetDailyInfo(int closure, char type) throws Exception {
        String temp = "";
        temp = String.format(null, "%d,%c", closure, Character.valueOf(type));
        this.protocol.FormMessage((byte)114, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetDailyPeriodInfo(int closure1, char type, int closure2) throws Exception {
        String temp = "";
        temp = String.format(null, "%d,%c,%d", closure1, Character.valueOf(type), closure2);
        this.protocol.FormMessage((byte)114, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetFiscalMemoryDump(int startAddress, int count) throws Exception {
        String temp = "";
        if (startAddress < 0 || startAddress + count > 131071 || count > 64) {
            throw new Exception("Memory range error, range: 0x00000 - 0x1FFFF");
        }
        temp = String.format(null, "%x,%d", startAddress, count);
        this.protocol.FormMessage((byte)116, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlGetInfoOnSellingsFromOperatngMemory(int reg) throws Exception {
        if (reg > 3) {
            throw new Exception("There are four registers, reg range: 0 - 3");
        }
        String temp = String.format(null, "%d", reg);
        this.protocol.FormMessage((byte)117, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlRollDownPaper(int numRows, int whichRoll) throws Exception {
        if (numRows < 99 && numRows > 0) {
            String message = String.valueOf(numRows);
            message = message.concat(",");
            message = message.concat(String.valueOf(whichRoll));
            this.protocol.FormMessage((byte)44, message);
        }
        return this.protocol.messageDown;
    }

    public byte[] ControlPaperCut() throws Exception {
        this.protocol.FormMessage((byte)45, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlDisplayErase() throws Exception {
        this.protocol.FormMessage((byte)33, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlDisplayMessageUpper(String upperRow) throws Exception {
        if (!upperRow.isEmpty()) {
            if (upperRow.length() < 20) {
                this.protocol.FormMessage((byte)47, upperRow);
            } else {
                upperRow = upperRow.substring(0, 20);
                this.protocol.FormMessage((byte)47, upperRow);
            }
        }
        return this.protocol.messageDown;
    }

    public byte[] ControlDisplayMessageLower(String lowerRow) throws Exception {
        if (!lowerRow.isEmpty()) {
            if (lowerRow.length() < 20) {
                this.protocol.FormMessage((byte)35, lowerRow);
            } else {
                lowerRow = lowerRow.substring(0, 20);
                this.protocol.FormMessage((byte)35, lowerRow);
            }
        }
        return this.protocol.messageDown;
    }

    public byte[] ControlDisplayDateAndTime() throws Exception {
        this.protocol.FormMessage((byte)63, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlDisplayFullControl() throws Exception {
        return null;
    }

    public byte[] ControlMoneyRaise(BigDecimal amount) throws Exception {
        String temp = "";
        String format1 = "%5.2f";
        if (amount.doubleValue() > 99999.99 || amount.doubleValue() < -99999.99) {
            throw new Exception("Not allowed amount, range is -99999.99 to 99999.99");
        }
        temp = String.format(null, format1, amount);
        this.protocol.FormMessage((byte)70, temp);
        return this.protocol.messageDown;
    }

    public byte[] ControlPrintDiagnose() throws Exception {
        this.protocol.FormMessage((byte)71, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlBeep() throws Exception {
        this.protocol.FormMessage((byte)80, null);
        return this.protocol.messageDown;
    }

    public byte[] ControlFiscalMemoryTest(boolean writeTest) throws Exception {
        if (!writeTest) {
            this.protocol.FormMessage((byte)89, null);
        } else {
            this.protocol.FormMessage((byte)89, "T");
        }
        return this.protocol.messageDown;
    }

    public byte[] ControlOpenCashDrawer() throws Exception {
        this.protocol.FormMessage((byte)106, null);
        return this.protocol.messageDown;
    }

    private String formatQuantity(double quantity) {
        BigDecimal bdQuantity = new BigDecimal(String.valueOf(quantity));
        int decimalPlaces = GP100Control.getNumberOfDecimalPlaces(bdQuantity);
        String pattern = "#####";
        switch (decimalPlaces) {
            case 0: {
                if (quantity < 10.0) {
                    pattern = "     #";
                    break;
                }
                if (quantity >= 10.0 && quantity < 100.0) {
                    pattern = "    ##";
                    break;
                }
                if (quantity >= 100.0 && quantity < 1000.0) {
                    pattern = "   ###";
                    break;
                }
                if (quantity >= 1000.0 && quantity < 10000.0) {
                    pattern = " ####";
                    break;
                }
                if (!(quantity >= 10000.0)) break;
                pattern = "#####";
                break;
            }
            case 1: {
                if (quantity < 10.0) {
                    pattern = "  #.#";
                    break;
                }
                if (quantity >= 10.0 && quantity < 100.0) {
                    pattern = " ##.#";
                    break;
                }
                if (!(quantity >= 100.0) || !(quantity < 1000.0)) break;
                pattern = "###.#";
                break;
            }
            case 2: {
                if (quantity < 10.0) {
                    pattern = " #.##";
                    break;
                }
                if (!(quantity >= 10.0) || !(quantity < 100.0)) break;
                pattern = "##.##";
                break;
            }
            case 3: {
                if (quantity < 10.0) {
                    pattern = "     #";
                    break;
                }
                if (!(quantity >= 10.0) || !(quantity < 100.0)) break;
                pattern = "#.###";
            }
        }
        DecimalFormat formatter = new DecimalFormat(pattern);
        return formatter.format(quantity);
    }

    private String formatPrice(float price) {
        DecimalFormat formatter = new DecimalFormat("######.##");
        String s = formatter.format(price);
        s = s.replace(",", ".");
        return s;
    }

    public static int getNumberOfDecimalPlaces(BigDecimal bigDecimal) {
        String string = bigDecimal.stripTrailingZeros().toPlainString();
        int index = string.indexOf(".");
        return index < 0 ? 0 : string.length() - index - 1;
    }
}

