/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function.string;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionGroup;
import net.sourceforge.jeval.function.string.CharAt;
import net.sourceforge.jeval.function.string.CompareTo;
import net.sourceforge.jeval.function.string.CompareToIgnoreCase;
import net.sourceforge.jeval.function.string.Concat;
import net.sourceforge.jeval.function.string.EndsWith;
import net.sourceforge.jeval.function.string.Equals;
import net.sourceforge.jeval.function.string.EqualsIgnoreCase;
import net.sourceforge.jeval.function.string.Eval;
import net.sourceforge.jeval.function.string.IndexOf;
import net.sourceforge.jeval.function.string.LastIndexOf;
import net.sourceforge.jeval.function.string.Length;
import net.sourceforge.jeval.function.string.Replace;
import net.sourceforge.jeval.function.string.StartsWith;
import net.sourceforge.jeval.function.string.Substring;
import net.sourceforge.jeval.function.string.ToLowerCase;
import net.sourceforge.jeval.function.string.ToUpperCase;
import net.sourceforge.jeval.function.string.Trim;

public class StringFunctions
implements FunctionGroup {
    private List functions = new ArrayList();

    public StringFunctions() {
        this.functions.add(new CharAt());
        this.functions.add(new CompareTo());
        this.functions.add(new CompareToIgnoreCase());
        this.functions.add(new Concat());
        this.functions.add(new EndsWith());
        this.functions.add(new Equals());
        this.functions.add(new EqualsIgnoreCase());
        this.functions.add(new Eval());
        this.functions.add(new IndexOf());
        this.functions.add(new LastIndexOf());
        this.functions.add(new Length());
        this.functions.add(new Replace());
        this.functions.add(new StartsWith());
        this.functions.add(new Substring());
        this.functions.add(new ToLowerCase());
        this.functions.add(new ToUpperCase());
        this.functions.add(new Trim());
    }

    @Override
    public String getName() {
        return "stringFunctions";
    }

    @Override
    public List getFunctions() {
        return this.functions;
    }

    @Override
    public void load(Evaluator evaluator) {
        Iterator functionIterator = this.functions.iterator();
        while (functionIterator.hasNext()) {
            evaluator.putFunction((Function)functionIterator.next());
        }
    }

    @Override
    public void unload(Evaluator evaluator) {
        Iterator functionIterator = this.functions.iterator();
        while (functionIterator.hasNext()) {
            evaluator.removeFunction(((Function)functionIterator.next()).getName());
        }
    }
}

