/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function.string;

import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionHelper;
import net.sourceforge.jeval.function.FunctionResult;

public class Length
implements Function {
    @Override
    public String getName() {
        return "length";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
        Integer result = null;
        String exceptionMessage = "One string argument is required.";
        try {
            String stringValue = arguments;
            String argumentOne = FunctionHelper.trimAndRemoveQuoteChars(stringValue, evaluator.getQuoteCharacter());
            result = new Integer(argumentOne.length());
        }
        catch (FunctionException fe) {
            throw new FunctionException(fe.getMessage(), fe);
        }
        catch (Exception e) {
            throw new FunctionException(exceptionMessage, e);
        }
        return new FunctionResult(result.toString(), 0);
    }
}

