/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.putGetEngine;

import java.io.IOException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import rs.pezar.core.PzApplication;
import rs.pezar.kasa.putGetEngine.DataGetter;
import rs.pezar.kasa.putGetEngine.DataPutter;

public class PutGetEngine {
    private static final String SUBFOLDER = "EI";
    private static final Integer WAIT_FOR_RESPONSE = 25000;
    private static final Integer RETRY_TIME = WAIT_FOR_RESPONSE / 10;
    private String workingFolder;
    private String inFolder;
    private String outFolder;
    private DataPutter dataPutter;
    private Timer timer;
    private TimerTask t;
    private boolean timeOver = false;
    private Integer timeCounter = 0;
    private Integer waitForResponse = WAIT_FOR_RESPONSE;
    private Integer retryTime = RETRY_TIME;
    private String commandFolder;
    private String errorFolder;

    public PutGetEngine(HashMap<String, String> params) {
        this.workingFolder = PzApplication.getApplication().getDataFolder().getPath();
        this.outFolder = params.get("PARAM5");
        this.inFolder = params.get("PARAM2");
        this.commandFolder = params.get("PARAM1");
        this.errorFolder = params.get("PARAM3");
        this.dataPutter = new DataPutter();
    }

    public void put(String data, String type, String filename) throws IOException {
        String folderName;
        String tempName;
        if (type.equals("BILL_TYPE")) {
            tempName = String.valueOf(filename) + ".bon";
            folderName = this.inFolder;
        } else {
            tempName = filename;
            folderName = this.commandFolder;
        }
        this.dataPutter.put(this.workingFolder, SUBFOLDER, folderName, tempName, data, type);
    }

    public HashMap<String, String> get(String filename) {
        DataGetter.dataGet(this.outFolder, filename);
        return null;
    }

    private TimerTask getTimerTask() {
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                PutGetEngine putGetEngine = PutGetEngine.this;
                putGetEngine.timeCounter = putGetEngine.timeCounter + PutGetEngine.this.retryTime;
                if (PutGetEngine.this.timeCounter >= PutGetEngine.this.waitForResponse) {
                    PutGetEngine.this.timeOver = true;
                }
            }
        };
        return t;
    }

    public synchronized HashMap<String, String> putGet(String data, String type, String filename) throws Exception {
        this.timeOver = false;
        this.timeCounter = 0;
        System.out.println(this.waitForResponse);
        System.out.println(this.retryTime);
        try {
            this.put(data, type, filename);
        }
        catch (IOException iOException) {
            throw new Exception("H|Nije moguce snimiti fajl u ulazni direktorijum programa posrednika, da li ste dobro podesili?");
        }
        this.timer = new Timer();
        this.t = this.getTimerTask();
        this.timer.schedule(this.t, 0L, (long)this.retryTime.intValue());
        while (true) {
            HashMap<String, String> resultData = DataGetter.dataGet(this.outFolder, filename);
            HashMap<String, String> resultError = DataGetter.errorGet(this.errorFolder, filename);
            if (resultData.size() > 0 || this.timeOver) {
                this.timer.cancel();
                this.resetTimeSettings();
                return resultData;
            }
            if (resultError.size() > 0 || this.timeOver) {
                this.timer.cancel();
                this.resetTimeSettings();
                return resultError;
            }
            Thread.sleep(this.retryTime.intValue());
        }
    }

    public void extendWaitTime(Integer toMilliseconds) {
        this.waitForResponse = toMilliseconds;
        this.retryTime = this.waitForResponse / 10;
    }

    private void resetTimeSettings() {
        this.waitForResponse = WAIT_FOR_RESPONSE;
        this.retryTime = RETRY_TIME;
    }
}

