/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.putGetEngine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.regex.Pattern;
import rs.pezar.util.PzDateUtility;

public class DataGetter {
    public static String INFO_ERROR = ".ERR";
    public static String INFO_OK = ".OK";

    public static HashMap<String, String> dataGet(String outFolder, String filename) {
        HashMap<String, String> returnInfo = new HashMap<String, String>();
        String regexPattern = String.format("(%s)(.*?)(.bon)", filename);
        SimpleDateFormat formatter = new SimpleDateFormat();
        formatter.applyPattern("d-M-yyyy");
        String date = formatter.format(PzDateUtility.getCurrentDate());
        File[] files = null;
        try {
            files = DataGetter.listFilesMatching(new File(String.valueOf(outFolder) + "\\" + date + "\\"), regexPattern);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (files != null && files.length > 0) {
            returnInfo.put(INFO_OK, "Ok, file je u arhivi");
        }
        return returnInfo;
    }

    public static HashMap<String, String> errorGet(String outFolder, String filename) {
        HashMap<String, String> returnInfo = new HashMap<String, String>();
        try {
            String error = DataGetter.readFile(String.valueOf(outFolder) + "\\" + filename + ".opis");
            returnInfo.put(INFO_ERROR, error);
        }
        catch (IOException e) {
            System.out.println("file " + filename + ".opis " + "nije u direktorijumu za greske");
            e.printStackTrace();
        }
        return returnInfo;
    }

    private static String readFile(String fileName) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    public static File[] listFilesMatching(File root, String regex) {
        if (!root.isDirectory()) {
            throw new IllegalArgumentException(root + " is no directory.");
        }
        final Pattern p = Pattern.compile(regex);
        return root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return p.matcher(file.getName()).matches();
            }
        });
    }

    public static void main(String[] args) {
        DataGetter.listFilesMatching(new File("c:\\Ipos\\Arhiva\\"), "(00036)(.*?)(.bon)");
    }
}

