/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.bill;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import rs.pezar.kasa.article.EiPosLinkArticle;
import rs.pezar.msg.device.cashregister.data.Article;
import rs.pezar.msg.device.interfaces.cashRegister.BillInterface;
import rs.pezar.util.PzDateUtility;

public class EiPosLinkBill {
    private static final String ZAGLAVLJE = "100";
    private static final String PLACANJE = "300";
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("ddMMyyyy");
    private static SimpleDateFormat timeFormatter = new SimpleDateFormat("hhmmss");

    public static String getBill(BillInterface bill, String filename) throws Exception {
        String zaglavlje = EiPosLinkBill.getZaglavlje(filename, bill.getOperaterCode());
        Vector articles = bill.getArticles();
        String art = "";
        int i = 0;
        while (i < articles.size()) {
            art = String.valueOf(art) + EiPosLinkArticle.getEiArticleBillFormat((Article)articles.get(i));
            ++i;
        }
        String pay = EiPosLinkBill.getPaymentOptionsPart(bill.getPaidAmountCard(), bill.getPaidAmountCheck(), bill.getPaidAmountCustomer(), articles);
        return String.valueOf(zaglavlje) + art + pay;
    }

    private static String getZaglavlje(String filename, String operaterCode) throws Exception {
        if (operaterCode == null || operaterCode.length() == 0) {
            throw new Exception("Nevalidan operater kod");
        }
        String operaterCod = operaterCode.length() == 1 ? "0" + operaterCode : operaterCode.substring(operaterCode.length() - 2, operaterCode.length());
        return ZAGLAVLJE + EiPosLinkBill.getCurrentFormattedDate() + EiPosLinkBill.getCurrentFormattedTime() + filename + operaterCod + "\n";
    }

    private static String getCurrentFormattedDate() {
        return dateFormatter.format(PzDateUtility.getCurrentDate());
    }

    private static String getCurrentFormattedTime() {
        return timeFormatter.format(PzDateUtility.getCurrentDate());
    }

    private static String getPaymentOptionsPart(BigDecimal card, BigDecimal check, BigDecimal cash, Vector<Article> articles) {
        String payment = "";
        DecimalFormat df1 = new DecimalFormat("000000000.00");
        if (card.doubleValue() > 0.0) {
            payment = String.valueOf(payment) + PLACANJE + df1.format(card).replace(".", "").replace(",", "") + "02" + "\n";
        }
        if (check.doubleValue() > 0.0) {
            payment = String.valueOf(payment) + PLACANJE + df1.format(check).replace(".", "").replace(",", "") + "01" + "\n";
        }
        if (cash.doubleValue() > 0.0) {
            payment = String.valueOf(payment) + PLACANJE + df1.format(cash).replace(".", "").replace(",", "") + "00" + "\n";
        }
        return payment;
    }
}

