/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.article;

import java.text.DecimalFormat;
import java.util.HashMap;
import rs.pezar.kasa.PzDeviceDriver;
import rs.pezar.msg.device.cashregister.data.Article;

public class EiPosLinkArticle {
    private static final String ARTIKAL = "200";
    private static final Integer MAX_SIFRA_LENGTH = 13;
    static HashMap<String, String> taxRates = new HashMap();

    static {
        taxRates.put("A", "00");
        taxRates.put("G", "01");
        taxRates.put("D", "02");
        taxRates.put("d", "03");
        taxRates.put("E", "04");
        taxRates.put("Z", "05");
        taxRates.put("I", "06");
        taxRates.put("J", "07");
        taxRates.put("K", "08");
    }

    public static String getEiArticleBillFormat(Article article) throws Exception {
        Integer nameLength;
        String name;
        String code = (String.valueOf(article.getSifra()) + "             ").substring(0, 13);
        String taxRate = taxRates.get(String.valueOf(article.getTaxRate()));
        DecimalFormat df = new DecimalFormat("0000000.00");
        String price = df.format(article.getPrice()).replace(",", "").replace(".", "");
        DecimalFormat df1 = new DecimalFormat("00000.000");
        String quantity = df1.format(article.getQuantity()).replace(",", "").replace(".", "");
        if (article.getSifra() == null || article.getSifra().length() == 0 || article.getSifra().length() > MAX_SIFRA_LENGTH) {
            throw new Exception("Na racunu je detektovan artikal sa nedefinisanom sifrom ili je sifra duza od " + MAX_SIFRA_LENGTH + " karaktera.");
        }
        if (taxRate == null || taxRate.length() == 0) {
            throw new Exception("Artikal " + article.getSifra() + " nema podesenu stopu poreza.");
        }
        if (article.getPrice() == null) {
            throw new Exception("Artikal " + article.getSifra() + " nema definisanu cenu.");
        }
        if (article.getQuantity() == null || article.getQuantity().equals("0")) {
            throw new Exception("Artikal " + article.getSifra() + " ne moze imati cenu 0 ili cena nije definisana.");
        }
        try {
            name = PzDeviceDriver.getInstance().getParams().get("PARAM4");
            nameLength = Integer.valueOf(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Lose prosledjena vrednost za parametar duzine naziva pri inicijalizaciji drivera za Ei printer");
        }
        name = String.valueOf(article.getName()) + "                                      ";
        name = name.replaceAll("\u00c5\u00a0", "S");
        name = name.replaceAll("\u00c5\u00a1", "s");
        name = name.replaceAll("\u00c4\u2018", "d");
        name = name.replaceAll("\u00c4\ufffd", "D");
        name = name.replaceAll("\u00c5\u00be", "z");
        name = name.replaceAll("\u00c5\u00bd", "Z");
        name = name.replaceAll("\u00c4\ufffd", "c");
        name = name.replaceAll("\u00c4\u0152", "C");
        name = name.replaceAll("\u00c4\u2021", "c");
        name = name.replaceAll("\u00c4\u2020", "C");
        name = name.replaceAll(",", " ");
        name = name.replaceAll("'", " ");
        name = name.replaceAll("\"", " ");
        name = name.replaceAll("`", " ");
        name = name.replaceAll("&", " ");
        name = name.substring(0, nameLength);
        return ARTIKAL + name + price + quantity + "00" + code + taxRate + "\n";
    }
}

