/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.util;

import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentFinalizer;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.globals.TipDokumentConfig;

public class PzProdajaFinalizer
implements PzDokumentFinalizer {
    List<String> tipovi = new Vector<String>();

    public PzProdajaFinalizer() {
        this.tipovi.add(TipDokumentConfig.get().FAKTURA);
        this.tipovi.add(TipDokumentConfig.get().FAKTURA_SERVISA);
        this.tipovi.add(TipDokumentConfig.get().FAKTURA_USLUGA);
        this.tipovi.add(TipDokumentConfig.get().RACUN_KUPCA);
    }

    public boolean appliesTo(PzDokument d) {
        return this.tipovi.contains(d.getTip());
    }

    public void finalize(PzDokument d, EntityManager em) {
        if (d.getDokument() != null) {
            if (d.getDokument().getStorno() == 0) {
                d.getDokument().setVrstaDuga("P");
            } else {
                d.getDokument().setVrstaDuga("PS");
            }
        }
        if (d.getDokument().getArtikaldokuments() != null) {
            for (Artikaldokument ad : d.getDokument().getArtikaldokuments()) {
                Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(ad.getId().getSfrProizvod(), d.getRadnajedinica()));
                if (d.getDokument().getStorno() == 0) {
                    ad.setVrstaPromene("P");
                    if (!d.getTip().equals(TipDokumentConfig.get().FAKTURA) && !d.getTip().equals(TipDokumentConfig.get().FAKTURA_SERVISA) && !d.getTip().equals(TipDokumentConfig.get().FISKALNI_IZVESTAJ)) continue;
                    s.setKumProdaje(s.getKumProdaje() + ad.getKolicina());
                    continue;
                }
                ad.setVrstaPromene("PS");
                if (!d.getTip().equals(TipDokumentConfig.get().FAKTURA) && !d.getTip().equals(TipDokumentConfig.get().FAKTURA_SERVISA) && !d.getTip().equals(TipDokumentConfig.get().FISKALNI_IZVESTAJ)) continue;
                s.setKumProdaje(s.getKumProdaje() - ad.getKolicina());
            }
        }
        if (d.getTip().equals(TipDokumentConfig.get().FAKTURA)) {
            PzEntityUtil.addTaksaDokuments((PzDokument)d, (String)"AKC");
            d.getDokument().updateTaksaDokuments(d.getTaksadokuments());
        }
    }
}

