/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.util;

import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Ogranak;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.db.entity.Stavkaporudzbine;
import rs.pezar.db.entity.StavkaporudzbinePK;
import rs.pezar.db.util.WebPorudzbina;
import rs.pezar.db.util.WebPorudzbinaStavka;
import rs.pezar.prodaja.PzExtensionLoader;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.PreuzimanjePorudzbine;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzGenericTableDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PreuzimanjePorudzbineUtil {
    private static String nepostojeci;

    public static void ucitajPorudzbinu(final WebPorudzbina p, final Radnajedinica rj, final PzTable table, final PreuzimanjePorudzbine dlg) {
        if (p == null || rj == null) {
            return;
        }
        if (p.getStavke() == null || p.getStavke().size() == 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)dlg), (String)"Izabrana porud\u017ebina nema stavke. Preuzimanje obustavljeno!");
            return;
        }
        PzWorkerDialog.showStatus((String)"U\u010ditavanje porud\u017ebine je u toku. Molim, sa\u010dekajte ...", (PzDialog)((PzDialog)SwingUtilities.getRoot((Component)table)));
        SwingWorker<Vector<Stavkaporudzbine>, Integer> worker = new SwingWorker<Vector<Stavkaporudzbine>, Integer>(){
            EntityManager em;
            private Faktura f;

            @Override
            protected Vector<Stavkaporudzbine> doInBackground() throws Exception {
                this.em = PzEntityManagerFactory.getInstance().createEm();
                StringBuffer nepostojeci = new StringBuffer();
                Vector<Stavkaporudzbine> stavke = new Vector<Stavkaporudzbine>();
                PzWorkerDialog.getDialogInstance().setProgresSize(0, p.getStavke().size());
                this.em.getTransaction().begin();
                int i = 1;
                this.f = new Faktura();
                for (WebPorudzbinaStavka wps : p.getStavke()) {
                    String sfrProizvod = wps.getSifra();
                    Stanjeartikal a = (Stanjeartikal)this.em.find(Stanjeartikal.class, (Object)new StanjeartikalPK(sfrProizvod, rj));
                    if (a == null) {
                        nepostojeci.append(String.valueOf(sfrProizvod) + "\n");
                    } else {
                        Stavkaporudzbine stavka = new Stavkaporudzbine();
                        stavka.setId(new StavkaporudzbinePK(Integer.valueOf(0), Integer.valueOf(i++)));
                        stavka.setCenaPorucena(wps.getCena());
                        stavka.setKolPorucena(wps.getKolicina());
                        stavka.setRabat(wps.getRabat());
                        stavka.setFaktura(this.f);
                        Stanje s = (Stanje)this.em.find(Stanje.class, (Object)new StanjePK(sfrProizvod, rj));
                        if (s != null) {
                            if (s.getKolicina() - s.getAlocKolicina() < 0.0) {
                                s.setAlocKolicina(stavka.getKolPorucena().doubleValue() + s.getAlocKolicina());
                            } else {
                                s.setAlocKolicina(stavka.getKolPorucena().doubleValue() + s.getAlocKolicina());
                            }
                        }
                        stavka.setStanjeartikal(a);
                        stavke.add(stavka);
                    }
                    this.publish(i);
                }
                this.f.setKomitent((Komitent)this.em.find(Komitent.class, (Object)p.getSfrKomitent()));
                this.f.setDatPrometa(PzDateUtility.getCurrentDate());
                this.f.setDatum(PzDateUtility.getCurrentDate());
                this.f.setDatValute(PzDateUtility.getCurrentDate());
                this.f.setRadnajedinica(rj);
                this.f.setTip("FAKTURA");
                this.f.setStavkaporudzbines(stavke);
                this.f.setArtikalfakturas(new Vector());
                this.f.setFakturaparameters(new ArrayList());
                Fakturaparameter fp = new Fakturaparameter(this.f.getIdDok(), "NAPOMENA", p.getComment(), "Napomena iz porudzbine");
                this.f.getFakturaparameters().add(fp);
                this.em.getTransaction().commit();
                for (Stavkaporudzbine st : this.f.getStavkaporudzbines()) {
                    st.getStanjeartikal().setAlocKolicina(st.getStanjeartikal().getAlocKolicina() + st.getKolPorucena().doubleValue());
                }
                if (nepostojeci.length() > 0) {
                    nepostojeci = nepostojeci.toString();
                }
                return stavke;
            }

            @Override
            protected void done() {
                try {
                    try {
                        table.setData((List)this.get(), Stavkaporudzbine.class);
                        dlg.setRenderers();
                        dlg.setFaktura(this.f);
                        if (nepostojeci != null) {
                            JXErrorPane.showDialog((Component)table, (ErrorInfo)new ErrorInfo("Nepostoje\u0107i artikli", "Fajl sadr\u017ei nepostoje\u0107e \u0161ifre. Takvi artikli ne\u0107e biti uklju\u010deni u porud\u017ebinu.", nepostojeci, null, null, null, null));
                            nepostojeci = null;
                        }
                    }
                    catch (Exception e) {
                        dlg.dispose();
                        PzMysqlExceptionHandler.handle((Component)table, (Throwable)e);
                        this.em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    this.em.close();
                    PzWorkerDialog.hideStatus();
                }
            }

            @Override
            protected void process(List<Integer> arg0) {
                int i = 0;
                while (i < arg0.size()) {
                    PzWorkerDialog.getDialogInstance().incProgress(1);
                    ++i;
                }
            }
        };
        worker.execute();
    }

    public static Vector<Artikalfaktura> transformToArtikalFakturas(List<Stavkaporudzbine> stavke, EntityManager em) throws Exception {
        Vector<Artikalfaktura> rez = null;
        if (stavke != null && stavke.size() > 0) {
            rez = new Vector<Artikalfaktura>();
            for (Stavkaporudzbine st : stavke) {
                Artikalfaktura af = new Artikalfaktura();
                Artikal artikal = (Artikal)em.find(Artikal.class, (Object)st.getStanjeartikal().getId().getSfrProizvod());
                if (artikal == null) {
                    throw new Exception("Artikal " + st.getStanjeartikal().getId().getSfrProizvod() + " ne postoji");
                }
                af.init(artikal, (PzDokument)st.getFaktura());
                af.setCena(st.getCenaPorucena().doubleValue());
                af.setKolicina(st.getKolPorucena().doubleValue());
                af.setProcRabata(st.getRabat().doubleValue());
                af.setKonsignacija(st.getKons());
                af.setKolSaKons(st.getKolKons().doubleValue());
                af.setDobSifra(artikal.getDobSifra());
                af.setProsNabCena(st.getStanjeartikal().getProsNabCena());
                af.setProdCena(BDConverter.getProdCena((double)af.getCena()));
                af.setTezina(st.getStanjeartikal().getTezina() != 0.0 ? st.getStanjeartikal().getTezina() : 0.0);
                af.setDobSifra(st.getStanjeartikal().getDobSifra());
                af.setNabCena(st.getStanjeartikal().getZadNabCena());
                rez.add(af);
            }
        }
        return rez;
    }

    private static String dealocirajStavkeBezKolicine(List<Stavkaporudzbine> stavke, EntityManager em) {
        StringBuffer result = new StringBuffer();
        for (Stavkaporudzbine stavka : stavke) {
            if (stavka.getKolIndikator() != -1) continue;
            result.append("-    [" + stavka.getStanjeartikal().getId().getSfrProizvod() + "] " + stavka.getStanjeartikal().getNaziv() + "#n");
        }
        if (result.length() > 0) {
            String poruka = "\u017dao nam je, ali trenutno nismo u mogu\u0107nosti da vam po\u0161aljemo artikle: #n#n" + result.toString() + "#n iz slede\u0107ih razloga:#n#n#n#n#n";
            Firma firma = null;
            try {
                firma = PzFirma.getFirma();
                String komercijalista = String.valueOf(PzExtensionLoader.getLoggedUser().getIme()) + " " + PzExtensionLoader.getLoggedUser().getPrezime() + "#n" + firma.getNaziv() + "#n" + firma.getAdresa() + "#n" + firma.getPostBroj() + " " + firma.getGrad() + "#n" + firma.getTelefoni();
                poruka = String.valueOf(poruka) + komercijalista;
                poruka = poruka.replaceAll("\"|\\^|\\%|\\$|\\&|'|\\*|\\(|\\)|\\||`", "").replace(" ", "%20").replace("#n", "%0D%0A");
                return poruka;
            }
            catch (Exception e) {
                PzLogger.getInstance().logException((Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static void transformToArtikalFakturas(List<Stavkaporudzbine> stavke, Faktura f, PreuzimanjePorudzbine dlg) throws Exception {
        if (PreuzimanjePorudzbineUtil.postojiSpornaStavka(stavke)) {
            PzSwingUtility.showErrorMessage((Component)((Object)dlg), (String)"Postoji stavka \u010dija koli\u010dina nije preuzeta sa konsignacije. Preuzmite koli\u010dinu ili uklonite artikal iz liste!");
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                Vector<Artikalfaktura> rez = PreuzimanjePorudzbineUtil.transformToArtikalFakturas(stavke, em);
                String poruka = PreuzimanjePorudzbineUtil.dealocirajStavkeBezKolicine(stavke, em);
                f.getArtikalfakturas().addAll(rez);
                f.setStavkaporudzbines(new Vector());
                PzDokumentManager.getInstance().snimiDokument((PzDokument)f, true, null, em);
                em.persist((Object)f.createLog(15, "Preuzeta porudzbina", f.getUserPoc(), em));
                em.getTransaction().commit();
                try {
                    if (poruka != null) {
                        Desktop.getDesktop().mail(new URI("mailto:" + f.getKomitent().getEmail() + "?subject=Va\u0161a%20porud\u017ebina&body=" + poruka, null, null));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    PzSwingUtility.showErrorMessage((Component)((Object)dlg), (String)("Gre\u0161ka prilikom formiranja e-mail poruke. E-mail adresa kupca najverovatnije nije dobro formirana: " + f.getKomitent().getEmail() + "\n" + ". Ispravite adrese kroz \u0161ifarnik komitenata pa poku\u0161ajte ponovo."));
                    em.getTransaction().begin();
                    f.getArtikalfakturas().clear();
                    f.setStavkaporudzbines(stavke);
                    em.getTransaction().commit();
                }
                dlg.dispose();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public static void posaljiMejl(List<Stavkaporudzbine> stavke, String komentar, String idPorudzbine, String email) {
        StringBuffer result = new StringBuffer();
        result.append("Po\u0161tovani, potvr\u0111ujemo prijem Va\u0161e porud\u017ebine " + idPorudzbine + "\n\n");
        result.append("SADR\u017dAJ PORUD\u017dBINE: \n\n");
        for (Stavkaporudzbine stavka : stavke) {
            String red = stavka.getKolPorucena().setScale(1) + " X " + "[" + stavka.getStanjeartikal().getId().getSfrProizvod() + "] " + stavka.getStanjeartikal().getNaziv() + "\n";
            result.append(red);
        }
        result.append("\n\n");
        result.append(komentar);
        String poruka = result.toString();
        poruka = poruka.replaceAll("\"|\\^|\\%|\\$|\\&|'|\\*|\\(|\\)|\\||`", "").replace(":", "%3a").replace(" ", "%20").replace("\r\n", "%0D%0A").replace("\n", "%0D%0A");
        try {
            Desktop.getDesktop().mail(new URI("mailto:" + email + "?subject=Va\u0161a%20porud\u017ebina%20broj%20" + idPorudzbine + "&body=" + poruka, null, null));
        }
        catch (URISyntaxException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    private static boolean postojiSpornaStavka(List<Stavkaporudzbine> stavke) {
        boolean found = false;
        for (Stavkaporudzbine stavka : stavke) {
            if (stavka.getKolIndikator() != 0) continue;
            found = true;
            break;
        }
        return found;
    }

    public static void alociraj(Stanje s, double kol) {
        s.setAlocKolicina(s.getAlocKolicina() + kol);
    }

    public static void deAlociraj(Stanje s, double kol) {
        s.setAlocKolicina(s.getAlocKolicina() - kol);
    }

    public static Stanje getKolKons(EntityManager em, PzDialog parent, List<Stanje> data) {
        PzEntityFilter filter = new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Stanje a = (Stanje)entity;
                return new Object[]{"[" + a.getId().getOznRj() + "] " + a.getRadnajedinica().getNaziv(), a.getRaspolozivaKolicina()};
            }

            public String[] getColumnNames() {
                return new String[]{"Radna jedinica", "<html>Rapolo\u017eiva<br>koli\u010dina</html>"};
            }
        };
        return (Stanje)PzGenericTableDialog.showDialog((PzDialog)parent, Stanjeartikal.class, data, (String)"Preuzimanje koli\u010dine", (String)"Izaberite konsignaciju sa koje se preuzima koli\u010dina", (PzEntityFilter)filter);
    }

    public static List<Stanje> getKonsignacije(EntityManager em, double kolicina, String sfrProizvod, Ogranak ogranak) {
        Query q = em.createQuery("SELECT s FROM Stanje s where s.radnajedinica.ogranak=:ogranak and s.id.sfrProizvod=:sfrP and s.radnajedinica.gTip=:tip and s.kolicina - s.alocKolicina>=:kol");
        q.setParameter("sfrP", (Object)sfrProizvod);
        q.setParameter("ogranak", (Object)ogranak);
        q.setParameter("tip", (Object)"T");
        q.setParameter("kol", (Object)kolicina);
        List data = q.getResultList();
        return data;
    }

    public static void preuzmiIzKonsignacije(Stavkaporudzbine st, EntityManager em, PzDialog parent, PzTable table) {
        if (st.getKolIndikator() != 0) {
            return;
        }
        Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(st.getStanjeartikal().getId().getSfrProizvod(), st.getStanjeartikal().getRadnajedinica()));
        if (stanje == null) {
            PzSwingUtility.showErrorMessage((Component)parent, (String)"Artikal do sada nije imao promet u posmatranoj radnoj jedinici. Rad sa ovim artiklom vam je zato onemogu\u0107en.");
            return;
        }
        double raspolozivaKolicina = stanje.getRaspolozivaKolicina() + st.getKolPorucena().doubleValue() > 0.0 ? stanje.getRaspolozivaKolicina() + st.getKolPorucena().doubleValue() : 0.0;
        double kolZaPreuzimanje = st.getKolPorucena().doubleValue() - raspolozivaKolicina;
        List<Stanje> konsignacije = PreuzimanjePorudzbineUtil.getKonsignacije(em, kolZaPreuzimanje, st.getStanjeartikal().getId().getSfrProizvod(), st.getStanjeartikal().getRadnajedinica().getOgranak());
        if (konsignacije.size() == 0) {
            String msg = "Ni u jednoj pojedina\u010dnoj konsignacije nema dovoljno koli\u010dine za pokrivanje porud\u017ebine. ";
            List<Stanje> konsignacijeSve = PreuzimanjePorudzbineUtil.getKonsignacije(em, 0.0, st.getStanjeartikal().getId().getSfrProizvod(), st.getStanjeartikal().getRadnajedinica().getOgranak());
            if (konsignacijeSve.size() > 0) {
                msg = String.valueOf(msg) + "\nRaspolozive kolicine po konsignacijama: ";
                int i = 0;
                while (i < konsignacijeSve.size()) {
                    msg = String.valueOf(msg) + "\n  ---  ( Konsignacija: [" + konsignacijeSve.get(i).getId().getOznRj() + "] - koli\u010dina: " + konsignacijeSve.get(i).getRaspolozivaKolicina() + " )";
                    ++i;
                }
            }
            PzSwingUtility.showErrorMessage((Component)parent, (String)msg);
        } else {
            if (konsignacije.size() == 1) {
                PreuzimanjePorudzbineUtil.alociraj(konsignacije.get(0), kolZaPreuzimanje);
            } else {
                Stanje sKons = PreuzimanjePorudzbineUtil.getKolKons(em, parent, konsignacije);
                PreuzimanjePorudzbineUtil.alociraj(sKons, kolZaPreuzimanje);
            }
            st.setKolKons(new BigDecimal(Double.toString(kolZaPreuzimanje)));
            st.setKons(konsignacije.get(0).getId().getOznRj());
            int row = table.getSelectedRow();
            table.updateSelectedEntity((PzEntity)st, em);
            st.getStanjeartikal().setKonsKolicina(st.getStanjeartikal().getKonsKolicina() - kolZaPreuzimanje);
            table.setRowSelectionInterval(row, row);
        }
    }

    public static void vratiKolicine(Stavkaporudzbine stavka, EntityManager em) {
        Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(stavka.getStanjeartikal().getId().getSfrProizvod(), stavka.getStanjeartikal().getRadnajedinica()));
        if (s == null) {
            return;
        }
        s.setAlocKolicina(s.getAlocKolicina() - stavka.getKolPorucena().doubleValue());
        if (stavka.getKolKons().doubleValue() > 0.0) {
            Stanje s1 = (Stanje)em.find(Stanje.class, (Object)new StanjePK(stavka.getStanjeartikal().getId().getSfrProizvod(), "1", stavka.getKons()));
            s1.setAlocKolicina(s1.getAlocKolicina() - stavka.getKolKons().doubleValue());
        }
    }

    public static void vratiKolicine(Faktura f, EntityManager em) {
        if (f.getTip().equals("FAKTURA") && f.getStavkaporudzbines() != null && f.getStavkaporudzbines().size() > 0) {
            for (Stavkaporudzbine st : f.getStavkaporudzbines()) {
                PreuzimanjePorudzbineUtil.vratiKolicine(st, em);
            }
        }
    }
}

