/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.rabatnaPolitika;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.entity.KondGrupa;
import rs.pezar.db.entity.RabatnaPolitika;
import rs.pezar.sifarnici.gui.PzDialogKondicioneGrupe;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzIntegerField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;

public class DodavanjeRabatnePolitike
extends PzDialog {
    private static final long serialVersionUID = 3737764509820717235L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader header;
    private PzPanel pnlCenter;
    private JLabel lblArtikli;
    private JLabel lblKomitenti;
    private PzIntegerField intGrupaArtikli;
    private PzIntegerField intGrupaKomitenti;
    private PzTextField txtNazivArtikli;
    private PzTextField txtNazivKomitenti;
    private JLabel lblRabat;
    private PzDoubleField dblProcenat;
    private JCheckBox chckbxPrimenjujeSePermanentno;
    private PzFieldIndikator indArtikli;
    private PzFieldIndikator indKomitenti;
    private PzRadioGroup radioGroup;
    private PzPanel pnlDatumi;
    private JLabel lblDatumOd;
    private PzDateField datOd;
    private JLabel lblKrajnjiDatum;
    private PzDateField datDo;
    private PzComponentGroup dateGroup;
    private JCheckBox chckbxPolitikaJeAktivna;
    private PzTable table;
    private RabatnaPolitika politika;
    private Boolean update;
    private KondGrupa kondGrupaArtikli;
    private KondGrupa kondGrupaKomitenti;
    private JLabel lblOpis;
    private PzTextField txtOpis;

    public DodavanjeRabatnePolitike() {
        this.initGUI();
    }

    public DodavanjeRabatnePolitike(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.initData();
        this.paintPanel();
    }

    private void initData() {
        this.update = (Boolean)this.getSession().getParameter("update");
        this.table = (PzTable)this.getSession().getParameter("RABATNA_POLITIKA_TABLE");
        if (this.update.booleanValue()) {
            this.politika = (RabatnaPolitika)this.table.getSelectedEntity();
            if (this.politika.getKondGrupaArtikli() != null) {
                this.intGrupaArtikli.setVal((Object)this.politika.getKondGrupaArtikli().getIdKondGrupa());
            }
            if (this.politika.getKondGrupaKomitenti() != null) {
                this.intGrupaKomitenti.setVal((Object)this.politika.getKondGrupaKomitenti().getIdKondGrupa());
            }
            this.dblProcenat.setVal((Object)this.politika.getProcenat().doubleValue());
            this.chckbxPrimenjujeSePermanentno.setSelected(this.politika.getTip() == 1);
            this.chckbxPolitikaJeAktivna.setSelected(this.politika.getAktivna() == 1);
            this.txtOpis.setVal((Object)this.politika.getOpis());
            if (this.politika.getDatOd() != null && this.politika.getDatDo() != null) {
                this.radioGroup.setSelectedIndex(1);
                this.datOd.setVal((Object)this.politika.getDatOd());
                this.datDo.setVal((Object)this.politika.getDatDo());
            }
        }
    }

    private void paintPanel() {
        this.contentPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.contentPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.contentPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        this.setTitle("Dodavanje / izmena rabatne politike");
        this.setSize(570, 430);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        JPanel buttonPane = new JPanel();
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        buttonPane.setLayout(new FlowLayout(1));
        buttonPane.setOpaque(false);
        JButton okButton = new JButton("Unesi");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DodavanjeRabatnePolitike.this.okButtonactionPerformed(arg0);
            }
        });
        okButton.setIcon(new ImageIcon(DodavanjeRabatnePolitike.class.getResource("/rs/pezar/prodaja/resource/img/check.png")));
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.header = new PzPanelHeader();
        this.header.setText("Izabrtite grupu artikala i komitenata na koje se primenjuje politika");
        this.header.setTitle("Rabatna politika");
        this.header.setIcon(new ImageIcon(DodavanjeRabatnePolitike.class.getResource("/rs/pezar/prodaja/resource/img/document_chart.png")));
        this.contentPanel.add((Component)this.header, (Object)"North");
        this.header.setOpaque(false);
        this.pnlCenter = new PzPanel();
        this.pnlCenter.setBorder((Border)new EmptyBorder(0, 10, 0, 10));
        this.contentPanel.add((Component)this.pnlCenter, (Object)"Center");
        GridBagLayout gbl_pnlCenter = new GridBagLayout();
        int[] nArray = new int[5];
        nArray[1] = 88;
        gbl_pnlCenter.columnWidths = nArray;
        gbl_pnlCenter.rowHeights = new int[9];
        gbl_pnlCenter.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_pnlCenter.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.pnlCenter.setLayout((LayoutManager)gbl_pnlCenter);
        this.pnlCenter.setOpaque(false);
        this.lblArtikli = new JLabel("Grupa artikala:");
        GridBagConstraints gbc_lblArtikli = new GridBagConstraints();
        gbc_lblArtikli.anchor = 13;
        gbc_lblArtikli.insets = new Insets(0, 0, 5, 5);
        gbc_lblArtikli.gridx = 0;
        gbc_lblArtikli.gridy = 0;
        this.pnlCenter.add((Component)this.lblArtikli, (Object)gbc_lblArtikli);
        this.intGrupaArtikli = new PzIntegerField();
        this.intGrupaArtikli.setFKField(KondGrupa.class, PzDialogKondicioneGrupe.class, false, null);
        this.intGrupaArtikli.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DodavanjeRabatnePolitike.this.sfrProizvodfocusGained(e);
            }
        });
        GridBagConstraints gbc_intGrupaArtikli = new GridBagConstraints();
        gbc_intGrupaArtikli.insets = new Insets(0, 0, 5, 5);
        gbc_intGrupaArtikli.fill = 2;
        gbc_intGrupaArtikli.gridx = 1;
        gbc_intGrupaArtikli.gridy = 0;
        this.pnlCenter.add((Component)this.intGrupaArtikli, (Object)gbc_intGrupaArtikli);
        this.indArtikli = new PzFieldIndikator();
        GridBagConstraints gbc_indArtikli = new GridBagConstraints();
        gbc_indArtikli.insets = new Insets(0, 0, 5, 5);
        gbc_indArtikli.anchor = 13;
        gbc_indArtikli.gridx = 2;
        gbc_indArtikli.gridy = 0;
        this.pnlCenter.add((Component)this.indArtikli, (Object)gbc_indArtikli);
        this.txtNazivArtikli = new PzTextField();
        this.txtNazivArtikli.setText("Primenjuje se na sve artikle");
        this.txtNazivArtikli.setFocusable(false);
        this.txtNazivArtikli.setEditable(false);
        GridBagConstraints gbc_txtNazivArtikli = new GridBagConstraints();
        gbc_txtNazivArtikli.insets = new Insets(0, 0, 5, 0);
        gbc_txtNazivArtikli.fill = 2;
        gbc_txtNazivArtikli.gridx = 3;
        gbc_txtNazivArtikli.gridy = 0;
        this.pnlCenter.add((Component)this.txtNazivArtikli, (Object)gbc_txtNazivArtikli);
        this.lblKomitenti = new JLabel("Grupa komitenata:");
        GridBagConstraints gbc_lblKomitenti = new GridBagConstraints();
        gbc_lblKomitenti.anchor = 13;
        gbc_lblKomitenti.insets = new Insets(0, 0, 5, 5);
        gbc_lblKomitenti.gridx = 0;
        gbc_lblKomitenti.gridy = 1;
        this.pnlCenter.add((Component)this.lblKomitenti, (Object)gbc_lblKomitenti);
        this.intGrupaKomitenti = new PzIntegerField();
        this.intGrupaKomitenti.setFKField(KondGrupa.class, PzDialogKondicioneGrupe.class, false, null);
        this.intGrupaKomitenti.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DodavanjeRabatnePolitike.this.intGrupaKomitentifocusGained(e);
            }
        });
        GridBagConstraints gbc_intGrupaKomitenti = new GridBagConstraints();
        gbc_intGrupaKomitenti.insets = new Insets(0, 0, 5, 5);
        gbc_intGrupaKomitenti.fill = 2;
        gbc_intGrupaKomitenti.gridx = 1;
        gbc_intGrupaKomitenti.gridy = 1;
        this.pnlCenter.add((Component)this.intGrupaKomitenti, (Object)gbc_intGrupaKomitenti);
        this.indKomitenti = new PzFieldIndikator();
        GridBagConstraints gbc_indKomitenti = new GridBagConstraints();
        gbc_indKomitenti.insets = new Insets(0, 0, 5, 5);
        gbc_indKomitenti.anchor = 13;
        gbc_indKomitenti.gridx = 2;
        gbc_indKomitenti.gridy = 1;
        this.pnlCenter.add((Component)this.indKomitenti, (Object)gbc_indKomitenti);
        this.txtNazivKomitenti = new PzTextField();
        this.txtNazivKomitenti.setText("Primenjuje se na sve komitente");
        this.txtNazivKomitenti.setFocusable(false);
        this.txtNazivKomitenti.setEditable(false);
        GridBagConstraints gbc_txtNazivKomitenti = new GridBagConstraints();
        gbc_txtNazivKomitenti.insets = new Insets(0, 0, 5, 0);
        gbc_txtNazivKomitenti.fill = 2;
        gbc_txtNazivKomitenti.gridx = 3;
        gbc_txtNazivKomitenti.gridy = 1;
        this.pnlCenter.add((Component)this.txtNazivKomitenti, (Object)gbc_txtNazivKomitenti);
        this.lblRabat = new JLabel("Procenat rabata:");
        GridBagConstraints gbc_lblRabat = new GridBagConstraints();
        gbc_lblRabat.anchor = 13;
        gbc_lblRabat.insets = new Insets(0, 0, 5, 5);
        gbc_lblRabat.gridx = 0;
        gbc_lblRabat.gridy = 2;
        this.pnlCenter.add((Component)this.lblRabat, (Object)gbc_lblRabat);
        this.dblProcenat = new PzDoubleField();
        GridBagConstraints gbc_dblProcenat = new GridBagConstraints();
        gbc_dblProcenat.insets = new Insets(0, 0, 5, 5);
        gbc_dblProcenat.fill = 2;
        gbc_dblProcenat.gridx = 1;
        gbc_dblProcenat.gridy = 2;
        this.pnlCenter.add((Component)this.dblProcenat, (Object)gbc_dblProcenat);
        this.chckbxPrimenjujeSePermanentno = new JCheckBox("Primenjuje se permanentno");
        this.chckbxPrimenjujeSePermanentno.setOpaque(false);
        GridBagConstraints gbc_chckbxPromenjujeSePermanentno = new GridBagConstraints();
        gbc_chckbxPromenjujeSePermanentno.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxPromenjujeSePermanentno.anchor = 17;
        gbc_chckbxPromenjujeSePermanentno.gridwidth = 3;
        gbc_chckbxPromenjujeSePermanentno.gridx = 1;
        gbc_chckbxPromenjujeSePermanentno.gridy = 3;
        this.pnlCenter.add((Component)this.chckbxPrimenjujeSePermanentno, (Object)gbc_chckbxPromenjujeSePermanentno);
        this.intGrupaArtikli.setStateIndikator(this.indArtikli);
        this.intGrupaKomitenti.setStateIndikator(this.indKomitenti);
        this.radioGroup = new PzRadioGroup();
        this.radioGroup.setValues((Object[])new PzChoice[]{new PzChoice("Politika se primenjuje bez ograni\u010denja", (Object)"BEZ_OGRANICENJA"), new PzChoice("Politika \u0107e se primenjivati u periodu", (Object)"PERIOD")});
        this.radioGroup.setLayoutAxis(1);
        this.radioGroup.setSelectedIndex(0);
        this.radioGroup.setBorder((Border)new TitledBorder(null, "Period primene", 4, 2, null, null));
        this.radioGroup.addRadioGroupListener(new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                DodavanjeRabatnePolitike.this.radioGroupselectionChanged(evt);
            }
        });
        GridBagConstraints gbc_radioGroup = new GridBagConstraints();
        gbc_radioGroup.insets = new Insets(0, 0, 5, 0);
        gbc_radioGroup.gridwidth = 3;
        gbc_radioGroup.fill = 1;
        gbc_radioGroup.gridx = 1;
        gbc_radioGroup.gridy = 4;
        this.pnlCenter.add((Component)this.radioGroup, (Object)gbc_radioGroup);
        this.radioGroup.setOpaque(false);
        this.pnlDatumi = new PzPanel();
        FlowLayout flowLayout = (FlowLayout)this.pnlDatumi.getLayout();
        flowLayout.setAlignment(0);
        GridBagConstraints gbc_pnlDatumi = new GridBagConstraints();
        gbc_pnlDatumi.insets = new Insets(0, 0, 5, 0);
        gbc_pnlDatumi.gridwidth = 3;
        gbc_pnlDatumi.fill = 1;
        gbc_pnlDatumi.gridx = 1;
        gbc_pnlDatumi.gridy = 5;
        this.pnlCenter.add((Component)this.pnlDatumi, (Object)gbc_pnlDatumi);
        this.pnlDatumi.setOpaque(false);
        this.lblDatumOd = new JLabel("Po\u010detni datum:");
        this.pnlDatumi.add((Component)this.lblDatumOd);
        this.datOd = new PzDateField();
        this.datOd.setColumns(10);
        this.pnlDatumi.add((Component)this.datOd);
        this.lblKrajnjiDatum = new JLabel("Krajnji datum:");
        this.pnlDatumi.add((Component)this.lblKrajnjiDatum);
        this.datDo = new PzDateField();
        this.datDo.setColumns(10);
        this.pnlDatumi.add((Component)this.datDo);
        this.dateGroup = new PzComponentGroup();
        this.dateGroup.add((Component)this.datOd);
        this.dateGroup.add((Component)this.datDo);
        this.datOd.setEnabled(false);
        this.datDo.setEnabled(false);
        this.lblOpis = new JLabel("Opis:");
        GridBagConstraints gbc_lblOpis = new GridBagConstraints();
        gbc_lblOpis.anchor = 13;
        gbc_lblOpis.insets = new Insets(0, 0, 5, 5);
        gbc_lblOpis.gridx = 0;
        gbc_lblOpis.gridy = 6;
        this.pnlCenter.add((Component)this.lblOpis, (Object)gbc_lblOpis);
        this.txtOpis = new PzTextField();
        GridBagConstraints gbc_txtOpis = new GridBagConstraints();
        gbc_txtOpis.insets = new Insets(0, 0, 5, 0);
        gbc_txtOpis.gridwidth = 3;
        gbc_txtOpis.fill = 2;
        gbc_txtOpis.gridx = 1;
        gbc_txtOpis.gridy = 6;
        this.pnlCenter.add((Component)this.txtOpis, (Object)gbc_txtOpis);
        this.chckbxPolitikaJeAktivna = new JCheckBox("Politika je aktivna");
        this.chckbxPolitikaJeAktivna.setSelected(true);
        this.chckbxPolitikaJeAktivna.setOpaque(false);
        GridBagConstraints gbc_chckbxPolitikaJeAktivna = new GridBagConstraints();
        gbc_chckbxPolitikaJeAktivna.anchor = 17;
        gbc_chckbxPolitikaJeAktivna.gridwidth = 3;
        gbc_chckbxPolitikaJeAktivna.gridx = 1;
        gbc_chckbxPolitikaJeAktivna.gridy = 7;
        this.pnlCenter.add((Component)this.chckbxPolitikaJeAktivna, (Object)gbc_chckbxPolitikaJeAktivna);
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void sfrProizvodfocusGained(FocusEvent e) {
        this.getSession().putParameter("KOND_GRUPA_TIP", (Object)"ARTIKLI");
    }

    protected void intGrupaKomitentifocusGained(FocusEvent e) {
        this.getSession().putParameter("KOND_GRUPA_TIP", (Object)"KOMITENTI");
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        PzField field = (PzField)component;
        KondGrupa grp = (KondGrupa)entity;
        field.setVal((Object)grp.getIdKondGrupa());
        if (field == this.intGrupaArtikli) {
            this.txtNazivArtikli.setVal((Object)grp.getNaziv());
            this.kondGrupaArtikli = grp;
        } else if (field == this.intGrupaKomitenti) {
            this.txtNazivKomitenti.setVal((Object)grp.getNaziv());
            this.kondGrupaKomitenti = grp;
        }
    }

    protected void radioGroupselectionChanged(PzRadioGroupEvent evt) {
        if (evt.getStateChange() == 1) {
            if (this.radioGroup.getSelectedIndex() == 0) {
                this.dateGroup.disableAll();
            } else {
                this.dateGroup.enableAll();
            }
        }
    }

    protected void okButtonactionPerformed(ActionEvent arg0) {
        try {
            if (!this.update.booleanValue()) {
                this.politika = new RabatnaPolitika();
            }
            this.politika.setIdKomercijalnaPolitika(PzIdGen.getNextId((String)"KOMERC_POLITIKA_ID", (int)1).getIdVal());
            this.politika.setAktivna(Integer.valueOf(this.chckbxPolitikaJeAktivna.isSelected() ? 1 : 0));
            this.politika.setKondGrupaArtikli(!this.intGrupaArtikli.getText().equals("") ? this.kondGrupaArtikli : null);
            this.politika.setKondGrupaKomitenti(!this.intGrupaKomitenti.getText().equals("") ? this.kondGrupaKomitenti : null);
            this.politika.setProcenat(this.dblProcenat.getBigDecimal());
            this.politika.setTip(Integer.valueOf(this.chckbxPrimenjujeSePermanentno.isSelected() ? 1 : 0));
            this.politika.setAktivna(Integer.valueOf(this.chckbxPolitikaJeAktivna.isSelected() ? 1 : 0));
            this.politika.setOpis(this.txtOpis.getVal());
            this.politika.setPzuser(PzApplication.getApplication().getSession().getLoggedUser());
            if (this.datOd.isEnabled() && this.datDo.isEnabled()) {
                this.politika.setDatOd((Date)this.datOd.getVal());
                this.politika.setDatDo((Date)this.datDo.getVal());
            } else {
                this.politika.setDatOd(null);
                this.politika.setDatDo(null);
            }
            if (!this.update.booleanValue()) {
                this.table.insert((PzEntity)this.politika, true);
            } else {
                this.table.updateSelectedEntity((PzEntity)this.politika, true);
            }
            this.dispose();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

