/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.propustenaProdaja;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PrenosUFakturu
extends PzDialog {
    private static final long serialVersionUID = -1822493133459068125L;
    private PzPanel pnlContent;
    private PzRadioGroup<String> panelTipDok;
    private JButton btnOk;
    public static final String FAKTURA = "Faktura";
    public static final String OTPREMNICA = "Otpremnica";
    private Faktura propustenaProdaja;

    public PrenosUFakturu(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PrenosUFakturu(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.propustenaProdaja = (Faktura)this.getSession().getParameter("faktura");
    }

    private void paintPanel() {
        this.pnlContent.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlContent.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlContent.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Prenos propu\u0161tene prodaje u fakturu");
            this.pnlContent = new PzPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlContent, "Center");
            pnlContentLayout.rowWeights = new double[]{0.0, 0.1};
            pnlContentLayout.rowHeights = new int[]{46, 20};
            pnlContentLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
            pnlContentLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.pnlContent.setOpaque(false);
            this.panelTipDok = new PzRadioGroup((Object[])new String[]{FAKTURA, OTPREMNICA});
            BoxLayout panelTipDokLayout1 = new BoxLayout((Container)this.panelTipDok, 1);
            this.panelTipDok.setLayout((LayoutManager)panelTipDokLayout1);
            this.pnlContent.add(this.panelTipDok, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.panelTipDok.setBorder((Border)BorderFactory.createTitledBorder(null, "Odaberite tip dokumenta", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 128, 255)));
            this.panelTipDok.setSelectedValue((Object)FAKTURA);
            this.panelTipDok.setOpaque(false);
            this.panelTipDok.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                }
            });
            this.btnOk = new JButton("OK");
            this.pnlContent.add((Component)this.btnOk, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
            this.btnOk.setName("btnOk");
            this.getRootPane().setDefaultButton(this.btnOk);
            this.btnOk.setPreferredSize(new Dimension(118, 26));
            this.btnOk.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check_small.png")));
            this.btnOk.setActionCommand("prenesi");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.paintPanel();
            this.setResizable(false);
            this.setSize(300, 150);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String tipFakture = "";
        Radnajedinica rj = this.propustenaProdaja.getRadnajedinica();
        if (((String)this.panelTipDok.getSelectedValue()).equals(FAKTURA)) {
            tipFakture = "FAKTURA";
        } else {
            tipFakture = "OTPREMNICA";
            if (rj.getgTip().equals(String.valueOf("EL".charAt(0)))) {
                JOptionPane.showMessageDialog(null, "Otpremnica se ne izra\u0111uje u maloprodaji!", "Informacija", 1);
                return;
            }
        }
        int rez = PzSwingUtility.daNeDijalog((Component)this.btnOk, (Object)"Da li ste sigurni?", (String)"Prenos u fakturu", null, (boolean)false);
        if (rez == 0) {
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    em.getTransaction().begin();
                    Faktura f = new Faktura();
                    f.setTip(tipFakture);
                    f.setDatum(this.propustenaProdaja.getDatum());
                    f.setDatPrometa(this.propustenaProdaja.getDatPrometa());
                    f.setDatValute(this.propustenaProdaja.getDatValute());
                    f.setKomitent(this.propustenaProdaja.getKomitent());
                    f.setRadnajedinica(rj);
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)f, true, null, em);
                    boolean postojiArtikalSaRaspolozivomKolicinom = false;
                    boolean jos = true;
                    int brojac = 0;
                    while (jos) {
                        Artikalfaktura af = (Artikalfaktura)this.propustenaProdaja.getArtikalfakturas().get(brojac);
                        BigDecimal kolicina = BDConverter.getKolicina((double)af.getKolicina());
                        if (PzProdajaUtil.updateStanjeInsert(f, af, af.getKolicina(), 0.0, "", true, false, false, em, true)) {
                            postojiArtikalSaRaspolozivomKolicinom = true;
                            BigDecimal kolicinaAritkal = BDConverter.getKolicina((double)af.getKolicina());
                            if (kolicina.compareTo(kolicinaAritkal) == 0) {
                                PzEntityManager.delete(Artikalfaktura.class, (Object)af.getId(), (EntityManager)em);
                                this.propustenaProdaja.getArtikalfakturas().remove(brojac);
                            } else {
                                Artikalfaktura artikalPropProdaje = (Artikalfaktura)em.find(Artikalfaktura.class, (Object)af.getId());
                                artikalPropProdaje.setKolicina(kolicina.subtract(kolicinaAritkal).doubleValue());
                            }
                            af.getId().setrBroj(f.getArtikalfakturas().size() + 1);
                            f.getArtikalfakturas().add(af);
                            af.setFaktura(f);
                        } else {
                            ++brojac;
                        }
                        if (brojac != this.propustenaProdaja.getArtikalfakturas().size() && this.propustenaProdaja.getArtikalfakturas().size() != 0) continue;
                        jos = false;
                    }
                    if (!postojiArtikalSaRaspolozivomKolicinom) {
                        em.getTransaction().rollback();
                        JOptionPane.showMessageDialog((Component)((Object)this), "Nijedna stavka nema raspolo\u017eive koli\u010dine, prenos u fakturu nije izvr\u0161en!", "Informacija", 1);
                    } else {
                        f.adjust();
                        em.getTransaction().commit();
                        JOptionPane.showMessageDialog((Component)((Object)this), "Prenos u fakturu uspe\u0161no izvr\u0161en! Broj preba\u010denih stavki: " + f.getArtikalfakturas().size(), "Informacija", 1);
                        this.getSession().putParameter("prenetoUFakturu", (Object)true);
                    }
                    this.dispose();
                }
                catch (Exception ex) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle(null, (Throwable)ex);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }
}

