/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Nalogmagacinu;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.prodaja.PzExtensionLoader;
import rs.pezar.prodaja.gui.PzDialogIzradaFaktureZaProdajuRobe;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class SpajanjeFakturaKomitenta
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private PzButton btnSpoji;
    private PzTable table;
    private JScrollPane scTabela;
    private PzButton btnPotvrdi;
    private PzTextField opisKomitenta;
    private PzTextField komitent;
    private JLabel jLabel1;
    private PzPanel panelKomitent;
    private PzPanel panelMain;
    private String tipF;
    private Radnajedinica rj;

    public SpajanjeFakturaKomitenta(PzDialog dialog) {
        super(dialog);
        this.tipF = this.getSession().getParameter("tipDokumenta").toString();
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.panelMain.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.panelMain.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.panelMain.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.panelMain = new PzPanel();
            this.getContentPane().add((Component)this.panelMain, "Center");
            GridBagLayout panelMainLayout = new GridBagLayout();
            panelMainLayout.columnWeights = new double[]{0.1};
            panelMainLayout.columnWidths = new int[]{7};
            panelMainLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            panelMainLayout.rowHeights = new int[]{50, 7, 40};
            this.panelMain.setLayout((LayoutManager)panelMainLayout);
            this.panelKomitent = new PzPanel();
            this.panelMain.add((Component)this.panelKomitent, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout panelUserLayout = new GridBagLayout();
            panelUserLayout.rowWeights = new double[]{0.0, 0.0};
            panelUserLayout.rowHeights = new int[]{30, 40};
            panelUserLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelUserLayout.columnWidths = new int[]{70, 100, 380, 7};
            this.panelKomitent.setLayout((LayoutManager)panelUserLayout);
            this.panelKomitent.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.panelKomitent.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.jLabel1.setText("Komitent");
            this.komitent = new PzTextField();
            this.panelKomitent.add((Component)this.komitent, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 1, 0), 0, 0));
            this.komitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.komitent.requestFocus();
            this.opisKomitenta = new PzTextField();
            this.panelKomitent.add((Component)this.opisKomitenta, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 1, 10), 0, 0));
            this.opisKomitenta.setEditable(false);
            this.opisKomitenta.setFocusable(false);
            this.btnPotvrdi = new PzButton();
            this.panelKomitent.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("odaberi");
            this.scTabela = new JScrollPane();
            this.panelMain.add((Component)this.scTabela, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.scTabela.setBackground(new Color(211, 242, 210));
            this.scTabela.setOpaque(false);
            this.table = new PzTable();
            this.btnSpoji = new PzButton();
            this.panelMain.add((Component)this.btnSpoji, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 3, new Insets(5, 0, 5, 0), 0, 0));
            this.btnSpoji.setText("Spoji fakture");
            this.btnSpoji.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnSpoji.setEnabled(false);
            this.btnSpoji.addActionListener((ActionListener)((Object)this));
            this.btnSpoji.setActionCommand("spoji");
            this.pack();
            this.setPreferredSize(new Dimension(900, 400));
            this.setMinimumSize(new Dimension(800, 400));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            if (ac.equals("odaberi")) {
                Query q = null;
                String upit = "SELECT f FROM Faktura f where f.userKraj=:user and f.tip=:tip and f.arhiviran=0 and f.komitent.sfrKomitent=:komitent and f.radnajedinica=:rj";
                if (this.tipF.equals("AVANSNI_RACUN")) {
                    upit = String.valueOf(upit) + " and f.podTip='AVANSNI_RACUN_KOLICINA'";
                } else if (this.tipF.equals("FAKTURA")) {
                    upit = String.valueOf(upit) + " and f.zaOtpremnice = 0";
                }
                upit = String.valueOf(upit) + " order by f.idDok";
                q = em.createQuery(upit);
                q.setParameter("user", (Object)PzExtensionLoader.getLoggedUser());
                q.setParameter("komitent", (Object)this.komitent.getVal());
                q.setParameter("tip", (Object)this.tipF);
                q.setParameter("rj", (Object)this.rj);
                Vector data = (Vector)q.getResultList();
                if (data.size() == 0) {
                    JOptionPane.showMessageDialog((Component)this.table, "Nije prona\u0111en nijedan dokument!", "Informacija", 1);
                    this.komitent.requestFocus();
                    this.table.setData(new Vector(), Faktura.class);
                    this.btnSpoji.setEnabled(false);
                    return;
                }
                if (data.size() == 1) {
                    JOptionPane.showMessageDialog((Component)this.table, "Prona\u0111en je samo jedan dokument! Spajanje nije mogu\u0107e izvr\u0161iti!", "Informacija", 1);
                    this.komitent.requestFocus();
                    this.table.setData(new Vector(), Faktura.class);
                    this.btnSpoji.setEnabled(false);
                    return;
                }
                this.table.setData(data, Faktura.class);
                this.table.setCheckboxColumn(0, KeyStroke.getKeyStroke("F2"));
                this.table.checkAll();
                this.table.setRowSelectionInterval(0, 0);
                this.scTabela.setViewportView((Component)this.table);
                this.table.requestFocusInWindow();
                this.table.setRowSelectionInterval(0, 0);
                this.btnSpoji.setEnabled(true);
                return;
            } else {
                List dokumenti = this.table.getCheckedEntities();
                if (dokumenti.size() < 2) {
                    JOptionPane.showMessageDialog((Component)this.table, "Moraju biti selektovane najmanje dve fakture!", "Informacija", 1);
                    this.table.requestFocus();
                    return;
                }
                if (!this.mozeDaSeIzvrsiSpajanjeNalog(dokumenti)) {
                    JOptionPane.showMessageDialog((Component)this.table, "Mogu se spojiti fakture samo ako su svima izdati nalozi magacinu ili nije izdat nalog magacinu ni za jednu fakturu!", "Informacija", 1);
                    this.table.requestFocus();
                    return;
                }
                if (!this.mozeDaSeIzvrsiSpajanjeDatumValute(dokumenti)) {
                    JOptionPane.showMessageDialog((Component)this.table, "Mogu se spojiti samo fakture \u010diji su datumi valute isti!", "Informacija", 1);
                    this.table.requestFocus();
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)this.table, (Object)"Da li ste sigurni da \u017eelite da spojite odabrane fakture?", (String)"Spajanje faktura", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    Faktura glavna = (Faktura)dokumenti.get(0);
                    int i = 1;
                    while (i < dokumenti.size()) {
                        Faktura pom = (Faktura)dokumenti.get(i);
                        glavna.kopirajArtikleSaFakture(pom, true);
                        for (Nalogmagacinu nalog : pom.getNalogmagacinus()) {
                            nalog.setDokument(glavna.getDokument());
                            glavna.getNalogmagacinus().add(nalog);
                            em.merge((Object)nalog);
                        }
                        PzEntityManager.update((Object)glavna, (EntityManager)em);
                        PzDokumentManager.getInstance().deleteDokument((PzDokument)pom, null, em);
                        ++i;
                    }
                    em.getTransaction().commit();
                    ((PzDialogIzradaFaktureZaProdajuRobe)((Object)this.getParent())).initializeTable(true);
                    this.dispose();
                    this.getSession().putParameter("faktura", (Object)PzEntityManager.find(Faktura.class, (Object)glavna.getIdDok()));
                    this.getSession().putParameter("spojeneFakture", (Object)true);
                    return;
                }
                catch (Exception ex) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                }
            }
            return;
        }
        finally {
            em.close();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            Komitent kom = (Komitent)entity;
            this.komitent.setText(kom.getSfrKomitent());
            this.opisKomitenta.setText(kom.getNaziv());
        }
    }

    public static Object getGUIBuilderInstance() {
        return new SpajanjeFakturaKomitenta(Boolean.FALSE);
    }

    public SpajanjeFakturaKomitenta(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        if (this.rj != null) {
            this.setVisible(false);
            this.setTitle("Spajanje faktura komitenta iz rj: " + this.rj.getPunNaziv());
            return true;
        }
        this.setVisible(false);
        return false;
    }

    private boolean mozeDaSeIzvrsiSpajanjeNalog(List<PzEntity> fakture) {
        boolean rez;
        Faktura f = (Faktura)fakture.get(0);
        boolean pom = rez = f.getNalogmagacinus() != null && f.getNalogmagacinus().size() != 0;
        int i = 1;
        while (i < fakture.size()) {
            f = (Faktura)fakture.get(i);
            pom = rez;
            boolean bl = rez = f.getNalogmagacinus() != null && f.getNalogmagacinus().size() != 0;
            if (rez != pom) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean mozeDaSeIzvrsiSpajanjeDatumValute(List<PzEntity> fakture) {
        Faktura f = (Faktura)fakture.get(0);
        Date datum = f.getDatValute();
        int i = 1;
        while (i < fakture.size()) {
            f = (Faktura)fakture.get(i);
            if (!datum.equals(f.getDatValute())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

