/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.dnevniFiskalniIzvestaj;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.prodaja.PzExtensionLoader;
import rs.pezar.prodaja.gui.dnevniFiskalniIzvestaj.ArhivaRacuna;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.UnosPodataka;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class IzradaSlikeMaloprodajnogRacuna
extends PzDialog {
    private PzToolBarIcon btnIzmena;
    private PzToolBarIcon btnDodavanje;
    private PzToolBarIcon btnArhivaStampa;
    private PzToolBarIcon btnBrisiSve;
    private PzToolBarIcon btnBrisanje;
    private JToolBar toolbar;
    private JScrollPane tblScrolPane;
    private PzTable tabelaArtikli;
    private PzPanel pnlLabele;
    private PzPanel pnlGlavni;
    private JLabel lblIznosBezPoreza;
    private PzDoubleField dfIznosBezPoreza;
    private JLabel lblIznosSaPorezom;
    private PzDoubleField dfIznosSaPorezom;
    private Radnajedinica rj;
    private Faktura racun;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private boolean exception;

    public IzradaSlikeMaloprodajnogRacuna(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public IzradaSlikeMaloprodajnogRacuna(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.pnlGlavni = new PzPanel();
            GridBagLayout jPanel2Layout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            jPanel2Layout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            jPanel2Layout.rowHeights = new int[]{129, 46, 7, 7};
            jPanel2Layout.columnWeights = new double[]{0.1};
            jPanel2Layout.columnWidths = new int[]{7};
            this.pnlGlavni.setLayout((LayoutManager)jPanel2Layout);
            this.pnlLabele = new PzPanel();
            this.pnlGlavni.add((Component)this.pnlLabele, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pnlLabeleLayout = new GridBagLayout();
            pnlLabeleLayout.rowWeights = new double[]{0.0};
            pnlLabeleLayout.rowHeights = new int[]{25};
            pnlLabeleLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlLabeleLayout.columnWidths = new int[]{140, 191, 136, 7};
            this.pnlLabele.setLayout((LayoutManager)pnlLabeleLayout);
            this.pnlLabele.setOpaque(false);
            this.lblIznosBezPoreza = new JLabel();
            this.pnlLabele.add((Component)this.lblIznosBezPoreza, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 4, 5), 0, 0));
            this.lblIznosBezPoreza.setText("Iznos BEZ poreza");
            this.lblIznosBezPoreza.setFont(new Font("Segoe UI", 1, 14));
            this.dfIznosBezPoreza = new PzDoubleField();
            this.pnlLabele.add((Component)this.dfIznosBezPoreza, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 1, 0), 0, 0));
            this.dfIznosBezPoreza.setPreferredSize(new Dimension(120, 24));
            this.dfIznosBezPoreza.setFont(new Font("Tahoma", 1, 14));
            this.dfIznosBezPoreza.setEditable(false);
            this.dfIznosBezPoreza.setFocusable(false);
            this.lblIznosSaPorezom = new JLabel();
            this.pnlLabele.add((Component)this.lblIznosSaPorezom, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 4, 5), 0, 0));
            this.lblIznosSaPorezom.setText("Iznos SA porezom");
            this.lblIznosSaPorezom.setFont(new Font("Segoe UI", 1, 14));
            this.dfIznosSaPorezom = new PzDoubleField();
            this.pnlLabele.add((Component)this.dfIznosSaPorezom, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 1, 0), 0, 0));
            this.dfIznosSaPorezom.setPreferredSize(new Dimension(120, 24));
            this.dfIznosSaPorezom.setFont(new Font("Tahoma", 1, 14));
            this.dfIznosSaPorezom.setEditable(false);
            this.dfIznosSaPorezom.setFocusable(false);
            this.tblScrolPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.tblScrolPane, (Object)new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnDodavanje);
            this.btnDodavanje.setText("Dodavanje|stavke|(Ins)");
            this.btnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/box_add.png")));
            this.btnDodavanje.setActionCommand("dodavanje");
            this.btnDodavanje.addActionListener((ActionListener)((Object)this));
            this.btnDodavanje.setShortcut("INSERT");
            this.btnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnIzmena);
            this.btnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/box_edit.png")));
            this.btnIzmena.setText("Izmena|stavke|(F3)");
            this.btnIzmena.setActionCommand("izmena");
            this.btnIzmena.addActionListener((ActionListener)((Object)this));
            this.btnIzmena.setShortcut("F3");
            this.btnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisanje);
            this.btnBrisanje.setText("Brisanje|stavke|(Del)");
            this.btnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/box_delete.png")));
            this.btnBrisanje.setActionCommand("brisi");
            this.btnBrisanje.addActionListener((ActionListener)((Object)this));
            this.btnBrisanje.setShortcut("DELETE");
            this.btnBrisiSve = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisiSve);
            this.btnBrisiSve.setText("Brisanje|dokumenta|(Ctrl+Q)");
            this.btnBrisiSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/note_delete.png")));
            this.btnBrisiSve.setActionCommand("brisiSve");
            this.btnBrisiSve.addActionListener((ActionListener)((Object)this));
            this.btnBrisiSve.setShortcut("CTRL+Q");
            this.btnArhivaStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnArhivaStampa);
            this.btnArhivaStampa.setText("Arhiva i|\u0161tampa|(Ctrl+W)");
            this.btnArhivaStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/printer_preferences.png")));
            this.btnArhivaStampa.setActionCommand("arhiva");
            this.btnArhivaStampa.addActionListener((ActionListener)((Object)this));
            this.btnArhivaStampa.setShortcut("CTRL+W");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(765, 450);
            this.setMinimumSize(new Dimension(765, 450));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IzradaSlikeMaloprodajnogRacuna(Boolean initGUI) {
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                this.getSession().putParameter("tabela", (Object)this.tabelaArtikli);
                this.getSession().putParameter("faktura", (Object)this.racun);
                PzButton button = (PzButton)e.getSource();
                String actionCommand = button.getActionCommand();
                if (actionCommand.equals("dodavanje")) {
                    this.getSession().putParameter("update", (Object)false);
                    this.showDialog(UnosPodataka.class);
                } else if (actionCommand.equals("izmena")) {
                    if (this.tabelaArtikli.getSelectedRow() != -1) {
                        this.getSession().putParameter("update", (Object)true);
                        this.showDialog(UnosPodataka.class);
                        this.racun.getArtikalfakturas();
                    }
                } else if (actionCommand.equalsIgnoreCase("brisi")) {
                    if (this.tabelaArtikli.getSelectedRow() != -1) {
                        em.getTransaction().begin();
                        if (this.tabelaArtikli.removeSelectedEntity(true, em)) {
                            Artikalfaktura cfr_ignored_0 = (Artikalfaktura)this.tabelaArtikli.getSelectedEntity();
                            em.getTransaction().commit();
                            this.tabelaArtikli.commitRemove();
                        }
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().commit();
                        }
                    }
                } else if (actionCommand.equals("brisiSve")) {
                    int rez;
                    if (this.tabelaArtikli.getSelectedRow() != -1 && (rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)false)) == 0) {
                        em.getTransaction().begin();
                        em.remove(em.find(Faktura.class, (Object)this.racun.getIdDok()));
                        em.getTransaction().commit();
                        this.dispose();
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().commit();
                        }
                    }
                } else if (actionCommand.equals("arhiva") && this.tabelaArtikli.getSelectedRow() != -1) {
                    this.showDialog(ArhivaRacuna.class);
                }
                this.racun = (Faktura)em.find(Faktura.class, (Object)this.racun.getIdDok());
                this.setPolja();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void setPolja() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IzradaSlikeMaloprodajnogRacuna.this.dfIznosBezPoreza.setVal((Object)IzradaSlikeMaloprodajnogRacuna.this.racun.getIznosBezPorezaMaloprodaja(IzradaSlikeMaloprodajnogRacuna.this.racun.getArtikalfakturas()));
                IzradaSlikeMaloprodajnogRacuna.this.dfIznosSaPorezom.setVal((Object)IzradaSlikeMaloprodajnogRacuna.this.racun.getIznosBezPorezaVeleprodaja(IzradaSlikeMaloprodajnogRacuna.this.racun.getArtikalfakturas()));
                IzradaSlikeMaloprodajnogRacuna.this.brDok.setText(String.valueOf(IzradaSlikeMaloprodajnogRacuna.this.tabelaArtikli.getDataSize()));
            }
        });
    }

    public boolean shouldBeShown() {
        boolean res = false;
        this.pnlGlavni.setPaintGradient(true);
        this.pnlGlavni.setGradient(ProdajaGradientUtil.FISKALNI_MALOPRODAJNI_GRADIENT);
        this.getSession().putParameter("gradient", (Object)ProdajaGradientUtil.FISKALNI_MALOPRODAJNI_GRADIENT);
        this.rj = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"EL", "E", "ET", "EV"});
        if (this.rj != null) {
            this.racun = this.getRacun();
            if (this.racun == null && !this.exception) {
                try {
                    this.racun = new Faktura();
                    this.racun.setArhiviran((short)0);
                    this.racun.setTip("SLIKA_MALOPRODAJNOG_RACUNA");
                    this.racun.setRadnajedinica(this.rj);
                    this.racun.setDatum(PzDateUtility.getCurrentDate());
                    this.racun.setUserPoc(PzExtensionLoader.getLoggedUser());
                    this.racun.setUserKraj(PzExtensionLoader.getLoggedUser());
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)this.racun, true, null);
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
            if (this.racun == null) {
                return false;
            }
            this.tabelaArtikli = new PzTable(this.racun.getArtikalfakturas(), Artikalfaktura.class);
            this.tabelaArtikli.setId("TABLE_ARTIKLI");
            this.tblScrolPane.setViewportView((Component)this.tabelaArtikli);
            this.tabelaArtikli.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    IzradaSlikeMaloprodajnogRacuna.this.btnDodavanje.doClick();
                }
            });
            this.setPolja();
            res = true;
            this.setTitle("\u0160tampa slike ra\u010duna maloprodaji u: " + this.rj.getSkracenNaziv());
        }
        return res;
    }

    private Faktura getRacun() {
        Faktura res = null;
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                Query q = null;
                q = em.createQuery("SELECT f FROM Faktura f where f.arhiviran = 0 and f.radnajedinica=:rj and f.tip=:tip and f.userPoc=:user ");
                q.setParameter("rj", (Object)this.rj);
                q.setParameter("tip", (Object)"SLIKA_MALOPRODAJNOG_RACUNA");
                q.setParameter("user", (Object)PzExtensionLoader.getLoggedUser());
                List data = q.getResultList();
                if (data.size() != 0) {
                    res = (Faktura)data.get(0);
                }
            }
            catch (Exception e) {
                this.exception = true;
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return res;
    }

    public static Object getGUIBuilderInstance() {
        return new IzradaSlikeMaloprodajnogRacuna(Boolean.FALSE);
    }
}

