/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.RuleKepu;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDefaultDokumentCustomizer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentException;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Id_gen;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Sfutaksa;
import rs.pezar.db.entity.SfutaksaPK;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.TaksafakturaPK;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prodaja.gui.PzDialogFaktureArhiva;
import rs.pezar.prodaja.gui.faktureUsluga.DodavanjeStavke;
import rs.pezar.prodaja.gui.faktureUsluga.PzDialogTaksa;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextArea;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzDialogStornoFaktureZaUsluge
extends PzDialog {
    private static final long serialVersionUID = -6448346344034499513L;
    private JToolBar toolbar;
    private JLabel lblSifraKupca;
    private JScrollPane scp;
    private PzDateField dfDatumStorniranja;
    private JLabel lblDatumStorniranja;
    private PzTable table;
    private PzPanel panelPDV;
    private PzDoubleField dfStornoIznos;
    private JLabel lblSaBez;
    private JLabel lblStornoIznos;
    private JSeparator jSeparator2;
    private JLabel lblDug;
    private JLabel lblStorno;
    private JLabel lblUplate;
    private PzDoubleField dfUplate;
    private PzDoubleField dfDug;
    private PzDoubleField dfStorno;
    private JLabel lblIznos;
    private PzDoubleField dfIznos;
    private JSeparator jSeparator1;
    private JLabel lblFaktura;
    private PzTextField tfFaktura;
    private PzToolBarIcon btnKraj;
    private PzToolBarIcon icnBrisanje;
    private PzNumericOnlyTextField nfSifraKupca;
    private PzTextField opisKomitenta;
    private JLabel lblDatumIzrade;
    private PzDateField dfDatumIzrade;
    private PzTextArea taOpis;
    private JScrollPane scRazlog;
    private PzPanel panelFields;
    private PzToolBarIcon icnIzmena;
    private JSeparator jSeparator;
    private Fakturausluga fSpedicije;
    Fakturausluga original = null;
    Fakturausluga stornoDok = null;
    BigDecimal maxOsnovica;
    private HashMap<Integer, Double> mapaCena = null;
    private PzPanel mainPanel;

    public PzDialogStornoFaktureZaUsluge(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogStornoFaktureZaUsluge(PzDialog dialog) {
        super(dialog);
        this.original = (Fakturausluga)this.getSession().getParameter("original");
        this.stornoDok = (Fakturausluga)this.getSession().getParameter("storno");
        this.mapaCena = this.setMapaCena(this.stornoDok);
        this.initGUI();
        this.postInit();
    }

    public double getCenaFor(int stavka) {
        return this.mapaCena.get(stavka);
    }

    private HashMap<Integer, Double> setMapaCena(Fakturausluga f) {
        HashMap<Integer, Double> rez = new HashMap<Integer, Double>();
        for (Stavkafaktureusl a : f.getStavkafaktureusls()) {
            rez.put(a.getId().getrBroj(), a.getCena());
        }
        return rez;
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        this.setContentPane((Container)this.mainPanel);
        this.setTitle("Storno fakture usluge");
        this.scRazlog = new JScrollPane();
        this.scRazlog.setOpaque(false);
        this.getContentPane().add((Component)this.scRazlog, "South");
        this.scRazlog.setBorder(BorderFactory.createTitledBorder("Razlog storniranja"));
        this.scRazlog.setPreferredSize(new Dimension(784, 152));
        this.taOpis = new PzTextArea();
        this.scRazlog.setViewportView((Component)this.taOpis);
        this.toolbar = new JToolBar();
        this.toolbar.setOpaque(false);
        this.getContentPane().add((Component)this.toolbar, "North");
        FlowLayout toolbarLayout = new FlowLayout();
        toolbarLayout.setAlignment(0);
        toolbarLayout.setHgap(10);
        this.toolbar.setLayout(toolbarLayout);
        this.btnKraj = new PzToolBarIcon();
        this.toolbar.add((Component)this.btnKraj);
        this.btnKraj.setText("Arhiva i|\u0161tampa|(Ctrl+W)");
        this.btnKraj.setActionCommand("arhiviranje");
        this.btnKraj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/printer_preferences.png")));
        this.btnKraj.addActionListener((ActionListener)((Object)this));
        this.btnKraj.setShortcut("CTRL+W");
        this.jSeparator = new JSeparator();
        this.toolbar.add(this.jSeparator);
        this.jSeparator.setOrientation(1);
        this.jSeparator.setPreferredSize(new Dimension(8, 75));
        this.icnIzmena = new PzToolBarIcon();
        this.toolbar.add((Component)this.icnIzmena);
        this.icnIzmena.setText("Izmena|PDV-a|(F3)");
        this.icnIzmena.setActionCommand("izmenaPDV");
        this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/row_edit.png")));
        this.icnIzmena.addActionListener((ActionListener)((Object)this));
        this.icnIzmena.setShortcut("F3");
        this.icnIzmena.setVisible(false);
        this.icnBrisanje = new PzToolBarIcon();
        this.toolbar.add((Component)this.icnBrisanje);
        this.icnBrisanje.setText("Brisanje|PDV-a|(del)");
        this.icnBrisanje.setActionCommand("brisanjePDV");
        this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/row_delete.png")));
        this.icnBrisanje.setVisible(false);
        this.icnBrisanje.addActionListener((ActionListener)((Object)this));
        this.icnBrisanje.setShortcut("delete");
        this.panelFields = new PzPanel();
        this.panelFields.setOpaque(false);
        GridBagLayout panelFieldsLayout = new GridBagLayout();
        this.getContentPane().add((Component)this.panelFields, "Center");
        panelFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
        panelFieldsLayout.rowHeights = new int[]{6, 25, 25, 25, 10, 25, 25, 10, 25, 20, 25, 20, 25, 20};
        panelFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
        panelFieldsLayout.columnWidths = new int[]{5, 100, 110, 200, 110, 20};
        this.panelFields.setLayout((LayoutManager)panelFieldsLayout);
        this.panelFields.setPreferredSize(new Dimension(484, 298));
        this.dfDatumIzrade = new PzDateField();
        this.panelFields.add((Component)this.dfDatumIzrade, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.dfDatumIzrade.setFont(new Font("Tahoma", 0, 14));
        this.dfDatumIzrade.setDefaultDate(PzDateUtility.getCurrentDate());
        this.lblDatumIzrade = new JLabel();
        this.panelFields.add((Component)this.lblDatumIzrade, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.lblDatumIzrade.setText("Datum izrade");
        this.opisKomitenta = new PzTextField();
        this.panelFields.add((Component)this.opisKomitenta, (Object)new GridBagConstraints(3, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 5), 0, 0));
        this.opisKomitenta.setFont(new Font("Tahoma", 0, 14));
        this.opisKomitenta.setEditable(false);
        this.opisKomitenta.setForeground(new Color(255, 0, 0));
        this.opisKomitenta.setPreferredSize(new Dimension(95, 24));
        this.opisKomitenta.setFocusable(false);
        this.nfSifraKupca = new PzNumericOnlyTextField();
        this.panelFields.add((Component)this.nfSifraKupca, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.nfSifraKupca.setFont(new Font("Tahoma", 0, 14));
        this.nfSifraKupca.setPreferredSize(new Dimension(95, 24));
        this.nfSifraKupca.setFocusable(false);
        this.lblSifraKupca = new JLabel();
        this.panelFields.add((Component)this.lblSifraKupca, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.lblSifraKupca.setText("Kupac");
        this.tfFaktura = new PzTextField();
        this.panelFields.add((Component)this.tfFaktura, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 130), 0, 0));
        this.tfFaktura.setFont(new Font("Tahoma", 0, 14));
        this.tfFaktura.setPreferredSize(new Dimension(95, 24));
        this.tfFaktura.setFocusable(false);
        this.lblFaktura = new JLabel();
        this.panelFields.add((Component)this.lblFaktura, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.lblFaktura.setText("Broj fakture");
        this.jSeparator1 = new JSeparator();
        this.panelFields.add((Component)this.jSeparator1, (Object)new GridBagConstraints(1, 4, 5, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.jSeparator1.setPreferredSize(new Dimension(8, 2));
        this.jSeparator1.setOpaque(false);
        this.dfIznos = new PzDoubleField();
        this.panelFields.add((Component)this.dfIznos, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.dfIznos.setFont(new Font("Tahoma", 0, 14));
        this.dfIznos.setBackground(new Color(192, 192, 192));
        this.dfIznos.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
        this.dfIznos.setFocusable(false);
        this.lblIznos = new JLabel();
        this.panelFields.add((Component)this.lblIznos, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.lblIznos.setText("Obra\u010dunat iznos");
        this.dfStorno = new PzDoubleField();
        this.panelFields.add((Component)this.dfStorno, (Object)new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.dfStorno.setFont(new Font("Tahoma", 0, 14));
        this.dfStorno.setEditable(false);
        this.dfStorno.setBackground(new Color(192, 192, 192));
        this.dfStorno.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
        this.dfStorno.setFocusable(false);
        this.dfDug = new PzDoubleField();
        this.panelFields.add((Component)this.dfDug, (Object)new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.dfDug.setFont(new Font("Tahoma", 0, 14));
        this.dfDug.setEditable(false);
        this.dfDug.setBackground(new Color(192, 192, 192));
        this.dfDug.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
        this.dfDug.setFocusable(false);
        this.dfUplate = new PzDoubleField();
        this.panelFields.add((Component)this.dfUplate, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.dfUplate.setFont(new Font("Tahoma", 0, 14));
        this.dfUplate.setEditable(false);
        this.dfUplate.setBackground(new Color(192, 192, 192));
        this.dfUplate.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
        this.dfUplate.setFocusable(false);
        this.lblUplate = new JLabel();
        this.panelFields.add((Component)this.lblUplate, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.lblUplate.setText("Uplate");
        this.lblStorno = new JLabel();
        this.panelFields.add((Component)this.lblStorno, (Object)new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.lblStorno.setText("Storno");
        this.lblDug = new JLabel();
        this.panelFields.add((Component)this.lblDug, (Object)new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.lblDug.setText("Dug");
        this.jSeparator2 = new JSeparator();
        this.panelFields.add((Component)this.jSeparator2, (Object)new GridBagConstraints(1, 7, 5, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.jSeparator2.setOpaque(false);
        this.jSeparator2.setPreferredSize(new Dimension(8, 2));
        this.lblStornoIznos = new JLabel();
        this.panelFields.add((Component)this.lblStornoIznos, (Object)new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblStornoIznos.setText("Iznos za storniranje");
        this.lblSaBez = new JLabel();
        this.panelFields.add((Component)this.lblSaBez, (Object)new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblSaBez.setText("(Bez poreza, sa pravom na odbitak)");
        this.dfStornoIznos = new PzDoubleField();
        this.panelFields.add((Component)this.dfStornoIznos, (Object)new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 65, 0, 65), 0, 0));
        this.dfStornoIznos.setFont(new Font("Tahoma", 0, 14));
        this.dfStornoIznos.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (PzMathUtility.roundToBigDecimal((double)PzDialogStornoFaktureZaUsluge.this.dfStornoIznos.getVal()).compareTo(PzDialogStornoFaktureZaUsluge.this.original.getPreostaliIznosZaStorniranje()) == 1) {
                    JOptionPane.showMessageDialog(null, "Iznos za storniranje ne mo\u017ee biti ve\u0107i od preostalog iznosa za storniranje!", "Informacija", 1);
                    return false;
                }
                if (PzDialogStornoFaktureZaUsluge.this.dfStornoIznos.getVal() < 0.0) {
                    JOptionPane.showMessageDialog(null, "Iznos za storniranje ne mo\u017ee biti manji od 0!", "Informacija", 1);
                    return false;
                }
                if (PzDialogStornoFaktureZaUsluge.this.dfStornoIznos.getVal() == 0.0) {
                    JOptionPane.showMessageDialog(null, "Iznos za storniranje ne mo\u017ee biti 0!", "Informacija", 1);
                    return false;
                }
                return true;
            }
        });
        this.panelPDV = new PzPanel();
        this.panelPDV.setOpaque(false);
        this.panelFields.add((Component)this.panelPDV, (Object)new GridBagConstraints(3, 8, 3, 6, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 3), 0, 0));
        GridBagLayout jPanel2Layout = new GridBagLayout();
        jPanel2Layout.columnWidths = new int[]{96, 110, 20};
        jPanel2Layout.rowHeights = new int[]{7};
        jPanel2Layout.columnWeights = new double[]{0.0, 0.0, 0.1};
        jPanel2Layout.rowWeights = new double[]{0.1};
        this.panelPDV.setLayout((LayoutManager)jPanel2Layout);
        this.panelPDV.setBorder((Border)BorderFactory.createTitledBorder("PDV"));
        this.scp = new JScrollPane();
        this.panelPDV.add((Component)this.scp, (Object)new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scp.setBackground(new Color(211, 242, 210));
        if (!this.stornoDok.jeFakturaSpedicije() && this.stornoDok.getSaPorezom() == 0) {
            this.table = new PzTable(new Vector(), Taksafaktura.class);
        } else if (this.stornoDok.jeFakturaSpedicije()) {
            this.table = new PzTable(this.stornoDok.getStavkafaktureusls(), Stavkafaktureusl.class);
            this.table.setId("TABLE_FAKTURA_SPEDICIJE");
        } else {
            this.table = new PzTable(this.stornoDok.getTaksafakturas(), Taksafaktura.class);
        }
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PzDialogStornoFaktureZaUsluge.this.table.transferFocus();
            }
        });
        this.table.setFocusable(false);
        this.scp.setViewportView((Component)this.table);
        this.lblDatumStorniranja = new JLabel();
        this.panelFields.add((Component)this.lblDatumStorniranja, (Object)new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblDatumStorniranja.setText("Datum storniranja");
        this.dfDatumStorniranja = new PzDateField();
        this.panelFields.add((Component)this.dfDatumStorniranja, (Object)new GridBagConstraints(1, 12, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 65, 1, 65), 0, 0));
        this.dfDatumStorniranja.setFont(new Font("Tahoma", 0, 14));
        this.dfDatumStorniranja.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent arg0) {
                PzDialogStornoFaktureZaUsluge.this.dfDatumStorniranja.setVal((Object)PzDialogStornoFaktureZaUsluge.this.dfDatumIzrade.getVal());
            }
        });
        this.dfDatumStorniranja.setDefaultDate(PzDateUtility.getCurrentDate());
        this.setSize(650, 600);
        this.setMinimumSize(this.getSize());
        this.paintPanel();
    }

    private void postInit() {
        this.nfSifraKupca.setVal((Object)this.original.getKomitent().getSfrKomitent());
        this.opisKomitenta.setText(this.original.getKomitent().getNaziv());
        this.tfFaktura.setText(this.original.getOznDokumenta());
        this.dfIznos.setVal((Object)this.original.getIznos());
        this.dfStorno.setVal((Object)this.original.getStornoIznos());
        this.dfUplate.setVal((Object)this.original.getUplata());
        this.dfDug.setVal((Object)this.original.getDug());
        this.dfStornoIznos.setVal((Object)this.original.getPreostaliIznosZaStorniranje());
        if (this.original.getSaPorezom() == 1) {
            this.table.setFocusable(true);
            this.lblSaBez.setText("(Sa porezom)");
            this.dfStornoIznos.setFocusable(false);
            this.icnIzmena.setVisible(true);
            if (!this.original.jeFakturaSpedicije()) {
                Taksafaktura taksa = (Taksafaktura)this.table.getSelectedEntity();
                this.maxOsnovica = taksa.getOsnovica();
                this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/pdv_edit.png")));
            } else {
                this.icnBrisanje.setVisible(true);
                this.icnIzmena.setText("Izmena|stavke|(F3)");
                this.icnBrisanje.setText("Brisanje|stavke|(del)");
                this.panelPDV.setBorder((Border)BorderFactory.createTitledBorder("Usluge"));
            }
        } else {
            this.jSeparator.setVisible(false);
            this.table.setEnabled(false);
            if (this.original.getSaPravomNaOdbitak() == 1) {
                this.lblSaBez.setText("(Bez poreza, sa pravom na odbitak)");
            } else {
                this.lblSaBez.setText("(Bez poreza, bez prava na odbitak)");
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            PzButton button = (PzButton)e.getSource();
            String ac = button.getActionCommand();
            if (ac.equals("arhiviranje")) {
                if (this.taOpis.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Morate uneti razlog storniranja!", "Informacija", 1);
                    this.taOpis.requestFocusInWindow();
                    return;
                }
                if (this.stornoDok.jeFakturaSpedicije() && this.stornoDok.getStavkafaktureusls().size() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Dokument ne sadr\u017ei nijednu stavku!", "Informacija", 1);
                    return;
                }
                if (!this.stornoDok.jeFakturaSpedicije() && this.stornoDok.getSaPorezom() == 1 && this.stornoDok.getTaksafakturas().size() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Dokument ne sadr\u017ei porez!", "Informacija", 1);
                    return;
                }
                if (this.dfStornoIznos.getVal() <= 0.0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Iznos za storniranje mora biti ve\u0107i od 0!", "Informacija", 1);
                    return;
                }
                if (!this.stornoDok.jeFakturaSpedicije()) {
                    this.stornoFaktureUsluge(this.stornoDok);
                } else {
                    if (this.table.getRowCount() != 0) {
                        Vector<Stavkafaktureusl> stavke = new Vector<Stavkafaktureusl>();
                        int i = 0;
                        while (i < this.table.getRowCount()) {
                            stavke.add((Stavkafaktureusl)this.table.getEntity(i));
                            ++i;
                        }
                        this.stornoDok.getStavkafaktureusls().clear();
                        this.stornoDok.getStavkafaktureusls().addAll(stavke);
                    }
                    this.stornoFaktureSpedicije(this.stornoDok);
                }
                this.dispose();
            } else if (ac.equals("brisanjePDV")) {
                this.table.removeSelectedEntity(true, false);
                this.dfStornoIznos.setVal((Object)this.stornoDok.getIznosFaktureSpedicije());
                if (this.table.getDataSize() > 0) {
                    this.table.requestFocusInWindow();
                }
            } else if (ac.equals("izmenaPDV")) {
                this.getSession().putParameter("tabela", (Object)this.table);
                if (this.original.jeFakturaSpedicije()) {
                    this.getSession().putParameter("update", (Object)true);
                    this.getSession().putParameter("fakturaU", (Object)this.stornoDok);
                    Stavkafaktureusl stavka = (Stavkafaktureusl)this.table.getSelectedEntity();
                    this.getSession().putParameter("cena", (Object)this.getCenaFor(stavka.getId().getrBroj()));
                    this.showDialog(DodavanjeStavke.class);
                    this.dfStornoIznos.setVal((Object)this.stornoDok.getIznosFaktureSpedicije());
                } else {
                    if (this.table.getDataSize() < 1) {
                        return;
                    }
                    this.getSession().putParameter("taksa", (Object)this.table.getSelectedEntity());
                    this.getSession().putParameter("osnovica", (Object)this.maxOsnovica);
                    this.showDialog(PzDialogTaksa.class);
                }
                this.dfStornoIznos.setVal(this.getSession().getParameter("noviIznosFakture"));
            }
        }
        catch (Exception ex) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogStornoFaktureZaUsluge(Boolean.FALSE);
    }

    private int getNewIdDok(Fakturausluga fu, EntityManager em) {
        String className = fu.getClass().getSimpleName();
        Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
        if (dokId == null) {
            dokId = new Id_gen();
            dokId.setIdName(className);
            dokId.setIdVal(0);
        }
        dokId.setIdVal(dokId.getIdVal() + 1);
        em.merge((Object)dokId);
        return dokId.getIdVal();
    }

    private Fakturausluga createCopy(Fakturausluga f, EntityManager em) throws Exception {
        Fakturausluga fStorno = null;
        Fakturausluga temp = (Fakturausluga)em.find(f.getClass(), (Object)f.getIdDok());
        em.detach((Object)temp);
        fStorno = (Fakturausluga)BeanUtils.cloneBean((Object)temp);
        return fStorno;
    }

    private void setStornoIznos(Fakturausluga original, EntityManager em) {
        Fakturausluga fu = (Fakturausluga)em.find(Fakturausluga.class, (Object)original.getIdDok());
        fu.setStornoIznos(this.fSpedicije.getIznos().add(fu.getStornoIznos()));
    }

    private void stornoFaktureSpedicije(Fakturausluga f) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        em.getTransaction().begin();
        try {
            try {
                this.fSpedicije = null;
                this.fSpedicije = this.createCopy(f, em);
                this.fSpedicije.setIdDok(0);
                this.fSpedicije.setStornoIznos(new BigDecimal("0.0"));
                this.fSpedicije.setArhiviran((short)0);
                this.fSpedicije.setDokument(null);
                this.fSpedicije.setTip(TipDokumentConfig.get().FAKTURA_USLUGA);
                this.fSpedicije.setPodTip(TipDokumentConfig.get().PODTIP_FAKTURA_SPEDICIJE);
                this.fSpedicije.setDatPrometa(this.dfDatumStorniranja.getVal());
                this.fSpedicije.setDatum(this.dfDatumIzrade.getVal());
                this.fSpedicije.setDatValute(f.getDatValute());
                this.fSpedicije.setTekuciRacun(f.getTekuciRacun());
                this.fSpedicije.setRadnajedinica(f.getRadnajedinica());
                List stavke = f.getStavkafaktureusls();
                List troskovi = f.getPutnitrosaks();
                f.getTaksafakturas();
                this.fSpedicije.setStavkafaktureusls(null);
                this.fSpedicije.setPutnitrosaks(null);
                this.fSpedicije.getTaksafakturas().clear();
                PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.fSpedicije, true, null, em);
                em.flush();
                this.fSpedicije.setOriginal((Faktura)f);
                this.fSpedicije.setStorno(1);
                this.fSpedicije.setStavkafaktureusls(stavke);
                this.fSpedicije.setPutnitrosaks(troskovi);
                PzEntityUtil.addTaksaDokuments((PzDokument)this.fSpedicije, (String)"PDV");
                this.fSpedicije.adjust();
                this.fSpedicije.getDokument().setOriginal(f.getDokument());
                this.fSpedicije.getDokument().update((PzDokument)this.fSpedicije, true);
                if (RuleKepu.isInKepu((Radnajedinica)this.fSpedicije.getRadnajedinica(), (String)this.fSpedicije.getTip())) {
                    this.fSpedicije.getDokument().setRbrKepu(new PzDefaultDokumentCustomizer().getRbrKepu((PzDokument)this.fSpedicije, em));
                }
                em.merge((Object)this.fSpedicije);
                em.flush();
                this.setStornoIznos(f, em);
                em.getTransaction().commit();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.stornoDok);
                ((PzDialogFaktureArhiva)((Object)this.getParent())).refreshData();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                PzSwingUtility.showErrorMessage((Component)this.mainPanel, (String)"Gre\u0161ka prilikom storniranja fakture \u0161pedicije. Poku\u0161ajte ponovo.");
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void stornoFaktureUsluge(Fakturausluga fu) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        em.getTransaction().begin();
        try {
            try {
                Fakturausluga fuStorno = null;
                fuStorno = this.createCopy(fu, em);
                fuStorno.setDatPrometa(this.dfDatumStorniranja.getVal());
                fuStorno.setDatum(this.dfDatumIzrade.getVal());
                fuStorno.setIznos(BDConverter.getIznos((double)this.dfStornoIznos.getVal()));
                fuStorno.setStornoIznos(new BigDecimal("0.0"));
                Fakturausluga original = (Fakturausluga)em.find(Fakturausluga.class, (Object)fu.getIdDok());
                if (original == null) {
                    throw new PzDokumentException(PzDokumentException.EXCEPTION_NEMA_ORIGINALA, "Storno dokument ne sadrzi referencu ka originalnom dokumentu koga stornira. Pri pozivu metoda arhivirajStorno() polje idDok mora sadrzati ID dokumenta koji se stornira!");
                }
                original.setStornoIznos(original.getStornoIznos().add(this.dfStornoIznos.getBigDecimal()));
                fuStorno.setIdDok(this.getNewIdDok(fu, em));
                if (original.getSaPorezom() == 1) {
                    fuStorno.setVrednostUsluga(((Taksafaktura)fu.getTaksafakturas().get(0)).getOsnovica());
                } else {
                    fuStorno.setVrednostUsluga(this.dfStornoIznos.getBigDecimal());
                }
                fuStorno.setOriginal((Faktura)original);
                if (fu.getSaPorezom() == 1) {
                    fuStorno.getTaksafakturas().clear();
                    Taksafaktura taksa = new Taksafaktura();
                    TaksafakturaPK taksaPK = new TaksafakturaPK();
                    taksaPK.setIdDok(fuStorno.getIdDok());
                    taksaPK.setOznTarGr(((Taksafaktura)fu.getTaksafakturas().get(0)).getId().getOznTarGr());
                    taksaPK.setTip(((Taksafaktura)fu.getTaksafakturas().get(0)).getId().getTip());
                    taksa.setId(taksaPK);
                    taksa.setTarifnagrupa(((Taksafaktura)fu.getTaksafakturas().get(0)).getTarifnagrupa());
                    taksa.setVrsta(((Taksafaktura)fu.getTaksafakturas().get(0)).getVrsta());
                    taksa.setOsnovica(((Taksafaktura)fu.getTaksafakturas().get(0)).getOsnovica());
                    taksa.setIznos(((Taksafaktura)fu.getTaksafakturas().get(0)).getIznos());
                    taksa.setFaktura((Faktura)fuStorno);
                    fuStorno.getTaksafakturas().add(taksa);
                }
                fuStorno.setArhiviran((short)1);
                fuStorno.setStorno(1);
                fuStorno.setPoruka(this.taOpis.getVal().toString());
                Dokument dok = new Dokument((PzDokument)fuStorno, true);
                fuStorno.setDokument(dok);
                fuStorno.getStavkafaktureusls().clear();
                em.persist((Object)fuStorno);
                em.flush();
                Stavkafaktureusl stavka = new Stavkafaktureusl();
                stavka.setId(fuStorno.getIdDok(), 1);
                if (fu.getSaPorezom() == 1) {
                    stavka.setCena(((Taksafaktura)fu.getTaksafakturas().get(0)).getOsnovica().doubleValue());
                } else {
                    stavka.setCena(this.dfStornoIznos.getVal().doubleValue());
                }
                stavka.setNaziv(((Stavkafaktureusl)fu.getStavkafaktureusls().get(0)).getNaziv());
                if (fu.getSaPorezom() == 1) {
                    if (stavka.getSfutaksas() == null) {
                        stavka.setSfutaksas((List)new IndirectList());
                    }
                    Sfutaksa taksa = new Sfutaksa();
                    SfutaksaPK taksaPK = new SfutaksaPK();
                    taksaPK.setIdDok(fuStorno.getIdDok());
                    taksaPK.setOznTarGr(((Sfutaksa)((Stavkafaktureusl)fu.getStavkafaktureusls().get(0)).getSfutaksas().get(0)).getId().getOznTarGr());
                    taksaPK.setrBroj(((Sfutaksa)((Stavkafaktureusl)fu.getStavkafaktureusls().get(0)).getSfutaksas().get(0)).getId().getrBroj());
                    taksa.setId(taksaPK);
                    taksa.setOpis(((Sfutaksa)((Stavkafaktureusl)fu.getStavkafaktureusls().get(0)).getSfutaksas().get(0)).getOpis());
                    taksa.setOznVrstaTG(((Sfutaksa)((Stavkafaktureusl)fu.getStavkafaktureusls().get(0)).getSfutaksas().get(0)).getOznVrstaTG());
                    taksa.setStopa(((Sfutaksa)((Stavkafaktureusl)fu.getStavkafaktureusls().get(0)).getSfutaksas().get(0)).getStopa());
                    taksa.setStavkafaktureusl(stavka);
                    stavka.getSfutaksas().add(taksa);
                }
                stavka.setFakturausluga(fuStorno);
                fuStorno.getStavkafaktureusls().add(stavka);
                if (RuleKepu.isInKepu((Radnajedinica)fuStorno.getRadnajedinica(), (String)fuStorno.getTip())) {
                    fuStorno.getDokument().setRbrKepu(new PzDefaultDokumentCustomizer().getRbrKepu((PzDokument)fuStorno, em));
                }
                em.getTransaction().commit();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)fuStorno);
                ((PzDialogFaktureArhiva)((Object)this.getParent())).refreshData();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                PzSwingUtility.showErrorMessage((Component)this.mainPanel, (String)"Gre\u0161ka prilikom storniranja fakture usluga. Poku\u0161ajte ponovo.");
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public PzDialogStornoFaktureZaUsluge(Boolean initGUI) {
    }
}

