/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogPregledPropusteneProdaje
extends PzDialog {
    public static final String PO_ARTIKLIMA = "Po artiklima";
    public static final String PO_KOMITENTU = "Po komitent";
    public static final String SVE_RJ = "Sve radne jedinice";
    public static final String ODABRANA_RJ = "Odre\u0111ena radna jedinica";
    private PzTable tblProdaja;
    private PzRadioGroup<String> panelRbs1;
    private JButton btnPotvrdi;
    private JScrollPane scrollPane;
    private PzPanel mainPanel;
    private PzRadioGroup<String> panelRbs;
    private Radnajedinica rj;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogPregledPropusteneProdaje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Pregled propu\u0161tene prodaje");
            this.mainPanel = new PzPanel(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{85, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{147, 166, 153, 20};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.panelRbs = new PzRadioGroup((Object[])new String[]{PO_ARTIKLIMA, PO_KOMITENTU});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs, 1);
            this.panelRbs.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRbs, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 0), 0, 0));
            this.panelRbs.setBorder((Border)BorderFactory.createTitledBorder("Sortiranje podataka"));
            this.panelRbs.setSelectedValue((Object)PO_ARTIKLIMA);
            this.panelRbs.setOpaque(false);
            this.panelRbs1 = new PzRadioGroup((Object[])new String[]{SVE_RJ, ODABRANA_RJ});
            panelRBsLayout = new BoxLayout((Container)this.panelRbs1, 1);
            this.panelRbs1.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRbs1, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.panelRbs1.setBorder((Border)BorderFactory.createTitledBorder("Izbor radne jedinice"));
            this.panelRbs1.setSelectedValue((Object)SVE_RJ);
            this.panelRbs1.setOpaque(false);
            this.panelRbs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1 && evt.getValue().equals(PzDialogPregledPropusteneProdaje.ODABRANA_RJ)) {
                        PzDialogPregledPropusteneProdaje.this.rj = PzDialogRJ.getRJ((PzDialog)PzDialogPregledPropusteneProdaje.this);
                        if (PzDialogPregledPropusteneProdaje.this.rj == null) {
                            return;
                        }
                    }
                }
            });
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(5, 7, 7, 7), 0, 0));
            this.tblProdaja = new PzTable();
            this.scrollPane.setViewportView((Component)this.tblProdaja);
            this.tblProdaja.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Artikalfaktura dok = (Artikalfaktura)entity;
                    return new Object[]{dok.getSifra(), dok.getNaziv(), dok.getKolicina(), dok.getProdCena(), dok.getDokument().getKomitent().getSfrKomitent(), dok.getDokument().getKomitent().getNaziv(), dok.getFaktura().getRadnajedinica().getId().getOznRj()};
                }

                public String[] getColumnNames() {
                    return new String[]{"\u0160ifra", "Naziv", "Koli\u010dina", "Prodajna cena", "\u0160ifra komitenta", "Naziv komitenta", "Radna jedinica"};
                }
            });
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 0, 1, 40), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText(" Broj stavki:");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(739, 498);
            this.setMinimumSize(new Dimension(739, 498));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    String upit = "";
                    Query q = null;
                    upit = "SELECT a FROM Artikalfaktura a WHERE a.faktura.tip ='" + TipDokumentConfig.get().PROPUSTENA_PRODAJA + "' %rj% ";
                    upit = ((String)PzDialogPregledPropusteneProdaje.this.panelRbs1.getSelectedValue()).equals(PzDialogPregledPropusteneProdaje.ODABRANA_RJ) ? upit.replace("%rj%", " and a.faktura.radnajedinica =:rj ") : upit.replace("%rj%", "  ");
                    if (((String)PzDialogPregledPropusteneProdaje.this.panelRbs.getSelectedValue()).equals(PzDialogPregledPropusteneProdaje.PO_ARTIKLIMA)) {
                        upit = String.valueOf(upit) + " ORDER BY a.artikal.sfrSort ";
                    }
                    q = em.createQuery(upit);
                    if (((String)PzDialogPregledPropusteneProdaje.this.panelRbs1.getSelectedValue()).equals(PzDialogPregledPropusteneProdaje.ODABRANA_RJ)) {
                        q.setParameter("rj", (Object)PzDialogPregledPropusteneProdaje.this.rj);
                    }
                    List data = q.getResultList();
                    em.getTransaction().commit();
                    return data;
                }

                @Override
                protected void done() {
                    try {
                        List data = (List)this.get();
                        if (((String)PzDialogPregledPropusteneProdaje.this.panelRbs.getSelectedValue()).equals(PzDialogPregledPropusteneProdaje.PO_KOMITENTU)) {
                            Collections.sort(data, new Comparator<Artikalfaktura>(){

                                @Override
                                public int compare(Artikalfaktura arg0, Artikalfaktura arg1) {
                                    block4: {
                                        try {
                                            if (Integer.parseInt(arg0.getFaktura().getKomitent().getSfrKomitent()) <= Integer.parseInt(arg1.getFaktura().getKomitent().getSfrKomitent())) break block4;
                                            return 1;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            return 0;
                                        }
                                    }
                                    if (Integer.parseInt(arg0.getFaktura().getKomitent().getSfrKomitent()) < Integer.parseInt(arg1.getFaktura().getKomitent().getSfrKomitent())) {
                                        return -1;
                                    }
                                    return 0;
                                }
                            });
                        }
                        if (data.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogPregledPropusteneProdaje.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogPregledPropusteneProdaje.this.tblProdaja.setData(data, Faktura.class);
                            PzDialogPregledPropusteneProdaje.this.brDok.setText(String.valueOf(data.size()));
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPregledPropusteneProdaje.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            worker.execute();
        }
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(ProdajaGradientUtil.PRENOSNICA_GRADIENT);
        return true;
    }
}

