/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogBrisanjeStornoFakture
extends PzDialog {
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzPanel pnlFields;
    private PzTable tabela;
    private JScrollPane scrollPane;
    private PzTextField tfNaziv;
    private PzFieldIndikator indSifra;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzToolBarIcon icnSlikaDokumenta;
    private Komitent komitent;
    private PzToolBarIcon icnBrisi;
    private PzStatusBar statusBar;
    private JLabel jlStatusBar = new JLabel();
    private JLabel brDok = new JLabel();

    public PzDialogBrisanjeStornoFakture(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initializeTable() {
        EntityManager em = PzEntityManager.getEm();
        Query q = null;
        String upit = "Select f From Faktura f Where f.storno = 1 and f.arhiviran = 1 and f.komitent=:komitent";
        q = em.createQuery(upit);
        q.setParameter("komitent", (Object)this.komitent);
        List data = q.getResultList();
        this.tabela.setData(data, Faktura.class);
        this.brDok.setText(String.valueOf(data.size()));
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{111, 54, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnSlikaDokumenta = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlikaDokumenta);
            this.icnSlikaDokumenta.setText("Slika|dokumenta|(F2)");
            this.icnSlikaDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/presentation_chart.png")));
            this.icnSlikaDokumenta.setActionCommand("slika");
            this.icnSlikaDokumenta.addActionListener((ActionListener)((Object)this));
            this.icnSlikaDokumenta.setShortcut("F2");
            this.icnBrisi = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisi);
            this.icnBrisi.setText("Brisanje|storno fakture|(DELETE)");
            this.icnBrisi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/document_delete.png")));
            this.icnBrisi.setActionCommand("brisi");
            this.icnBrisi.addActionListener((ActionListener)((Object)this));
            this.icnBrisi.setShortcut("Delete");
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{7, 25, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlFieldsLayout.columnWidths = new int[]{84, 99, 21, 319, 94, 167};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblSifra = new JLabel();
            this.pnlFields.add((Component)this.lblSifra, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra kupca");
            this.tfSifra = new PzTextField();
            this.pnlFields.add((Component)this.tfSifra, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfSifra.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogBrisanjeStornoFakture.this.komitent == null) {
                        return false;
                    }
                    PzDialogBrisanjeStornoFakture.this.initializeTable();
                    return true;
                }
            });
            this.indSifra = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indSifra, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv = new PzTextField();
            this.pnlFields.add((Component)this.tfNaziv, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv.setFocusable(false);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.tabela = new PzTable();
            this.scrollPane.setViewportView((Component)this.tabela);
            this.tabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Faktura f = (Faktura)entity;
                    BigDecimal pdv = f.getIznos().subtract(f.getIznosBezPoreza());
                    return new Object[]{f.getDatum(), f.getOznDokumenta(), f.getIznos(), f.getIznosBezPoreza(), pdv};
                }

                public String[] getColumnNames() {
                    return new String[]{"Datum", "Broj fakture", "Iznos sa PDV-om", "Iznos bez PDV-a", "Iznos PDV-a"};
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.tfSifra.setStateIndikator(this.indSifra);
            this.setTitle("Brisanje storno fakture");
            this.pack();
            this.setSize(800, 700);
            this.setMinimumSize(new Dimension(800, 700));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent e) {
        block13: {
            button = (PzButton)e.getSource();
            actionCommand = button.getActionCommand();
            em = PzEntityManager.getEm();
            try {
                if (!actionCommand.equals("brisi")) ** GOTO lbl32
                if (this.tabela.getSelectedRow() == -1) break block13;
                storno = (Faktura)this.tabela.getSelectedEntity();
                if (storno.getDokument().getProknjizen() == 1) {
                    JOptionPane.showMessageDialog((Component)this, "Odabrani dokument je proknji\u017een! Nije mogu\u0107e izvr\u0161iti brisanje!", "Informacija", 1);
                    return;
                }
                rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    original = storno.getOriginal();
                    original.setStornoIznos(original.getStornoIznos().subtract(storno.getIznos()));
                    em.merge((Object)original);
                    for (Artikalfaktura af : storno.getArtikalfakturas()) {
                        s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(af.getId().getSfrProizvod(), storno.getRadnajedinica()));
                        if (s == null) {
                            throw new PzInfoException("Gre\u0161ka prilikom brisanja storno fakture - ne postoji stanje za artikal: " + af.getId().getSfrProizvod());
                        }
                        s.setKolicina(s.getKolicina() - af.getKolicina());
                    }
                    this.tabela.removeSelectedEntity(false, true);
                    em.getTransaction().commit();
                    this.tabela.refreshData();
                    this.refresh();
                    break block13;
lbl32:
                    // 1 sources

                    if (actionCommand.equals("slika")) {
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)((Faktura)this.tabela.getSelectedEntity()));
                    }
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)this, (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.tfSifra.setVal((Object)this.komitent.getSfrKomitent());
            this.tfNaziv.setVal((Object)this.komitent.getNaziv());
        }
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(ProdajaGradientUtil.KOREKCIJE_GRADIENT);
        this.getSession().putParameter("gradient", (Object)ProdajaGradientUtil.KOREKCIJE_GRADIENT);
        return true;
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogBrisanjeStornoFakture.this.brDok.setText(String.valueOf(PzDialogBrisanjeStornoFakture.this.tabela.getRowCount()));
            }
        });
    }
}

