/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.korisnici.gui;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.util.ComponentWindowProvider;
import bibliothek.gui.dock.util.WindowProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Pzuserinfo;
import rs.pezar.korisnici.PzUserException;
import rs.pezar.korisnici.gui.PzPanelDozvoleKorisnika;
import rs.pezar.korisnici.gui.PzPanelKorisnickiPodaci;
import rs.pezar.korisnici.gui.PzPanelLicniPodaci;
import rs.pezar.korisnici.gui.PzPanelPodaciOZaposlenom;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogKorisnikMain
extends PzDialog {
    private PzButtonPanel btnPanel;
    private PzPanel pnlMain;
    private PzButton btnCancel;
    private PzButton btnOK;
    private PzPanelLicniPodaci licniPodaci;
    private PzPanelPodaciOZaposlenom podaciOZaposlenom;
    private PzPanelKorisnickiPodaci korisnickiPodaci;
    private CControl control;
    private DefaultSingleCDockable dockLicniPodaci;
    private DefaultSingleCDockable dockKorisnickiPodaci;
    private CGrid grid;
    private DefaultSingleCDockable dockPodaciOZaposlenom;
    private Boolean update;
    private Pzuser user;
    private PzPanelDozvoleKorisnika dozvoleKorisnika;
    private DefaultSingleCDockable dockDozvoleKorisnika;
    private PzTable table;
    private PzTextField podaciOZaposlenomNadredjeni;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogKorisnikMain inst = new PzDialogKorisnikMain(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogKorisnikMain(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogKorisnikMain(PzDialog dialog) {
        super(dialog);
        this.update = (Boolean)this.getSession().getParameter("update");
        this.table = (PzTable)this.getSession().getParameter("table");
        if (this.update.booleanValue()) {
            this.user = (Pzuser)this.getSession().getParameter("user");
        }
        this.initGUI();
        if (!this.update.booleanValue()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PzDialogKorisnikMain.this.korisnickiPodaci.getKorIme().requestFocus();
                }
            });
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Definicija korisnika");
            this.btnPanel = new PzButtonPanel();
            this.getContentPane().add((Component)this.btnPanel, "South");
            this.btnPanel.setPreferredSize(new Dimension(541, 44));
            this.btnOK = new PzButton();
            this.btnPanel.add((Component)this.btnOK);
            this.btnOK.setName("btnOK");
            this.btnOK.setPreferredSize(new Dimension(75, 33));
            this.btnOK.setText("OK");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.btnOK.setActionCommand("ok");
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/check.png")));
            this.btnCancel = new PzButton();
            this.btnPanel.add((Component)this.btnCancel);
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setPreferredSize(new Dimension(90, 33));
            this.btnCancel.setText("Nazad");
            this.btnCancel.addActionListener((ActionListener)((Object)this));
            this.btnCancel.setActionCommand("nazad");
            this.btnCancel.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/x.png")));
            this.pnlMain = new PzPanel();
            this.pnlMain.setLayout((LayoutManager)new BorderLayout());
            this.pnlMain.setBackground(Color.BLUE);
            this.getContentPane().add((Component)this.pnlMain, "Center");
            this.setSize(557, 439);
            this.initPanels();
            this.startupDockFrames();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton btn = (PzButton)e.getSource();
        String actionCommand = btn.getActionCommand();
        if (actionCommand.equalsIgnoreCase("nazad")) {
            this.dispose();
        } else {
            if (this.korisnickiPodaci.getUserName().equals("") || this.korisnickiPodaci.getPassword().equals("")) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate popuniti sva polja na panelu Korisni\u010dki podaci.");
                return;
            }
            this.snimi();
            this.dispose();
        }
    }

    void initPanels() {
        this.podaciOZaposlenom = new PzPanelPodaciOZaposlenom();
        this.korisnickiPodaci = new PzPanelKorisnickiPodaci();
        this.licniPodaci = new PzPanelLicniPodaci();
        this.dozvoleKorisnika = new PzPanelDozvoleKorisnika();
        if (this.update.booleanValue()) {
            this.podaciOZaposlenom.setUser(this.user);
            this.korisnickiPodaci.setUser(this.user);
            this.licniPodaci.setUser(this.user);
            this.dozvoleKorisnika.setUser(this.user);
        }
    }

    void startupDockFrames() {
        ComponentWindowProvider provider = new ComponentWindowProvider((Component)this.pnlMain);
        this.control = new CControl((WindowProvider)provider);
        this.control.setTheme("eclipse");
        this.pnlMain.add((Component)this.control.getContentArea());
        this.dockLicniPodaci = this.licniPodaci.getDockable();
        this.dockKorisnickiPodaci = this.korisnickiPodaci.getDockable();
        this.dockPodaciOZaposlenom = this.podaciOZaposlenom.getDockable();
        this.dockDozvoleKorisnika = this.dozvoleKorisnika.getDockable();
        this.grid = new CGrid(this.control);
        this.grid.add(0.0, 0.0, 1.0, 1.0, new CDockable[]{this.dockKorisnickiPodaci});
        this.grid.add(0.0, 0.0, 1.0, 1.0, new CDockable[]{this.dockLicniPodaci});
        this.grid.add(0.0, 0.0, 1.0, 1.0, new CDockable[]{this.dockPodaciOZaposlenom});
        this.grid.add(0.0, 0.0, 1.0, 1.0, new CDockable[]{this.dockDozvoleKorisnika});
        this.control.getContentArea().deploy(this.grid);
        this.dockKorisnickiPodaci.toFront();
    }

    private void snimi() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (this.user == null) {
                    this.user = this.createUser();
                } else {
                    this.user = (Pzuser)em.find(Pzuser.class, (Object)this.user.getPzusername());
                    if (this.user.getPzuserInfo() == null) {
                        this.user.setPzuserInfo(new Pzuserinfo());
                    }
                }
                em.getTransaction().begin();
                this.korisnickiPodaci.saveData(this.user, this.update, em);
                this.podaciOZaposlenom.saveData(this.user, this.update, em);
                this.licniPodaci.saveData(this.user, this.update, em);
                this.dozvoleKorisnika.saveData(this.user, this.update, em);
                this.user.getPzuserInfo().setPzusername(this.user.getPzusername());
                if (!this.update.booleanValue()) {
                    em.persist((Object)this.user);
                }
                em.getTransaction().commit();
                if (!this.update.booleanValue()) {
                    this.table.insert((PzEntity)this.user, false);
                } else {
                    this.table.updateSelectedEntity((PzEntity)this.user, false);
                }
                this.dispose();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                if (e instanceof PzUserException) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)e.getMessage());
                } else {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private Pzuser createUser() {
        Pzuser user = new Pzuser();
        user.setPzuserInfo(new Pzuserinfo());
        user.getPzuserInfo().setPzuser(user);
        user.setDozvolas(new ArrayList());
        user.setEmails(new ArrayList());
        user.setTelefons(new ArrayList());
        return user;
    }

    public void setEntity(PzEntity entity, Component component) {
        if (component == this.podaciOZaposlenomNadredjeni) {
            if (entity == null) {
                return;
            }
            Pzuser user = (Pzuser)entity;
            this.podaciOZaposlenomNadredjeni.setVal((Object)user.getPzusername());
        }
    }
}

