/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.korisnici;

import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import rs.pezar.db.entity.Dozvola;
import rs.pezar.db.entity.Email;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Telefon;
import rs.pezar.db.entity.Tipemaila;
import rs.pezar.db.entity.Tiptelefona;
import rs.pezar.korisnici.PzUserException;

public class PzUserUtil {
    public static void addEmail(String adresa, Pzuser u, Integer tip, String nazivTipa, EntityManager em) throws PzUserException {
        Tipemaila tipEmaila = (Tipemaila)em.find(Tipemaila.class, (Object)tip);
        if (tipEmaila == null) {
            tipEmaila = new Tipemaila();
            tipEmaila.setIdTipEmaila(tip);
            tipEmaila.setNaziv(nazivTipa);
            tipEmaila.setPredefinisan(Integer.valueOf(0));
            em.persist((Object)tipEmaila);
        }
        Email email = null;
        if (!adresa.equals("")) {
            email = (Email)em.find(Email.class, (Object)adresa);
        }
        if (email == null) {
            email = new Email();
            email.setAdresa(adresa);
            email.setTipEmaila(tipEmaila);
            PzUserUtil.addEmail(u, email, em);
        } else {
            if (!email.getPzuser().getPzusername().equals(u.getPzusername())) {
                throw new PzUserException("Gre\u0161ka! Adresa " + email.getAdresa() + " je vec registrovana u kod korisnika " + email.getPzuser().getFullName());
            }
            if (email.getKomitent() != null) {
                throw new PzUserException("Gre\u0161ka! Adresa " + email.getAdresa() + " je vec registrovana u kod komitenta " + email.getKomitent().getPunNaziv());
            }
            PzUserUtil.addEmail(u, email, em);
        }
    }

    public static void addTelefon(String broj, Pzuser u, Integer tip, String nazivTipa, EntityManager em) throws PzUserException {
        Tiptelefona tipTelefona = (Tiptelefona)em.find(Tiptelefona.class, (Object)tip);
        if (tipTelefona == null) {
            tipTelefona = new Tiptelefona();
            tipTelefona.setIdTipTelefona(tip);
            tipTelefona.setNaziv(nazivTipa);
            tipTelefona.setPredefinisan(Integer.valueOf(0));
            em.persist((Object)tipTelefona);
        }
        Telefon telefon = null;
        if (!broj.equals("")) {
            telefon = (Telefon)em.find(Telefon.class, (Object)broj);
        }
        if (telefon == null) {
            telefon = new Telefon();
            telefon.setBrojTelefona(broj);
            telefon.setTipTelefona(tipTelefona);
            PzUserUtil.addTelefon(u, telefon, em);
        } else {
            if (!telefon.getPzuser().getPzusername().equals(u.getPzusername())) {
                throw new PzUserException("Gre\u0161ka! Broj telefona " + telefon.getBrojTelefona() + " je vec registrovan u kod korisnika " + telefon.getPzuser().getFullName());
            }
            if (telefon.getKomitent() != null) {
                throw new PzUserException("Gre\u0161ka! Broj telefona " + telefon.getBrojTelefona() + " je vec registrovan u kod komitenta " + telefon.getKomitent().getPunNaziv());
            }
            PzUserUtil.addTelefon(u, telefon, em);
        }
    }

    public static void addEmail(Pzuser u, Email e, EntityManager em) {
        boolean tipExists = false;
        Iterator iterator = u.getEmails().iterator();
        while (iterator.hasNext() && !tipExists) {
            Email email = (Email)iterator.next();
            if (!email.getTipEmaila().getIdTipEmaila().equals(e.getTipEmaila().getIdTipEmaila()) || email.getAdresa().equals(e.getAdresa())) continue;
            iterator.remove();
            em.remove((Object)email);
            tipExists = true;
        }
        u.getEmails().add(e);
        e.setPzuser(u);
    }

    public static void removeEmail(Pzuser u, Integer tip, EntityManager em) {
        Iterator iterator = u.getEmails().iterator();
        while (iterator.hasNext()) {
            Email email = (Email)iterator.next();
            if (!email.getTipEmaila().getIdTipEmaila().equals(tip)) continue;
            iterator.remove();
            em.remove((Object)email);
        }
    }

    public static void addTelefon(Pzuser u, Telefon t, EntityManager em) {
        boolean tipExists = false;
        Iterator iterator = u.getTelefons().iterator();
        while (iterator.hasNext() && !tipExists) {
            Telefon telefon = (Telefon)iterator.next();
            if (!telefon.getTipTelefona().getIdTipTelefona().equals(t.getTipTelefona().getIdTipTelefona()) || telefon.getBrojTelefona().equals(t.getBrojTelefona())) continue;
            iterator.remove();
            em.remove((Object)telefon);
            tipExists = true;
        }
        u.getTelefons().add(t);
        t.setPzuser(u);
    }

    public static void removeTelefon(Pzuser u, Integer tip, EntityManager em) {
        Iterator iterator = u.getTelefons().iterator();
        while (iterator.hasNext()) {
            Telefon telefon = (Telefon)iterator.next();
            if (!telefon.getTipTelefona().getIdTipTelefona().equals(tip)) continue;
            iterator.remove();
            em.remove((Object)telefon);
        }
    }

    public static void addDozvola(Pzuser u, Dozvola d) {
        boolean found = false;
        Iterator iterator = u.getDozvolas().iterator();
        while (iterator.hasNext() && !found) {
            Dozvola dozvola = (Dozvola)iterator.next();
            if (!d.getId().equals((Object)dozvola.getId())) continue;
            found = true;
        }
        if (!found) {
            u.getDozvolas().add(d);
        }
    }

    public static void removeDozvola(Pzuser u, Dozvola d) {
        boolean found = false;
        Iterator iterator = u.getDozvolas().iterator();
        while (iterator.hasNext() && !found) {
            Dozvola dozvola = (Dozvola)iterator.next();
            if (!dozvola.getId().equals((Object)d.getId())) continue;
            iterator.remove();
            found = true;
        }
    }

    public static void removeDozvolaUnlisted(Pzuser u, List<Dozvola> dozvole) {
        Iterator iterator = u.getDozvolas().iterator();
        while (iterator.hasNext()) {
            Dozvola dozvola = (Dozvola)iterator.next();
            boolean found = false;
            Iterator<Dozvola> iterator1 = dozvole.iterator();
            while (iterator1.hasNext() && !found) {
                Dozvola dozvola1 = iterator1.next();
                if (!dozvola.getId().equals((Object)dozvola1.getId())) continue;
                found = true;
            }
            if (found) continue;
            iterator.remove();
        }
    }
}

