/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.util;

import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.SwingWorker;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.izmeneNaArtiklu.PromenaStope;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzDateUtility;

public class PromenaStopeUtility {
    public static void izmeniStopu(final String oznTarGr, final BigDecimal staraStopa, final BigDecimal novaStopa, final boolean razlikaPrioritet, final PzDialog parent) {
        PzWorkerDialog.showStatus((String)"Procesiranje podataka u toku. Molimo sa\u010dekajte", (PzDialog)parent);
        SwingWorker<List<Opstidokument>, Object> worker = new SwingWorker<List<Opstidokument>, Object>(){
            EntityManager em;

            @Override
            protected List<Opstidokument> doInBackground() throws Exception {
                Vector<Opstidokument> listaDokumenata = new Vector<Opstidokument>();
                this.em = PzEntityManagerFactory.getInstance().createEm();
                this.em.getTransaction().begin();
                List radnejedinice = this.em.createQuery("SELECT r FROM Radnajedinica r WHERE r.gTip='E'").getResultList();
                for (Radnajedinica rj : radnejedinice) {
                    Opstidokument d = new Opstidokument();
                    d.setIznosBezPoreza(new BigDecimal(0));
                    d.setIznosSaPorezom(new BigDecimal(0));
                    d.setArtikalopstidokuments(new Vector());
                    d.setRadnajedinica(rj);
                    List stanja = this.em.createQuery("SELECT s FROM Stanje s, IN(s.artikal.tarifnagrupas) tgr WHERE s.radnajedinica=:rj and s.kolicina > 0 and tgr.oznTarGr=:oznTarGr ORDER BY s.id.sfrProizvod").setParameter("rj", (Object)rj).setParameter("oznTarGr", (Object)oznTarGr).getResultList();
                    for (Stanje s : stanja) {
                        BigDecimal vrednostPosle;
                        BigDecimal vrednostPre;
                        if (!s.getArtikal().getTarifnaGrupa("PDV").getOznTarGr().equals(oznTarGr)) continue;
                        if (razlikaPrioritet) {
                            vrednostPre = BDConverter.getIznos((BigDecimal)BDConverter.getProdCena((double)s.getProdCena()).multiply(BDConverter.getKolicina((double)s.getKolicina())));
                            BigDecimal vrednostStarogPDVa = BDConverter.getIznos((double)(vrednostPre.multiply(staraStopa).doubleValue() / new BigDecimal(100).add(staraStopa).doubleValue()));
                            vrednostPosle = BDConverter.getIznos((BigDecimal)vrednostPre.subtract(vrednostStarogPDVa).multiply(BDConverter.getStopaPDV((double)(new BigDecimal(100).add(novaStopa).doubleValue() / 100.0))));
                            BigDecimal novaCena = BDConverter.getProdCena((double)(vrednostPosle.doubleValue() / s.getKolicina()));
                            s.setProdCena(novaCena.doubleValue());
                        } else {
                            BigDecimal vrednost = BDConverter.getIznos((BigDecimal)BDConverter.getProdCena((double)s.getProdCena()).multiply(BDConverter.getKolicina((double)s.getKolicina())));
                            BigDecimal vrednostStarogPDVa = BDConverter.getIznos((double)(vrednost.multiply(staraStopa).doubleValue() / new BigDecimal(100).add(staraStopa).doubleValue()));
                            BigDecimal vrednostNovogPDVa = BDConverter.getIznos((double)(vrednost.multiply(novaStopa).doubleValue() / new BigDecimal(100).add(novaStopa).doubleValue()));
                            vrednostPre = vrednost.subtract(vrednostStarogPDVa);
                            vrednostPosle = vrednost.subtract(vrednostNovogPDVa);
                        }
                        Artikalopstidokument aod = new Artikalopstidokument();
                        aod.init(s.getArtikal(), (PzDokument)d);
                        aod.setKolicina(s.getKolicina());
                        aod.setCenaBezPoreza(vrednostPre.doubleValue());
                        aod.setCenaSaPorezom(vrednostPosle.doubleValue());
                        d.setIznosBezPoreza(d.getIznosBezPoreza().add(vrednostPre));
                        d.setIznosSaPorezom(d.getIznosSaPorezom().add(vrednostPosle));
                        d.getArtikalopstidokuments().add(aod);
                    }
                    if (d.getArtikalopstidokuments().size() <= 0) continue;
                    PromenaStopeUtility.popuniPodatke(d, razlikaPrioritet, this.em);
                    listaDokumenata.add(d);
                }
                for (Opstidokument d : listaDokumenata) {
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)d, true, null, this.em);
                }
                this.em.getTransaction().commit();
                return listaDokumenata;
            }

            @Override
            protected void done() {
                try {
                    try {
                        List listaDokumenata = (List)this.get();
                        PzReportManager.createAndShowReports((PzDialog)parent, (List)listaDokumenata, null, null);
                    }
                    catch (Exception e) {
                        if (this.em.getTransaction().isActive()) {
                            this.em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Throwable)e);
                        this.em.close();
                        parent.dispose();
                    }
                }
                finally {
                    this.em.close();
                    parent.dispose();
                }
            }
        };
        worker.execute();
    }

    public static void izmeniStopu(final List<PzEntity> artikali, final boolean razlikaPrioritet, final PzDialog parent) {
        PzWorkerDialog.showStatus((String)"Procesiranje podataka u toku. Molimo sa\u010dekajte", (PzDialog)parent);
        SwingWorker<List<Opstidokument>, Object> worker = new SwingWorker<List<Opstidokument>, Object>(){
            EntityManager em;

            @Override
            protected List<Opstidokument> doInBackground() throws Exception {
                Vector<Opstidokument> listaDokumenata = new Vector<Opstidokument>();
                this.em = PzEntityManagerFactory.getInstance().createEm();
                this.em.getTransaction().begin();
                for (PzEntity a : artikali) {
                    PromenaStope artikal = (PromenaStope)a;
                    Artikal art = (Artikal)this.em.find(Artikal.class, (Object)artikal.getSifra());
                    art.getTarifnagrupas().remove(this.em.find(Tarifnagrupa.class, (Object)artikal.getStaraTarifa()));
                    art.getTarifnagrupas().add((Tarifnagrupa)this.em.find(Tarifnagrupa.class, (Object)artikal.getNovaTarifa()));
                    List stanja = this.em.createQuery("SELECT s FROM Stanje s WHERE s.kolicina > 0 and s.id.sfrProizvod=:artikal and s.radnajedinica.gTip='E' ").setParameter("artikal", (Object)artikal.getSifra()).getResultList();
                    for (Stanje s : stanja) {
                        BigDecimal vrednostPosle;
                        BigDecimal vrednostPre;
                        Opstidokument d = new Opstidokument();
                        d.setIznosBezPoreza(new BigDecimal(0));
                        d.setIznosSaPorezom(new BigDecimal(0));
                        d.setArtikalopstidokuments(new Vector());
                        d.setRadnajedinica(s.getRadnajedinica());
                        if (razlikaPrioritet) {
                            vrednostPre = BDConverter.getIznos((BigDecimal)BDConverter.getProdCena((double)s.getProdCena()).multiply(BDConverter.getKolicina((double)s.getKolicina())));
                            BigDecimal vrednostStarogPDVa = BDConverter.getIznos((double)(vrednostPre.multiply(artikal.getStaraStopa()).doubleValue() / new BigDecimal(100).add(artikal.getStaraStopa()).doubleValue()));
                            vrednostPosle = BDConverter.getIznos((BigDecimal)vrednostPre.subtract(vrednostStarogPDVa).multiply(BDConverter.getStopaPDV((double)(new BigDecimal(100).add(artikal.getNovaStopa()).doubleValue() / 100.0))));
                            BigDecimal novaCena = BDConverter.getProdCena((double)(vrednostPosle.doubleValue() / s.getKolicina()));
                            s.setProdCena(novaCena.doubleValue());
                        } else {
                            BigDecimal vrednost = BDConverter.getIznos((BigDecimal)BDConverter.getProdCena((double)s.getProdCena()).multiply(BDConverter.getKolicina((double)s.getKolicina())));
                            BigDecimal vrednostStarogPDVa = BDConverter.getIznos((double)(vrednost.multiply(artikal.getStaraStopa()).doubleValue() / new BigDecimal(100).add(artikal.getStaraStopa()).doubleValue()));
                            BigDecimal vrednostNovogPDVa = BDConverter.getIznos((double)(vrednost.multiply(artikal.getNovaStopa()).doubleValue() / new BigDecimal(100).add(artikal.getNovaStopa()).doubleValue()));
                            vrednostPre = vrednost.subtract(vrednostStarogPDVa);
                            vrednostPosle = vrednost.subtract(vrednostNovogPDVa);
                        }
                        Artikalopstidokument aod = new Artikalopstidokument();
                        aod.init(s.getArtikal(), (PzDokument)d);
                        aod.setKolicina(s.getKolicina());
                        aod.setCenaBezPoreza(vrednostPre.doubleValue());
                        aod.setCenaSaPorezom(vrednostPosle.doubleValue());
                        d.setIznosBezPoreza(d.getIznosBezPoreza().add(vrednostPre));
                        d.setIznosSaPorezom(d.getIznosSaPorezom().add(vrednostPosle));
                        d.getArtikalopstidokuments().add(aod);
                        PromenaStopeUtility.popuniPodatke(d, razlikaPrioritet, this.em);
                        listaDokumenata.add(d);
                    }
                }
                for (Opstidokument d : listaDokumenata) {
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)d, true, null, this.em);
                }
                this.em.getTransaction().commit();
                return listaDokumenata;
            }

            @Override
            protected void done() {
                try {
                    try {
                        List listaDokumenata = (List)this.get();
                        PzReportManager.createAndShowReports((PzDialog)parent, (List)listaDokumenata, null, null);
                    }
                    catch (Exception e) {
                        if (this.em.getTransaction().isActive()) {
                            this.em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Throwable)e);
                        this.em.close();
                        parent.dispose();
                    }
                }
                finally {
                    this.em.close();
                    parent.dispose();
                }
            }
        };
        worker.execute();
    }

    private static void popuniPodatke(Opstidokument d, boolean razlikaPrioritet, EntityManager em) {
        d.setTip(TipDokumentConfig.get().PROMENA_STOPE);
        if (razlikaPrioritet) {
            d.setPodTip("RAZLIKA");
        } else {
            d.setPodTip("POREZ");
        }
        d.setDatum(PzDateUtility.getServerDate((EntityManager)em));
    }
}

