/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.kursnaLista.valuta;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jdesktop.swingx.JXStatusBar;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Valuta;
import rs.pezar.sifarnici.gui.kursnaLista.valuta.DodavanjeValute;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzGenericTableDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.webservice.client.nbs.NBS;

public class PzDialogValute
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzToolBarIcon icnDodavanje;
    private JPanel jPanel1;
    private PzToolBarIcon icnIzmena;
    private PzTable table;
    private JScrollPane scpKursnaLista;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanje;
    private JLabel lblCount;
    private PzToolBarIcon icnNbs;
    private PzToolBarIcon icnBrisanjeSvega;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogValute inst = new PzDialogValute(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogValute(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public PzDialogValute(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("\u0160ifarnik valuta");
            this.jPanel1 = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.getContentPane().add((Component)this.jPanel1, "Center");
            this.jPanel1.setPreferredSize(new Dimension(592, 272));
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.columnWidths = new int[]{7, 7, 7, 7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.scpKursnaLista = new JScrollPane();
            this.jPanel1.add((Component)this.scpKursnaLista, new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.scpKursnaLista.setBackground(new Color(211, 242, 210));
            this.table = new PzTable(Valuta.class);
            this.table.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PzDialogValute.this.lblCount.setText(String.valueOf(PzDialogValute.this.table.getRowCount()));
                        }
                    });
                }
            });
            this.scpKursnaLista.setViewportView((Component)this.table);
            this.setSize(933, 603);
            this.toolbar = new JToolBar();
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.getContentPane().add((Component)this.toolbar, "North");
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/currency_euro_add.png")));
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/currency_euro_edit.png")));
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/currency_euro_delete.png")));
            this.icnBrisanje.setText("Brisanje| (DEL)");
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("DELETE");
            this.icnBrisanjeSvega = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanjeSvega);
            this.icnBrisanjeSvega.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/delete2.png")));
            this.icnBrisanjeSvega.setText("Brisanje svega| (CTRL+Q)");
            this.icnBrisanjeSvega.setActionCommand("brisanje_svega");
            this.icnBrisanjeSvega.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeSvega.setShortcut("ctrl+q");
            this.icnNbs = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNbs);
            this.icnNbs.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/nbs.png")));
            this.icnNbs.setText("NBS| (ALT+N)");
            this.icnNbs.setActionCommand("nbs");
            this.icnNbs.addActionListener((ActionListener)((Object)this));
            this.icnNbs.setShortcut("alt+n");
            JXStatusBar statusBar = new JXStatusBar();
            statusBar.add((Component)new JLabel("Broj valuta"));
            this.lblCount = new JLabel(String.valueOf(this.table.getRowCount()));
            statusBar.add((Component)this.lblCount);
            this.getContentPane().add((Component)statusBar, "South");
            this.setSize(600, 400);
            this.setLocationRelativeTo(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        Object data2 = null;
        boolean izmena = false;
        PzToolBarIcon icon = (PzToolBarIcon)arg0.getSource();
        String actionCommand = icon.getActionCommand();
        if (actionCommand.equalsIgnoreCase("Brisanje")) {
            this.table.removeSelectedEntity(true, true);
        }
        if (actionCommand.equalsIgnoreCase("Izmena")) {
            if (this.table.getSelectedRow() == -1) {
                return;
            }
            actionCommand = "Dodavanje";
            izmena = true;
            this.showDialog(DodavanjeValute.class, izmena, this.table, data2);
            actionCommand = "Izmena";
        }
        if (actionCommand.equalsIgnoreCase("dodavanje")) {
            this.showDialog(DodavanjeValute.class, izmena, this.table, data2);
        }
        if (actionCommand.equalsIgnoreCase("nbs")) {
            this.executeNBS();
        }
        if (actionCommand.equalsIgnoreCase("brisanje_svega")) {
            this.brisiSve();
        }
    }

    private void brisiSve() {
        int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Ova opcija \u0107e obrisati sve valute i njihove kursne promene iz sistema. Da li ste sigurni da to \u017eelite?", (String)"Brisanje svega?", null, (boolean)true);
        if (rez != 0) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                int i = 0;
                while (i < this.table.getRowCount()) {
                    this.table.remove(i, false, em);
                    ++i;
                }
                em.getTransaction().commit();
                this.table.commitRemove();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void executeNBS() {
        int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Ova opcija vam omogu\u0107ava preuzimanje \u0161ifarnika valuta iz sistema Narodne banke Srbije.\nPostoje\u0107e valute \u0107e biti dopunjene novim podacima.\nDa li \u017eelite da nastavite?", (String)"Preuzimanje valuta", null, (boolean)false);
        if (rez != 0) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Preuzimanje \u0161ifarnika valuta u toku. Operacija mo\u017ee da potraje. Molim, sa\u010dekajte.", (PzDialog)this);
        final PzDialogValute ref = this;
        SwingWorker<List<Valuta>, Object> worker = new SwingWorker<List<Valuta>, Object>(){

            @Override
            protected List<Valuta> doInBackground() throws Exception {
                return NBS.getValute();
            }

            @Override
            protected void done() {
                try {
                    try {
                        List valute = (List)this.get();
                        PzWorkerDialog.hideStatus();
                        PzDialogValute.this.selectValute(valute);
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)ref), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    private void selectValute(List<Valuta> valute) {
        PzEntityFilter f = new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Valuta v = (Valuta)entity;
                return new Object[]{v.getOznValuta(), v.getNaziv(), v.getZemlja()};
            }

            public String[] getColumnNames() {
                return new String[]{"Oznaka", "Naziv", "Zemlja"};
            }
        };
        List izabraneValute = PzGenericTableDialog.showDialog((PzDialog)this, Valuta.class, valute, (String)"Izbor valute za uvoz", (String)"Izaberite valute koje \u017eelite da koristite u sistemu", (int)0, (PzEntityFilter)f);
        if (izabraneValute != null && izabraneValute.size() > 0) {
            this.unesiValute(izabraneValute);
        }
    }

    private void unesiValute(final List<PzEntity> izabraneValute) {
        PzWorkerDialog.showStatus((String)"Unos valuta u toku. Molim, sa\u010dekajte.", (PzDialog)this);
        SwingWorker<List<PzEntity>, Object> worker = new SwingWorker<List<PzEntity>, Object>(){

            @Override
            protected List<PzEntity> doInBackground() throws Exception {
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                try {
                    try {
                        em.getTransaction().begin();
                        for (PzEntity v : izabraneValute) {
                            em.merge((Object)v);
                        }
                        em.getTransaction().commit();
                    }
                    catch (Exception e) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        throw e;
                    }
                }
                finally {
                    em.close();
                }
                return izabraneValute;
            }

            @Override
            protected void done() {
                try {
                    List valute = (List)this.get();
                    PzDialogValute.this.table.clear();
                    PzDialogValute.this.table.setData(valute, Valuta.class);
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)PzDialogValute.this), (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogValute(Boolean.FALSE);
    }

    public PzDialogValute(Boolean initGUI) {
    }
}

