/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.kursnaLista;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.Valuta;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzIntegerField;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzFieldIndikator indJedinica;
    private PzIntegerField intJedinica;
    private JLabel lblJedinica;
    private JComboBox cbValuta;
    private JLabel lblValuta;
    private PzDateField datum;
    private PzDoubleField kurs;
    private PzButton btnOK;
    private JPanel pnlButtons;
    private PzFieldIndikator indKurs;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;
    private boolean izmena;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Dodavanje inst = new Dodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Dodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)data1, data2);
        this.izmena = izmena;
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.panel = new PzPanel();
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setPreferredSize(new Dimension(435, 92));
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0};
            panelLayout.columnWidths = new int[]{81, 98, 102};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel1.setText("Datum:");
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel2.setText("Iznos:");
            this.datum = new PzDateField();
            this.panel.add((Component)this.datum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.datum.setFont(new Font("Tahoma", 0, 14));
            this.datum.setSize(80, 24);
            this.datum.setPKField(Kurs.class, null);
            this.datum.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    KursPK id = new KursPK();
                    id.setDatum(Dodavanje.this.datum.getVal());
                    id.setOznValuta(((Valuta)Dodavanje.this.cbValuta.getSelectedItem()).getOznValuta());
                    Kurs k = null;
                    try {
                        k = (Kurs)PzEntityManager.find(Kurs.class, (Object)id);
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)Dodavanje.this), (Throwable)e);
                    }
                    return k;
                }
            });
            this.kurs = new PzDoubleField();
            this.panel.add((Component)this.kurs, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.kurs.setFont(new Font("Tahoma", 0, 14));
            this.kurs.setDecimalFormat(PzFormatFactory.getKursFormat());
            this.kurs.setSize(80, 24);
            this.kurs.setVerifyInput(true);
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.getContentPane().add((Component)this.header, "North");
            this.pnlButtons = new JPanel();
            this.getContentPane().add((Component)this.pnlButtons, "South");
            this.pnlButtons.setPreferredSize(new Dimension(435, 46));
            this.btnOK = new PzButton();
            this.pnlButtons.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setBounds(48, 9, 133, 30);
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnOK.setActionCommand("insert");
            this.btnOK.setPreferredSize(new Dimension(140, 31));
            if (this.isUpdate()) {
                this.btnOK.setActionCommand("update");
            }
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.indKurs = new PzFieldIndikator();
            this.panel.add((Component)this.indKurs, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblValuta = new JLabel();
            this.lblValuta.setText("Valuta:");
            this.panel.add((Component)this.lblValuta, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.cbValuta = new JComboBox();
            this.cbValuta.setFont(new Font("SansSerif", 0, 14));
            this.panel.add((Component)this.cbValuta, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.lblJedinica = new JLabel("Jedinica:");
            this.panel.add((Component)this.lblJedinica, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.intJedinica = new PzIntegerField();
            this.intJedinica.setVal((Object)new Integer(1));
            this.intJedinica.setColumns(3);
            this.intJedinica.setFont(new Font("Tahoma", 0, 14));
            this.panel.add((Component)this.intJedinica, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.intJedinica.setName("intJedinica");
            this.intJedinica.setVerifyInput(true);
            this.indJedinica = new PzFieldIndikator();
            this.panel.add((Component)this.indJedinica, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.kurs.setStateIndikator(this.indKurs);
            this.intJedinica.setStateIndikator(this.indJedinica);
            this.setSize(441, 262);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Kurs k;
        if (!this.panel.validateForm(true)) {
            return;
        }
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("odustajanje")) {
            this.dispose();
        }
        if (actionCommand.equalsIgnoreCase("insert")) {
            k = new Kurs();
            KursPK id = new KursPK();
            id.setOznValuta(((Valuta)this.cbValuta.getSelectedItem()).getOznValuta());
            id.setDatum(this.datum.getVal());
            k.setId(id);
            k.setValuta((Valuta)this.cbValuta.getSelectedItem());
            k.setSrednji(this.kurs.getBigDecimal());
            k.setJedinica(this.intJedinica.getVal().intValue());
            this.getTable().insert((PzEntity)k, true);
        }
        if (actionCommand.equalsIgnoreCase("update")) {
            k = (Kurs)this.getTable().getSelectedEntity();
            k.setSrednji(this.kurs.getBigDecimal());
            this.getTable().updateSelectedEntity((PzEntity)k, true);
        }
        this.dispose();
    }

    public static Object getGUIBuilderInstance() {
        return new Dodavanje(Boolean.FALSE);
    }

    public Dodavanje(Boolean initGUI) {
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
    }

    protected void onUpdate() {
        Kurs kurs = (Kurs)this.getTable().getSelectedEntity();
        this.datum.setVal((Object)kurs.getId().getDatum());
        this.intJedinica.setVal((Object)kurs.getJedinica());
        this.kurs.setVal((Object)kurs.getSrednji());
        this.datum.setEnabled(false);
        this.intJedinica.setEnabled(false);
        this.cbValuta.setEnabled(false);
        this.panel.updateAllFieldsState();
        this.btnOK.setActionCommand("update");
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje kursa");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/currency_euro_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena kursa");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/currency_euro_edit.png")));
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    private boolean setValute(Valuta val) {
        List valute;
        block6: {
            valute = PzEntityManager.getList((String)"SELECT v FROM Valuta v");
            if (valute != null && valute.size() != 0) break block6;
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"U sistemu nije definisana ni jedna valuta. Definisite makar jednu valutu da biste mogli da definisete kurs.");
            return false;
        }
        try {
            String defStr = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
            Valuta def = null;
            for (Valuta valuta : valute) {
                this.cbValuta.addItem(valuta);
                if (val != null) {
                    if (!valuta.getOznValuta().equals(val.getOznValuta())) continue;
                    def = valuta;
                    continue;
                }
                if (!valuta.getOznValuta().equals(defStr)) continue;
                def = valuta;
            }
            AutoCompleteDecorator.decorate((JComboBox)this.cbValuta);
            if (def != null) {
                this.cbValuta.setSelectedItem(def);
            }
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            return this.setValute(((Kurs)this.getTable().getSelectedEntity()).getValuta());
        }
        return this.setValute(null);
    }
}

