/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.kondicioneGrupe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import rs.pezar.core.gui.pretraga.criteria.Condition;
import rs.pezar.core.gui.pretraga.criteria.Criteria;
import rs.pezar.core.gui.pretraga.criteria.CriteriaChoices;
import rs.pezar.core.gui.pretraga.criteria.CriteriaComponent;
import rs.pezar.core.gui.pretraga.criteria.CriteriaContainer;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.entity.KondGrupa;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class DodavanjeKondicioneGrupe
extends PzDialogInsert {
    private static final long serialVersionUID = -5652577629496646899L;
    private JPanel contentPanel;
    private PzPanelHeader header;
    private PzPanel pnlCenter;
    private JLabel lblNaziv;
    private PzTextField txtNaziv;
    private JScrollPane scrollPane;
    private CriteriaContainer container;
    private CriteriaComponent criteriaComponent;
    private KondGrupa kondGrupa;
    private PzTable table;

    public static void main(String[] args) {
        try {
            DodavanjeKondicioneGrupe dialog = new DodavanjeKondicioneGrupe();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DodavanjeKondicioneGrupe() {
        this.initGUI();
        this.createCondition();
    }

    public DodavanjeKondicioneGrupe(PzDialog parent) {
        super(parent);
        this.table = (PzTable)this.getSession().getParameter("KOND_GRUPA_TABLE");
    }

    protected void initGUI() {
        this.setTitle("Dodavanje kondicione grupe");
        this.setBounds(100, 100, 651, 405);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPane = new JPanel();
        this.contentPanel.add((Component)buttonPane, "South");
        buttonPane.setLayout(new FlowLayout(1));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DodavanjeKondicioneGrupe.this.okButtonactionPerformed(arg0);
            }
        });
        okButton.setIcon(new ImageIcon(DodavanjeKondicioneGrupe.class.getResource("/rs/pezar/sifarnici/resource/img/check.png")));
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.header = new PzPanelHeader();
        this.header.setText("Izaberite kriterijume po kojima ce se artikli / komitenti svrstati u ovu grupu");
        this.header.setTitle("Nova kondiciona grupa");
        this.header.setIcon(new ImageIcon(DodavanjeKondicioneGrupe.class.getResource("/rs/pezar/sifarnici/resource/img/folder_add.png")));
        this.contentPanel.add((Component)this.header, "North");
        this.pnlCenter = new PzPanel();
        this.contentPanel.add((Component)this.pnlCenter, "Center");
        GridBagLayout gbl_pnlCenter = new GridBagLayout();
        gbl_pnlCenter.columnWidths = new int[3];
        gbl_pnlCenter.rowHeights = new int[3];
        gbl_pnlCenter.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_pnlCenter.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.pnlCenter.setLayout((LayoutManager)gbl_pnlCenter);
        this.lblNaziv = new JLabel("Naziv grupe:");
        GridBagConstraints gbc_lblNaziv = new GridBagConstraints();
        gbc_lblNaziv.insets = new Insets(0, 0, 5, 5);
        gbc_lblNaziv.anchor = 13;
        gbc_lblNaziv.gridx = 0;
        gbc_lblNaziv.gridy = 0;
        this.pnlCenter.add((Component)this.lblNaziv, (Object)gbc_lblNaziv);
        this.txtNaziv = new PzTextField();
        GridBagConstraints gbc_txtNaziv = new GridBagConstraints();
        gbc_txtNaziv.insets = new Insets(0, 0, 5, 0);
        gbc_txtNaziv.fill = 2;
        gbc_txtNaziv.gridx = 1;
        gbc_txtNaziv.gridy = 0;
        this.pnlCenter.add((Component)this.txtNaziv, (Object)gbc_txtNaziv);
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.gridwidth = 2;
        gbc_scrollPane.insets = new Insets(0, 0, 0, 5);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 1;
        this.pnlCenter.add((Component)this.scrollPane, (Object)gbc_scrollPane);
        this.createCondition();
    }

    private void createCondition() {
        this.container = new CriteriaContainer();
        this.scrollPane.setViewportView((Component)this.container);
        this.criteriaComponent = new CriteriaComponent();
        this.container.add(this.criteriaComponent);
        if (this.getSession().getParameter("KOND_GRUPA_TIP").equals("KOMITENTI")) {
            this.criteriaComponent.setCriterias(this.createCriteriasKomitenti());
        } else if (this.getSession().getParameter("KOND_GRUPA_TIP").equals("ARTIKLI")) {
            this.criteriaComponent.setCriterias(this.createCriteriasArtikli());
        }
    }

    private Criteria[] createCriteriasArtikli() {
        return new Criteria[]{new Criteria("[x.id.sfrProizvod]", "\u0160ifra", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.naziv]", "Naziv", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.bliziOpis]", "Bli\u017ei opis", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.dobavljac]", "\u0160ifra dobavlja\u010da", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.nazivDobavljac]", "Naziv dobavlja\u010da", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.proizvodjac]", "\u0160ifra proizvo\u0111a\u010da", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.nazivProizvodjac]", "Naziv proizvo\u0111a\u010da", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.oznModel]", "Oznaka modela", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.nazivModela]", "Naziv modela", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.oznRobGr]", "Oznaka robne grupe", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.nazivRobGr]", "Naziv robne grupe", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.prSifra]", "Proizvo\u0111a\u010deva \u0161ifra", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.dobSifra]", "Katalo\u0161ki broj", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.opis]", "Opis", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.tip]", "Tip", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.jedMere]", "Jedinica mere", 1, CriteriaChoices.CHOICES_STRING_MIXED)};
    }

    private Criteria[] createCriteriasKomitenti() {
        return new Criteria[]{new Criteria("[x.sfrKomitent]", "\u0160ifra", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.naziv]", "Naziv", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.domaciKomitent]", "Inostrani komitent", 4, CriteriaChoices.CHOICES_BOOLEAN_MIX), new Criteria("[x.grad]", "Grad", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.obveznikPdv]", "Pdv obveznik", 4, CriteriaChoices.CHOICES_BOOLEAN_MIX), new Criteria("[x.postBroj]", "Po\u0161tanski broj", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("[x.srbija]", "Komitent sa kosova", 4, CriteriaChoices.CHOICES_BOOLEAN_MIX), new Criteria("[x.zemljaKomitenta]", "Zemlja komitenta", 1, CriteriaChoices.CHOICES_STRING_MIXED), new Criteria("x.grupaPostoji", "Grupa komitenata", 1, CriteriaChoices.CHOICES_GRUPA_KOMITENTI)};
    }

    protected void okButtonactionPerformed(ActionEvent arg0) {
        try {
            Condition root = Condition.getRootCondition((CriteriaComponent)this.criteriaComponent);
            if (!root.isConditionValid()) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Postoje polja kriterijuma koja nisu popunjena. Molim, popunite sva polja da bi uslov mogao da se primeni.");
                return;
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Condition.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            m.marshal((Object)root, (OutputStream)os);
            if (!this.isUpdate()) {
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                em.getTransaction().begin();
                this.kondGrupa = new KondGrupa();
                this.kondGrupa.setIdKondGrupa(PzIdGen.getNextId((String)"KOND_GRUPA_ID", (int)1, (EntityManager)em).getIdVal());
                this.kondGrupa.setNaziv(this.txtNaziv.getVal());
                this.kondGrupa.setUslov(os.toString());
                this.kondGrupa.setTip((String)this.getSession().getParameter("KOND_GRUPA_TIP"));
                this.table.insert((PzEntity)this.kondGrupa, em);
                em.getTransaction().commit();
                this.table.commitInsert();
            } else {
                this.kondGrupa = (KondGrupa)this.table.getSelectedEntity();
                this.kondGrupa.setNaziv(this.txtNaziv.getVal());
                this.kondGrupa.setUslov(os.toString());
                this.kondGrupa.setTip((String)this.getSession().getParameter("KOND_GRUPA_TIP"));
                this.table.updateSelectedEntity((PzEntity)this.kondGrupa, true);
            }
            System.out.println(root.getExpression(0));
            this.dispose();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void setHeaderOnUpdate() {
    }

    protected void setHeaderOnInsert() {
    }

    protected void onUpdate() {
        try {
            this.table = (PzTable)this.getSession().getParameter("KOND_GRUPA_TABLE");
            this.kondGrupa = (KondGrupa)this.table.getSelectedEntity();
            this.txtNaziv.setText(this.kondGrupa.getNaziv());
            Condition condition = Condition.getRootCondition((KondGrupa)this.kondGrupa);
            this.criteriaComponent.restoreState(condition);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void onInsert() {
    }

    public void setEntity(PzEntity entity, Component component) {
    }
}

