/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.komintenti;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzShortcutListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.webservice.client.nbs.NBS;

public class PzDialogTekuciRacuni
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzTable table;
    private JScrollPane scpTekuciRacuniKomintenta;
    private JToolBar toolbar;
    private Komitent komitent;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnNbs;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogTekuciRacuni inst = new PzDialogTekuciRacuni(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogTekuciRacuni(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogTekuciRacuni(PzDialog dialog) {
        super(dialog);
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.initGUI();
    }

    public PzDialogTekuciRacuni(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog);
        this.setData1(data1);
        this.setData2(data2);
        this.komitent = (Komitent)((PzTable)data1).getSelectedEntity();
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setSize(933, 603);
            this.scpTekuciRacuniKomintenta = new JScrollPane();
            this.getContentPane().add((Component)this.scpTekuciRacuniKomintenta, "Center");
            this.scpTekuciRacuniKomintenta.setBackground(new Color(211, 242, 210));
            this.table = new PzTable(this.komitent.getTekuciracuns(), Tekuciracun.class);
            this.table.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Tekuciracun t = (Tekuciracun)entity;
                    return new Object[]{t.getBrRacuna(), t.getBanka()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Broj ra\u010duna", "Naziv banke"};
                }
            });
            this.scpTekuciRacuniKomintenta.setViewportView((Component)this.table);
            this.toolbar = new JToolBar();
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.getContentPane().add((Component)this.toolbar, "North");
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/creditcards_add.png")));
            this.icnDodavanje.setText("Dodavanje|(ins)");
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/creditcards_edit.png")));
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/creditcards_delete.png")));
            this.icnBrisanje.setText("Brisanje| (del)");
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("DELETE");
            this.icnNbs = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNbs);
            this.icnNbs.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/nbs.png")));
            this.icnNbs.setText("NBS|(ALT+N)");
            this.icnNbs.setActionCommand("nbs");
            this.icnNbs.addActionListener((ActionListener)((Object)this));
            this.icnNbs.setShortcut("alt+n");
            ((PzDialog)SwingUtilities.getRoot((Component)((Object)this))).setShortcutListener(this.getShortcutListener());
            ((PzDialog)SwingUtilities.getRoot((Component)((Object)this))).registerShortcuts(new String[]{"ctrl+alt+n"});
            this.setSize(600, 400);
            this.setLocationRelativeTo(null);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PzShortcutListener getShortcutListener() {
        return new PzShortcutListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(PzShortcutListener.PzShortcutEvent evt) {
                String command = evt.getShortcut();
                if (command.equals("ctrl+alt+n")) {
                    PzDialogTekuciRacuni.this.azurirajSveRacune();
                }
            }
        };
    }

    public void actionPerformed(ActionEvent arg0) {
        PzTable data1 = null;
        Object data2 = null;
        boolean izmena = false;
        PzToolBarIcon icon = (PzToolBarIcon)arg0.getSource();
        String actionCommand = icon.getActionCommand();
        if (actionCommand.equals("nbs")) {
            PzWorkerDialog.showStatus((String)"Dobavljanje podataka u toku...", (PzDialog)this);
            SwingWorker<String, Object> worker = new SwingWorker<String, Object>(){
                EntityManager em;

                @Override
                protected String doInBackground() throws Exception {
                    String postojeci = "";
                    this.em = PzEntityManagerFactory.getInstance().createEm();
                    List trlist = NBS.getTekuciRacuni((Komitent)PzDialogTekuciRacuni.this.komitent);
                    if (trlist == null || trlist.size() == 0) {
                        return postojeci;
                    }
                    this.em.getTransaction().begin();
                    for (Tekuciracun tr : trlist) {
                        tr.setKomitent(PzDialogTekuciRacuni.this.komitent);
                        Tekuciracun tr1 = (Tekuciracun)this.em.find(Tekuciracun.class, (Object)tr.getBrRacuna());
                        if (tr1 != null) {
                            if (tr1.getKomitent() != null) {
                                postojeci = String.valueOf(postojeci) + "\t{ " + tr1.getBrRacuna() + " } , [ " + tr1.getKomitent().getSfrKomitent() + " ] " + tr1.getKomitent().getNaziv() + "\n";
                                continue;
                            }
                            if (tr1.getFirma() == null) continue;
                            postojeci = String.valueOf(postojeci) + tr1.getBrRacuna() + ", " + tr1.getFirma().getNaziv() + " ( RA\u010cUN NA\u0160E FIRME )";
                            continue;
                        }
                        PzDialogTekuciRacuni.this.table.insert((PzEntity)tr, this.em);
                    }
                    this.em.getTransaction().commit();
                    PzDialogTekuciRacuni.this.table.commitInsert();
                    return postojeci;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            String postojeci = (String)this.get();
                            if (!postojeci.equals("")) {
                                PzSwingUtility.showInformationMessage((Component)((Object)PzDialogTekuciRacuni.this), (String)("Slede\u0107i ra\u010duni su prona\u0111eni, ali su ve\u0107 vezani za komitenta u sistemu:\n" + postojeci));
                            }
                        }
                        catch (Exception e) {
                            if (this.em.getTransaction().isActive()) {
                                this.em.getTransaction().rollback();
                            }
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogTekuciRacuni.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                            this.em.close();
                        }
                    }
                    finally {
                        PzWorkerDialog.hideStatus();
                        this.em.close();
                    }
                }
            };
            worker.execute();
        } else if (actionCommand.equalsIgnoreCase("Brisanje")) {
            this.table.removeSelectedEntity(true, true);
        } else {
            if (actionCommand.equalsIgnoreCase("Izmena")) {
                actionCommand = "Dodavanje";
                izmena = true;
            }
            data1 = this.table;
            data2 = this.getData2();
            this.showDialog("tekuciRacuniKomintenta." + actionCommand, ((Object)((Object)this)).getClass().getClassLoader(), izmena, data1, data2);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogTekuciRacuni(Boolean.FALSE);
    }

    public PzDialogTekuciRacuni(Boolean initGUI) {
    }

    private void azurirajSveRacune() {
        PzWorkerDialog.showStatus((String)"Dobavljanje podataka u toku...", (PzDialog)this);
        SwingWorker<String, Object> worker = new SwingWorker<String, Object>(){
            EntityManager em;

            @Override
            protected String doInBackground() throws Exception {
                String postojeci = "";
                this.em = PzEntityManagerFactory.getInstance().createEm();
                this.em.getTransaction().begin();
                List list = this.em.createQuery("SELECT k FROM Komitent k").getResultList();
                for (Komitent k : list) {
                    if (!(k.getPib() != null && !k.getPib().equals("") && !k.getPib().equals("0") || k.getMatBroj() != null && !k.getMatBroj().equals("") && !k.getMatBroj().equals("0"))) continue;
                    List trlist = NBS.getTekuciRacuni((Komitent)k);
                    for (Tekuciracun tr : trlist) {
                        tr.setKomitent(k);
                        Tekuciracun tr1 = (Tekuciracun)this.em.find(Tekuciracun.class, (Object)tr.getBrRacuna());
                        if (tr1 != null) continue;
                        this.em.persist((Object)tr);
                    }
                }
                this.em.getTransaction().commit();
                return postojeci;
            }

            @Override
            protected void done() {
                try {
                    try {
                        String postojeci = (String)this.get();
                        if (!postojeci.equals("")) {
                            PzSwingUtility.showInformationMessage((Component)((Object)PzDialogTekuciRacuni.this), (String)("Slede\u0107i ra\u010duni su prona\u0111eni, ali su ve\u0107 vezani za komitenta u sistemu:\n" + postojeci));
                        }
                    }
                    catch (Exception e) {
                        if (this.em.getTransaction().isActive()) {
                            this.em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogTekuciRacuni.this), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                        this.em.close();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                    this.em.close();
                }
            }
        };
        worker.execute();
    }
}

