/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.importArtikala.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.poi.ss.util.CellRangeAddress;
import rs.pezar.sifarnici.gui.artikli.importArtikala.PlanImporta;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;

public class CriteriaComponent
extends PzPanel {
    private static final long serialVersionUID = 1031006653818452161L;
    private JComboBox cbField;
    private PzTextField tfValue;
    private int value = -1;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)((Object)new CriteriaComponent()));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public CriteriaComponent() {
        this.initGUI();
    }

    public void setCriterias(String[] criterias) {
        if (criterias == null || criterias.length == 0) {
            return;
        }
        this.clear();
        String[] stringArray = criterias;
        int n = criterias.length;
        int n2 = 0;
        while (n2 < n) {
            String criteria = stringArray[n2];
            this.cbField.addItem(criteria);
            ++n2;
        }
    }

    public void setCriteria(String criteria) {
        this.cbField.setSelectedItem(criteria);
    }

    private void initGUI() {
        try {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(300, 40));
            this.setOpaque(false);
            this.cbField = new JComboBox();
            this.add(this.cbField);
            this.cbField.setFont(new Font("SansSerif", 0, 14));
            this.cbField.setBounds(25, 7, 155, 26);
            this.cbField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    System.out.println("Index je:" + CriteriaComponent.this.cbField.getSelectedIndex());
                    if (CriteriaComponent.this.cbField.getSelectedIndex() != 0) {
                        if (PlanImporta.checkComboBox(CriteriaComponent.this.cbField.getSelectedIndex())) {
                            JOptionPane.showMessageDialog((Component)((Object)CriteriaComponent.this), "Polje " + CriteriaComponent.this.cbField.getSelectedItem().toString() + " je ve\u0107 izabrano! Izaberite neko drugo polje.", "Informacija", 1);
                            return false;
                        }
                    } else {
                        CriteriaComponent.this.tfValue.setText("");
                        CriteriaComponent.this.value = -1;
                    }
                    return true;
                }
            });
            this.tfValue = new PzTextField();
            this.tfValue.setBounds(186, 7, 80, 26);
            this.tfValue.setToUpperCase(true);
            this.tfValue.setMaxLength(2);
            this.add((Component)this.tfValue);
            this.tfValue.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (CriteriaComponent.this.cbField.getSelectedIndex() != 0 && !CriteriaComponent.this.tfValue.getVal().equals("")) {
                        if (CriteriaComponent.this.getInteger(CriteriaComponent.this.tfValue.getVal()) == -1) {
                            CriteriaComponent.this.value = CellRangeAddress.valueOf((String)(String.valueOf(CriteriaComponent.this.tfValue.getVal()) + "1")).getFirstColumn();
                        } else {
                            CriteriaComponent criteriaComponent = CriteriaComponent.this;
                            criteriaComponent.value = criteriaComponent.value + CriteriaComponent.this.getInteger(CriteriaComponent.this.tfValue.getVal());
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean isValidComponent() {
        System.out.println("Index je:" + this.cbField.getSelectedIndex());
        if (this.cbField.getSelectedIndex() != 0) {
            return this.value != -1;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.cbField.setEnabled(enabled);
    }

    public String getText() {
        return (String)this.cbField.getSelectedItem();
    }

    public void setText(String text) {
        this.cbField.addItem(text);
    }

    public int getChoice() {
        return this.cbField.getSelectedIndex();
    }

    public int getFieldValue() {
        return this.value;
    }

    public void clear() {
        this.cbField.removeAllItems();
    }

    public int getInteger(String input) {
        try {
            int broj = Integer.parseInt(input);
            return broj;
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

