/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.browser.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.JXImagePanel;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Slika;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class BrowserImgPanel
extends BrowserComponent {
    private static final long serialVersionUID = -841140026042815533L;
    private final String ID = "IMG_PANEL";
    private PzPanel btnPanel;
    private PzButton btnNazad;
    private PzButton btnNapred;
    private JXImagePanel pnlImage;
    private String direktorijum;
    private List<Slika> slike;
    private JLabel lblMessage;
    private int pointer = -1;
    private PzBusyPainterUI layerUI;
    private JXLayer<JXImagePanel> layer;

    public BrowserImgPanel() {
        this.initGUI();
        this.setComponentLocation(new BrowserComponent.Location(1, 1, 1, 1));
    }

    private void initGUI() {
        this.setMinimumSize(new Dimension(200, 200));
        this.setLayout(new BorderLayout(0, 0));
        this.btnPanel = new PzPanel();
        this.add((Component)this.btnPanel, "South");
        this.btnNazad = new PzButton();
        this.btnNazad.setEnabled(false);
        this.btnNazad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BrowserImgPanel.this.btnNazadactionPerformed(arg0);
            }
        });
        this.btnNazad.setMnemonic(90);
        this.btnPanel.add((Component)this.btnNazad);
        this.btnNazad.setText("Prethodna");
        this.btnNazad.setActionCommand("Nazad");
        this.btnNazad.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/navigate_left.png")));
        this.btnNazad.setPreferredSize(new Dimension(115, 23));
        this.btnNazad.setSize(120, 23);
        this.btnNazad.setToolTipText("Prethodna slika (alt+z)");
        this.btnNapred = new PzButton();
        this.btnNapred.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BrowserImgPanel.this.btnNapredactionPerformed(arg0);
            }
        });
        this.btnNapred.setEnabled(false);
        this.btnNapred.setMnemonic(88);
        this.btnPanel.add((Component)this.btnNapred);
        this.btnNapred.setText("Slede\u0107a     ");
        this.btnNapred.setHorizontalTextPosition(2);
        this.btnNapred.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/navigate_right.png")));
        this.btnNapred.setActionCommand("Napred");
        this.btnNapred.setHorizontalAlignment(10);
        this.btnNapred.setSize(120, 23);
        this.btnNapred.setPreferredSize(new Dimension(115, 23));
        this.btnNapred.setToolTipText("Sledeca slika (alt+x)");
        this.pnlImage = new JXImagePanel();
        this.layerUI = new PzBusyPainterUI();
        this.layer = new JXLayer((Component)this.pnlImage, (LayerUI)this.layerUI);
        this.add((Component)this.layer, "Center");
        this.lblMessage = new JLabel("");
        this.pnlImage.add((Component)this.lblMessage);
    }

    @Override
    public void updateData(final Stanjeartikal sa, Object parentComponent) {
        if (sa == null) {
            return;
        }
        this.layerUI.setLocked(true);
        SwingWorker<List<Slika>, Object> worker = new SwingWorker<List<Slika>, Object>(){

            @Override
            protected List<Slika> doInBackground() throws Exception {
                String query = "SELECT s FROM Slika AS s, IN(s.artikals) art WHERE art.sfrProizvod = '" + sa.getId().getSfrProizvod() + "'";
                return PzEntityManager.getList((String)query);
            }

            @Override
            protected void done() {
                try {
                    BrowserImgPanel.this.layerUI.setLocked(false);
                    BrowserImgPanel.this.slike = (List)this.get();
                    BrowserImgPanel.this.initPanel(BrowserImgPanel.this.slike);
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)BrowserImgPanel.this), (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    @Override
    public void updateData(Artikal a, Object parentComponent) {
        if (a == null) {
            return;
        }
        this.slike = a.getSlikas();
        this.initPanel(this.slike);
    }

    public void initPanel(List<Slika> slike) {
        if (slike != null && slike.size() > 0) {
            this.pointer = 0;
            this.paintImage(slike.get(0));
            if (slike.size() > 1) {
                this.btnNapred.setEnabled(true);
            }
        } else {
            this.pnlImage.setImage(null);
        }
    }

    public void paintImage(Slika slika) {
        String path = "";
        try {
            if (this.direktorijum == null || this.direktorijum.equals("")) {
                this.direktorijum = PzParameter.getParameterValue((String)"DIR_SLIKE");
            }
            path = String.valueOf(this.direktorijum) + File.separator + slika.getFileName();
            BufferedImage image = ImageIO.read(new FileInputStream(path));
            this.lblMessage.setVisible(false);
            this.pnlImage.setStyle(JXImagePanel.Style.SCALED_KEEP_ASPECT_RATIO);
            this.pnlImage.setImage((Image)image);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.pnlImage.setImage(null);
            this.lblMessage.setVisible(true);
            this.lblMessage.setText("Nepostoje\u0107i fajl: " + path);
        }
        catch (IOException iOException) {
            this.pnlImage.setImage(null);
            this.lblMessage.setVisible(true);
            this.lblMessage.setText("Neuspelo u\u010ditavanje slike iz fajla: " + path);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private Slika moveNext() {
        ++this.pointer;
        this.btnNazad.setEnabled(true);
        if (this.slike.size() == this.pointer + 1) {
            this.btnNapred.setEnabled(false);
        }
        return this.slike.get(this.pointer);
    }

    private Slika movePrevious() {
        --this.pointer;
        this.btnNapred.setEnabled(true);
        if (this.pointer == 0) {
            this.btnNazad.setEnabled(false);
        }
        return this.slike.get(this.pointer);
    }

    protected void btnNazadactionPerformed(ActionEvent arg0) {
        this.paintImage(this.movePrevious());
    }

    protected void btnNapredactionPerformed(ActionEvent arg0) {
        this.paintImage(this.moveNext());
    }

    @Override
    public void focusGained() {
    }

    @Override
    public String getId() {
        return "IMG_PANEL";
    }

    @Override
    public String getTitle() {
        return "Slike";
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public PzToolBarIcon getSwitchIcon() {
        PzToolBarIcon icnSlika = new PzToolBarIcon();
        icnSlika.setText("Slike|artikla|(ALT+F6)");
        icnSlika.addActionListener(this.createSwitchActionListener());
        icnSlika.setActionCommand("slika");
        icnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_photo.png")));
        icnSlika.setShortcut("alt+f6");
        return icnSlika;
    }
}

