/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.Valuta;
import rs.pezar.sifarnici.gui.kursnaLista.Dodavanje;
import rs.pezar.sifarnici.gui.kursnaLista.Period;
import rs.pezar.sifarnici.gui.kursnaLista.valuta.PzDialogValute;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzGenericTableDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.renderers.PzDoubleCellRenderer;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import rs.pezar.webservice.client.nbs.NBS;
import rs.pezar.webservice.client.nbs.NBSException;

public class PzDialogKursnaLista
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzToolBarIcon icnDodavanje;
    private JButton btnPrikazi;
    private JPanel pnlPretraga;
    private PzDateField datDo;
    private JLabel lblDatum2;
    private PzDateField datOd;
    private JLabel lblDatum;
    private JPanel jPanel1;
    private PzToolBarIcon icnIzmena;
    private PzTable table;
    private JScrollPane scpKursnaLista;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanje;
    private JComboBox cbValuta;
    private JLabel lblValuta;
    private JLabel lblCount;
    private PzToolBarIcon icnNbs;
    private PzToolBarIcon icnVal;
    private PzToolBarIcon icnBrisanjeSvega;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogKursnaLista inst = new PzDialogKursnaLista(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogKursnaLista(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public PzDialogKursnaLista(JFrame frame) {
        super(frame);
        this.initGUI();
        this.setValute();
        this.setData();
    }

    private void setData() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        List kurs = em.createQuery("SELECT k FROM Kurs k JOIN FETCH k.valuta WHERE k.valuta = :valuta AND k.id.datum >= :datOd AND k.id.datum <= :datDo ORDER BY k.id.datum ASC").setParameter("valuta", this.cbValuta.getSelectedItem()).setParameter("datOd", (Object)this.datOd.getVal()).setParameter("datDo", (Object)this.datDo.getVal()).getResultList();
        this.table.setData(kurs, Kurs.class);
        this.table.getColumn(3).setCellRenderer((TableCellRenderer)new PzDoubleCellRenderer(PzFormatFactory.getKursFormat()));
    }

    private void setValute() {
        try {
            this.cbValuta.removeAllItems();
            List valute = PzEntityManager.getList((String)"SELECT v FROM Valuta v");
            if (valute == null || valute.size() == 0) {
                return;
            }
            String defStr = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
            Valuta def = null;
            for (Valuta valuta : valute) {
                this.cbValuta.addItem(valuta);
                if (!valuta.getOznValuta().equals(defStr)) continue;
                def = valuta;
            }
            AutoCompleteDecorator.decorate((JComboBox)this.cbValuta);
            if (def != null) {
                this.cbValuta.setSelectedItem(def);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Kursna lista");
            this.jPanel1 = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.getContentPane().add((Component)this.jPanel1, "Center");
            jPanel1Layout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.columnWeights = new double[]{0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7, 7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.scpKursnaLista = new JScrollPane();
            this.jPanel1.add((Component)this.scpKursnaLista, new GridBagConstraints(0, 1, 8, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.scpKursnaLista.setBackground(new Color(211, 242, 210));
            this.table = new PzTable();
            this.table.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PzDialogKursnaLista.this.lblCount.setText(String.valueOf(PzDialogKursnaLista.this.table.getRowCount()));
                        }
                    });
                }
            });
            this.scpKursnaLista.setViewportView((Component)this.table);
            this.pnlPretraga = new JPanel();
            FlowLayout pnlPretragaLayout = new FlowLayout();
            pnlPretragaLayout.setAlignment(0);
            this.pnlPretraga.setLayout(pnlPretragaLayout);
            this.jPanel1.add((Component)this.pnlPretraga, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlPretraga.setBorder(BorderFactory.createEtchedBorder(1));
            this.lblValuta = new JLabel("Valuta:");
            this.pnlPretraga.add(this.lblValuta);
            this.cbValuta = new JComboBox();
            this.pnlPretraga.add(this.cbValuta);
            this.cbValuta.setFont(new Font("SansSerif", 0, 14));
            this.cbValuta.setPreferredSize(new Dimension(216, 21));
            this.lblDatum = new JLabel("Datum od:");
            this.pnlPretraga.add(this.lblDatum);
            this.datOd = new PzDateField();
            this.pnlPretraga.add((Component)this.datOd);
            this.datOd.setColumns(5);
            this.datOd.setDefaultDate(PzDateUtility.getFirstDayOfCurrentYear());
            this.datOd.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.datOd.setName("datOd");
            this.datOd.setColumns(8);
            this.lblDatum2 = new JLabel("Datum do:");
            this.pnlPretraga.add(this.lblDatum2);
            this.datDo = new PzDateField();
            this.pnlPretraga.add((Component)this.datDo);
            this.datDo.setDefaultDate(PzDateUtility.getCurrentDate());
            this.datDo.setName("datDo");
            this.datDo.setColumns(8);
            this.btnPrikazi = new JButton("Prika\u017ei");
            this.pnlPretraga.add(this.btnPrikazi);
            this.btnPrikazi.addActionListener((ActionListener)((Object)this));
            this.btnPrikazi.setActionCommand("prikazi");
            this.btnPrikazi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnPrikazi.setPreferredSize(new Dimension(95, 31));
            this.setSize(933, 603);
            this.toolbar = new JToolBar();
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.getContentPane().add((Component)this.toolbar, "North");
            this.toolbar.setPreferredSize(new Dimension(781, 88));
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/kurs_ins.png")));
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/kurs_edit.png")));
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/kurs_del.png")));
            this.icnBrisanje.setText("Brisanje| (DEL)");
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("DELETE");
            this.icnBrisanjeSvega = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanjeSvega);
            this.icnBrisanjeSvega.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/delete2.png")));
            this.icnBrisanjeSvega.setText("Brisanje svega| (CTRL+Q)");
            this.icnBrisanjeSvega.setActionCommand("brisanje_svega");
            this.icnBrisanjeSvega.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeSvega.setShortcut("ctrl+q");
            this.icnNbs = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNbs);
            this.icnNbs.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/nbs.png")));
            this.icnNbs.setText("NBS| (ALT+N)");
            this.icnNbs.setActionCommand("nbs");
            this.icnNbs.addActionListener((ActionListener)((Object)this));
            this.icnNbs.setShortcut("alt+n");
            this.icnVal = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnVal);
            this.icnVal.addActionListener((ActionListener)((Object)this));
            this.icnVal.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/currency_euro.png")));
            this.icnVal.setText("Valute| F4");
            this.icnVal.setActionCommand("valute");
            this.icnVal.setShortcut("F4");
            JXStatusBar statusBar = new JXStatusBar();
            statusBar.add((Component)new JLabel("Broj promena"));
            this.lblCount = new JLabel(String.valueOf(this.table.getRowCount()));
            statusBar.add((Component)this.lblCount);
            this.getContentPane().add((Component)statusBar, "South");
            this.setSize(789, 579);
            this.setLocationRelativeTo(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        Object data2 = null;
        boolean izmena = false;
        JButton icon = (JButton)arg0.getSource();
        String actionCommand = icon.getActionCommand();
        if (actionCommand.equalsIgnoreCase("Brisanje")) {
            this.table.removeSelectedEntity(true, true);
        }
        if (actionCommand.equalsIgnoreCase("Izmena")) {
            if (this.table.getSelectedRow() == -1) {
                return;
            }
            actionCommand = "Dodavanje";
            izmena = true;
            this.showDialog(Dodavanje.class, izmena, this.table, data2);
            actionCommand = "Izmena";
        }
        if (actionCommand.equalsIgnoreCase("valute")) {
            this.showDialog(PzDialogValute.class);
            this.setValute();
            return;
        }
        if (actionCommand.equalsIgnoreCase("dodavanje")) {
            this.showDialog(Dodavanje.class, izmena, this.table, data2);
        }
        if (actionCommand.equalsIgnoreCase("prikazi")) {
            this.setData();
        }
        if (actionCommand.equalsIgnoreCase("nbs")) {
            this.preuzmiKurs();
        }
        if (actionCommand.equalsIgnoreCase("brisanje_svega")) {
            this.brisiSve();
        }
    }

    private void brisiSve() {
        int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Ova opcija \u0107e obrisati sve kursne promene iz sistema. Da li ste sigurni da to \u017eelite?", (String)"Brisanje svega?", null, (boolean)true);
        if (rez != 0) {
            return;
        }
        List<PzEntity> valute = null;
        try {
            valute = this.getValute(PzEntityManager.getList((String)"SELECT v FROM Valuta v"), "Izbor valute", "Izaberite valute za koje \u017eelite da izbri\u0161ete sve kursne promene");
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            return;
        }
        if (valute == null || valute.size() == 0) {
            return;
        }
        ArrayList<String> oznValutas = new ArrayList<String>();
        for (PzEntity v : valute) {
            oznValutas.add(((Valuta)v).getOznValuta());
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                em.createQuery("DELETE FROM Kurs k WHERE k.id.oznValuta IN :valute").setParameter("valute", oznValutas).executeUpdate();
                em.getTransaction().commit();
                this.setData();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void preuzmiKurs() {
        int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Ova opcija vam omogu\u0107ava preuzimanje kursnih promena iz sistema Narodne banke Srbije.\nPostoje\u0107e stavke \u0107e biti prea\u017eurirane novim podacima.\nDa li \u017eelite da nastavite?", (String)"Izbor valute", null, (boolean)false);
        if (rez != 0) {
            return;
        }
        List<PzEntity> valute = null;
        try {
            valute = this.getValute(PzEntityManager.getList((String)"SELECT v FROM Valuta v"), "Izbor valute", "Izaberite valute koje \u017eelite da preuzmene kursne promene");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (valute == null || valute.size() == 0) {
            return;
        }
        final List<PzEntity> refVal = valute;
        this.showDialog(Period.class);
        final Date datDo = (Date)this.getSession().getParameter("period.datum.do");
        final Date datOd = (Date)this.getSession().getParameter("period.datum.od");
        this.getSession().putParameter("period.datum.od", null);
        this.getSession().putParameter("period.datum.do", null);
        if (datDo == null || datOd == null) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Preuzimanje kursnih promena je u toku. Operacija mo\u017ee da potraje. Molim, sa\u010dekajte.", (PzDialog)this);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                for (PzEntity e : refVal) {
                    Valuta valuta = (Valuta)e;
                    List kurs = NBS.getKurs((java.util.Date)datOd, (java.util.Date)datDo, (Valuta)valuta);
                    EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                    try {
                        try {
                            em.getTransaction().begin();
                            for (Kurs k : kurs) {
                                if (!(k.getSrednji().doubleValue() > 0.0)) continue;
                                em.merge((Object)k);
                            }
                            em.getTransaction().commit();
                        }
                        catch (Exception e1) {
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            throw e1;
                        }
                    }
                    finally {
                        em.close();
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        PzDialogKursnaLista.this.setData();
                    }
                    catch (InterruptedException e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogKursnaLista.this), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                    }
                    catch (ExecutionException e) {
                        block9: {
                            if (e.getCause() instanceof NBSException) {
                                PzSwingUtility.showErrorMessage((Component)((Object)PzDialogKursnaLista.this), (String)e.getMessage());
                                break block9;
                            }
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogKursnaLista.this), (Throwable)e);
                        }
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    private List<PzEntity> getValute(List<Valuta> valute, String title, String text) {
        PzEntityFilter f = new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Valuta v = (Valuta)entity;
                return new Object[]{v.getOznValuta(), v.getNaziv(), v.getZemlja()};
            }

            public String[] getColumnNames() {
                return new String[]{"Oznaka", "Naziv", "Zemlja"};
            }
        };
        List izabraneValute = PzGenericTableDialog.showDialog((PzDialog)this, Valuta.class, valute, (String)title, (String)text, (int)0, (PzEntityFilter)f);
        return izabraneValute;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKursnaLista(Boolean.FALSE);
    }

    public PzDialogKursnaLista(Boolean initGUI) {
    }
}

